/*
 * Decompiled with CFR 0.152.
 */
package com.ge.med.terra.tap.util.dicom;

import com.ge.med.terra.tap.Tap;
import com.ge.med.terra.tap.util.dicom.DicomBytesBuilder;
import com.ge.med.terra.tap.util.dicom.DicomCharSet;
import com.ge.med.terra.tap.util.dicom.PersonName;
import com.ge.med.terra.tap.util.dicom.dicomParser;
import com.ge.med.terra.tap.util.dicom.tagValue;
import com.ge.med.terra.tap.util.dicom.vr;
import java.io.ByteArrayOutputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.RandomAccessFile;
import java.util.Vector;
import java.util.logging.Level;

public final class DicomWriter {
    public static byte[] getValueAsBytes(tagValue tv, boolean explicit, boolean littleEndian) throws IOException {
        return DicomWriter.getValueAsBytes(tv, explicit, littleEndian, DicomCharSet.getDefaultCharSet());
    }

    public static byte[] getValueAsBytes(tagValue tv, boolean explicit, boolean littleEndian, DicomCharSet[] dicomCharsets) throws IOException {
        boolean needSwap;
        byte[] value;
        block54: {
            Object val;
            block55: {
                block53: {
                    value = tv.valueAsBytes;
                    if (null != value) {
                        return value;
                    }
                    val = tv.value;
                    if (0 == tv.len || null == val) {
                        value = new byte[]{};
                        return value;
                    }
                    boolean bl = needSwap = !littleEndian;
                    if (!(val instanceof int[])) break block53;
                    int[] ints = (int[])val;
                    value = new byte[tv.len];
                    for (int i2 = 0; i2 < ints.length; ++i2) {
                        int x2 = ints[i2];
                        value[2 * i2 + 0] = (byte)(x2 & 0xFF);
                        value[2 * i2 + 1] = (byte)((x2 >>= 8) & 0xFF);
                    }
                    break block54;
                }
                if (!(val instanceof Integer[])) break block55;
                Integer[] ints = (Integer[])val;
                switch (tv.vrep) {
                    case 21324: {
                        int x3;
                        int i3;
                        value = new byte[tv.len * 4];
                        for (i3 = 0; i3 < ints.length; ++i3) {
                            x3 = ints[i3];
                            value[4 * i3 + 0] = (byte)(x3 & 0xFF);
                            value[4 * i3 + 1] = (byte)((x3 >>= 8) & 0xFF);
                            value[4 * i3 + 2] = (byte)((x3 >>= 8) & 0xFF);
                            value[4 * i3 + 3] = (byte)((x3 >>= 8) & 0xFF);
                        }
                        break block54;
                    }
                    case 16724: 
                    case 21331: 
                    case 21836: 
                    case 21843: {
                        int x3;
                        int i3;
                        value = new byte[tv.len];
                        for (i3 = 0; i3 < ints.length; ++i3) {
                            x3 = ints[i3];
                            value[2 * i3 + 0] = (byte)(x3 & 0xFF);
                            value[2 * i3 + 1] = (byte)((x3 >>= 8) & 0xFF);
                        }
                        break;
                    }
                }
                break block54;
            }
            if (val instanceof Long[]) {
                value = new byte[tv.len];
                Long[] longs = (Long[])val;
                for (int i4 = 0; i4 < longs.length; ++i4) {
                    long x4 = longs[i4];
                    value[4 * i4 + 0] = (byte)(x4 & 0xFFL);
                    value[4 * i4 + 1] = (byte)((x4 >>= 8) & 0xFFL);
                    value[4 * i4 + 2] = (byte)((x4 >>= 8) & 0xFFL);
                    value[4 * i4 + 3] = (byte)((x4 >>= 8) & 0xFFL);
                }
            } else if (val instanceof Float[]) {
                value = new byte[tv.len];
                Float[] floats = (Float[])val;
                for (int i5 = 0; i5 < floats.length; ++i5) {
                    int x5 = Float.floatToIntBits(floats[i5].floatValue());
                    value[4 * i5 + 0] = (byte)(x5 & 0xFF);
                    value[4 * i5 + 1] = (byte)((x5 >>= 8) & 0xFF);
                    value[4 * i5 + 2] = (byte)((x5 >>= 8) & 0xFF);
                    value[4 * i5 + 3] = (byte)((x5 >>= 8) & 0xFF);
                }
            } else if (val instanceof Double[]) {
                value = new byte[tv.len];
                Double[] doubles = (Double[])val;
                for (int i6 = 0; i6 < doubles.length; ++i6) {
                    long x6 = Double.doubleToLongBits(doubles[i6]);
                    value[8 * i6 + 0] = (byte)(x6 & 0xFFL);
                    value[8 * i6 + 1] = (byte)((x6 >>= 8) & 0xFFL);
                    value[8 * i6 + 2] = (byte)((x6 >>= 8) & 0xFFL);
                    value[8 * i6 + 3] = (byte)((x6 >>= 8) & 0xFFL);
                    value[8 * i6 + 4] = (byte)((x6 >>= 8) & 0xFFL);
                    value[8 * i6 + 5] = (byte)((x6 >>= 8) & 0xFFL);
                    value[8 * i6 + 6] = (byte)((x6 >>= 8) & 0xFFL);
                    value[8 * i6 + 7] = (byte)((x6 >>= 8) & 0xFFL);
                }
            } else if (val instanceof short[]) {
                value = new byte[tv.len];
                short[] shorts = (short[])val;
                for (int i7 = 0; i7 < shorts.length; ++i7) {
                    short x7 = shorts[i7];
                    value[2 * i7 + 0] = (byte)(x7 & 0xFF);
                    x7 = (short)(x7 >> 8);
                    value[2 * i7 + 1] = (byte)(x7 & 0xFF);
                }
            } else if (val instanceof byte[]) {
                value = (byte[])val;
            } else if (val instanceof Integer) {
                Integer integer = (Integer)val;
                switch (tv.vrep) {
                    case 21324: {
                        value = new byte[4];
                        int x8 = integer;
                        value[0] = (byte)(x8 & 0xFF);
                        value[1] = (byte)((x8 >>= 8) & 0xFF);
                        value[2] = (byte)((x8 >>= 8) & 0xFF);
                        value[3] = (byte)((x8 >>= 8) & 0xFF);
                        break;
                    }
                    case 16724: 
                    case 21331: 
                    case 21836: 
                    case 21843: {
                        value = new byte[2];
                        int x8 = integer;
                        value[0] = (byte)(x8 & 0xFF);
                        value[1] = (byte)((x8 >>= 8) & 0xFF);
                    }
                }
            } else if (val instanceof Long) {
                value = new byte[4];
                long x9 = (Long)val;
                value[0] = (byte)(x9 & 0xFFL);
                value[1] = (byte)((x9 >>= 8) & 0xFFL);
                value[2] = (byte)((x9 >>= 8) & 0xFFL);
                value[3] = (byte)((x9 >>= 8) & 0xFFL);
            } else if (val instanceof Float) {
                value = new byte[4];
                int x10 = Float.floatToIntBits(((Float)val).floatValue());
                value[3] = (byte)(x10 & 0xFF);
                value[2] = (byte)((x10 >>= 8) & 0xFF);
                value[1] = (byte)((x10 >>= 8) & 0xFF);
                value[0] = (byte)((x10 >>= 8) & 0xFF);
            } else if (val instanceof Double) {
                value = new byte[8];
                long x11 = Double.doubleToLongBits((Double)val);
                value[0] = (byte)(x11 & 0xFFL);
                value[1] = (byte)((x11 >>= 8) & 0xFFL);
                value[2] = (byte)((x11 >>= 8) & 0xFFL);
                value[3] = (byte)((x11 >>= 8) & 0xFFL);
                value[4] = (byte)((x11 >>= 8) & 0xFFL);
                value[5] = (byte)((x11 >>= 8) & 0xFFL);
                value[6] = (byte)((x11 >>= 8) & 0xFFL);
                value[7] = (byte)((x11 >>= 8) & 0xFFL);
            } else if (tv.vrep == 21329) {
                Object[] items = (Object[])val;
                ByteArrayOutputStream bytes = new ByteArrayOutputStream();
                byte[] beginItem = null;
                byte[] endItem = null;
                byte[] endSeq = null;
                if (littleEndian) {
                    beginItem = new byte[]{-2, -1, 0, -32};
                    endItem = new byte[]{-2, -1, 13, -32};
                    endSeq = new byte[]{-2, -1, -35, -32};
                } else {
                    beginItem = new byte[]{-1, -2, -32, 0};
                    endItem = new byte[]{-1, -2, -32, 13};
                    endSeq = new byte[]{-1, -2, -32, -35};
                }
                byte[] undefinedLength = new byte[]{-1, -1, -1, -1};
                byte[] zeroLength = new byte[4];
                for (int i8 = 0; i8 < items.length; ++i8) {
                    bytes.write(beginItem);
                    bytes.write(undefinedLength);
                    for (int j2 = 0; j2 < ((Object[])items[i8]).length; ++j2) {
                        tagValue tmpTv = (tagValue)((Object[])items[i8])[j2];
                        DicomWriter.dumpDataElement(tmpTv, bytes, explicit, littleEndian, dicomCharsets);
                    }
                    bytes.write(endItem);
                    bytes.write(zeroLength);
                }
                bytes.write(endSeq);
                bytes.write(zeroLength);
                value = bytes.toByteArray();
            } else if (val instanceof String[]) {
                Tap.log.log(Level.WARNING, "String[] encoding is unsupported");
            } else {
                switch (tv.vrep) {
                    case 20558: {
                        DicomCharSet alphabeticCharset = dicomCharsets[0];
                        DicomCharSet ideographicCharset = dicomCharsets.length > 1 ? dicomCharsets[1] : dicomCharsets[0];
                        DicomCharSet phoneticCharset = dicomCharsets.length > 1 ? dicomCharsets[1] : dicomCharsets[0];
                        PersonName pn = new PersonName(val.toString().trim());
                        value = pn.getDicomBytes(alphabeticCharset, ideographicCharset, phoneticCharset);
                        if (value.length <= tv.len) break;
                        Object[] args = new Object[]{tv, pn, value.length, tv.len};
                        Tap.log.log(Level.WARNING, "{0}: encoded value \"{1}\" length ({2}) truncated to tag length ({3}).", args);
                        byte[] valueTruncated = new byte[tv.len];
                        System.arraycopy(value, 0, valueTruncated, 0, tv.len);
                        value = valueTruncated;
                        break;
                    }
                    case 19535: 
                    case 19540: 
                    case 21320: 
                    case 21332: 
                    case 21844: {
                        value = DicomBytesBuilder.getDicomBytes(val.toString(), dicomCharsets);
                        break;
                    }
                    default: {
                        value = val.toString().getBytes(DicomCharSet.getDefaultCharSet()[0].getJavaCharsetName());
                    }
                }
                if (value.length < tv.len) {
                    int pad = 21833 == tv.vrep ? 0 : 32;
                    byte[] valueWithPad = new byte[tv.len];
                    System.arraycopy(value, 0, valueWithPad, 0, value.length);
                    for (int i9 = value.length; i9 < tv.len; ++i9) {
                        valueWithPad[i9] = pad;
                    }
                    value = valueWithPad;
                }
                needSwap = false;
            }
        }
        if (null == value) {
            value = new byte[]{};
        } else if (needSwap) {
            for (int i10 = 0; i10 < value.length / 2; ++i10) {
                byte tmp = value[i10];
                value[i10] = value[value.length - i10 - 1];
                value[value.length - i10 - 1] = tmp;
            }
        }
        return value;
    }

    public static byte[] getTagAsBytes(tagValue tv, boolean explicit, boolean littleEndian) throws IOException {
        boolean keyVRs = tv.vrep == 20290 || tv.vrep == 20311 || tv.vrep == 20294 || tv.vrep == 21329 || tv.vrep == 21844 || tv.vrep == 21838;
        int extra = 0;
        if (explicit && keyVRs) {
            extra = 4;
        }
        byte[] tag2 = new byte[8 + extra];
        if (littleEndian) {
            int i2 = 0;
            tag2[i2++] = (byte)(tv.group & 0xFF);
            tag2[i2++] = (byte)(tv.group >> 8 & 0xFF);
            tag2[i2++] = (byte)(tv.element & 0xFF);
            tag2[i2++] = (byte)(tv.element >> 8 & 0xFF);
            if (explicit) {
                byte[] vrbytes = vr.toString(tv.vrep).getBytes(DicomCharSet.DEFAULT.getJavaCharsetName());
                tag2[i2++] = vrbytes[0];
                tag2[i2++] = vrbytes[1];
                if (keyVRs) {
                    tag2[i2++] = 0;
                    tag2[i2++] = 0;
                }
            }
            if (keyVRs || !explicit) {
                int len = tv.vrep == 21329 && 0 != tv.len ? -1 : tv.len;
                tag2[i2++] = (byte)(len & 0xFF);
                tag2[i2++] = (byte)((len >>= 8) & 0xFF);
                tag2[i2++] = (byte)((len >>= 8) & 0xFF);
                tag2[i2++] = (byte)((len >>= 8) & 0xFF);
            } else {
                tag2[i2++] = (byte)(tv.len & 0xFF);
                tag2[i2++] = (byte)(tv.len >> 8 & 0xFF);
            }
        } else {
            int i3 = 0;
            tag2[i3++] = (byte)(tv.group >> 8 & 0xFF);
            tag2[i3++] = (byte)(tv.group & 0xFF);
            tag2[i3++] = (byte)(tv.element >> 8 & 0xFF);
            tag2[i3++] = (byte)(tv.element & 0xFF);
            if (explicit) {
                byte[] vrbytes = vr.toString(tv.vrep).getBytes(DicomCharSet.DEFAULT.getJavaCharsetName());
                tag2[i3++] = vrbytes[0];
                tag2[i3++] = vrbytes[1];
                if (keyVRs) {
                    tag2[i3++] = 0;
                    tag2[i3++] = 0;
                }
            }
            if (keyVRs || !explicit) {
                int len = tv.vrep == 21329 && 0 != tv.len ? -1 : tv.len;
                i3 += 3;
                tag2[i3--] = (byte)(len & 0xFF);
                tag2[i3--] = (byte)((len >>= 8) & 0xFF);
                tag2[i3--] = (byte)((len >>= 8) & 0xFF);
                tag2[i3--] = (byte)((len >>= 8) & 0xFF);
                i3 += 3;
            } else {
                tag2[i3++] = (byte)(tv.len >> 8 & 0xFF);
                tag2[i3++] = (byte)(tv.len & 0xFF);
            }
        }
        return tag2;
    }

    private static void dumpGroup(Vector group, OutputStream ostream, boolean explicit, boolean littleEndian, DicomCharSet[] dicomCharsets) throws IOException {
        int start;
        tagValue first = (tagValue)group.get(0);
        Tap.log.log(Level.INFO, "Dumping Group for element {0}", first);
        if (first.group >= 8 && first.element == 0) {
            Tap.log.log(Level.INFO, "Skipping group length element {0}", tagValue.atToString(first.group, first.element));
            start = 1;
        } else {
            start = 0;
        }
        for (int i2 = start; i2 < group.size(); ++i2) {
            tagValue tv = (tagValue)group.get(i2);
            DicomWriter.dumpDataElement(tv, ostream, explicit, littleEndian, dicomCharsets);
        }
    }

    private static void dumpDataElement(tagValue tv, OutputStream ostream, boolean isExplicit, boolean littleEndian, DicomCharSet[] dicomCharsets) throws IOException {
        ostream.write(DicomWriter.getTagAsBytes(tv, isExplicit, littleEndian));
        ostream.write(DicomWriter.getValueAsBytes(tv, isExplicit, littleEndian, dicomCharsets));
    }

    public static void updatePart10InLine(String fileName, int group, int element, byte[] value) throws IOException {
        dicomParser parser = new dicomParser(fileName);
        tagValue tv = new tagValue(group, element);
        parser.fill(new tagValue[]{tv});
        Tap.log.log(Level.INFO, "Found {0}", tv);
        if (value == null) {
            parser.clearFile();
            throw new IllegalArgumentException("Error updating " + tagValue.atToString(group, element) + ": No value specified!");
        }
        if (tv.vrep == 21329) {
            parser.clearFile();
            throw new IllegalArgumentException("Error updating " + tagValue.atToString(group, element) + ": Given tag is a sequence; not supported!");
        }
        if (tv.len < value.length) {
            parser.clearFile();
            throw new IllegalArgumentException("Error updating " + tagValue.atToString(group, element) + ": Given value length (" + value.length + ") bigger than original (" + tv.len + ")!");
        }
        long offset = tv.fileOffset;
        offset += 4L;
        if (parser.isExplicitVR()) {
            offset += 2L;
        }
        if (tv.vrep == 20290 || tv.vrep == 20311 || tv.vrep == 21329 || tv.vrep == 21844 || tv.vrep == 21838) {
            offset += 2L;
        }
        offset = parser.isExplicitVR() ? (offset += 2L) : (offset += 4L);
        RandomAccessFile file = new RandomAccessFile(fileName, "rw");
        file.seek(offset);
        file.write(value);
        if (tv.len > value.length) {
            byte[] zeros = new byte[tv.len - value.length];
            for (int i2 = 0; i2 < zeros.length; ++i2) {
                zeros[i2] = 0;
            }
            file.write(zeros);
        }
        file.close();
        parser.clearFile();
    }

    public static void updatePart10(String fileName, tagValue[] tags, String newFile) throws IOException {
        block3: for (tagValue tv : tags) {
            switch (tv.vrep) {
                case 16709: 
                case 17235: 
                case 19535: 
                case 19540: 
                case 20558: 
                case 21320: 
                case 21332: 
                case 21833: 
                case 21844: {
                    String val = tv.value.toString();
                    if (0 == (val.length() & 1)) continue block3;
                    Tap.log.log(Level.WARNING, "Length is odd for {0}", tv);
                    tv.len = val.length() + 1;
                    Tap.log.log(Level.WARNING, "Updated length to be even for {0}", tv);
                }
            }
        }
        dicomParser parser = new dicomParser(fileName);
        DicomCharSet[] dicomCharsets = parser.getDicomCharsets();
        FileOutputStream fout = new FileOutputStream(newFile);
        byte[] preamble = new byte[132];
        preamble[128] = 68;
        preamble[129] = 73;
        preamble[130] = 67;
        preamble[131] = 77;
        fout.write(preamble);
        int lastGroup = -1;
        Vector<tagValue> group = new Vector<tagValue>();
        while (parser.hasMoreTags()) {
            tagValue tv = parser.readNext();
            if (lastGroup != -1 && tv.group != lastGroup) {
                DicomWriter.dumpGroup(group, fout, 2 == lastGroup ? true : parser.isExplicitVR(), parser.isFileLittleEndian(), dicomCharsets);
                group.clear();
            }
            for (int i2 = 0; i2 < tags.length; ++i2) {
                if (!tags[i2].is(tv.group, tv.element)) continue;
                Tap.log.log(Level.INFO, "Will replace " + tv);
                tv = tags[i2];
                break;
            }
            if (tv.is(8, 5)) {
                dicomCharsets = parser.getDicomCharsets();
            }
            group.add(tv);
            lastGroup = tv.group;
        }
        DicomWriter.dumpGroup(group, fout, parser.isExplicitVR(), parser.isFileLittleEndian(), dicomCharsets);
        fout.close();
        parser.clearFile();
    }

    public static void main(String[] args) {
        try {
            String src = args[0];
            String dst = args[1];
            int size = (args.length - 2) / 3;
            tagValue[] tags = new tagValue[size];
            String[] values = new String[size];
            int i2 = 2;
            int j2 = 0;
            while (i2 < args.length) {
                tags[j2] = new tagValue(Integer.parseInt(args[i2], 16), Integer.parseInt(args[i2 + 1], 16));
                values[j2] = args[i2 + 2];
                i2 += 3;
                ++j2;
            }
            dicomParser parser = new dicomParser(src);
            parser.fill(tags);
            parser.clearFile();
            for (int i3 = 0; i3 < tags.length; ++i3) {
                tags[i3].value = values[i3];
                tags[i3].valueAsBytes = null;
                tags[i3].len = values[i3].length();
            }
            DicomWriter.updatePart10(src, tags, dst);
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }
}

