/*
 * Decompiled with CFR 0.152.
 */
package com.ge.med.terra.tap.util.dicom;

import com.archimed.dicom.DicomObject;
import com.ge.med.terra.tap.util.dicom.DicomComposite;
import com.ge.med.terra.tap.util.dicom.FixedStream;
import com.ge.med.terra.tap.util.dicom.UidGenerator;
import com.ge.med.terra.tap.util.dicom.tagValue;
import java.io.BufferedReader;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.IOException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.StringTokenizer;

class FixDicom {
    public static void epd_err() throws Exception {
        String file = "D:/dev/images/epd_err/i1.dcm";
        String outfile = "D:/dev/images/epd_err/imod.dcm";
        DicomObject obj = new DicomObject();
        FileInputStream in = new FileInputStream(file);
        obj.read(in);
        in.close();
        obj.set_ge(32, 13, "1.2.840.113711.2.25.1.1762157631.873239999.140");
        FileOutputStream out = new FileOutputStream(outfile);
        obj.write(out, true);
        out.close();
        FileInputStream fixed = new FileInputStream(outfile);
        obj.read(fixed);
        fixed.close();
        obj.dumpVRs(System.err);
    }

    public static void genseed(String type) {
        try {
            SimpleDateFormat dfmt = new SimpleDateFormat("yyyyMMdd");
            SimpleDateFormat tfmt = new SimpleDateFormat("HHmmss");
            String today = dfmt.format(Calendar.getInstance().getTime());
            String now = tfmt.format(Calendar.getInstance().getTime());
            System.out.println("Today= " + today);
            System.out.println("Now  = " + now);
            String file = "D:/dev/images/enhanced_sr/Abdomen.dcm";
            String outfile = "D:/work/projects/java/tap/src/java/com/ge/med/terra/tap/util/dicom/srseed.dcm";
            DicomObject obj = new DicomObject();
            FileInputStream in = new FileInputStream(file);
            obj.read(new FixedStream(in));
            in.close();
            obj.set_ge(8, 18, today);
            obj.set_ge(8, 19, now);
            obj.set_ge(8, 24, UidGenerator.newInstanceUID());
            obj.set_ge(8, 32, today);
            obj.set_ge(8, 48, now);
            obj.set_ge(8, 80, "UNKNOWN");
            obj.set_ge(8, 96, "OR");
            obj.set_ge(8, 128, "GSP-TAP");
            obj.set_ge(8, 144, "UNKNOWN");
            obj.set_ge(8, 4368, null);
            obj.set_ge(8, 4369, null);
            obj.set_ge(8, 4373, null);
            obj.set_ge(16, 16, "UNKNOWN");
            obj.set_ge(16, 32, "UNKNOWN");
            obj.set_ge(16, 48, "00000000");
            obj.set_ge(32, 13, UidGenerator.newInstanceUID());
            obj.set_ge(32, 14, UidGenerator.newInstanceUID());
            obj.set_ge(32, 16, "1");
            obj.set_ge(32, 17, "1");
            obj.set_ge(32, 19, "1");
            obj.set_ge(32, 32, "1");
            obj.set_ge(32, 48, "1");
            obj.set_ge(40, 4178, null);
            obj.set_ge(40, 4179, null);
            obj.set_ge(40, 4180, null);
            obj.set_ge(40, 12560, null);
            if (type.equals("GSPS")) {
                obj.set_ge(64, 580, today);
                obj.set_ge(64, 581, now);
                obj.set_ge(64, 595, "UNKNOWN");
                obj.set_ge(64, 596, "UNKNOWN");
                obj.set_ge(64, 629, null);
                obj.set_ge(112, 90, null);
                obj.set_ge(112, 128, "Empty PR");
                obj.set_ge(112, 129, "Empty Presentation Object created by TAP");
                obj.set_ge(112, 130, today);
                obj.set_ge(112, 131, now);
                obj.set_ge(112, 132, "TAP");
                obj.set_ge(8272, 32, null);
            } else if (type.equals("SR")) {
                obj.removeGroup(40);
                obj.removeGroup(57);
                obj.set_ge(64, 41027, null);
                obj.set_ge(64, 41845, null);
                obj.set_ge(64, 42244, null);
                obj.set_ge(64, 42800, null);
            }
            FileOutputStream out = new FileOutputStream(outfile);
            obj.write(out, true);
            out.close();
            FileInputStream fixed = new FileInputStream(outfile);
            obj.read(fixed);
            fixed.close();
            obj.dumpVRs(System.err);
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    public static void modifyWithTap() {
        try {
            String file = "D:/dev/images/group2issue/before.dcm";
            String outfile = "D:/dev/images/group2issue/after1.dcm";
            DicomComposite obj = new DicomComposite();
            FileInputStream in = new FileInputStream(file);
            obj.read(new FixedStream(in));
            in.close();
            obj.setValue(8, 24, "1.2.3.4.5.6.7");
            FileOutputStream out = new FileOutputStream(outfile);
            obj.write(out, true);
            out.close();
            FileInputStream fixed = new FileInputStream(outfile);
            obj.read(fixed);
            fixed.close();
            obj.printDebugInfo(System.err);
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    public static void modify(String infile, String outfile, tagValue[] edits) {
        try {
            DicomObject obj = new DicomObject();
            FileInputStream in = new FileInputStream(infile);
            obj.read(new FixedStream(in));
            in.close();
            for (int i2 = 0; i2 < edits.length; ++i2) {
                System.out.println("Changing  : " + edits[i2]);
                obj.set_ge(edits[i2].group, edits[i2].element, edits[i2].value);
            }
            FileOutputStream out = new FileOutputStream(outfile);
            obj.write(out, true);
            out.close();
            FileInputStream fixed = new FileInputStream(outfile);
            obj.read(fixed);
            fixed.close();
            System.out.println("\nNew Image: ");
            obj.dumpVRs(System.err, true);
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static tagValue[] getTagsToChange(String file) {
        tagValue[] tv = null;
        BufferedReader r2 = null;
        try {
            r2 = new BufferedReader(new FileReader(file));
            String line = r2.readLine();
            ArrayList<tagValue> list = new ArrayList<tagValue>(10);
            while (line != null) {
                StringTokenizer tok = new StringTokenizer(line);
                tagValue t2 = new tagValue(Integer.parseInt(tok.nextToken().substring(2), 16), Integer.parseInt(tok.nextToken().substring(2), 16));
                t2.value = tok.nextToken();
                list.add(t2);
                line = r2.readLine();
            }
            tv = list.toArray(new tagValue[list.size()]);
        }
        catch (Exception e2) {
            e2.printStackTrace();
        }
        finally {
            if (null != r2) {
                try {
                    r2.close();
                }
                catch (IOException iOException) {}
            }
        }
        return tv;
    }

    public static void main(String[] args) {
        try {
            if (args.length == 4 && args[0].equals("-f")) {
                tagValue[] tv = FixDicom.getTagsToChange(args[1]);
                System.out.println("Converting: " + args[2]);
                System.out.println("To        : " + args[3]);
                FixDicom.modify(args[2], args[3], tv);
            } else {
                String me = "java com.ge.med.terra.tap.util.dicom.FixDicom";
                System.out.println("\nUsage: " + me + " -f tags.txt infile outfile");
                System.out.println("\twhere tags file looks like this:");
                System.out.println("\t\t0x0010 0x0010 foo");
                System.out.println("\t\t0x0018 0x1020 bar");
                System.out.println("\t\t ...... ");
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }
}

