/*
 * Decompiled with CFR 0.152.
 */
package com.ge.med.terra.tap.util.dicom;

import com.archimed.dicom.DicomException;
import com.archimed.dicom.SOPClass;
import com.archimed.dicom.UID;
import com.archimed.dicom.UIDEntry;
import com.ge.med.terra.tap.Tap;
import java.lang.reflect.AccessibleObject;
import java.lang.reflect.Field;
import java.util.HashMap;
import java.util.Properties;

public class SOPClassUtil
extends UID {
    public static HashMap jdtSOPs = new HashMap();
    public static HashMap jdtTSIDs = new HashMap();
    public static boolean debug = Tap.getProperty("tap.dm.SOP.debug", "false").equalsIgnoreCase("true");

    public static HashMap getFields(String cname, int maxval) {
        HashMap<String, Integer> fields = new HashMap<String, Integer>();
        try {
            Class<?> c1 = Class.forName(cname);
            AccessibleObject[] fieldArr = c1.getFields();
            Field.setAccessible(fieldArr, true);
            if (debug) {
                System.out.println("class <" + c1 + "> fields:");
            }
            for (int i2 = 0; i2 < fieldArr.length; ++i2) {
                AccessibleObject f2 = fieldArr[i2];
                try {
                    int v2 = ((Field)f2).getInt(c1);
                    if (v2 <= 0 || v2 >= maxval) continue;
                    if (debug) {
                        System.out.println("name:" + ((Field)f2).getName() + " type:" + ((Field)f2).getType() + " val:" + ((Field)f2).getInt(c1));
                    }
                    fields.put(((Field)f2).getName(), new Integer(((Field)f2).getInt(c1)));
                    continue;
                }
                catch (Exception ex) {
                    // empty catch block
                }
            }
        }
        catch (ClassNotFoundException e2) {
            e2.printStackTrace();
        }
        return fields;
    }

    public static void addCustomSOPClasses(Properties props) {
        if (props == null) {
            return;
        }
        String str = props.getProperty("tap.dm.newSOPClasses");
        if (str == null) {
            return;
        }
        int num = Integer.parseInt(str);
        UIDEntry[] entries = new UIDEntry[num];
        for (int i2 = 0; i2 < num; ++i2) {
            str = props.getProperty("tap.dm.newSOPClass" + (i2 + 1));
            if (str == null) continue;
            String[] sop = str.split("\\,");
            if (sop.length != 3) {
                System.out.println("Error parsing <" + str + "> skipping ...");
                continue;
            }
            if (debug) {
                System.out.println("Adding: " + sop[0].trim() + " " + sop[1].trim() + " " + sop[2].trim());
            }
            entries[i2] = new UIDEntry(0, sop[0].trim(), sop[1].trim(), sop[2].trim(), 1);
        }
        try {
            SOPClassUtil.addEntries(entries);
        }
        catch (Exception ex) {
            System.out.println("Failed adding SOPClasses!");
            ex.printStackTrace();
        }
    }

    public static synchronized void addEntries(UIDEntry[] earray) throws DicomException {
        int i2;
        for (i2 = 0; i2 < earray.length; ++i2) {
            if (earray[i2].getType() == 1) continue;
            throw new DicomException("UIDEntry added should be of type SOPClass: " + earray[i2].getName());
        }
        System.out.println("Adding " + earray.length + " entries");
        for (i2 = 0; i2 < earray.length; ++i2) {
            SOPClass.addEntry(earray[i2]);
        }
    }

    public static int[] parseSOPClasses(String sopstr) {
        int i2;
        if (sopstr == null) {
            return null;
        }
        String[] sops = sopstr.split("\\,");
        int[] arr = new int[sops.length];
        for (i2 = 0; i2 < sops.length; ++i2) {
            String sop = sops[i2].trim();
            Integer icode = (Integer)jdtSOPs.get(sop);
            arr[i2] = -1;
            if (icode != null) {
                arr[i2] = icode;
            } else {
                try {
                    UIDEntry uid = UID.getUIDEntry(sop);
                    if (uid != null) {
                        arr[i2] = uid.getConstant();
                    }
                }
                catch (Exception ex) {
                    ex.printStackTrace();
                }
            }
            if (arr[i2] != -1) continue;
            System.out.println("Cannot find SOPClass: <" + sop + ">, skipping ..");
        }
        if (debug) {
            System.out.println(">>> " + sopstr + ":");
            for (i2 = 0; i2 < arr.length; ++i2) {
                System.out.println("sops[i]" + sops[i2].trim() + " :" + arr[i2] + ", ");
            }
        }
        return arr;
    }

    public static void main(String[] args) {
        System.out.println("tsids:" + jdtSOPs.toString());
        int[] arr = SOPClassUtil.parseSOPClasses("ImplicitVRLittleEndian, ExplicitVRBigEndian, ExplicitVRLittleEndian");
    }

    static {
        int maxUIDs = Integer.MAX_VALUE;
        SOPClassUtil.addCustomSOPClasses(Tap.getProperties());
        HashMap tsmap = SOPClassUtil.getFields("com.archimed.dicom.TransferSyntax", maxUIDs);
        if (Tap.logLevel >= Tap.LEVEL_FINE) {
            Tap.log.fine("maxUID: " + maxUIDs);
        }
        jdtTSIDs.putAll(tsmap);
        jdtSOPs.putAll(tsmap);
        jdtSOPs.putAll(SOPClassUtil.getFields("com.archimed.dicom.SOPClass", maxUIDs));
        jdtSOPs.putAll(SOPClassUtil.getFields("com.archimed.dicom.MetaSOPClass", maxUIDs));
        jdtSOPs.putAll(SOPClassUtil.getFields("com.archimed.dicom.SOPInstance", maxUIDs));
    }
}

