/*
 * Decompiled with CFR 0.152.
 */
package com.ge.med.terra.tap.util.dicom;

import com.ge.med.terra.tap.dm.DMElement;
import com.ge.med.terra.tap.dm.DMObject;
import com.ge.med.terra.tap.dm.DMSession;
import com.ge.med.terra.tap.util.dicom.DicomComposite;
import com.ge.med.terra.tap.util.dicom.UidGenerator;
import java.io.FileOutputStream;
import java.io.IOException;
import java.text.SimpleDateFormat;
import java.util.Calendar;

public class SRComposite
extends DicomComposite {
    SimpleDateFormat dfmt = new SimpleDateFormat("yyyyMMdd");
    SimpleDateFormat tfmt = new SimpleDateFormat("HHmmss");
    String today = this.dfmt.format(Calendar.getInstance().getTime());
    String now = this.tfmt.format(Calendar.getInstance().getTime());

    public SRComposite() {
        this.read(this.getClass().getResourceAsStream("srseed.dcm"));
        this.setValue(8, 18, this.today);
        this.setValue(8, 19, this.now);
        this.setValue(8, 24, UidGenerator.newInstanceUID());
        this.setValue(8, 32, this.today);
        this.setValue(8, 48, this.now);
        this.setValue(8, 96, "SR");
        this.setValue(32, 14, UidGenerator.newInstanceUID());
    }

    public void fill(DMObject obj) {
        DMElement[] tagsToFill = new DMElement[]{new DMElement(8, 80), new DMElement(8, 112), new DMElement(8, 144), new DMElement(16, 16), new DMElement(16, 32), new DMElement(16, 48), new DMElement(16, 64), new DMElement(32, 13), new DMElement(32, 16)};
        obj.getValues(tagsToFill);
        this.setValues(tagsToFill);
        try {
            int serNum = Integer.parseInt((String)obj.getValue(32, 17));
            this.setValue(32, 17, "" + (serNum += 1100));
        }
        catch (Exception e2) {
            e2.printStackTrace();
        }
    }

    public static void main(String[] args) {
        try {
            String[] stringArray;
            SRComposite sr = new SRComposite();
            sr.printDebugInfo(System.out);
            if (args.length == 0) {
                String[] stringArray2 = new String[2];
                stringArray2[0] = "file";
                stringArray = stringArray2;
                stringArray2[1] = "d:/dev/images/mr";
            } else {
                stringArray = args;
            }
            DMSession ses = new DMSession(stringArray);
            System.out.println("\nAfter fill()\n");
            sr.fill(ses.getChildren()[0]);
            sr.printDebugInfo(System.out);
            FileOutputStream out = new FileOutputStream("D:/dev/images/enhanced_sr/srseed2.dcm");
            sr.write(out, true);
            out.close();
        }
        catch (IOException ex) {
            ex.printStackTrace();
        }
    }
}

