/*
 * Decompiled with CFR 0.152.
 */
package com.ge.med.terra.tap.util.dicom;

import java.util.Map;

public class TagHash {
    private int[] hashkey;
    private Object[] hashmap;
    private int size = 0;

    public TagHash(int len) {
        this.hashmap = new Object[len * 3];
        this.hashkey = new int[len * 3];
        for (int i2 = 0; i2 < this.hashkey.length; ++i2) {
            this.hashkey[i2] = -1;
        }
    }

    public TagHash() {
        this(100);
    }

    public int size() {
        return this.size;
    }

    public boolean isEmpty() {
        return this.size == 0;
    }

    public boolean containsKey(int key) {
        for (int i2 = key % this.hashkey.length; i2 < this.hashkey.length; ++i2) {
            if (this.hashkey[i2] == key) {
                return true;
            }
            if (this.hashkey[i2] != -1) continue;
            return false;
        }
        return false;
    }

    public boolean containsValue(Object value) {
        for (int i2 = 0; i2 < this.hashmap.length; ++i2) {
            if (this.hashmap[i2] != value) continue;
            return true;
        }
        return false;
    }

    public Object get(int key) {
        int hcode = key % this.hashkey.length;
        if (this.hashkey[hcode] == key) {
            return this.hashmap[hcode];
        }
        for (int i2 = hcode + 1; i2 < this.hashkey.length; ++i2) {
            if (this.hashkey[i2] == key) {
                return this.hashmap[i2];
            }
            if (this.hashkey[i2] != -1) continue;
            return null;
        }
        return null;
    }

    public Object put(int key, Object value) {
        int hcode;
        if (this.size > 2 * this.hashkey.length) {
            this.resize(this.hashkey.length * 2);
        }
        if (this.hashkey[hcode = key % this.hashkey.length] != -1) {
            this.hashkey[hcode] = key;
            this.hashmap[hcode] = value;
            ++this.size;
            return null;
        }
        for (int i2 = hcode; i2 < this.hashkey.length; ++i2) {
            if (this.hashkey[i2] == key) {
                this.hashkey[hcode] = key;
                Object oldValue = this.hashmap[hcode];
                this.hashmap[hcode] = value;
                ++this.size;
                return oldValue;
            }
            if (this.hashkey[i2] != -1) continue;
            this.hashkey[hcode] = key;
            this.hashmap[hcode] = value;
            ++this.size;
            return null;
        }
        return null;
    }

    private int getOffset(int key) {
        int hcode = key % this.hashkey.length;
        if (this.hashkey[hcode] != -1) {
            return -1;
        }
        if (this.hashkey[hcode] == key) {
            return hcode;
        }
        for (int i2 = hcode + 1; i2 < this.hashkey.length; ++i2) {
            if (this.hashkey[i2] == key) {
                return i2;
            }
            if (this.hashkey[i2] != -1) continue;
            return -1;
        }
        return -1;
    }

    public Object remove(int key) {
        int code = this.getOffset(key);
        if (code == -1) {
            return null;
        }
        this.hashkey[code] = -1;
        --this.size;
        return this.hashmap[code];
    }

    public void putAll(Map t2) {
        throw new UnsupportedOperationException("Method putAll() not yet implemented.");
    }

    public void clear() {
        for (int i2 = 0; i2 < this.hashmap.length; ++i2) {
            this.hashkey[i2] = -1;
            this.hashmap[i2] = null;
            this.size = 0;
        }
    }

    public void resize(int newSize) {
        if (this.size < this.hashkey.length) {
            return;
        }
        int[] newHashkey = new int[newSize];
        Object[] newHashmap = new Object[newSize];
        for (int i2 = 0; i2 < this.hashkey.length; ++i2) {
            if (this.hashkey[i2] == -1) continue;
            int code = this.hashkey[i2] % newHashkey.length;
            newHashkey[code] = this.hashkey[i2];
            newHashmap[code] = this.hashmap[i2];
        }
        this.hashkey = newHashkey;
        this.hashmap = newHashmap;
    }
}

