/*
 * Decompiled with CFR 0.152.
 */
package com.ge.med.terra.tap.util.dicom;

import java.math.BigInteger;
import java.util.UUID;

public class UUIDUtil {
    public static byte[] asByteArray(UUID uuid) {
        int i2;
        long msb = uuid.getMostSignificantBits();
        long lsb = uuid.getLeastSignificantBits();
        byte[] buffer = new byte[16];
        for (i2 = 0; i2 < 8; ++i2) {
            buffer[i2] = (byte)(msb >>> 8 * (7 - i2));
        }
        for (i2 = 8; i2 < 16; ++i2) {
            buffer[i2] = (byte)(lsb >>> 8 * (7 - i2));
        }
        return buffer;
    }

    public static UUID toUUID(byte[] byteArray) {
        int i2;
        long msb = 0L;
        long lsb = 0L;
        for (i2 = 0; i2 < 8; ++i2) {
            msb = msb << 8 | (long)(byteArray[i2] & 0xFF);
        }
        for (i2 = 8; i2 < 16; ++i2) {
            lsb = lsb << 8 | (long)(byteArray[i2] & 0xFF);
        }
        UUID result = new UUID(msb, lsb);
        return result;
    }

    public static BigInteger asInteger(UUID uuid) {
        byte[] uuidArray = UUIDUtil.asByteArray(uuid);
        BigInteger uuidInteger = new BigInteger(1, uuidArray);
        return uuidInteger;
    }

    public static UUID toUUID(BigInteger uuidInteger) {
        String uuidHex = uuidInteger.toString(16);
        String[] components = new String[]{uuidHex.substring(0, 8), uuidHex.substring(8, 12), uuidHex.substring(12, 16), uuidHex.substring(16, 20), uuidHex.substring(20)};
        uuidHex = components[0] + "-" + components[1] + "-" + components[2] + "-" + components[3] + "-" + components[4];
        UUID result = UUID.fromString(uuidHex);
        return result;
    }

    public static String randomUUIDAsInteger() {
        return UUIDUtil.asInteger(UUID.randomUUID()).toString();
    }
}

