/*
 * Decompiled with CFR 0.152.
 */
package com.ge.med.terra.tap.util.dicom;

import com.ge.med.terra.tap.dm.DMObject;
import com.ge.med.terra.tap.util.dicom.DicomComposite;
import com.ge.med.terra.tap.util.dicom.UidGenerator;
import java.awt.Image;
import java.awt.image.BufferedImage;
import java.awt.image.DataBufferByte;
import java.io.InputStream;
import java.text.SimpleDateFormat;
import java.util.Date;
import javax.swing.JComponent;

public class Utils {
    public static InputStream getScreenCapture(DMObject dmo, JComponent comp) {
        return Utils.getScreenCapture(dmo, comp, null);
    }

    public static InputStream getScreenCapture(DMObject dmo, JComponent comp, String SeriesUID) {
        DicomComposite obj = Utils.getScreenCapture(dmo, SeriesUID);
        int width = comp.getWidth();
        int height = comp.getHeight();
        obj.setValue(40, 16, new Integer(width));
        obj.setValue(40, 17, new Integer(height));
        BufferedImage bi = new BufferedImage(width, height, 5);
        comp.paint(bi.createGraphics());
        DataBufferByte dbi = (DataBufferByte)bi.getRaster().getDataBuffer();
        byte[] bb = dbi.getData();
        for (int i2 = 0; i2 < bb.length; i2 += 3) {
            byte t2 = bb[i2];
            bb[i2] = bb[i2 + 2];
            bb[i2 + 2] = t2;
        }
        obj.setValue(32736, 16, bb);
        return obj.getInputStream(true, (String)dmo.getValue(2, 16));
    }

    public static InputStream getScreenCapture(DMObject dmo, BufferedImage img, String SeriesUID) {
        byte[] bb;
        DicomComposite obj = Utils.getScreenCapture(dmo, SeriesUID);
        int width = img.getWidth();
        int height = img.getHeight();
        obj.setValue(40, 16, new Integer(width));
        obj.setValue(40, 17, new Integer(height));
        if (img.getType() != 5) {
            BufferedImage bi = new BufferedImage(width, height, 5);
            bi.createGraphics().drawImage((Image)img, 0, 0, null);
            DataBufferByte dbi = (DataBufferByte)bi.getRaster().getDataBuffer();
            bb = dbi.getData();
            for (int i2 = 0; i2 < bb.length; i2 += 3) {
                byte t2 = bb[i2];
                bb[i2] = bb[i2 + 2];
                bb[i2 + 2] = t2;
            }
        } else {
            DataBufferByte dbi = (DataBufferByte)img.getRaster().getDataBuffer();
            bb = dbi.getData();
            for (int i3 = 0; i3 < bb.length; i3 += 3) {
                byte t3 = bb[i3];
                bb[i3] = bb[i3 + 2];
                bb[i3 + 2] = t3;
            }
        }
        obj.setValue(32736, 16, bb);
        return obj.getInputStream(true, (String)dmo.getValue(2, 16));
    }

    private static DicomComposite getScreenCapture(DMObject dmo, String SeriesUID) {
        if (SeriesUID == null) {
            DMObject[] exam = dmo.getRelated("Study");
            DMObject[] series = exam[0].getRelated("Series");
            for (int i2 = 0; i2 < series.length; ++i2) {
                String seriesNo = (String)series[i2].getValue(32, 17);
                if (seriesNo == null || !seriesNo.equals("99")) continue;
                SeriesUID = (String)series[i2].getValue(32, 14);
                break;
            }
        }
        DicomComposite obj = new DicomComposite();
        obj.setValue(2, 1, dmo.getValue(2, 1));
        obj.setValue(2, 2, "1.2.840.10008.4.1.4.1.1.7");
        obj.setValue(2, 3, UidGenerator.newInstanceUID());
        obj.setValue(2, 16, dmo.getValue(2, 16));
        obj.setValue(2, 18, dmo.getValue(2, 18));
        obj.setValue(2, 19, dmo.getValue(2, 19));
        obj.setValue(2, 22, dmo.getValue(2, 22));
        String charSet = (String)dmo.getValue(8, 5);
        if (charSet == null) {
            charSet = "ISO_IR 100";
        }
        obj.setValue(8, 5, charSet);
        String pName = (String)dmo.getValue(16, 16);
        if (pName == null) {
            pName = "";
        }
        obj.setValue(16, 16, pName);
        String pId = (String)dmo.getValue(16, 32);
        if (pId == null) {
            pId = "";
        }
        obj.setValue(16, 32, pId);
        String pBdate = (String)dmo.getValue(16, 48);
        if (pBdate == null) {
            pBdate = "";
        }
        obj.setValue(16, 48, pBdate);
        String pSex = (String)dmo.getValue(16, 64);
        if (pSex == null) {
            pSex = "";
        }
        obj.setValue(16, 64, pSex);
        obj.setValue(32, 13, dmo.getValue(32, 13));
        String exDate = (String)dmo.getValue(8, 32);
        if (exDate == null) {
            exDate = "";
        }
        obj.setValue(8, 32, exDate);
        String exTime = (String)dmo.getValue(8, 48);
        if (exTime == null) {
            exTime = "";
        }
        obj.setValue(8, 48, exTime);
        String refPhy = (String)dmo.getValue(8, 144);
        if (refPhy == null) {
            refPhy = "";
        }
        obj.setValue(8, 144, refPhy);
        String exId = (String)dmo.getValue(32, 16);
        if (exId == null) {
            exId = "";
        }
        obj.setValue(32, 16, exId);
        String accessionNo = (String)dmo.getValue(8, 80);
        if (accessionNo == null) {
            accessionNo = "";
        }
        obj.setValue(8, 80, accessionNo);
        String exDescpt = (String)dmo.getValue(8, 4144);
        if (exDescpt == null) {
            exDescpt = "";
        }
        obj.setValue(8, 4144, exDescpt);
        String patAge = (String)dmo.getValue(16, 4112);
        if (patAge == null) {
            patAge = "";
        }
        obj.setValue(16, 4112, patAge);
        String pat1 = (String)dmo.getValue(16, 4128);
        if (pat1 == null) {
            pat1 = "";
        }
        obj.setValue(16, 4128, pat1);
        String patWeight = (String)dmo.getValue(16, 4144);
        if (patWeight == null) {
            patWeight = "";
        }
        obj.setValue(16, 4144, patWeight);
        String modality = (String)dmo.getValue(8, 96);
        if (modality == null) {
            modality = "";
        }
        obj.setValue(8, 96, modality);
        if (SeriesUID == null) {
            SeriesUID = UidGenerator.newInstanceUID();
        }
        obj.setValue(32, 14, SeriesUID);
        obj.setValue(32, 17, Integer.toString(99));
        String laterality = (String)dmo.getValue(32, 96);
        if (laterality == null) {
            laterality = "";
        }
        obj.setValue(32, 96, laterality);
        obj.setValue(8, 4158, "Screen Save");
        String patPos = (String)dmo.getValue(24, 20736);
        if (patPos == null) {
            patPos = "";
        }
        obj.setValue(24, 20736, patPos);
        String Protocol_Name = (String)dmo.getValue(24, 4144);
        if (Protocol_Name == null) {
            Protocol_Name = "";
        }
        obj.setValue(24, 4144, Protocol_Name);
        String Contrast_on_Screen_Save = (String)dmo.getValue(24, 16);
        if (Contrast_on_Screen_Save == null) {
            Contrast_on_Screen_Save = "";
        }
        obj.setValue(24, 16, Contrast_on_Screen_Save);
        String unk1 = (String)dmo.getValue(24, 4160);
        if (unk1 == null) {
            unk1 = "";
        }
        obj.setValue(24, 4160, unk1);
        Object pps_sequence = dmo.getValue(8, 4369);
        String manuf = (String)dmo.getValue(8, 112);
        if (manuf == null) {
            manuf = "";
        }
        obj.setValue(8, 112, manuf);
        String institutionName = (String)dmo.getValue(8, 128);
        if (institutionName == null) {
            institutionName = "";
        }
        obj.setValue(8, 128, institutionName);
        String unk2 = (String)dmo.getValue(8, 129);
        if (unk2 == null) {
            unk2 = "";
        }
        obj.setValue(8, 129, unk2);
        String stationName = (String)dmo.getValue(8, 4112);
        if (stationName == null) {
            stationName = "";
        }
        obj.setValue(8, 4112, stationName);
        String manfmodel = (String)dmo.getValue(8, 4240);
        if (manfmodel == null) {
            manfmodel = "";
        }
        obj.setValue(8, 4240, manfmodel);
        obj.setValue(8, 100, "WSD");
        obj.setValue(32, 19, new Integer(1));
        String unk3 = (String)dmo.getValue(32, 32);
        if (unk3 == null) {
            unk3 = "";
        }
        obj.setValue(32, 32, unk3);
        SimpleDateFormat dateFormat = new SimpleDateFormat("yyyyMMdd");
        String date = dateFormat.format(new Date());
        SimpleDateFormat timeFormat = new SimpleDateFormat("hhmmss");
        obj.setValue(8, 35, date);
        obj.setValue(8, 8, "DERIVED\\SECONDARY\\SCREEN SAVE");
        obj.setValue(40, 2, new Integer(3));
        obj.setValue(40, 4, "RGB");
        obj.setValue(40, 256, new Integer(8));
        obj.setValue(40, 257, new Integer(8));
        obj.setValue(40, 258, new Integer(7));
        obj.setValue(40, 259, new Integer(0));
        obj.removeTag(40, 4178);
        obj.removeTag(40, 4179);
        obj.removeTag(40, 4180);
        obj.setValue(40, 6, new Integer(0));
        obj.setValue(40, 48, new String("0.488281\\0.488281"));
        obj.setValue(40, 769, new String("YES "));
        obj.setValue(8, 22, "1.2.840.10008.5.1.4.1.1.7");
        obj.setValue(8, 24, UidGenerator.newInstanceUID());
        obj.setValue(2, 3, UidGenerator.newInstanceUID());
        return obj;
    }
}

