/*
 * Decompiled with CFR 0.152.
 */
package com.ge.med.terra.tap.util.er;

import com.ge.med.terra.tap.util.er.ErServer;
import com.ge.med.terra.tap.util.er.ErServerEvent;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.net.Socket;
import java.nio.ByteBuffer;
import java.util.HashMap;
import java.util.Vector;

public class ErClientProxy {
    DataInputStream is;
    DataOutputStream os;
    HashMap reg = new HashMap();
    ErServer server;

    public ErClientProxy(Socket s2, ErServer server) {
        this.server = server;
        try {
            this.is = new DataInputStream(s2.getInputStream());
            this.os = new DataOutputStream(s2.getOutputStream());
        }
        catch (IOException ex) {
            throw new RuntimeException(ex);
        }
        Thread t2 = new Thread(){

            @Override
            public void run() {
                ErServerEvent event = new ErServerEvent();
                try {
                    block2: while (true) {
                        int eventCount;
                        if ((eventCount = ErClientProxy.this.is.readInt()) != 1) {
                            System.out.println("eventcount =" + eventCount);
                        }
                        int type = ErClientProxy.this.is.readInt();
                        int i2 = 0;
                        while (true) {
                            if (i2 >= eventCount) continue block2;
                            event.read(ErClientProxy.this.is);
                            ErClientProxy.this.processEvent(type, event, System.currentTimeMillis());
                            ++i2;
                        }
                        break;
                    }
                }
                catch (IOException ex) {
                    ErClientProxy.this.removeMe();
                    return;
                }
            }
        };
        t2.setName("socket");
        t2.start();
    }

    private void removeMe() {
        this.server.clients.remove(this);
    }

    public void processEvent(int type, ErServerEvent event, long time) {
        switch (type) {
            case 13: {
                ListenFor l2 = new ListenFor(event.type, event.getBuffer(), time);
                this.reg.put(l2.eventType, l2);
                break;
            }
            case 14: {
                this.reg.remove(event.getType());
                break;
            }
            case 15: {
                this.server.dispatch(event.type, event, this, time);
                break;
            }
            default: {
                throw new RuntimeException("dont know the event =" + event.type);
            }
        }
    }

    public synchronized void send(String type, ErServerEvent s2, long time) throws IOException {
        ListenFor l2 = (ListenFor)this.reg.get(type);
        if (l2 == null) {
            return;
        }
        if (s2 != null) {
            l2.unsent.add(s2);
            s2.atach();
        }
        this.send(l2, time);
    }

    public void wake() {
        long time = System.currentTimeMillis();
        for (ListenFor l2 : this.reg.values()) {
            if (time - l2.last < (long)l2.minTime) continue;
            try {
                this.send(l2, time);
            }
            catch (IOException ex) {}
        }
    }

    private synchronized void send(ListenFor l2, long time) throws IOException {
        if (time - l2.last >= (long)l2.minTime) {
            this.os.writeInt(l2.unsent.size());
            while (l2.unsent.size() > 0) {
                ErServerEvent se = (ErServerEvent)l2.unsent.remove(0);
                se.write(this.os);
                se.detach();
            }
            l2.last = time;
        } else {
            this.server.notifyLater(this, (long)l2.minTime - (time - l2.last));
        }
    }

    public static class ListenFor {
        String eventType;
        int minTime;
        long last;
        Vector unsent = new Vector();

        public ListenFor(String type, ByteBuffer b2, long time) {
            this.eventType = type;
            this.minTime = b2.getInt();
            this.last = time;
        }
    }
}

