/*
 * Decompiled with CFR 0.152.
 */
package com.ge.med.terra.tap.util.log;

import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.logging.Handler;
import java.util.logging.Level;
import java.util.logging.LogRecord;

public class TapHandler
extends Handler {
    @Override
    public void close() {
    }

    @Override
    public void flush() {
    }

    @Override
    public void publish(LogRecord record) {
        Level logLevel = record.getLevel();
        if (logLevel == Level.INFO) {
            System.out.print(logLevel);
            System.out.print("       |".substring(logLevel.getName().length()));
            System.out.println(record.getMessage());
            return;
        }
        this.printline(record);
    }

    private void printline(LogRecord record) {
        long time = record.getMillis();
        String method = record.getSourceMethodName();
        int lineno = -1;
        Level logLevel = record.getLevel();
        String fileName = "?";
        StackTraceElement[] el = new Throwable().getStackTrace();
        for (int i2 = 0; i2 < el.length; ++i2) {
            if (!el[i2].getMethodName().equals(method)) continue;
            lineno = el[i2].getLineNumber();
            fileName = el[i2].getFileName();
            break;
        }
        StringBuffer s2 = new StringBuffer();
        s2.append(logLevel);
        s2.append("       |\"".substring(logLevel.getName().length()));
        s2.append(record.getMessage());
        s2.append("\"|");
        s2.append(record.getSourceClassName());
        s2.append(".");
        s2.append(method);
        s2.append("(");
        s2.append(fileName);
        s2.append(":");
        s2.append(lineno);
        s2.append(")[");
        s2.append(record.getThreadID());
        s2.append("/");
        SimpleDateFormat df = new SimpleDateFormat("yyyyMMdd.HH:mm.ss.SSS");
        s2.append(df.format(new Date(time)));
        s2.append("]");
        System.out.println(s2);
    }
}

