/*
 * Decompiled with CFR 0.152.
 */
package com.ge.med.terra.tap.util.log;

import com.ge.med.terra.tap.util.SimpleUtilities;
import com.ge.med.terra.tap.util.log.Tid;
import java.util.logging.Formatter;
import java.util.logging.Level;
import java.util.logging.LogRecord;

public class TapLogFormatter
extends Formatter {
    @Override
    public synchronized String format(LogRecord record) {
        Level logLevel = record.getLevel();
        String method = record.getSourceMethodName();
        int lineno = -1;
        String fileName = "?";
        StackTraceElement[] el = new Throwable().getStackTrace();
        for (int i2 = 0; i2 < el.length; ++i2) {
            if (!el[i2].getMethodName().equals(method)) continue;
            lineno = el[i2].getLineNumber();
            fileName = el[i2].getFileName();
            break;
        }
        StringBuffer result = new StringBuffer();
        result.append(logLevel);
        result.append("       |\"".substring(logLevel.getName().length()));
        String message = this.formatMessage(record);
        result.append(message);
        Throwable thrown = record.getThrown();
        if (null != thrown) {
            result.append(thrown);
        }
        result.append("\" at ");
        if (logLevel.intValue() == Level.INFO.intValue()) {
            result.append("(");
            result.append(fileName);
            result.append(":");
            result.append(lineno);
            result.append(")");
        } else {
            result.append(record.getSourceClassName());
            result.append(".");
            result.append(method);
            result.append("(");
            result.append(fileName);
            result.append(":");
            result.append(lineno);
            result.append(")[");
            result.append(record.getThreadID());
            result.append("/");
            long time = record.getMillis();
            result.append(time);
            result.append("]");
            long t2 = Tid.getTID();
            if (t2 != -1L) {
                result.append("(T");
                result.append(t2);
                result.append(")");
            }
        }
        result.append(SimpleUtilities.getLineSeparator());
        return result.toString();
    }
}

