/*
 * Decompiled with CFR 0.152.
 */
package com.ge.med.terra.tap.util.log;

import com.ge.med.terra.tap.util.log.CheckTlt;
import com.ge.med.terra.tap.util.log.Logger;
import java.lang.reflect.Method;

public class TltAdapter {
    protected static boolean tltUp = false;
    private static final String TltMessage = "com.ge.med.tlt.TltMessage";
    private static final String TltFormattable = "com.ge.med.tlt.TltFormattable";

    public TltAdapter() {
        try {
            System.loadLibrary("Tltjni");
            CheckTlt t2 = new CheckTlt();
            t2.start();
            while (t2.isAlive()) {
            }
            t2 = null;
        }
        catch (UnsatisfiedLinkError e2) {
            System.out.println("Unable to Load library Tltjni");
        }
    }

    public boolean isTltUp() {
        return tltUp;
    }

    public int send(int level, String msg) {
        String logLevel;
        int retVal = 1;
        switch (level) {
            case 0: {
                logLevel = "Error";
                break;
            }
            case 1: {
                logLevel = "Warning";
                break;
            }
            case 2: {
                logLevel = "Status";
                break;
            }
            case 3: {
                logLevel = "Debug";
                break;
            }
            default: {
                logLevel = "Unknown";
            }
        }
        Class<?> tltMessage = null;
        Class<?> tltFormattable = null;
        Method[] tltMessageMethods = null;
        Method[] tltFormattableMethods = null;
        int send = -1;
        int setField = -1;
        int getField = -1;
        try {
            int k2;
            tltMessage = Class.forName(TltMessage);
            tltFormattable = Class.forName(TltFormattable);
            Object tltMessageObj = tltMessage.newInstance();
            Object tltFormattableObj = tltFormattable.newInstance();
            tltMessageMethods = tltMessage.getMethods();
            tltFormattableMethods = tltFormattable.getMethods();
            for (k2 = 0; k2 < tltMessageMethods.length; ++k2) {
                if (tltMessageMethods[k2].getName().equals("setField")) {
                    setField = k2;
                }
                if (tltMessageMethods[k2].getName().equals("getField")) {
                    getField = k2;
                }
                if (!tltMessageMethods[k2].getName().equals("send")) continue;
                send = k2;
            }
            for (k2 = 0; k2 < tltFormattableMethods.length; ++k2) {
                if (!tltFormattableMethods[k2].getName().equals("setString")) continue;
                tltFormattableMethods[k2].invoke(tltFormattableObj, logLevel);
            }
            if (getField != -1 && setField != -1) {
                String s2 = "eCategory";
                int i2 = tltMessage.getField("eCategory").getInt(tltMessageObj);
                tltMessageMethods[setField].invoke(tltMessageObj, new Integer(i2), tltFormattableObj);
            } else {
                Logger.send("setField/getField not found in tltMessageObj");
            }
            if (send == -1) {
                throw new Exception();
            }
            tltMessageMethods[send].invoke(tltMessageObj, msg, new Integer(0));
        }
        catch (Exception ex) {
            tltUp = false;
            Logger.send("Tlt classes could not be instantiated");
            Logger.send(level, msg);
        }
        return retVal;
    }
}

