/*
 * Decompiled with CFR 0.152.
 */
package com.ge.med.terra.tap.util.socket;

import com.ge.med.terra.tap.util.socket.SocketClient;
import com.ge.med.terra.tap.util.socket.SocketListener;
import java.io.IOException;

public class SocketPerformance {
    private int size = 1;
    private String host = "localhost";
    private String port = "9909";
    private boolean dBug = false;

    public SocketPerformance(String[] args) {
        if (args != null && args.length > 0) {
            this.host = args[0];
        }
        if (args != null && args.length > 1) {
            this.port = args[1];
        }
        if (args != null && args.length > 2) {
            this.size = Integer.parseInt(args[2]);
        }
        if (args != null && args.length > 3) {
            this.dBug = args[3].equalsIgnoreCase("DEBUGON");
        }
    }

    public void tcp_perf() {
        this.tcp_perf(this.size);
    }

    public void tcp_perf(int msgsize) {
        SocketClient client = new SocketClient(this.host, this.port);
        client.setDebugOn(this.dBug);
        try {
            int size = msgsize;
            if (size <= 0) {
                size = 1;
            }
            byte[] msg = new byte[1024 * size];
            long start = System.currentTimeMillis();
            client.tcpip_byte_test_stub(msg);
            long elapse = System.currentTimeMillis() - start;
            System.out.println("" + size + "Kb, " + elapse + "ms");
        }
        catch (Exception e2) {
            e2.printStackTrace();
        }
    }

    public void tcp_perf_same_jvm() {
        final SocketListener server = new SocketListener();
        SocketClient client = new SocketClient();
        server.setDebugOn(this.dBug);
        client.setDebugOn(this.dBug);
        try {
            Thread t2 = new Thread(new Runnable(){

                @Override
                public void run() {
                    try {
                        server.tcpipByteSocket(SocketPerformance.this.port);
                    }
                    catch (IOException ioex) {
                        ioex.printStackTrace();
                    }
                }
            });
            t2.start();
            byte[] msg = new byte[1024 * this.size];
            long start = System.currentTimeMillis();
            client.tcpip_byte_test_stub(this.host, this.port, msg);
            long elapse = System.currentTimeMillis() - start;
            System.out.println("Synchronous send of " + this.size + "Kb in " + elapse + " ms in same JVM");
            server.kill();
        }
        catch (Exception e2) {
            server.kill();
            e2.printStackTrace();
        }
    }

    public static void usage() {
        System.out.println("Usage: SocketPerformance HOST PORT");
        System.exit(1);
    }

    public static void main(String[] args) {
        if (args == null || args.length < 2) {
            SocketPerformance.usage();
        }
        SocketPerformance sp = new SocketPerformance(args);
        for (int i2 = 0; i2 <= 12; ++i2) {
            sp.tcp_perf(1 << i2);
        }
    }
}

