/*
 * Decompiled with CFR 0.152.
 */
package com.ge.med.terra.tap.util.tgraph;

import com.ge.med.terra.tap.util.tgraph.TGraphCursor;
import java.awt.Color;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseMotionAdapter;
import java.awt.geom.AffineTransform;
import java.awt.geom.Point2D;
import java.beans.Beans;
import java.util.Vector;
import javax.swing.JPanel;

public class TGraph
extends JPanel {
    double xAxisMajorTickSpacing = 0.1;
    double xAxisMinorTickSpacing = 0.05;
    double yAxisMajorTickSpacing = 0.1;
    double yAxisMinorTickSpacing = 0.05;
    double yAxisMin = 0.0;
    double yAxisMax = 1.0;
    double xAxisMin = 0.0;
    double xAxisMax = 1.0;
    boolean xAxisShow = true;
    boolean yAxisShow = true;
    final int graphNorthOffset = 20;
    final int graphSouthOffset = 20;
    final int graphEastOffset = 20;
    final int graphWestOffset = 20;
    final int majorTickLen = 4;
    int graphMode = 0;
    public final int CURVE_GRAPH = 0;
    public final int BAR_GRAPH = 1;
    public final int SCATTER_GRAPH = 2;
    private int barShift = 10;
    private Color showPointColor = Color.yellow;
    private boolean showPoints = false;
    private boolean autoResetAxis = true;
    Point2D[] pts;
    Point2D[] pts2;
    int[] xPoints;
    int[] yPoints;
    Vector cursorList = new Vector();
    long[] times = new long[10];
    int tcount = 0;
    AffineTransform at = new AffineTransform();
    boolean isInverted;
    double yThreshHold = 0.0;
    Color aboveColor = Color.green;
    Color belowColor = Color.red;
    private String[] labels;
    private boolean showTip = false;

    public void setPoints(Point2D[] p2) {
        this.pts = p2;
        if (this.pts2 == null || this.pts2.length != this.pts.length) {
            this.pts2 = new Point2D[this.pts.length];
        }
        if (this.xPoints == null || this.xPoints.length != this.pts.length) {
            this.xPoints = new int[p2.length];
        }
        if (this.yPoints == null || this.yPoints.length != this.pts.length) {
            this.yPoints = new int[p2.length];
        }
        if (this.autoResetAxis) {
            this.recalcAxis();
        }
        this.recalcPoints();
        if (this.getParent() != null) {
            this.getParent().repaint(this.getX(), this.getY(), this.getWidth(), this.getHeight());
        }
    }

    public void setPoints(double[] x2, double[] y2) {
        Point2D[] p2 = new Point2D[y2.length];
        for (int i2 = 0; i2 < y2.length; ++i2) {
            p2[i2] = new Point2D.Double(x2[i2], y2[i2]);
        }
        this.setPoints(p2);
    }

    @Override
    public void paint(Graphics g2) {
        long t1 = System.currentTimeMillis();
        Graphics2D g22 = (Graphics2D)g2;
        this.plotAxis(g2);
        this.paintGraph(g2);
        this.paintChildren(g2);
        this.paintCursors(g2);
        t1 = System.currentTimeMillis() - t1;
        this.times[this.tcount++] = t1;
        this.tcount %= this.times.length;
        if (this.tcount == 0) {
            int sum = 0;
            for (int i2 = 0; i2 < this.times.length; ++i2) {
                sum = (int)((long)sum + this.times[i2]);
            }
            double avg = (double)sum / (double)this.times.length;
            System.out.println("avg = " + avg);
        }
    }

    private void paintGraph(Graphics g2) {
        Graphics g22 = g2.create();
        g22.setClip(20, 20, this.getWidth() - 20 - 20, this.getHeight() - 20 - 20);
        g22.setColor(Color.black);
        if (this.xPoints != null) {
            switch (this.graphMode) {
                case 0: {
                    g2.drawPolyline(this.xPoints, this.yPoints, this.yPoints.length);
                    break;
                }
                case 2: {
                    for (int i2 = 0; i2 < this.yPoints.length; ++i2) {
                        g2.setColor(this.pts[i2].getY() > this.yThreshHold ? this.aboveColor : this.belowColor);
                        g2.fillRect(this.xPoints[i2] - 3, this.yPoints[i2] - 3, 6, 6);
                    }
                    break;
                }
                case 1: {
                    g2.setColor(Color.gray);
                    for (int i3 = 0; i3 < this.yPoints.length; ++i3) {
                        g2.setColor(this.pts[i3].getY() > this.yThreshHold ? this.aboveColor : this.belowColor);
                        g2.fillRect(this.barShift + this.xPoints[i3] - 6, this.yPoints[i3], 12, this.getHeight() - 20 - this.yPoints[i3]);
                    }
                    break;
                }
            }
        }
    }

    private void paintPoints(int point, Graphics g2, boolean mark) {
        if (this.xPoints != null) {
            switch (this.graphMode) {
                case 0: {
                    g2.drawRect(this.xPoints[point] - 2, this.yPoints[point] - 2, 4, 4);
                    break;
                }
                case 2: {
                    Color c2;
                    Color color = c2 = this.pts[point].getY() > this.yThreshHold ? this.aboveColor : this.belowColor;
                    if (mark) {
                        c2 = c2.brighter();
                    }
                    g2.setColor(c2);
                    g2.fillRect(this.xPoints[point] - 3, this.yPoints[point] - 3, 6, 6);
                    break;
                }
                case 1: {
                    Color c2;
                    Color color = c2 = this.pts[point].getY() > this.yThreshHold ? this.aboveColor : this.belowColor;
                    if (mark) {
                        c2 = c2.brighter();
                    }
                    g2.setColor(c2);
                    g2.fillRect(this.barShift + this.xPoints[point] - 6, this.yPoints[point], 12, this.getHeight() - 20 - this.yPoints[point]);
                }
            }
        }
    }

    private void recalcPoints() {
        if (this.yPoints == null) {
            return;
        }
        double xscale = (double)(this.getWidth() - 20 - 20) / (this.xAxisMax - this.xAxisMin);
        double xoffset = 20.0 - this.xAxisMin * xscale;
        double yscale = (double)(-(this.getHeight() - 20 - 20)) / (this.yAxisMax - this.yAxisMin);
        double yoffset = (double)(this.getHeight() - 20) - this.yAxisMin * yscale;
        this.at.setToIdentity();
        this.at.setToTranslation(xoffset, yoffset);
        this.at.scale(xscale, yscale);
        this.at.transform(this.pts, 0, this.pts2, 0, this.pts.length);
        for (int i2 = 0; i2 < this.pts.length; ++i2) {
            this.xPoints[i2] = (int)this.pts2[i2].getX();
            this.yPoints[i2] = (int)this.pts2[i2].getY();
        }
    }

    public void recalcAxis() {
        this.yAxisMin = this.yAxisMax = this.pts[0].getY();
        this.xAxisMin = this.xAxisMax = this.pts[0].getX();
        for (int i2 = 0; i2 < this.pts.length; ++i2) {
            if (this.yAxisMin > this.pts[i2].getY()) {
                this.yAxisMin = this.pts[i2].getY();
            } else if (this.yAxisMax < this.pts[i2].getY()) {
                this.yAxisMax = this.pts[i2].getY();
            }
            if (this.xAxisMin > this.pts[i2].getX()) {
                this.xAxisMin = this.pts[i2].getX();
                continue;
            }
            if (!(this.xAxisMax < this.pts[i2].getX())) continue;
            this.xAxisMax = this.pts[i2].getX();
        }
        this.yAxisMajorTickSpacing = (this.yAxisMax - this.yAxisMin) / 5.0;
        this.xAxisMajorTickSpacing = (this.xAxisMax - this.xAxisMin) / 5.0;
    }

    private void plotAxis(Graphics g2) {
        this.plotYAxis(g2);
        this.plotXAxis(g2);
    }

    private void plotYAxis(Graphics g2) {
        g2.drawRect(20, 20, 1, this.getHeight() - 20 - 20);
        double step = (this.yAxisMax - this.yAxisMin) / this.yAxisMajorTickSpacing;
        if (step > 0.0) {
            double tickDist = (double)(this.getHeight() - 20 - 20) / step;
            double ticky = this.getHeight() - 20;
            for (double y2 = this.yAxisMin; y2 <= this.yAxisMax; y2 += this.yAxisMajorTickSpacing) {
                g2.drawRect(16, (int)ticky, 4, 1);
                ticky -= tickDist;
            }
        }
    }

    private void plotXAxis(Graphics g2) {
        g2.drawRect(20, this.getHeight() - 20, this.getWidth() - 20 - 20, 1);
        double step = (this.xAxisMax - this.xAxisMin) / this.xAxisMajorTickSpacing;
        if (step > 0.0) {
            int ypos = this.getHeight() - 20;
            double tickDist = (double)(this.getWidth() - 20 - 20) / step;
            double tickx = 20.0;
            for (double x2 = this.xAxisMin; x2 <= this.xAxisMax; x2 += this.xAxisMajorTickSpacing) {
                g2.drawRect((int)tickx, ypos, 1, 4);
                tickx += tickDist;
            }
        }
    }

    public void addCursor(TGraphCursor c2) {
        this.cursorList.add(c2);
        this.addMouseListener(c2);
        this.addMouseMotionListener(c2);
    }

    public void paintCursors(Graphics g2) {
        for (TGraphCursor c2 : this.cursorList) {
            c2.paint(g2, this);
        }
    }

    public void setXPoints(double[] x2) {
        Point2D[] p2 = this.pts == null ? new Point2D[x2.length] : new Point2D[x2.length < this.pts.length ? this.pts.length : x2.length];
        for (int i2 = 0; i2 < p2.length; ++i2) {
            p2[i2] = new Point2D.Double(x2.length > i2 ? x2[i2] : 0.0, this.pts == null || this.pts.length >= i2 ? 0.0 : this.pts[i2].getY());
        }
        this.setPoints(p2);
    }

    public double[] getXPoints() {
        double[] x2 = new double[this.pts.length];
        for (int i2 = 0; i2 < this.pts.length; ++i2) {
            x2[i2] = this.pts[i2].getX();
        }
        return x2;
    }

    public void setYPoints(double[] y2) {
        Point2D[] p2 = this.pts == null ? new Point2D[y2.length] : new Point2D[y2.length < this.pts.length ? this.pts.length : y2.length];
        for (int i2 = 0; i2 < p2.length; ++i2) {
            p2[i2] = new Point2D.Double(this.pts == null || this.pts.length >= i2 ? 0.0 : this.pts[i2].getX(), y2.length > i2 ? y2[i2] : 0.0);
        }
        this.setPoints(p2);
    }

    public double[] getYPoints() {
        double[] y2 = new double[this.pts.length];
        for (int i2 = 0; i2 < this.pts.length; ++i2) {
            y2[i2] = this.pts[i2].getY();
        }
        return y2;
    }

    public boolean getInverted() {
        return this.isInverted;
    }

    public void setInverted(boolean b2) {
        boolean oldValue = this.isInverted;
        this.isInverted = b2;
    }

    public void setGraphMode(int mode) {
        this.graphMode = mode;
        this.repaint();
    }

    public int getGraphMode() {
        return this.graphMode;
    }

    public double getxAxisMajorTickSpacing() {
        return this.xAxisMajorTickSpacing;
    }

    public void setxAxisMajorTickSpacing(double n2) {
        this.xAxisMajorTickSpacing = n2;
        this.reset_axis();
    }

    public double getxAxisMinorTickSpacing() {
        return this.xAxisMinorTickSpacing;
    }

    public void setxAxisMinorTickSpacing(double n2) {
        this.xAxisMinorTickSpacing = n2;
        this.reset_axis();
    }

    public double getyAxisMajorTickSpacing() {
        return this.yAxisMajorTickSpacing;
    }

    public void setyAxisMajorTickSpacing(double n2) {
        this.yAxisMajorTickSpacing = n2;
        this.reset_axis();
    }

    public double getyAxisMinorTickSpacing() {
        return this.yAxisMinorTickSpacing;
    }

    public void setyAxisMinorTickSpacing(double n2) {
        this.yAxisMinorTickSpacing = n2;
        this.reset_axis();
    }

    public double getyAxisMin() {
        return this.yAxisMin;
    }

    public void setyAxisMin(double n2) {
        this.yAxisMin = n2;
        this.reset_axis();
    }

    public double getyAxisMax() {
        return this.yAxisMax;
    }

    public void setyAxisMax(double n2) {
        this.yAxisMax = n2;
        this.reset_axis();
    }

    public double getxAxisMin() {
        return this.xAxisMin;
    }

    public void setxAxisMin(double n2) {
        this.xAxisMin = n2;
        this.reset_axis();
    }

    public double getxAxisMax() {
        return this.xAxisMax;
    }

    public void setxAxisMax(double n2) {
        this.xAxisMax = n2;
        this.reset_axis();
    }

    public boolean isxAxisShow() {
        return this.xAxisShow;
    }

    public void setxAxisShow(boolean show) {
        this.xAxisShow = show;
        this.reset_axis();
    }

    public boolean isyAxisShow() {
        return this.yAxisShow;
    }

    public void setyAxisShow(boolean show) {
        this.yAxisShow = show;
        this.reset_axis();
    }

    public double getThreshHold() {
        return this.yThreshHold;
    }

    public void setThreshHold(double value) {
        this.yThreshHold = value;
        this.reset_axis();
    }

    public void setThreshAboveColor(Color ac2) {
        this.aboveColor = ac2;
    }

    public Color getThreshAboveColor() {
        return this.aboveColor;
    }

    public void setThreshBelowColor(Color bc) {
        this.belowColor = bc;
    }

    public Color getThreshBelowColor() {
        return this.belowColor;
    }

    public void setShowPointColor(Color bc) {
        this.showPointColor = bc;
    }

    public Color getShowPointColor() {
        return this.showPointColor;
    }

    public void setShowPoints(boolean bc) {
        this.showPoints = bc;
    }

    public boolean isShowPoints() {
        return this.showPoints;
    }

    public void setAutoResetAxis(boolean reset) {
        this.autoResetAxis = reset;
    }

    public boolean isAutoResetAxis() {
        return this.autoResetAxis;
    }

    public void setPointLabels(String[] labels) {
        this.labels = labels;
    }

    public String[] getPointLabels() {
        return this.labels;
    }

    private void reset_axis() {
    }

    public TGraph() {
        try {
            this.jbInit();
        }
        catch (Exception e2) {
            e2.printStackTrace();
        }
        if (Beans.isDesignTime()) {
            double[] x2 = new double[100];
            double[] y2 = new double[100];
            for (int i2 = 0; i2 < x2.length; ++i2) {
                x2[i2] = i2;
                y2[i2] = Math.sin(x2[i2] / 10.0);
            }
            System.err.println("setting points");
            this.setPoints(x2, y2);
        }
    }

    private void jbInit() throws Exception {
        this.setOpaque(false);
        this.addMouseListener(new MouseAdapter(){

            @Override
            public void mousePressed(MouseEvent e2) {
                TGraph.this.graphMousePressed(e2);
            }

            @Override
            public void mouseReleased(MouseEvent e2) {
                TGraph.this.graphMouseReleased(e2);
            }
        });
        this.addMouseMotionListener(new MouseMotionAdapter(){

            @Override
            public void mouseMoved(MouseEvent e2) {
                TGraph.this.graphMouseMoved(e2);
            }

            @Override
            public void mouseDragged(MouseEvent e2) {
                TGraph.this.graphMouseDragged(e2);
            }
        });
        this.addComponentListener(new ComponentAdapter(){

            @Override
            public void componentResized(ComponentEvent e2) {
                TGraph.this.this_componentResized(e2);
            }
        });
        this.setLayout(null);
    }

    void this_componentResized(ComponentEvent e2) {
        this.recalcPoints();
    }

    public void addActionListener(ActionListener l2) {
        this.listenerList.add(ActionListener.class, l2);
    }

    public void removeActionListener(ActionListener l2) {
        this.listenerList.remove(ActionListener.class, l2);
    }

    protected void fireActionPerformed(ActionEvent event) {
        Object[] listeners = this.listenerList.getListenerList();
        Object e2 = null;
        for (int i2 = listeners.length - 2; i2 >= 0; i2 -= 2) {
            if (listeners[i2] != ActionListener.class) continue;
            ((ActionListener)listeners[i2 + 1]).actionPerformed(event);
        }
    }

    private void jbInit2() throws Exception {
    }

    void graphMouseMoved(MouseEvent e2) {
        if (!this.showPoints) {
            return;
        }
        boolean found = false;
        for (int i2 = 0; i2 < this.pts.length; ++i2) {
            int x2 = this.xPoints[i2] + (this.graphMode == 1 ? this.barShift : 0);
            if (Math.abs(e2.getX() - x2) >= 10) continue;
            if (!(this.graphMode != 1 && Math.abs(e2.getY() - this.yPoints[i2]) >= 10 || this.showTip)) {
                String str = this.graphMode == 1 ? "(" + this.pts[i2].getY() + ")" : "(" + this.pts[i2].getX() + "," + this.pts[i2].getY() + ")";
                Graphics g2 = this.getGraphics();
                g2.setColor(this.showPointColor);
                g2.drawString(str, e2.getX(), e2.getY());
                this.showTip = true;
            }
            found = true;
        }
        if (!found) {
            this.getParent().repaint();
            this.showTip = false;
        }
    }

    void graphMousePressed(MouseEvent e2) {
        for (int i2 = 0; i2 < this.pts.length; ++i2) {
            int x2 = this.xPoints[i2] + (this.graphMode == 1 ? this.barShift : 0);
            if (Math.abs(e2.getX() - x2) >= 10 || this.graphMode != 1 && Math.abs(e2.getY() - this.yPoints[i2]) >= 10) continue;
            this.paintPoints(i2, this.getGraphics(), true);
        }
    }

    void graphMouseReleased(MouseEvent e2) {
        for (int i2 = 0; i2 < this.pts.length; ++i2) {
            int x2 = this.xPoints[i2] + (this.graphMode == 1 ? this.barShift : 0);
            if (Math.abs(e2.getX() - x2) >= 10 || this.graphMode != 1 && Math.abs(e2.getY() - this.yPoints[i2]) >= 10) continue;
            this.fireActionPerformed(new ActionEvent(this, i2, e2.toString(), e2.getModifiers()));
        }
        this.getParent().repaint();
    }

    void graphMouseDragged(MouseEvent e2) {
        for (int i2 = 0; i2 < this.pts.length; ++i2) {
            int x2 = this.xPoints[i2] + (this.graphMode == 1 ? this.barShift : 0);
            if (Math.abs(e2.getX() - x2) >= 10 || this.graphMode != 1 && Math.abs(e2.getY() - this.yPoints[i2]) >= 10) continue;
            this.paintPoints(i2, this.getGraphics(), true);
        }
    }
}

