/*
 * Decompiled with CFR 0.152.
 */
package com.ge.med.terra.tap.util.tgraph;

import com.ge.med.terra.tap.util.tgraph.TGraph;
import java.awt.Graphics;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.awt.geom.Line2D;
import java.awt.geom.NoninvertibleTransformException;
import java.awt.geom.Point2D;
import java.text.DecimalFormat;
import javax.swing.JComponent;

public class TGraphCursor
extends JComponent
implements MouseListener,
MouseMotionListener {
    Point2D p = new Point2D.Double(0.0, 0.0);
    Point2D sp = new Point2D.Double(0.0, 0.0);
    public final int VERTICAL_MODE = 1;
    public final int HORIZONTAL_MODE = 2;
    public final int XY_MODE = 0;
    int mode = 1;
    private final double dist_error = 10.0;
    private boolean drag = false;
    DecimalFormat numf = new DecimalFormat();

    public void calcClosestPoint(TGraph jg) {
        if (jg.pts == null) {
            return;
        }
        block0 : switch (this.mode) {
            case 0: {
                double min_d = Double.MAX_VALUE;
                int min_i = 0;
                for (int i2 = 0; i2 < jg.pts.length - 1; ++i2) {
                    double d2 = Line2D.ptLineDistSq(jg.pts[i2].getX(), jg.pts[i2].getY(), jg.pts[i2 + 1].getX(), jg.pts[i2 + 1].getY(), this.p.getX(), this.p.getY());
                    if (!(min_d > d2)) continue;
                    min_d = d2;
                    min_i = i2;
                }
                break;
            }
            case 1: {
                for (int i3 = 0; i3 < jg.pts.length - 1; ++i3) {
                    if (!(jg.pts[i3].getX() >= this.p.getX())) continue;
                    this.p.setLocation(jg.pts[i3]);
                    break block0;
                }
                break;
            }
            case 2: {
                for (int i4 = 0; i4 < jg.pts.length - 1; ++i4) {
                    if (!(jg.pts[i4].getY() >= this.p.getY())) continue;
                    this.p.setLocation(jg.pts[i4]);
                    break block0;
                }
                break;
            }
        }
    }

    public void paint(Graphics g2, TGraph jg) {
        g2.setColor(this.getForeground());
        g2.setFont(this.getFont());
        jg.at.transform(this.p, this.sp);
        int x2 = (int)this.sp.getX();
        int y2 = (int)this.sp.getY();
        this.calcClosestPoint(jg);
        this.numf.setMaximumFractionDigits(3);
        String s2 = "(" + this.numf.format(this.p.getX()) + "," + this.numf.format(this.p.getY()) + ")";
        jg.getClass();
        g2.drawString(s2, 4 + x2, 20);
        g2.setColor(this.getBackground());
        switch (this.mode) {
            case 0: {
                g2.drawLine(x2 - 10, y2 - 10, x2 + 10, y2 + 10);
                g2.drawLine(x2 + 10, y2 - 10, x2 - 10, y2 + 10);
                return;
            }
            case 1: {
                g2.drawRect(x2, 0, 1, jg.getHeight());
                return;
            }
            case 2: {
                g2.drawRect(0, y2, jg.getWidth(), 1);
                return;
            }
        }
    }

    @Override
    public void mouseClicked(MouseEvent e2) {
    }

    @Override
    public void mousePressed(MouseEvent e2) {
        System.out.println("mouse pressed");
        switch (this.mode) {
            case 0: {
                if (this.sp.distance(e2.getX(), e2.getY()) < 10.0) {
                    this.drag = true;
                }
                return;
            }
            case 1: {
                if ((double)Math.abs((int)this.sp.getX() - e2.getX()) < 10.0) {
                    this.drag = true;
                }
                return;
            }
            case 2: {
                if ((double)Math.abs((int)this.sp.getY() - e2.getY()) < 10.0) {
                    this.drag = true;
                }
                return;
            }
        }
    }

    @Override
    public void mouseReleased(MouseEvent e2) {
        this.drag = false;
    }

    @Override
    public void mouseEntered(MouseEvent e2) {
    }

    @Override
    public void mouseExited(MouseEvent e2) {
    }

    @Override
    public void mouseDragged(MouseEvent e2) {
        if (!this.drag) {
            return;
        }
        if (!(e2.getSource() instanceof TGraph)) {
            return;
        }
        TGraph jg = (TGraph)e2.getSource();
        Point2D.Double p2 = new Point2D.Double(e2.getX(), e2.getY());
        try {
            jg.at.inverseTransform(p2, p2);
        }
        catch (NoninvertibleTransformException ex) {
            ex.printStackTrace();
        }
        this.p.setLocation(p2);
        jg.repaint();
    }

    @Override
    public void mouseMoved(MouseEvent e2) {
    }
}

