/*
 * Decompiled with CFR 0.152.
 */
package com.ge.med.terra.tap.util.tport;

import com.ge.med.terra.tap.dm.DMSession;
import com.ge.med.terra.tap.dm.sessionFile.dicomImageGen;
import com.ge.med.terra.tap.util.tport.TPort;
import java.awt.geom.AffineTransform;
import java.awt.image.AffineTransformOp;
import java.awt.image.BufferedImage;
import java.awt.image.DataBuffer;
import java.awt.image.DataBufferByte;
import java.awt.image.DataBufferInt;
import java.awt.image.DataBufferUShort;
import java.io.Externalizable;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.util.Enumeration;
import java.util.Hashtable;
import javax.swing.JFrame;

public class BufferedImageEx
implements Externalizable {
    int dimx;
    int dimy;
    byte[] data8bit;
    short[] data16bit;
    int[] data32bit;
    int type;
    boolean is8bit;
    boolean is16bit;
    Hashtable hash;
    int color_components;

    public BufferedImageEx() {
    }

    public BufferedImageEx(BufferedImage _image) {
        this.setBufferedImage(_image);
    }

    @Override
    public void writeExternal(ObjectOutput out) throws IOException {
        int scalefactor = new Float(this.dimx / 256).intValue();
        if (scalefactor <= 0) {
            scalefactor = 2;
        }
        int nx = this.dimx / scalefactor;
        int ny = this.dimy / scalefactor;
        out.writeObject(new Integer(nx));
        out.writeObject(new Integer(ny));
        out.writeObject(new Integer(this.type));
        out.writeObject(new Boolean(this.is8bit));
        out.writeObject(new Boolean(this.is16bit));
        out.writeObject(new Integer(this.color_components));
        out.writeObject(this.hash);
        if (this.is8bit) {
            byte[] scaled = new byte[nx * ny * this.color_components];
            for (int x2 = 0; x2 < nx; ++x2) {
                for (int y2 = 0; y2 < ny; ++y2) {
                    scaled[x2 + y2 * nx] = this.data8bit[x2 * this.dimx / nx + y2 * this.dimy / ny * nx];
                }
            }
            out.writeObject(new Integer(scaled.length));
            out.write(scaled);
        } else if (this.is16bit) {
            short[] scaled = new short[nx * ny * this.color_components];
            for (int x3 = 0; x3 < nx; ++x3) {
                for (int y3 = 0; y3 < ny; ++y3) {
                    scaled[x3 + y3 * nx] = this.data16bit[x3 * this.dimx / nx + y3 * this.dimy / ny * this.dimx];
                }
            }
            out.writeObject(new Integer(scaled.length));
            out.writeObject(scaled);
        } else {
            int[] scaled = new int[nx * ny * this.color_components];
            for (int x4 = 0; x4 < nx; ++x4) {
                for (int y4 = 0; y4 < ny; ++y4) {
                    scaled[x4 + y4 * nx] = this.data32bit[x4 * this.dimx / nx + y4 * this.dimy / ny * nx];
                }
            }
            out.writeObject(new Integer(scaled.length));
            out.writeObject(scaled);
        }
    }

    @Override
    public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
        this.dimx = (Integer)in.readObject();
        this.dimy = (Integer)in.readObject();
        this.type = (Integer)in.readObject();
        this.is8bit = (Boolean)in.readObject();
        this.is16bit = (Boolean)in.readObject();
        this.color_components = (Integer)in.readObject();
        this.hash = (Hashtable)in.readObject();
        if (this.is8bit) {
            this.data16bit = null;
            this.data32bit = null;
            int datalen = (Integer)in.readObject();
            this.data8bit = new byte[datalen];
            in.read(this.data8bit);
        } else if (this.is16bit) {
            this.data8bit = null;
            this.data32bit = null;
            int datalen = (Integer)in.readObject();
            this.data16bit = new short[datalen];
            this.data16bit = (short[])in.readObject();
        } else {
            this.data8bit = null;
            this.data16bit = null;
            int datalen = (Integer)in.readObject();
            this.data32bit = new int[datalen];
            this.data32bit = (int[])in.readObject();
        }
    }

    public void setBufferedImage(BufferedImage _image) {
        if (_image == null) {
            System.out.println("setBufferedImage got null image!");
            return;
        }
        Object obj = _image.getProperty("PROPERTY_HASH");
        if (obj != null) {
            Enumeration en = (Enumeration)obj;
            this.hash = new Hashtable();
            while (en.hasMoreElements()) {
                Object anObj = en.nextElement();
                this.hash.put(anObj, _image.getProperty((String)anObj));
            }
        } else {
            this.hash = null;
        }
        this.dimx = _image.getWidth();
        this.dimy = _image.getHeight();
        this.type = _image.getType();
        this.color_components = _image.getColorModel().getColorSpace().getNumComponents();
        int datalen = _image.getRaster().getDataBuffer().getSize();
        switch (this.type) {
            case 11: {
                this.is8bit = false;
                this.is16bit = true;
                this.data8bit = null;
                this.data16bit = ((DataBufferUShort)_image.getRaster().getDataBuffer()).getData();
                this.data32bit = null;
                break;
            }
            case 10: {
                this.is8bit = true;
                this.is16bit = false;
                this.data8bit = ((DataBufferByte)_image.getRaster().getDataBuffer()).getData();
                this.data16bit = null;
                this.data32bit = null;
                break;
            }
            case 5: {
                this.is8bit = true;
                this.is16bit = false;
                this.data8bit = ((DataBufferByte)_image.getRaster().getDataBuffer()).getData();
                this.data16bit = null;
                this.data32bit = null;
                break;
            }
            case 0: {
                this.is8bit = true;
                this.is16bit = false;
                this.data8bit = ((DataBufferByte)_image.getRaster().getDataBuffer()).getData();
                this.data16bit = null;
                this.data32bit = null;
                break;
            }
            default: {
                System.out.println("Unable to handle BufferedImage of type- " + this.type);
                this.is8bit = false;
                this.is16bit = false;
                this.data8bit = null;
                this.data16bit = null;
                this.data32bit = ((DataBufferInt)_image.getRaster().getDataBuffer()).getData();
            }
        }
    }

    public BufferedImage getBufferedImage() {
        BufferedImage bi = null;
        switch (this.type) {
            case 11: {
                bi = dicomImageGen.build16bitImage(this.dimx, this.dimy, this.data16bit, 0, 0, this.hash);
                break;
            }
            case 10: {
                bi = dicomImageGen.build8bitImage(this.dimx, this.dimy, this.data8bit, 0, this.hash);
                break;
            }
            case 5: {
                bi = dicomImageGen.buildRGBImage(this.dimx, this.dimy, this.data8bit, 0, this.hash);
                break;
            }
            case 0: {
                if (this.color_components == 3) {
                    bi = dicomImageGen.buildRGBImage(this.dimx, this.dimy, this.data8bit, 0, this.hash);
                    break;
                }
                bi = dicomImageGen.build8bitImage(this.dimx, this.dimy, this.data8bit, 0, this.hash);
                break;
            }
            default: {
                bi = dicomImageGen.build32bitImage(this.dimx, this.dimy, this.data32bit, 0, this.hash);
            }
        }
        return bi;
    }

    public static void printData(BufferedImage _image) {
        String[] props = _image.getPropertyNames();
        if (props != null) {
            for (int i2 = 0; i2 < props.length; ++i2) {
                System.out.println("Key= " + props[i2] + ", Value= " + _image.getProperty(props[i2]));
            }
        } else {
            System.out.println("No properties found");
        }
        System.out.println("# of color cmponents- " + _image.getColorModel().getNumComponents());
        int dimx = _image.getWidth();
        int dimy = _image.getHeight();
        int type = _image.getType();
        System.out.println("dimx= " + dimx);
        System.out.println("dimy= " + dimy);
        int datalen = _image.getRaster().getDataBuffer().getSize();
        switch (type) {
            case 11: {
                System.out.println("type= BufferedImage.TYPE_USHORT_GRAY");
                System.out.println("is8bit= false");
                System.out.println("is16bit= true");
                System.out.println("data8bit= null");
                System.out.println("data16bit= short[" + datalen + "]");
                System.out.println("data32bit= null");
                break;
            }
            case 10: {
                System.out.println("type= BufferedImage.TYPE_BYTE_GRAY");
                System.out.println("is8bit = true");
                System.out.println("is16bit= false");
                System.out.println("data8bit= byte[" + datalen + "]");
                System.out.println("data16bit= null");
                System.out.println("data32bit= null");
                break;
            }
            case 5: {
                System.out.println("type= BufferedImage.TYPE_3BYTE_BGR");
                System.out.println("is8bit = true");
                System.out.println("is16bit= false");
                System.out.println("data8bit= byte[" + datalen + "]");
                System.out.println("data16bit= null");
                System.out.println("data32bit= null");
                break;
            }
            case 0: {
                System.out.println("type= BufferedImage.TYPE_CUSTOM");
                DataBuffer obj = _image.getData().getDataBuffer();
                if (obj instanceof DataBufferByte) {
                    System.out.println("is8bit = true");
                    System.out.println("is16bit= false");
                    System.out.println("data8bit= byte[" + datalen + "]");
                    System.out.println("data16bit= null");
                    System.out.println("data32bit= null");
                    break;
                }
                if (obj instanceof DataBufferUShort) {
                    System.out.println("is8bit = false");
                    System.out.println("is16bit= true");
                    System.out.println("data8bit= null");
                    System.out.println("data16bit= short[" + datalen + "]");
                    System.out.println("data32bit= null");
                    break;
                }
                System.out.println("Unknwon DataBuffer type");
                break;
            }
            default: {
                System.out.println("Unable to handle BufferedImage of type- " + type);
                System.out.println("is8bit = false");
                System.out.println("is16bit= false");
                System.out.println("data8bit= null");
                System.out.println("data16bit= null");
                System.out.println("data32bit= int[" + datalen + "]");
            }
        }
    }

    public static void showImage(BufferedImage im) {
        BufferedImageEx.showImage(im, null);
    }

    public static void showImage(BufferedImage im, String title) {
        TPort tp = new TPort();
        BufferedImage[] bi = new BufferedImage[]{im};
        tp.setImages(bi);
        JFrame f2 = new JFrame(title);
        f2.getContentPane().add(tp);
        f2.setDefaultCloseOperation(3);
        f2.setSize(im.getWidth(), im.getHeight());
        f2.setVisible(true);
    }

    public static BufferedImage zoom(BufferedImage in) {
        try {
            AffineTransformOp affop = new AffineTransformOp(AffineTransform.getScaleInstance(1.0, 1.0), null);
            return affop.filter(in, null);
        }
        catch (Exception e2) {
            e2.printStackTrace();
            return null;
        }
    }

    public static BufferedImage scale(double scalefactor, BufferedImage srcImg) {
        BufferedImage out;
        Hashtable<String, Object> hash;
        int dimx = srcImg.getWidth();
        int dimy = srcImg.getHeight();
        int nx = (int)((double)dimx / scalefactor);
        int ny = (int)((double)dimy / scalefactor);
        int color_components = srcImg.getColorModel().getColorSpace().getNumComponents();
        String[] props = srcImg.getPropertyNames();
        if (props == null) {
            hash = null;
        } else {
            hash = new Hashtable<String, Object>();
            for (int i2 = 0; i2 < props.length; ++i2) {
                hash.put(props[i2], srcImg.getProperty(props[i2]));
            }
        }
        switch (srcImg.getType()) {
            case 11: {
                int x2;
                short[] data16bit = ((DataBufferUShort)srcImg.getRaster().getDataBuffer()).getData();
                short[] scaled16bit = new short[nx * ny * color_components];
                for (x2 = 0; x2 < nx; ++x2) {
                    for (int y2 = 0; y2 < ny; ++y2) {
                        scaled16bit[x2 + y2 * nx] = data16bit[x2 * dimx / nx + y2 * dimy / ny * dimx];
                    }
                }
                out = dicomImageGen.build16bitImage(nx, ny, scaled16bit, 0, 0, hash);
                break;
            }
            case 10: {
                int x2;
                byte[] data8bit = ((DataBufferByte)srcImg.getRaster().getDataBuffer()).getData();
                byte[] scaled8bit = new byte[nx * ny * color_components];
                for (x2 = 0; x2 < nx; ++x2) {
                    for (int y3 = 0; y3 < ny; ++y3) {
                        scaled8bit[x2 + y3 * nx] = data8bit[x2 * dimx / nx + y3 * dimy / ny * nx];
                    }
                }
                out = dicomImageGen.build8bitImage(nx, ny, scaled8bit, 0, hash);
                break;
            }
            case 5: {
                int x2;
                byte[] data8bit = ((DataBufferByte)srcImg.getRaster().getDataBuffer()).getData();
                byte[] scaled8bit = new byte[nx * ny * color_components];
                for (x2 = 0; x2 < nx; ++x2) {
                    for (int y4 = 0; y4 < ny; ++y4) {
                        scaled8bit[x2 + y4 * nx] = data8bit[x2 * dimx / nx + y4 * dimy / ny * nx];
                    }
                }
                out = dicomImageGen.buildRGBImage(nx, ny, scaled8bit, 0, hash);
                break;
            }
            case 0: {
                int x2;
                byte[] data8bit = ((DataBufferByte)srcImg.getRaster().getDataBuffer()).getData();
                byte[] scaled8bit = new byte[nx * ny * color_components];
                for (x2 = 0; x2 < nx; ++x2) {
                    for (int y5 = 0; y5 < ny; ++y5) {
                        scaled8bit[x2 + y5 * nx] = data8bit[x2 * dimx / nx + y5 * dimy / ny * nx];
                    }
                }
                out = dicomImageGen.build8bitImage(nx, ny, scaled8bit, 0, hash);
                break;
            }
            default: {
                int x2;
                System.out.println("Not quite sure how to handle image type(" + srcImg.getType() + ") ... but will return a 32 bit image");
                int[] data32bit = ((DataBufferInt)srcImg.getRaster().getDataBuffer()).getData();
                int[] scaled32bit = new int[nx * ny * color_components];
                for (x2 = 0; x2 < nx; ++x2) {
                    for (int y6 = 0; y6 < ny; ++y6) {
                        scaled32bit[x2 + y6 * nx] = data32bit[x2 * dimx / nx + y6 * dimy / ny * nx];
                    }
                }
                out = dicomImageGen.build32bitImage(nx, ny, scaled32bit, 0, hash);
            }
        }
        return out;
    }

    public void setProperty(Object key, Object value) {
        if (this.hash == null) {
            this.hash = new Hashtable();
        }
        this.hash.put(key, value);
    }

    public Object getProperty(Object key) {
        if (this.hash == null) {
            return null;
        }
        return this.hash.get(key);
    }

    public static void main(String[] args) {
        DMSession dm = new DMSession("file", null, new String[]{"\\\\Gspnet\\gspnet\\images\\dicom97\\dicom\\gems\\ct\\im85"});
        BufferedImage im1 = dm.getChildren()[0].getPixelData()[0];
        BufferedImageEx.showImage(im1, "Original");
        BufferedImageEx bix = new BufferedImageEx(im1);
        BufferedImageEx.showImage(bix.getBufferedImage(), "UnOriginal");
    }
}

