/*
 * Decompiled with CFR 0.152.
 */
package com.ge.med.terra.tap.util.tport;

import com.ge.med.terra.tap.dm.DMObject;
import com.ge.med.terra.tap.dm.DMSession;
import com.ge.med.terra.tap.util.tport.BufferedImageEx;
import java.awt.image.BufferedImage;
import java.io.BufferedReader;
import java.io.DataOutputStream;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.ObjectOutputStream;
import java.net.ServerSocket;
import java.net.Socket;
import java.util.StringTokenizer;

public class HttpImageServer {
    public static int OBJ_TYPE_IMAGE = 1;
    public static int OBJ_TYPE_LIST = 2;
    public static String HTTP_PORT = "4100";
    public static String BASE_DIR = "k:/developer/singh/bigDicom/xr/bigones";
    ServerSocket listen;

    public HttpImageServer() {
        this(HTTP_PORT, BASE_DIR);
    }

    public HttpImageServer(String port, String basedir) {
        HTTP_PORT = port;
        BASE_DIR = basedir;
        System.out.println("Starting HttpImageServer on port " + HTTP_PORT);
        System.out.println("BASE_DIR= " + BASE_DIR);
        try {
            this.listen = new ServerSocket(Integer.parseInt(HTTP_PORT));
            while (true) {
                this.connect(this.listen.accept());
            }
        }
        catch (IOException ex) {
            System.out.println("Exception...");
            ex.printStackTrace();
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void connect(Socket s2) {
        try {
            BufferedReader is = new BufferedReader(new InputStreamReader(s2.getInputStream()));
            DataOutputStream os = new DataOutputStream(s2.getOutputStream());
            this.proceess(is, os);
        }
        catch (Exception e2) {
        }
        finally {
            try {
                s2.close();
            }
            catch (IOException ex) {}
        }
    }

    private void proceess(BufferedReader is, DataOutputStream os) {
        try {
            String request = is.readLine();
            StringTokenizer st = new StringTokenizer(request);
            if (st.countTokens() >= 2 && st.nextToken().equals("GET")) {
                request = st.nextToken();
                if (request.startsWith("/")) {
                    request = request.substring(1);
                }
                HttpImageServer.shipDocuments2(os, request);
            } else {
                os.writeBytes("400 Bad Request");
            }
        }
        catch (IOException e2) {
            System.out.println("I/O error ");
            e2.printStackTrace();
        }
        catch (Exception ex) {
            System.out.println("Exception: ");
            ex.printStackTrace();
        }
    }

    protected static void shipDocument(DataOutputStream os, File f2) throws Exception {
        ObjectOutputStream out = new ObjectOutputStream(os);
        try {
            System.out.println("Reading " + f2.getAbsolutePath());
            BufferedImage[] bi = HttpImageServer.getPixelData(f2);
            for (int i2 = 0; i2 < bi.length; ++i2) {
                if (bi[i2] != null) {
                    out.writeObject(new BufferedImageEx(bi[i2]));
                    continue;
                }
                out.writeObject(null);
                System.out.println("Null Image found!");
            }
        }
        catch (FileNotFoundException e2) {
            System.out.println("404 Not Found");
            out.writeBytes("404 Not Found");
        }
        catch (SecurityException e1) {
            System.out.println("403 Forbidden...not enough access rights" + e1);
            out.writeBytes("403 Forbidden...not enough access rights" + e1);
        }
        out.close();
    }

    protected static void shipDocuments(DataOutputStream os, String request) throws Exception {
        ObjectOutputStream out = new ObjectOutputStream(os);
        try {
            StringTokenizer st2 = new StringTokenizer(request, "+");
            while (st2.hasMoreTokens()) {
                String tok = st2.nextToken();
                File f2 = new File(BASE_DIR + "/" + tok);
                BufferedImage[] bi = HttpImageServer.getPixelData(f2);
                for (int i2 = 0; i2 < bi.length; ++i2) {
                    if (bi[i2] != null) {
                        out.writeObject(new BufferedImageEx(bi[i2]));
                        continue;
                    }
                    out.writeObject(null);
                    System.out.println("Null Image found!");
                }
            }
        }
        catch (FileNotFoundException e2) {
            System.out.println("404 Not Found");
            out.writeBytes("404 Not Found");
        }
        catch (SecurityException e1) {
            System.out.println("403 Forbidden...not enough access rights" + e1);
            out.writeBytes("403 Forbidden...not enough access rights" + e1);
        }
        out.close();
    }

    protected static void shipDocuments2(DataOutputStream os, String request) throws Exception {
        ObjectOutputStream out = new ObjectOutputStream(os);
        try {
            if (request.equals("..")) {
                out.close();
                return;
            }
            File f2 = new File(BASE_DIR + "/" + request);
            File f22 = new File(BASE_DIR);
            String reqPath = f2.getAbsolutePath();
            if (f22.getAbsolutePath().length() < f2.getAbsolutePath().length()) {
                reqPath = f2.getAbsolutePath().substring(f22.getAbsolutePath().length() + 1);
            }
            reqPath = reqPath.replace('\\', '/');
            if (f2.isDirectory()) {
                File[] files = f2.listFiles();
                String[] str = new String[files.length + 2];
                str[0] = !request.equals("") ? ".  (" + reqPath + ")" : ".";
                str[1] = "..";
                for (int i2 = 0; i2 < files.length; ++i2) {
                    str[i2 + 2] = files[i2].isDirectory() ? "<DIR>" + files[i2].getName() : "<FILE>" + files[i2].getName();
                }
                out.writeObject(new Integer(OBJ_TYPE_LIST));
                out.writeObject(str);
            } else {
                System.out.println("Reading " + f2.getAbsolutePath());
                BufferedImage[] bi = HttpImageServer.getPixelData(f2);
                for (int i3 = 0; i3 < bi.length; ++i3) {
                    if (bi[i3] != null) {
                        out.writeObject(new Integer(OBJ_TYPE_IMAGE));
                        BufferedImageEx bex = new BufferedImageEx(bi[i3]);
                        out.writeObject(bex);
                        continue;
                    }
                    out.writeObject(new Integer(OBJ_TYPE_IMAGE));
                    out.writeObject(null);
                    System.out.println("Null Image found!");
                }
            }
        }
        catch (FileNotFoundException e2) {
            System.out.println("404 Not Found");
            out.writeBytes("404 Not Found");
        }
        catch (SecurityException e1) {
            System.out.println("403 Forbidden...not enough access rights" + e1);
            out.writeBytes("403 Forbidden...not enough access rights" + e1);
        }
        out.close();
    }

    public static BufferedImage[] getPixelData(File f2) {
        BufferedImage[] data = null;
        DMSession dm = null;
        if (f2.isFile()) {
            dm = new DMSession("file", null, new String[]{f2.getAbsolutePath()});
        } else if (f2.isDirectory()) {
            File[] files = f2.listFiles();
            if (files == null) {
                return null;
            }
            String[] filenames = new String[files.length];
            for (int i2 = 0; i2 < files.length; ++i2) {
                filenames[i2] = files[i2].getAbsolutePath();
            }
            dm = new DMSession("file", null, filenames);
        }
        DMObject[] obj = null;
        if (dm != null) {
            obj = dm.getChildren();
        }
        if (dm == null) {
            System.out.println("Null Session");
        } else if (obj == null) {
            System.out.println("obj=null");
        } else if (obj.length <= 0) {
            System.out.println("obj.length<=0");
        } else if (obj[0] == null) {
            System.out.println("obj[0]=null");
        } else {
            data = obj[0].getPixelData();
        }
        if (data == null || data.length <= 0 || data[0] == null) {
            System.out.println("No pixel data found");
        } else {
            for (int i3 = 0; i3 < data.length; ++i3) {
                BufferedImageEx bex = new BufferedImageEx(data[i3]);
                Object object = obj[0].getValue(8, 104);
                if (object != null) {
                    bex.setProperty("Greyscale Type", object);
                }
                data[i3] = bex.getBufferedImage();
            }
            System.out.println("Found " + data.length + " images");
        }
        return data;
    }

    public static void main(String[] args) {
        if (args.length > 1) {
            HttpImageServer httpServer1 = new HttpImageServer(args[0], args[1]);
        } else {
            HttpImageServer httpServer1 = new HttpImageServer();
        }
    }
}

