/*
 * Decompiled with CFR 0.152.
 */
package com.ge.med.terra.tap.util.tport;

import com.ge.med.terra.tap.dm.DMObject;
import com.ge.med.terra.tap.dm.DMSession;
import com.ge.med.terra.tap.dm.DMTag;
import com.ge.med.terra.tap.util.tport.BufferedImageEx;
import com.ge.med.terra.tap.util.tport.MedicalImageIcon;
import java.awt.image.BufferedImage;
import java.io.BufferedReader;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.ObjectOutputStream;
import java.net.InetAddress;
import java.net.ServerSocket;
import java.net.Socket;
import java.util.ArrayList;
import java.util.StringTokenizer;
import javax.swing.Icon;

public class HttpImageServer2 {
    public static int OBJ_TYPE_IMAGE = 1;
    public static int OBJ_TYPE_LIST = 2;
    public static int OBJ_TYPE_TNAIL = 3;
    public static boolean HTML_OP = false;
    public static String HTTP_PORT = "4100";
    public static String MY_IP;
    public static String QUERY_DELIM;
    public static String ID_DELIM;
    public static String BASE_DIR;
    public static String HTTP_BASE;
    private static DMTag examNumTag;
    private static DMTag seriesNumTag;
    private static DMTag imageNumTag;
    DMSession dm;
    ServerSocket listen;
    Icon[] icons;

    public HttpImageServer2() {
        this(new String[]{HTTP_PORT, BASE_DIR, HTTP_BASE});
    }

    public HttpImageServer2(String[] args) {
        try {
            MY_IP = InetAddress.getLocalHost().getHostAddress();
        }
        catch (Exception e2) {
            e2.printStackTrace();
        }
        HTTP_PORT = args != null && args.length > 0 ? args[0] : HTTP_PORT;
        BASE_DIR = args != null && args.length > 1 ? args[1] : BASE_DIR;
        HTTP_BASE = args != null && args.length > 2 ? args[2] : HTTP_BASE;
        System.out.println("Starting HttpImageServer2 on port " + HTTP_PORT);
        System.out.println("BASE_DIR = " + BASE_DIR);
        System.out.println("HTTP_BASE= " + HTTP_BASE);
        this.dm = new DMSession("file", BASE_DIR, null);
        try {
            this.listen = new ServerSocket(Integer.parseInt(HTTP_PORT));
            while (true) {
                this.connect(this.listen.accept());
            }
        }
        catch (IOException ex) {
            System.out.println("Exception...");
            ex.printStackTrace();
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void connect(Socket s2) {
        try {
            BufferedReader is = new BufferedReader(new InputStreamReader(s2.getInputStream()));
            DataOutputStream os = new DataOutputStream(s2.getOutputStream());
            this.process(is, os);
        }
        catch (Exception e2) {
            e2.printStackTrace();
        }
        finally {
            try {
                s2.close();
            }
            catch (IOException iOException) {}
        }
    }

    /*
     * Enabled aggressive block sorting
     */
    private void process(BufferedReader in, DataOutputStream dOut) throws Exception {
        ObjectOutputStream out;
        block10: {
            block11: {
                out = null;
                String request = in.readLine();
                StringTokenizer st = new StringTokenizer(request);
                if (st.countTokens() < 2 || !st.nextToken().equals("GET")) break block11;
                request = st.nextToken();
                while (request.startsWith("/")) {
                    request = request.substring(1);
                }
                Object result = this.getResponse(request);
                if (result instanceof byte[]) {
                    dOut.write((byte[])result);
                    break block10;
                } else if (result instanceof String[]) {
                    out = new ObjectOutputStream(dOut);
                    String[] resultStr = (String[])result;
                    out.writeObject(new Integer(OBJ_TYPE_LIST));
                    out.writeObject(result);
                    out.writeObject(new Integer(OBJ_TYPE_TNAIL));
                    out.writeObject(this.icons);
                    break block10;
                } else {
                    if (!(result instanceof BufferedImage[])) {
                        System.out.println("getRelated returned something wierd- " + result);
                        return;
                    }
                    out = new ObjectOutputStream(dOut);
                    BufferedImage[] resultImg = (BufferedImage[])result;
                    for (int i2 = 0; i2 < resultImg.length; ++i2) {
                        BufferedImageEx temp = new BufferedImageEx(resultImg[i2]);
                        out.writeObject(new Integer(OBJ_TYPE_IMAGE));
                        out.writeObject(temp);
                    }
                }
                break block10;
            }
            out.writeBytes(this.formatMsg("400 Bad Request"));
        }
        if (out != null) {
            out.close();
        }
        if (dOut != null) {
            dOut.close();
        }
        if (in != null) {
            in.close();
        }
    }

    private Object getResponse(String req) {
        if (!req.startsWith(QUERY_DELIM)) {
            return this.getHttpResponse(req);
        }
        req = req.substring(QUERY_DELIM.length(), req.length());
        String level = "Study";
        String key = null;
        StringTokenizer tok = new StringTokenizer(req, "=");
        if (tok.hasMoreTokens()) {
            level = tok.nextToken();
        }
        if (tok.hasMoreTokens()) {
            key = tok.nextToken();
        }
        DMObject o2 = null;
        DMObject[] obj = null;
        BufferedImage[] bi = null;
        if (!(level.equalsIgnoreCase("Study") || level.equalsIgnoreCase("Series") || level.equalsIgnoreCase("Image") || key != null)) {
            ArrayList<BufferedImage> list = new ArrayList<BufferedImage>();
            key = level;
            if (level.startsWith("Study")) {
                int i2;
                DMObject[] obj2 = null;
                o2 = this.dm.getDMObject("Study", key);
                obj = o2.getRelated("Series");
                for (i2 = 0; i2 < obj.length; ++i2) {
                    obj2 = obj[i2].getRelated("Image");
                    bi = new BufferedImage[obj2.length];
                    for (int j2 = 0; j2 < obj2.length; ++j2) {
                        bi = obj2[j2].getPixelData();
                        for (int k2 = 0; k2 < bi.length; ++k2) {
                            list.add(bi[k2]);
                        }
                    }
                }
                bi = new BufferedImage[list.size()];
                for (i2 = 0; i2 < list.size(); ++i2) {
                    bi[i2] = (BufferedImage)list.get(i2);
                }
                return bi;
            }
            if (level.startsWith("Series")) {
                int i3;
                o2 = this.dm.getDMObject("Series", key);
                obj = o2.getRelated("Image");
                bi = new BufferedImage[obj.length];
                for (i3 = 0; i3 < obj.length; ++i3) {
                    bi = obj[i3].getPixelData();
                    for (int j3 = 0; j3 < bi.length; ++j3) {
                        list.add(bi[j3]);
                    }
                }
                bi = new BufferedImage[list.size()];
                for (i3 = 0; i3 < list.size(); ++i3) {
                    bi[i3] = (BufferedImage)list.get(i3);
                }
                return bi;
            }
            if (level.startsWith("Image")) {
                o2 = this.dm.getDMObject("Image", key);
                return o2.getPixelData();
            }
        }
        if (key != null) {
            if (level.equalsIgnoreCase("Series")) {
                o2 = this.dm.getDMObject("Study", key);
                obj = o2.getRelated("Series");
            } else if (level.equalsIgnoreCase("Image")) {
                if (key.startsWith("Series")) {
                    o2 = this.dm.getDMObject("Series", key);
                    obj = o2.getRelated("Image");
                } else if (key.startsWith("Image")) {
                    o2 = this.dm.getDMObject("Image", key);
                    return o2.getPixelData();
                }
            }
        } else {
            obj = this.dm.getRelated(level);
        }
        if (obj == null) {
            return new String[]{"NOT FOUND"};
        }
        String[] str = new String[obj.length];
        this.icons = new Icon[obj.length];
        for (int i4 = 0; i4 < str.length; ++i4) {
            if (obj[i4].getType().equalsIgnoreCase("Study")) {
                str[i4] = "Exam# " + obj[i4].getValue(examNumTag) + ID_DELIM + obj[i4].getID();
            } else if (obj[i4].getType().equalsIgnoreCase("Series")) {
                str[i4] = "Series# " + obj[i4].getValue(seriesNumTag) + ID_DELIM + obj[i4].getID();
            } else if (obj[i4].getType().equalsIgnoreCase("Image")) {
                str[i4] = "Image# " + obj[i4].getValue(imageNumTag) + ID_DELIM + obj[i4].getID();
            }
            this.icons[i4] = this.getIcon(obj[i4]);
        }
        return str;
    }

    private Icon getIcon(DMObject obj) {
        BufferedImage[] im = null;
        if (obj.getType().equalsIgnoreCase("Study")) {
            im = obj.getRelated("Series")[0].getRelated("Image")[0].getPixelData();
        } else if (obj.getType().equalsIgnoreCase("Series")) {
            im = obj.getRelated("Image")[0].getPixelData();
        } else if (obj.getType().equalsIgnoreCase("Image")) {
            im = obj.getPixelData();
        }
        MedicalImageIcon icon = new MedicalImageIcon(im[0], 75);
        return icon;
    }

    private String formatMsg(String[] msg) {
        if (HTML_OP) {
            return this.getHtml(msg);
        }
        String s2 = "";
        for (int i2 = 0; i2 < msg.length; ++i2) {
            s2 = s2 + msg[i2];
        }
        return s2;
    }

    private String formatMsg(String msg) {
        if (HTML_OP) {
            return this.getHtml(msg);
        }
        return msg;
    }

    private String getHtml(String rawText) {
        return this.getHtml(new String[]{rawText});
    }

    private String getHtml(String[] rawText) {
        String html = "<HTML>\n";
        html = html + "<HEAD>\n";
        html = html + "<TITLE>\n";
        html = html + "HttpImageServer Response\n";
        html = html + "</TITLE>\n";
        html = html + "</HEAD>\n";
        html = html + "<BODY>\n";
        if (rawText != null) {
            String link = "";
            String display = "";
            for (int i2 = 0; i2 < rawText.length; ++i2) {
                link = "";
                display = "";
                if (rawText[i2].startsWith("Exam")) {
                    link = link + "Series=";
                } else if (rawText[i2].startsWith("Series")) {
                    link = link + "Image=";
                }
                StringTokenizer tok = new StringTokenizer(rawText[i2], "@@XD@@");
                display = display + tok.nextToken();
                link = link + tok.nextToken();
                if (rawText[i2].startsWith("Image")) {
                    html = html + display + "<BR>\n";
                    continue;
                }
                html = html + "<A HREF=\"http://" + MY_IP + ":" + HTTP_PORT + "/" + link + "\">" + display + "</A><BR>\n";
            }
        }
        html = html + "</BODY>\n";
        html = html + "</HTML>\n";
        return html;
    }

    public byte[] getHttpResponse(String req) {
        byte[] buf = null;
        try {
            File f2 = new File(HTTP_BASE + "/" + req);
            DataInputStream in = new DataInputStream(new FileInputStream(f2));
            int len = (int)f2.length();
            buf = new byte[len];
            in.readFully(buf);
            in.close();
        }
        catch (FileNotFoundException e2) {
            return "404 Not Found".getBytes();
        }
        catch (SecurityException e1) {
            return ("403 Forbidden...not enough access rights" + e1).getBytes();
        }
        catch (Exception e2) {
            e2.printStackTrace();
        }
        return buf;
    }

    public static void main(String[] args) {
        HttpImageServer2 httpServer1 = new HttpImageServer2(args);
    }

    static {
        QUERY_DELIM = "q=";
        ID_DELIM = "@@XD@@";
        BASE_DIR = "k:\\images\\dicom97\\dicom\\gems\\ct";
        HTTP_BASE = ".";
        examNumTag = new DMTag(32, 16);
        seriesNumTag = new DMTag(32, 17);
        imageNumTag = new DMTag(32, 19);
    }
}

