/*
 * Decompiled with CFR 0.152.
 */
package com.ge.med.terra.tap.util.tport;

import com.ge.med.terra.tap.dm.DMSession;
import com.ge.med.terra.tap.util.tport.BufferedImageEx;
import com.ge.med.terra.tap.util.tport.TPortAnnot;
import com.ge.med.terra.tap.util.tport.TPortScene;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.RenderingHints;
import java.awt.geom.AffineTransform;
import java.awt.image.BufferedImage;
import java.awt.image.IndexColorModel;
import java.io.Serializable;
import javax.swing.Icon;
import javax.swing.JFrame;
import javax.swing.JLabel;

public class MedicalImageIcon
implements Icon,
Serializable {
    int[] rgb = new int[65536];
    boolean highValClip = true;
    int old_max;
    int old_min;
    private int[] colorMap = null;
    int dim;
    private boolean doubleBuffered;
    BufferedImageEx bi;

    public MedicalImageIcon(BufferedImage b2, int maxDim) {
        double scalefactor = 1.0;
        if (maxDim < b2.getWidth() || maxDim < b2.getHeight()) {
            scalefactor = Math.max(b2.getWidth() / maxDim, b2.getHeight() / maxDim);
        }
        this.bi = new BufferedImageEx();
        this.bi.setBufferedImage(BufferedImageEx.scale(scalefactor, b2));
        this.dim = maxDim;
    }

    @Override
    public void paintIcon(Component co, Graphics gr, int x2, int y2) {
        int iHeight;
        double normy;
        int iWidth;
        double normx;
        int size;
        boolean lock = false;
        Graphics2D g2 = null;
        Object mainG = null;
        boolean hasChildren = false;
        long[] t2 = new long[10];
        int c2 = 0;
        boolean paintCount = false;
        Color selectColor = Color.green;
        Dimension _d = new Dimension();
        AffineTransform _tx = new AffineTransform();
        boolean orig_w_max = false;
        boolean orig_w_min = false;
        double orig_zoom = 0.0;
        double orig_panX = 0.0;
        double orig_panY = 0.0;
        boolean showWL = true;
        boolean inWL = false;
        Object r_hint = RenderingHints.VALUE_INTERPOLATION_BILINEAR;
        TPortScene s2 = new TPortScene();
        BufferedImage oldimgSet = null;
        BufferedImage finalimage = null;
        BufferedImage img = this.bi.getBufferedImage();
        t2[c2] = System.currentTimeMillis();
        co.getSize(_d);
        int n2 = size = _d.width < _d.height ? _d.width : _d.height;
        if (this.isDoubleBuffered()) {
            gr.setColor(Color.black);
            gr.fillRect(0, 0, _d.width, _d.height);
        }
        double norm = (normx = (double)_d.width / (double)(iWidth = img.getWidth())) > (normy = (double)_d.height / (double)(iHeight = img.getHeight())) ? normy : normx;
        g2 = (Graphics2D)gr.create();
        this.fillRGB(s2);
        _tx.setToIdentity();
        _tx.translate(_d.width / 2, _d.height / 2);
        _tx.translate(s2.pan_x * (double)_d.width, s2.pan_y * (double)_d.height);
        _tx.scale(norm, norm);
        _tx.rotate(s2.rotate * Math.PI / 180.0);
        _tx.scale(s2.zoom, s2.zoom);
        _tx.translate(-iWidth / 2, -iHeight / 2);
        g2.transform(_tx);
        if (img.getColorModel().getPixelSize() == 16) {
            if (this.old_max != s2.window_max || this.old_min != s2.window_min || oldimgSet != img) {
                IndexColorModel cm = new IndexColorModel(16, 65536, this.rgb, 0, false, -1, 1);
                finalimage = new BufferedImage(cm, img.getRaster(), false, null);
                this.old_max = s2.window_max;
                this.old_min = s2.window_min;
                oldimgSet = img;
            }
        } else {
            finalimage = img;
        }
        g2.setRenderingHint(RenderingHints.KEY_INTERPOLATION, r_hint);
        if (this.isDoubleBuffered()) {
            Image offScreen = co.createImage(co.getWidth(), co.getHeight());
            Graphics2D goff = (Graphics2D)offScreen.getGraphics();
            goff.fillRect(0, 0, co.getWidth(), co.getHeight());
            goff.setTransform(_tx);
            goff.setRenderingHint(RenderingHints.KEY_INTERPOLATION, r_hint);
            goff.drawImage((Image)finalimage, 0, 0, null);
            gr.drawImage(offScreen, 0, 0, co.getWidth(), co.getHeight(), null);
        } else {
            g2.drawImage((Image)finalimage, 0, 0, null);
        }
        if (showWL && inWL) {
            int width = s2.window_max - s2.window_min;
            int level = (s2.window_max + s2.window_min) / 2;
            TPortAnnot.annotDraw(gr, 10, _d.height / 2 - 7, "W:" + width + "L:" + level);
        }
    }

    @Override
    public int getIconWidth() {
        return this.bi.getBufferedImage().getWidth();
    }

    @Override
    public int getIconHeight() {
        return this.bi.getBufferedImage().getHeight();
    }

    private void fillRGB(TPortScene s2) {
        int i2;
        if (this.colorMap != null) {
            this.fillRGBcmap(s2);
            return;
        }
        if (s2.window_min < 0) {
            s2.window_min = 0;
        }
        if (s2.window_max < 0) {
            s2.window_max = 0;
        }
        for (i2 = 0; i2 < s2.window_min; ++i2) {
            this.rgb[i2] = 0;
        }
        for (i2 = s2.window_min; i2 < s2.window_max; ++i2) {
            this.rgb[i2] = 65793 * (255 * (i2 - s2.window_min) / (s2.window_max - s2.window_min));
        }
        for (i2 = s2.window_max; i2 < 32768; ++i2) {
            this.rgb[i2] = 0xFFFFFF;
        }
        if (this.highValClip) {
            for (i2 = 32768; i2 < 65536; ++i2) {
                this.rgb[i2] = 0;
            }
        } else {
            for (i2 = 32768; i2 < 65536; ++i2) {
                this.rgb[i2] = 0xFFFFFF;
            }
        }
    }

    private void fillRGBcmap(TPortScene s2) {
        int i2;
        if (s2.window_min < 0) {
            s2.window_min = 0;
        }
        if (s2.window_max < 0) {
            s2.window_max = 0;
        }
        for (i2 = 0; i2 < s2.window_min; ++i2) {
            this.rgb[i2] = 0;
        }
        for (i2 = s2.window_min; i2 < s2.window_max; ++i2) {
            this.rgb[i2] = this.colorMap[255 * (i2 - s2.window_min) / (s2.window_max - s2.window_min)];
        }
        for (i2 = s2.window_max; i2 < 32768; ++i2) {
            this.rgb[i2] = this.colorMap[255];
        }
        if (this.highValClip) {
            for (i2 = 32768; i2 < 65536; ++i2) {
                this.rgb[i2] = this.colorMap[0];
            }
        } else {
            for (i2 = 32768; i2 < 65536; ++i2) {
                this.rgb[i2] = this.colorMap[255];
            }
        }
    }

    public void showIcon() {
        JFrame f2 = new JFrame("Thumbnail");
        JLabel l2 = new JLabel(this);
        f2.getContentPane().add(l2);
        f2.setDefaultCloseOperation(3);
        f2.setSize(this.getIconWidth(), this.getIconHeight());
        f2.setVisible(true);
    }

    public void setDoubleBuffered(boolean doubleBuffered) {
        this.doubleBuffered = doubleBuffered;
    }

    public boolean isDoubleBuffered() {
        return this.doubleBuffered;
    }

    public static void main(String[] args) {
        DMSession dm = new DMSession("file", null, new String[]{"\\\\Gspnet\\gspnet\\images\\dicom97\\dicom\\gems\\ct\\im85"});
        BufferedImage im1 = dm.getChildren()[0].getPixelData()[0];
        BufferedImageEx.showImage(im1, "Original");
        MedicalImageIcon mi = new MedicalImageIcon(im1, 75);
        mi.showIcon();
    }
}

