/*
 * Decompiled with CFR 0.152.
 */
package com.ge.med.terra.tap.util.tport;

import com.ge.med.terra.tap.Tap;
import com.ge.med.terra.tap.dm.DMImage;
import com.ge.med.terra.tap.dm.DMObject;
import com.ge.med.terra.tap.dm.DMSession;
import com.ge.med.terra.tap.util.tport.KResponseCurve;
import com.ge.med.terra.tap.util.tport.TPortAnnot;
import com.ge.med.terra.tap.util.tport.TPortScene;
import com.ge.med.terra.tap.util.tport.color.ColorTable;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.RenderingHints;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseMotionAdapter;
import java.awt.event.MouseWheelEvent;
import java.awt.event.MouseWheelListener;
import java.awt.geom.AffineTransform;
import java.awt.image.BufferedImage;
import java.awt.image.DataBuffer;
import java.awt.image.DataBufferInt;
import java.awt.image.DataBufferShort;
import java.awt.image.DataBufferUShort;
import java.awt.image.IndexColorModel;
import java.io.File;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.JPanel;
import javax.swing.Timer;

public class TPort
extends JPanel {
    public static final int BILINEAR = 1;
    public static final int NEAREST_NEIGHBOR = 0;
    public static final int BICUBIC = 2;
    private static final int UNITS;
    private static Color selectColor;
    private static short[] toLogSpace;
    private static int[] GrayScale;
    private TPortScene s = new TPortScene();
    private Object r_hint = RenderingHints.VALUE_INTERPOLATION_BILINEAR;
    private BufferedImage[] imgSet = new BufferedImage[0];
    private DMImage[] dmImgSet = new DMImage[0];
    private boolean useDMImage = false;
    private int isetLength = 0;
    private int frame;
    private boolean cine = false;
    private int cineRate = 100;
    private Timer timer1;
    private boolean lock = false;
    private boolean highValClip = true;
    private boolean invert = false;
    private TPortAnnot annot = TPortAnnot.getDefault();
    private Graphics2D g2 = null;
    private boolean hasChildren = false;
    private int saved_min;
    private int saved_max;
    private boolean useModalityInfo = true;
    private boolean oldInvertFlag = true;
    private int wlDir = 0;
    private boolean rotateEnabled = true;
    private boolean cineEnabled = true;
    private boolean keyboardPaging = true;
    private boolean mousewheelPaging = true;
    private int[] rgb = new int[65536];
    private Dimension _d = new Dimension();
    private AffineTransform _tx = new AffineTransform();
    private IndexColorModel cm;
    private BufferedImage finalimage;
    private int old_max;
    private int old_min;
    private BufferedImage oldimgSet = null;
    private int mx;
    private int my;
    private int mouse;
    private int orig_w_max = 0;
    private int orig_w_min = 0;
    private double orig_zoom = 0.0;
    private double orig_panX = 0.0;
    private double orig_panY = 0.0;
    private String namedColorMap;
    private int[] colorMap = GrayScale;
    private boolean autoLeveled;
    private boolean showWL = true;
    private boolean inWL = false;

    public TPort() {
        this.resetTransForm();
        try {
            this.init();
        }
        catch (Exception e2) {
            e2.printStackTrace();
        }
    }

    private void init() {
        this.setBackground(Color.black);
        this.setForeground(Color.white);
        this.setDoubleBuffered(false);
        this.setOpaque(false);
        this.addKeyListener(new KeyAdapter(){

            @Override
            public void keyPressed(KeyEvent e2) {
                TPort.this.processKeyPressed(e2);
            }
        });
        this.addMouseListener(new MouseAdapter(){

            @Override
            public void mousePressed(MouseEvent e2) {
                TPort.this.processMousePressedEvent(e2);
            }

            @Override
            public void mouseReleased(MouseEvent e2) {
                TPort.this.requestFocus();
                TPort.this.inWL = false;
            }
        });
        this.addMouseMotionListener(new MouseMotionAdapter(){

            @Override
            public void mouseDragged(MouseEvent e2) {
                TPort.this.processMouseDraggedEvent(e2);
            }
        });
        this.addMouseWheelListener(new MouseWheelListener(){

            @Override
            public void mouseWheelMoved(MouseWheelEvent mwe) {
                if (mwe.getScrollType() == 0 && TPort.this.isMouseWheelPaging() && TPort.this.isetLength > 1) {
                    int units = mwe.getUnitsToScroll();
                    if (units > 0) {
                        TPort.this.forward(UNITS);
                    }
                    if (units < 0) {
                        TPort.this.back(UNITS);
                    }
                }
            }
        });
    }

    public boolean getHasChildren() {
        return this.hasChildren;
    }

    public void setHasChildren(boolean children) {
        this.hasChildren = children;
    }

    public int getRendering() {
        if (this.r_hint == RenderingHints.VALUE_INTERPOLATION_BILINEAR) {
            return 1;
        }
        if (this.r_hint == RenderingHints.VALUE_INTERPOLATION_NEAREST_NEIGHBOR) {
            return 0;
        }
        if (this.r_hint == RenderingHints.VALUE_INTERPOLATION_BICUBIC) {
            return 2;
        }
        return 0;
    }

    public void setRendering(int render) {
        if (render == 1) {
            this.r_hint = RenderingHints.VALUE_INTERPOLATION_BILINEAR;
        } else if (render <= 0) {
            this.r_hint = RenderingHints.VALUE_INTERPOLATION_NEAREST_NEIGHBOR;
        } else if (render > 1) {
            this.r_hint = RenderingHints.VALUE_INTERPOLATION_BICUBIC;
        }
        this.repaint();
    }

    void cineStep() {
        this.forward(1);
    }

    public int getCineRate() {
        return this.cineRate;
    }

    public void setCineRate(int delay) {
        this.cineRate = delay;
        if (this.timer1 != null) {
            this.timer1.setDelay(delay);
        }
    }

    public boolean getCine() {
        return this.cine;
    }

    public void setCine(boolean cine) {
        this.cine = cine;
        if (this.timer1 == null) {
            this.timer1 = new Timer(this.cineRate, new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e2) {
                    TPort.this.cineStep();
                }
            });
        }
        if (cine) {
            this.timer1.start();
        } else {
            this.timer1.stop();
        }
    }

    public int getWLdir() {
        return this.wlDir;
    }

    public void setWLdir(int wlDir) {
        this.wlDir = wlDir;
    }

    public int getWindowMax() {
        return this.s.window_max;
    }

    public void setWindowMax(int max) {
        this.s.window_max = max;
        this.repaint();
    }

    public int getWindowMin() {
        return this.s.window_min;
    }

    public void setWindowMin(int min) {
        this.s.window_min = min;
        this.repaint();
    }

    public int getSelection() {
        return this.s.selection;
    }

    public void setSelection(int sel) {
        if (this.s.selection == sel) {
            return;
        }
        this.s.selection = sel;
        this.paintSelection();
    }

    void paintSelection() {
        if (this.s.selection == 0) {
            this.repaint();
            return;
        }
        Graphics gr = this.getGraphics();
        gr.setColor(selectColor);
        gr.drawRect(0, 0, this.getWidth() - 1, this.getHeight() - 1);
    }

    public TPortAnnot getAnnot() {
        return this.annot;
    }

    public void setAnnot(TPortAnnot annot) {
        this.annot = annot;
    }

    public double getZoom() {
        return this.s.zoom;
    }

    public void setZoom(double zoom) {
        this.s.zoom = zoom;
        this.repaint();
    }

    public double getRotate() {
        return this.s.rotate;
    }

    public void setRotate(double rotate) {
        this.s.rotate = rotate;
        this.repaint();
    }

    public int getFrame() {
        return this.frame;
    }

    public void setFrame(int frame) {
        int oldFrame = this.frame;
        this.frame = frame;
        this.repaint();
        this.firePropertyChange("frame", oldFrame, frame);
    }

    public void forward(int n2) {
        int frameIdx = this.frame + n2;
        this.setFrame(frameIdx %= this.isetLength);
    }

    public void back(int n2) {
        int frameIdx = this.frame - n2;
        frameIdx = frameIdx < 0 ? this.isetLength + frameIdx : frameIdx;
        this.setFrame(frameIdx);
    }

    public double getPanY() {
        return this.s.pan_y;
    }

    public void setPanY(double pan_y) {
        this.s.pan_y = pan_y;
        this.repaint();
    }

    public double getPanX() {
        return this.s.pan_x;
    }

    public void setPanX(double pan_x) {
        this.s.pan_x = pan_x;
        this.repaint();
    }

    public boolean isRotateEnabled() {
        return this.rotateEnabled;
    }

    public void setRotateEnabled(boolean enabled) {
        this.rotateEnabled = enabled;
    }

    public boolean isCineEnabled() {
        return this.cineEnabled;
    }

    public void setCineEnabled(boolean enabled) {
        this.cineEnabled = enabled;
    }

    public final boolean isKeyboardPaging() {
        return this.keyboardPaging;
    }

    public final void setKeyboardPaging(boolean keyboardPaging) {
        this.keyboardPaging = keyboardPaging;
    }

    public final boolean isMouseWheelPaging() {
        return this.mousewheelPaging;
    }

    public final void setMouseWheelPaging(boolean mousewheelPaging) {
        this.mousewheelPaging = mousewheelPaging;
    }

    public boolean isLock() {
        return this.lock;
    }

    public void setLock(boolean lock) {
        this.lock = lock;
        this.repaint();
    }

    public void resetTransForm() {
        TPortScene.resetScene(this.s);
        this.frame = 0;
    }

    public BufferedImage[] getImages() {
        return this.imgSet;
    }

    public void setImages(BufferedImage[] imgSet, int frame) {
        this.imgSet = imgSet;
        this.isetLength = imgSet == null || imgSet.length == 0 ? 0 : imgSet.length;
        this.frame = 0 == frame ? 0 : frame % this.isetLength;
    }

    public void setImages(BufferedImage[] imgSet) {
        this.setImages(imgSet, 0);
    }

    public DMImage[] getDMImages() {
        return this.dmImgSet;
    }

    public void setImages(DMImage[] dmImgSet, int frame) {
        this.dmImgSet = dmImgSet;
        this.isetLength = dmImgSet == null || dmImgSet.length == 0 ? 0 : dmImgSet.length;
        this.useDMImage = true;
        this.frame = 0 == frame ? 0 : frame % this.isetLength;
    }

    public void setImages(DMImage[] dmImgSet) {
        this.setImages(dmImgSet, 0);
    }

    public TPortScene getScene() {
        return this.s;
    }

    public void setScene(TPortScene s2) {
        this.s = s2;
        this.repaint();
    }

    public boolean getUseModalityInfo() {
        return this.useModalityInfo;
    }

    public void setUseModalityInfo(boolean b2) {
        this.useModalityInfo = b2;
    }

    public boolean isInvert() {
        return this.invert;
    }

    public void setInvert(boolean b2) {
        this.oldInvertFlag = this.invert;
        this.invert = b2;
    }

    private void fillRGB() {
        if (this.s.window_min < 0) {
            this.s.window_min = 0;
        }
        if (this.s.window_max < 0) {
            this.s.window_max = 0;
        }
        if (!this.invert) {
            int i2;
            for (i2 = 0; i2 < this.s.window_min; ++i2) {
                this.rgb[i2] = 0;
            }
            for (i2 = this.s.window_min; i2 < this.s.window_max; ++i2) {
                this.rgb[i2] = this.colorMap[255 * (i2 - this.s.window_min) / (this.s.window_max - this.s.window_min)];
            }
            for (i2 = this.s.window_max; i2 < 32768; ++i2) {
                this.rgb[i2] = this.colorMap[255];
            }
            if (this.highValClip) {
                for (i2 = 32768; i2 < 65536; ++i2) {
                    this.rgb[i2] = this.colorMap[0];
                }
            } else {
                for (i2 = 32768; i2 < 65536; ++i2) {
                    this.rgb[i2] = this.colorMap[255];
                }
            }
        } else {
            int i3;
            for (i3 = 0; i3 < this.s.window_min; ++i3) {
                this.rgb[i3] = this.colorMap[255];
            }
            for (i3 = this.s.window_min; i3 < this.s.window_max; ++i3) {
                this.rgb[i3] = this.colorMap[255 - 255 * (i3 - this.s.window_min) / (this.s.window_max - this.s.window_min)];
            }
            for (i3 = this.s.window_max; i3 < 32768; ++i3) {
                this.rgb[i3] = this.colorMap[0];
            }
            if (this.highValClip) {
                for (i3 = 32768; i3 < 65536; ++i3) {
                    this.rgb[i3] = this.colorMap[255];
                }
            } else {
                for (i3 = 32768; i3 < 65536; ++i3) {
                    this.rgb[i3] = this.colorMap[0];
                }
            }
        }
    }

    public void greyScaleInvert() {
        Tap.log.fine("Doing grey scale inversion");
        for (int i2 = 0; i2 < this.rgb.length; ++i2) {
            int temp = this.rgb[i2];
            this.rgb[i2] = this.rgb[this.rgb.length - i2 - 1];
            this.rgb[this.rgb.length - i2 - 1] = temp;
        }
    }

    @Override
    public void paint(Graphics gr) {
        if (!this.lock) {
            this.getSize(this._d);
            if (!super.isDoubleBuffered()) {
                gr.setColor(Color.black);
                gr.fillRect(0, 0, this._d.width, this._d.height);
            }
            if (this.frame >= 0 && this.isetLength > 0) {
                BufferedImage img;
                int iHeight;
                int iWidth;
                int f2 = this.frame % this.isetLength;
                if (this.useDMImage) {
                    iWidth = this.dmImgSet[f2].getWidth();
                    iHeight = this.dmImgSet[f2].getHeight();
                } else {
                    iWidth = this.imgSet[f2].getWidth();
                    iHeight = this.imgSet[f2].getHeight();
                }
                double normx = (double)this._d.width / (double)iWidth;
                double normy = (double)this._d.height / (double)iHeight;
                double norm = normx > normy ? normy : normx;
                this.g2 = (Graphics2D)gr.create();
                this.fillRGB();
                this._tx.setToIdentity();
                this._tx.translate(this._d.width / 2, this._d.height / 2);
                this._tx.translate(this.s.pan_x * (double)this._d.width, this.s.pan_y * (double)this._d.height);
                this._tx.scale(norm, norm);
                this._tx.rotate(this.s.rotate * Math.PI / 180.0);
                this._tx.scale(this.s.zoom, this.s.zoom);
                this._tx.translate(-iWidth / 2, -iHeight / 2);
                this.g2.transform(this._tx);
                BufferedImage bufferedImage = img = this.useDMImage ? this.dmImgSet[f2].getPixelData() : this.imgSet[f2];
                if (img.getColorModel().getPixelSize() == 16) {
                    if (this.old_max != this.s.window_max || this.old_min != this.s.window_min || this.oldimgSet != img || this.oldInvertFlag != this.invert) {
                        Tap.log.fine("Building new color model");
                        this.cm = new IndexColorModel(16, 65536, this.rgb, 0, false, -1, 1);
                        this.finalimage = new BufferedImage(this.cm, img.getRaster(), false, null);
                        this.old_max = this.s.window_max;
                        this.old_min = this.s.window_min;
                        this.oldimgSet = img;
                    }
                } else {
                    this.finalimage = img;
                }
                this.g2.setRenderingHint(RenderingHints.KEY_INTERPOLATION, this.r_hint);
                if (super.isDoubleBuffered()) {
                    Image offScreen = this.createImage(this.getWidth(), this.getHeight());
                    Graphics2D goff = (Graphics2D)offScreen.getGraphics();
                    goff.fillRect(0, 0, this.getWidth(), this.getHeight());
                    goff.setTransform(this._tx);
                    goff.setRenderingHint(RenderingHints.KEY_INTERPOLATION, this.r_hint);
                    goff.drawImage((Image)this.finalimage, 0, 0, null);
                    gr.drawImage(offScreen, 0, 0, this.getWidth(), this.getHeight(), null);
                } else {
                    this.g2.drawImage((Image)this.finalimage, 0, 0, null);
                }
                if (this.annot != null) {
                    this.annot.draw(img, gr, this._d.width, this._d.height);
                    if (this.showWL && this.inWL) {
                        int width = this.s.window_max - this.s.window_min;
                        int level = (this.s.window_max + this.s.window_min) / 2;
                        TPortAnnot.annotDraw(gr, this._d.width - 90, this._d.height - 11, "W:" + width + "L:" + level);
                    }
                }
                if (this.s.selection > 0) {
                    gr.setColor(selectColor);
                    gr.drawRect(0, 0, this._d.width - 1, this._d.height - 1);
                }
            }
        }
        if (this.hasChildren) {
            this.paintChildren(gr);
        }
    }

    void processKeyPressed(KeyEvent ke) {
        int key = ke.getKeyCode();
        if (this.isCineEnabled() && this.isetLength > 1) {
            if (key == 39) {
                this.setCine(true);
                this.repaint();
            } else if (key == 37) {
                this.setCine(false);
                this.repaint();
            }
        }
        if (this.isRotateEnabled()) {
            if (key == 40) {
                this.s.rotate -= 0.2;
                this.repaint();
            } else if (key == 38) {
                this.s.rotate += 0.2;
                this.repaint();
            }
        }
        if (this.isKeyboardPaging() && this.isetLength > 1) {
            if (key == 34) {
                this.forward(1);
            } else if (key == 33) {
                this.back(1);
            } else if (key == 36) {
                this.frame = 0;
                this.repaint();
            } else if (key == 35) {
                this.frame = this.isetLength - 1;
                this.repaint();
            }
        }
    }

    void processMousePressedEvent(MouseEvent e2) {
        this.mx = e2.getX();
        this.my = e2.getY();
        this.orig_w_max = this.s.window_max;
        this.orig_w_min = this.s.window_min;
        this.orig_zoom = this.s.zoom;
        this.orig_panX = this.s.pan_x;
        this.orig_panY = this.s.pan_y;
        this.mouse = e2.getModifiers();
        if (0 != (this.mouse & 8)) {
            this.inWL = true;
        }
    }

    void processMouseDraggedEvent(MouseEvent e2) {
        if (0 != (this.mouse & 0x10)) {
            this.s.pan_x = this.orig_panX + (double)(e2.getX() - this.mx) / (double)this.getWidth();
            this.s.pan_y = this.orig_panY + (double)(e2.getY() - this.my) / (double)this.getHeight();
            double max_pan = 0.9 * Math.sqrt(this.s.zoom);
            if (this.s.pan_x > max_pan) {
                this.s.pan_x = max_pan;
            } else if (this.s.pan_x < -max_pan) {
                this.s.pan_x = -max_pan;
            }
            if (this.s.pan_y > max_pan) {
                this.s.pan_y = max_pan;
            } else if (this.s.pan_y < -max_pan) {
                this.s.pan_y = -max_pan;
            }
            this.repaint();
        }
        if (0 != (this.mouse & 8)) {
            int delta_level = e2.getY() - this.my;
            int delta_width = this.mx - e2.getX();
            if (this.wlDir == 0) {
                this.s.window_max = this.orig_w_max + delta_level + delta_width;
                this.s.window_min = this.orig_w_min + delta_level - delta_width;
            } else {
                int width = this.orig_w_max - this.orig_w_min;
                int level = (this.orig_w_max + this.orig_w_min) / 2;
                width = KResponseCurve.response(width, delta_width);
                level = KResponseCurve.response(level, delta_level);
                this.s.window_max = level + width / 2;
                this.s.window_min = level + width / 2;
            }
            if (this.s.window_max <= this.s.window_min) {
                this.s.window_min = (this.s.window_max + this.s.window_min) / 2;
                this.s.window_max = this.s.window_min - 1;
            }
            this.repaint();
        }
        if (0 != (this.mouse & 4)) {
            double delta = 1.0 + (double)(this.my - e2.getY()) / 100.0;
            if (delta <= 0.0) {
                delta = 0.01;
            }
            this.s.zoom = this.orig_zoom * delta;
            if (this.s.zoom < 0.1) {
                this.s.zoom = 0.1;
            }
            if (this.s.zoom > 20.0) {
                this.s.zoom = 20.0;
            }
            this.repaint();
        }
    }

    public static double[] panZoomToDicom(double pan_x, double pan_y, double zoom, int imgW, int imgH, int scrW, int scrH) {
        double norm;
        double normx = (double)scrW / (double)imgW;
        double normy = (double)scrH / (double)imgH;
        double d2 = norm = normx > normy ? normy : normx;
        if (pan_x == 0.0 && pan_y == 0.0 && zoom == 1.0) {
            return new double[]{0.0, 0.0, imgW, imgH};
        }
        AffineTransform _tx = new AffineTransform();
        _tx.setToIdentity();
        _tx.translate(scrW / 2, scrH / 2);
        _tx.translate(pan_x * (double)scrW, pan_y * (double)scrH);
        _tx.scale(norm, norm);
        _tx.scale(zoom, zoom);
        _tx.translate(-imgW / 2, -imgH / 2);
        double[] screen = new double[]{0.0, 0.0, scrW, scrH};
        double[] img = new double[4];
        try {
            _tx.inverseTransform(screen, 0, img, 0, 2);
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        Tap.log.fine("img map = (" + img[0] + "," + img[1] + ")-(" + img[2] + "," + img[3] + ")");
        return img;
    }

    public String getNamedColorMap() {
        return this.namedColorMap;
    }

    public void setNamedColorMap(String namedColorMap) {
        this.namedColorMap = namedColorMap;
        this.colorMap = ColorTable.getColorTable((String)namedColorMap);
    }

    @Override
    public boolean isDoubleBuffered() {
        return super.isDoubleBuffered();
    }

    @Override
    public void setDoubleBuffered(boolean doubleBuffered) {
        super.setDoubleBuffered(doubleBuffered);
    }

    public boolean isAutoLeveled() {
        return this.autoLeveled;
    }

    public void setAutoLeveled(boolean autoLeveled) {
        if (autoLeveled) {
            this.autoLevel();
        } else {
            this.resetLevel();
        }
    }

    public void autoLevel() {
        int[] b2 = this.useDMImage ? TPort.calcMinMax(this.dmImgSet[this.frame], 10) : TPort.calcMinMax(this.imgSet[this.frame], 10);
        this.saved_min = this.getWindowMin();
        this.saved_max = this.getWindowMax();
        this.autoLeveled = true;
        this.setWindowMin(b2[0]);
        this.setWindowMax(b2[1]);
    }

    public static int[] calcMinMax(DMImage img) {
        return TPort.calcMinMax(img, 1);
    }

    public static int[] calcMinMax(DMImage img, int skip) {
        return TPort.calcMinMax(img.getPixelData(), skip);
    }

    public static int[] calcMinMax(BufferedImage img) {
        return TPort.calcMinMax(img, 1);
    }

    public static int[] calcMinMax(BufferedImage img, int skip) {
        int[] data = new int[1];
        int[] minmax = new int[2];
        minmax[1] = Integer.MIN_VALUE;
        minmax[0] = Integer.MAX_VALUE;
        for (int y2 = 0; y2 < img.getHeight(); y2 += skip) {
            for (int x2 = 0; x2 < img.getWidth(); x2 += skip) {
                data = img.getRaster().getPixel(x2, y2, data);
                if (minmax[0] > data[0]) {
                    minmax[0] = data[0];
                    continue;
                }
                if (minmax[1] >= data[0]) continue;
                minmax[1] = data[0];
            }
        }
        return minmax;
    }

    public void resetLevel() {
        this.setWindowMin(this.saved_min);
        this.setWindowMax(this.saved_max);
        this.autoLeveled = false;
    }

    public void byteSwap() {
        BufferedImage[] images = this.getImages();
        for (int x2 = 0; x2 < images.length; ++x2) {
            int i2;
            Object[] data;
            DataBuffer db = images[x2].getRaster().getDataBuffer();
            if (db instanceof DataBufferShort) {
                data = ((DataBufferShort)db).getData();
                for (i2 = 0; i2 < data.length; ++i2) {
                    data[i2] = (short)((data[i2] & 0xFF) << 8 | (data[i2] & 0xFF00) >> 8);
                }
            } else if (db instanceof DataBufferUShort) {
                data = ((DataBufferUShort)db).getData();
                for (i2 = 0; i2 < data.length; ++i2) {
                    data[i2] = (short)((data[i2] & 0xFF) << 8 | (data[i2] & 0xFF00) >> 8);
                }
            } else if (db instanceof DataBufferInt) {
                data = ((DataBufferInt)db).getData();
                for (i2 = 0; i2 < data.length; ++i2) {
                    data[i2] = (data[i2] & 0xFFFF) << 16 | (data[i2] & 0xFFFF0000) >> 16;
                }
            } else {
                System.err.println("Unknown data buffer type");
            }
            Tap.log.fine("Done with byte swaping");
            this.setImages(images);
            this.repaint();
        }
    }

    public boolean isShowWL() {
        return this.showWL;
    }

    public void setShowWL(boolean showWL) {
        this.showWL = showWL;
    }

    public static JFrame simpleDisplayFrame(DMImage[] img) {
        JFrame f2 = new JFrame("Simple TPort (DMImage)");
        TPort tp = new TPort();
        tp.setShowWL(true);
        f2.getContentPane().add(tp);
        tp.setImages(img);
        f2.setBounds(0, 0, 512, 512);
        f2.setDefaultCloseOperation(3);
        f2.setVisible(true);
        return f2;
    }

    public static JFrame simpleDisplayFrame(BufferedImage[] img) {
        JFrame f2 = new JFrame("Simple TPort (BufferedImage)");
        TPort tp = new TPort();
        tp.setShowWL(true);
        f2.getContentPane().add(tp);
        tp.setImages(img);
        f2.setBounds(0, 0, 512, 512);
        f2.setDefaultCloseOperation(3);
        f2.setVisible(true);
        return f2;
    }

    public static void main(String[] args) {
        JFileChooser fc = new JFileChooser();
        fc.setSize(100, 100);
        fc.setMultiSelectionEnabled(false);
        fc.showOpenDialog(null);
        File f2 = fc.getSelectedFile();
        if (f2 != null) {
            String file = f2.getAbsolutePath();
            System.out.println("Loading " + file);
            DMSession dm = new DMSession("file", null, new String[]{file});
            DMObject[] obj = dm.getChildren();
            if (obj != null && obj.length > 0) {
                BufferedImage[] bims = obj[0].getPixelData();
                TPort.simpleDisplayFrame(bims);
            }
        }
    }

    static {
        int i2;
        UNITS = Integer.parseInt(Tap.getProperty("tap.mousewheel.scrollunits", "1"));
        selectColor = Color.cyan;
        toLogSpace = new short[65536];
        GrayScale = new int[256];
        for (i2 = Short.MIN_VALUE; i2 < Short.MAX_VALUE; ++i2) {
            TPort.toLogSpace[i2 & 0xFFFF] = (short)(16383.0 * Math.pow((double)i2 / 16383.0, 0.2));
        }
        for (i2 = 0; i2 < 256; ++i2) {
            TPort.GrayScale[i2] = 65793 * i2;
        }
    }
}

