/*
 * Decompiled with CFR 0.152.
 */
package com.ge.med.terra.tap.util.tport;

import com.ge.med.terra.tap.util.tport.BufferedImageEx;
import com.ge.med.terra.tap.util.tport.HttpImageServer;
import com.ge.med.terra.tap.util.tport.TPort;
import com.ge.med.terra.tap.util.tport.TPortClientApplet2_autolevel_actionAdapter;
import com.ge.med.terra.tap.util.tport.TPortClientApplet2_invert_actionAdapter;
import com.ge.med.terra.tap.util.tport.TPortClientApplet2_jList2_mouseAdapter;
import com.ge.med.terra.tap.util.tport.TPortClientApplet2_next_actionAdapter;
import com.ge.med.terra.tap.util.tport.TPortClientApplet2_previous_actionAdapter;
import java.applet.Applet;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Rectangle;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.MouseEvent;
import java.awt.image.BufferedImage;
import java.io.EOFException;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.net.InetAddress;
import java.net.URL;
import java.util.ArrayList;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JList;
import javax.swing.JScrollBar;
import javax.swing.JSplitPane;
import javax.swing.JTextField;

public class TPortClientApplet2
extends Applet {
    boolean isStandalone = false;
    JSplitPane jSplitPane1 = new JSplitPane();
    TPort tport = new TPort();
    JList jList2 = new JList();
    JScrollBar sb = new JScrollBar();
    BufferedImage[] bi;
    String url = "/";
    String curDir = "/";
    JTextField jTextField1 = new JTextField();
    JButton previous = new JButton();
    JButton next = new JButton();
    int current = 0;
    JButton autolevel = new JButton();
    JButton invert = new JButton();

    public String getParameter(String key, String def) {
        return this.isStandalone ? System.getProperty(key, def) : (this.getParameter(key) != null ? this.getParameter(key) : def);
    }

    @Override
    public void init() {
        try {
            this.jbInit();
        }
        catch (Exception e2) {
            e2.printStackTrace();
        }
    }

    private void jbInit() throws Exception {
        this.setLayout(null);
        this.jSplitPane1.setBorder(BorderFactory.createRaisedBevelBorder());
        this.jSplitPane1.setLeftComponent(this.sb);
        this.jSplitPane1.setBounds(new Rectangle(24, 11, 503, 367));
        this.tport.setLayout(null);
        this.jList2.setBackground(Color.lightGray);
        this.jList2.setSelectionBackground(Color.gray);
        this.jList2.setSelectionMode(0);
        this.jList2.addMouseListener(new TPortClientApplet2_jList2_mouseAdapter(this));
        this.jTextField1.setBackground(Color.lightGray);
        this.jTextField1.setDisabledTextColor(Color.lightGray);
        this.jTextField1.setEditable(false);
        this.jTextField1.setText("jTextField1");
        this.jTextField1.setBounds(new Rectangle(23, 423, 506, 24));
        this.previous.setEnabled(false);
        this.previous.setToolTipText("Show previous image");
        this.previous.setText("Previous");
        this.previous.setBounds(new Rectangle(114, 386, 94, 27));
        this.previous.addActionListener(new TPortClientApplet2_previous_actionAdapter(this));
        this.next.setEnabled(false);
        this.next.setToolTipText("Show Next Image");
        this.next.setText("Next");
        this.next.setBounds(new Rectangle(220, 386, 79, 27));
        this.next.addActionListener(new TPortClientApplet2_next_actionAdapter(this));
        this.invert.setText("Invert");
        this.invert.setBounds(new Rectangle(417, 385, 79, 27));
        this.invert.addActionListener(new TPortClientApplet2_invert_actionAdapter(this));
        this.tport.setAnnot(null);
        this.sb.add(this.jList2);
        this.tport.setOpaque(true);
        this.tport.setDoubleBuffered(true);
        this.tport.setAnnot(null);
        this.autolevel.setText("AutoLevel");
        this.autolevel.setBounds(new Rectangle(310, 385, 92, 27));
        this.autolevel.addActionListener(new TPortClientApplet2_autolevel_actionAdapter(this));
        this.jSplitPane1.add((Component)this.jList2, "left");
        this.jSplitPane1.add((Component)this.tport, "right");
        this.add((Component)this.jTextField1, null);
        this.add((Component)this.jSplitPane1, null);
        this.add((Component)this.previous, null);
        this.add((Component)this.next, null);
        this.add((Component)this.autolevel, null);
        this.add((Component)this.invert, null);
        this.jSplitPane1.setDividerLocation(150);
        this.getListing("");
    }

    @Override
    public void start() {
    }

    @Override
    public void stop() {
    }

    @Override
    public void destroy() {
    }

    @Override
    public String getAppletInfo() {
        return "Applet Information";
    }

    @Override
    public String[][] getParameterInfo() {
        return null;
    }

    void status(String msg) {
        this.jTextField1.setText(msg);
        this.jTextField1.repaint();
    }

    private void pull(String url_str) {
        try {
            this.status("Contacting server ..." + url_str);
            ArrayList<BufferedImage> list = new ArrayList<BufferedImage>();
            URL url = new URL(url_str);
            InputStream in = url.openStream();
            ObjectInputStream oi = new ObjectInputStream(in);
            try {
                while (true) {
                    Integer obj_type;
                    if ((obj_type = (Integer)oi.readObject()) == HttpImageServer.OBJ_TYPE_IMAGE) {
                        this.status("Pulling images ...");
                        BufferedImageEx i2 = (BufferedImageEx)oi.readObject();
                        list.add(i2.getBufferedImage());
                        continue;
                    }
                    if (obj_type == HttpImageServer.OBJ_TYPE_LIST) break;
                }
                this.status("Getting listing ...");
                String[] str = (String[])oi.readObject();
                try {
                    this.curDir = str[0].substring(str[0].indexOf(40) + 1, str[0].indexOf(41));
                    if (this.curDir.equals("..")) {
                        this.curDir = "/";
                    }
                }
                catch (Exception e2) {
                    this.curDir = "/";
                    e2.printStackTrace();
                }
                System.out.println("Setting curDir to " + this.curDir);
                this.jList2.setListData(str);
                oi.close();
                in.close();
                this.status("Done");
                return;
            }
            catch (Exception e3) {
                if (e3 instanceof EOFException) {
                    this.status("No more images to read");
                    oi.close();
                    in.close();
                } else {
                    e3.printStackTrace();
                }
                this.bi = new BufferedImage[list.size()];
                for (int i3 = 0; i3 < this.bi.length; ++i3) {
                    this.bi[i3] = (BufferedImage)list.get(i3);
                }
                this.status("Adding " + this.bi.length + " images to TPort");
                if (this.bi.length > 0) {
                    this.tport.setImages(this.bi);
                }
                this.tport.repaint();
                if (this.bi.length > 1) {
                    this.previous.setEnabled(true);
                    this.next.setEnabled(true);
                } else {
                    this.previous.setEnabled(false);
                    this.next.setEnabled(false);
                }
                this.status("Done");
            }
        }
        catch (Exception e4) {
            this.status("Failed: " + e4.getMessage());
            e4.printStackTrace();
        }
    }

    void getListing(String selection) {
        try {
            this.url = "http://" + InetAddress.getByName(this.getDocumentBase().getHost()).getHostAddress();
        }
        catch (Exception ee) {
            this.url = "http://localhost";
        }
        String port = this.getParameter("SERVER_PORT", "4100");
        this.url = this.url + ":" + port;
        this.url = this.url + "/" + selection;
        Thread th = new Thread(new Runnable(){

            @Override
            public void run() {
                try {
                    TPortClientApplet2.this.pull(TPortClientApplet2.this.url);
                }
                catch (Exception ex) {
                    ex.printStackTrace();
                }
            }
        });
        th.start();
    }

    void jList2_mouseClicked(MouseEvent e2) {
        try {
            int i2 = this.jList2.locationToIndex(e2.getPoint());
            String s2 = (String)this.jList2.getSelectedValue();
            this.jList2.setSelectedIndex(i2);
            if (this.curDir.equals("/") && s2.equals("..")) {
                return;
            }
            if (s2.startsWith("<") || s2.equals("..")) {
                s2 = s2.substring(s2.indexOf(62, 1) + 1);
                this.getListing(this.curDir + "/" + s2);
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    void previous_actionPerformed(ActionEvent e2) {
        if (this.bi == null || this.bi.length <= this.current + 1) {
            return;
        }
        ++this.current;
        this.tport.setFrame(this.current);
        this.tport.repaint();
    }

    void next_actionPerformed(ActionEvent e2) {
        if (this.current <= 0) {
            return;
        }
        --this.current;
        this.tport.setFrame(this.current);
        this.tport.repaint();
    }

    void autolevel_actionPerformed(ActionEvent e2) {
        if (this.tport.getImages() == null || this.tport.getImages().length <= 0) {
            return;
        }
        if (((JButton)e2.getSource()).getText().equalsIgnoreCase("AutoLevel")) {
            this.tport.autoLevel();
            ((JButton)e2.getSource()).setText("Reset W/L");
        } else if (((JButton)e2.getSource()).getText().equalsIgnoreCase("Reset W/L")) {
            TPort temp = new TPort();
            temp.setImages(this.tport.getImages());
            this.tport.setWindowMin(temp.getWindowMin());
            this.tport.setWindowMax(temp.getWindowMax());
            ((JButton)e2.getSource()).setText("AutoLevel");
        }
    }

    void invert_actionPerformed(ActionEvent e2) {
        if (this.tport.getImages() == null || this.tport.getImages().length <= 0) {
            return;
        }
        this.tport.setInvert(!this.tport.isInvert());
        this.tport.repaint();
    }

    public static void main(String[] args) {
        TPortClientApplet2 applet = new TPortClientApplet2();
        applet.isStandalone = true;
        JFrame frame = new JFrame();
        frame.setDefaultCloseOperation(3);
        frame.setTitle("Applet Frame");
        frame.getContentPane().add((Component)applet, "Center");
        applet.init();
        applet.start();
        frame.setSize(600, 500);
        Dimension d2 = Toolkit.getDefaultToolkit().getScreenSize();
        frame.setLocation((d2.width - frame.getSize().width) / 2, (d2.height - frame.getSize().height) / 2);
        frame.setVisible(true);
    }
}

