/*
 * Decompiled with CFR 0.152.
 */
package com.ge.med.terra.tap.util.xlib;

import com.ge.med.terra.tap.util.xlib.JXEvent;
import com.ge.med.terra.tap.util.xlib.JXEventListener;
import com.ge.med.terra.tap.util.xlib.JXPropertyEvent;
import com.ge.med.terra.tap.util.xlib.JXReplyEvent;
import com.ge.med.terra.tap.util.xlib.JXScreen;
import com.ge.med.terra.tap.util.xlib.JXWindow;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.ConnectException;
import java.net.InetAddress;
import java.net.Socket;
import java.net.UnknownHostException;
import java.util.HashMap;
import java.util.LinkedList;

public class JXDisplay {
    Socket sock;
    DataInputStream in;
    DataOutputStream out;
    String host;
    int displayNumber = 0;
    int screenNumber = 0;
    int resourceBase;
    int resourceMask;
    int major;
    int minor;
    int releaseNumber;
    int motionBufferSize;
    String vendor;
    int maxRequestLength;
    boolean imageMSB;
    boolean bitmapMSB;
    int bitmapScanUnit;
    int bitmapScanPad;
    JXScreen[] screen;
    HashMap eventhandles = new HashMap(1);
    LinkedList eventQue = new LinkedList();
    byte[] padding = new byte[12];

    public JXScreen getScreen(int i2) {
        return this.screen[i2];
    }

    public void connect(String displayName) throws ConnectException, IOException, UnknownHostException {
        InetAddress address;
        int colonPos = displayName.indexOf(58);
        if (colonPos > 0) {
            this.host = displayName.substring(0, colonPos);
            String display = displayName.substring(colonPos + 1);
            int dotPos = display.indexOf(46);
            if (dotPos > 0) {
                this.displayNumber = Integer.parseInt(display.substring(0, dotPos));
                this.screenNumber = Integer.parseInt(display.substring(dotPos + 1));
            } else {
                this.displayNumber = Integer.parseInt(display);
            }
        } else {
            this.host = displayName;
        }
        if (this.host.length() > 0) {
            address = InetAddress.getByName(this.host);
        } else {
            address = InetAddress.getLocalHost();
            this.host = address.getHostName();
        }
        this.connect(address, this.displayNumber, this.screenNumber);
    }

    public void connect(InetAddress address, int number, int screen) throws ConnectException, IOException, UnknownHostException {
        this.sock = new Socket(address, number + 6000);
        this.connect(this.sock.getInputStream(), this.sock.getOutputStream(), screen);
    }

    protected void connect(InputStream input, OutputStream output, int defaultScreen) throws ConnectException, IOException {
        int i2;
        this.in = new DataInputStream(input);
        this.out = new DataOutputStream(output);
        this.out.writeByte(66);
        this.out.writeByte(0);
        this.out.writeShort(11);
        this.out.writeShort(0);
        this.out.writeShort(0);
        this.out.writeShort(0);
        this.out.writeShort(0);
        this.out.flush();
        if (this.in.readByte() != 1) {
            byte[] reason = new byte[this.in.readByte()];
            short major = this.in.readShort();
            short minor = this.in.readShort();
            this.in.skipBytes(2);
            this.in.read(reason);
            throw new ConnectException("(" + major + "," + minor + ") " + new String(reason));
        }
        this.in.skipBytes(1);
        this.major = this.in.readShort();
        this.minor = this.in.readShort();
        this.in.skipBytes(2);
        this.releaseNumber = this.in.readInt();
        this.resourceBase = this.in.readInt();
        this.resourceMask = this.in.readInt();
        this.motionBufferSize = this.in.readInt();
        short vendorLength = this.in.readShort();
        this.maxRequestLength = this.in.readShort();
        byte number_of_screens = this.in.readByte();
        this.screen = new JXScreen[number_of_screens];
        int formats = this.in.readByte();
        this.imageMSB = this.in.readByte() == 1;
        this.bitmapMSB = this.in.readByte() == 1;
        this.bitmapScanUnit = this.in.readByte();
        this.bitmapScanPad = this.in.readByte();
        byte minKeyCode = this.in.readByte();
        byte maxKeyCode = this.in.readByte();
        int numKeyCode = maxKeyCode - minKeyCode + 1;
        this.in.skipBytes(4);
        byte[] buffer = new byte[vendorLength];
        this.in.read(buffer);
        this.vendor = new String(buffer);
        this.in.skipBytes(vendorLength % 2);
        System.out.println("release" + this.releaseNumber + " : " + this.major + "," + this.minor);
        System.out.println("vendor = \"" + this.vendor + "\"");
        System.out.println("" + this.screen.length + " screen" + (this.screen.length > 1 ? "s" : ""));
        int[] bpp = new int[65];
        int[] bitPad = new int[65];
        System.out.println("reading " + formats + " formats");
        for (i2 = 0; i2 < formats; ++i2) {
            byte depth = this.in.readByte();
            bpp[depth] = this.in.readByte();
            bitPad[depth] = this.in.readByte();
            this.in.skipBytes(5);
        }
        for (i2 = 0; i2 < this.screen.length; ++i2) {
            this.screen[i2] = new JXScreen(this, bpp, bitPad);
        }
        Thread t2 = new Thread(){

            @Override
            public void run() {
                JXDisplay.this.loop();
            }
        };
        t2.setDaemon(true);
        t2.start();
        System.out.println("connection complete");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void loop() {
        new eventDispatch(this.eventQue).start();
        while (true) {
            JXEvent e2;
            if (!this.eventhandles.containsKey(new Integer((e2 = JXEvent.getNextEvent(this.in)).getType()))) {
                continue;
            }
            LinkedList linkedList = this.eventQue;
            synchronized (linkedList) {
                this.eventQue.addLast(e2);
                this.eventQue.notify();
            }
        }
    }

    public void addEventHandle(int eventType, JXEventListener h2) {
        this.eventhandles.put(new Integer(eventType), h2);
    }

    private synchronized JXReplyEvent getReply() {
        return JXEvent.getReply();
    }

    public void SelectInput(JXWindow w2, int eventMask) {
        try {
            this.generateRequest(2, 0, 4);
            this.out.writeInt(w2.id);
            int bitmask = 2048;
            this.out.writeInt(bitmask);
            this.out.writeInt(eventMask);
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    public int internAtom(String name, boolean onlyIfExist) {
        try {
            int n2 = name.length();
            int p2 = JXDisplay.pad(n2);
            this.generateRequest(16, onlyIfExist ? 1 : 0, 2 + (n2 + p2) / 4);
            this.out.writeShort(n2);
            this.out.write(this.padding, 0, 2);
            this.out.write(name.getBytes());
            this.out.write(this.padding, 0, p2);
            JXReplyEvent re = this.getReply();
            int value = 0;
            for (int i2 = 0; i2 < 4; ++i2) {
                value <<= 8;
                value += re.data[i2] & 0xFF;
            }
            return value;
        }
        catch (Exception ex) {
            System.err.println("Trying to intern " + name);
            ex.printStackTrace();
            return 0;
        }
    }

    public String getAtomName(int atom) {
        try {
            this.generateRequest(17, 0, 2);
            this.out.writeInt(atom);
            JXReplyEvent re = this.getReply();
            int len = ((re.data[0] & 0xFF) << 8) + (re.data[1] & 0xFF);
            return new String(re.ext, 0, len);
        }
        catch (Exception ex) {
            System.err.println("Trying to acces " + atom);
            ex.printStackTrace();
            return null;
        }
    }

    public int getProperty(JXWindow w2, int atom, int type, int offset, int length, boolean delete) {
        try {
            this.generateRequest(20, delete ? 1 : 0, 6);
            this.out.writeInt(w2.id);
            this.out.writeInt(atom);
            this.out.writeInt(type);
            this.out.writeInt(offset);
            this.out.writeInt(length);
            JXReplyEvent re = this.getReply();
            int rtype = this.readInt(re.data, 0);
            int bytesAfter = this.readInt(re.data, 4);
            int lengthAfter = this.readInt(re.data, 8);
            return this.readInt(re.ext, 0);
        }
        catch (Exception ex) {
            System.err.println("Trying to acces " + atom);
            ex.printStackTrace();
            return 0;
        }
    }

    private int readInt(byte[] data, int offset) {
        int value = 0;
        for (int i2 = 0; i2 < 4; ++i2) {
            value <<= 8;
            value += data[i2 + offset] & 0xFF;
        }
        return value;
    }

    private int readShort(byte[] data, int offset) {
        int value = 0;
        for (int i2 = 0; i2 < 2; ++i2) {
            value <<= 8;
            value += data[i2 + offset] & 0xFF;
        }
        return value;
    }

    public void listProperties() {
    }

    public void generateRequest(int opcode, int ext, int length) throws IOException {
        this.out.writeByte(opcode);
        this.out.writeByte(ext);
        this.out.writeShort(length);
    }

    public static int pad(int length) {
        return -length & 3;
    }

    public static void main(String[] args) {
        try {
            final JXDisplay disp = new JXDisplay();
            disp.connect("dolphins:0.1");
            int atom = disp.internAtom("_XROOMS_CURRENT", true);
            System.out.println("atom = " + atom);
            String str = disp.getAtomName(atom);
            System.out.println("atom name = " + str);
            int propvalue = disp.getProperty(disp.getScreen(1).getRoot(), atom, 0, 0, 4, false);
            System.out.println("propvalue=" + propvalue);
            System.out.println("propvalue=" + disp.getAtomName(propvalue));
            disp.SelectInput(disp.getScreen(1).getRoot(), 0x400000);
            disp.addEventHandle(28, new JXEventListener(){

                @Override
                public void event(JXEvent e2) {
                    if (e2 instanceof JXPropertyEvent) {
                        JXPropertyEvent p2 = (JXPropertyEvent)e2;
                        int prop = p2.getAtom();
                        System.out.println("atom = " + prop);
                        JXWindow root = disp.getScreen(1).getRoot();
                        int xrooms = disp.internAtom("_XROOMS_CURRENT", true);
                        int desktopname = disp.getProperty(root, xrooms, 0, 0, 4, false);
                        String desktop = disp.getAtomName(desktopname);
                        System.out.println("desktop is now " + desktop);
                    }
                }
            });
            Thread.sleep(4000L);
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    class eventDispatch
    extends Thread {
        LinkedList eventQue;

        public eventDispatch(LinkedList e2) {
            this.setDaemon(true);
            this.eventQue = e2;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            while (true) {
                JXEvent event = null;
                LinkedList linkedList = this.eventQue;
                synchronized (linkedList) {
                    try {
                        while (this.eventQue.size() == 0) {
                            this.eventQue.wait();
                        }
                        event = (JXEvent)this.eventQue.removeFirst();
                    }
                    catch (InterruptedException ex) {
                        ex.printStackTrace();
                    }
                }
                JXEventListener l2 = (JXEventListener)JXDisplay.this.eventhandles.get(new Integer(event.getType()));
                l2.event(event);
            }
        }
    }
}

