/*
 * Decompiled with CFR 0.152.
 */
package com.ge.med.terra.xpv.autoControls;

import com.ge.med.idc.ColorMapCapable;
import com.ge.med.terra.tap.dm.DMObject;
import com.ge.med.terra.tap.util.log.Tid;
import com.ge.med.terra.xpv.autoControls.AutoControlPanelSeek;
import com.ge.med.terra.xpv.autoControls.AutoControlResources;
import com.ge.med.terra.xpv.base.CapableListener;
import com.ge.med.terra.xpv.base.XPcontrolArea;
import com.ge.med.terra.xpv.base.XPscreen;
import com.ge.med.terra.xpv.util.XPutil;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.File;
import java.util.HashMap;
import java.util.Properties;
import java.util.ResourceBundle;
import java.util.StringTokenizer;
import java.util.logging.Level;
import javax.swing.DefaultListModel;
import javax.swing.JComponent;
import javax.swing.JList;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;

public class XPwColorMapList
extends JList
implements CapableListener {
    static ResourceBundle res = AutoControlResources.STRING_RESOURCES;
    XPscreen screen = null;
    AutoControlPanelSeek panelSeek = null;
    DefaultListModel model = new DefaultListModel();
    HashMap hm = new HashMap();
    HashMap hm1 = new HashMap();
    private PropertyChangeListener viewPortListener = new PropertyChangeListener(){

        @Override
        public void propertyChange(PropertyChangeEvent evt) {
            if (evt.getPropertyName() == "data_changed") {
                XPwColorMapList.this.setSelectedValue("jpt", true);
                XPwColorMapList.this.screen.getSelectedPort().putClientProperty("colorMap", "jpt");
            }
        }
    };

    public XPwColorMapList() {
        this.panelSeek = new AutoControlPanelSeek(this);
        this.addAncestorListener(this.panelSeek);
        try {
            this.jbInit();
        }
        catch (Exception e2) {
            e2.printStackTrace();
        }
    }

    public void setData(DMObject[] objs) {
    }

    @Override
    public void setProperties(Properties properties) {
        String color = properties.getProperty("colorMaps");
        StringTokenizer st = new StringTokenizer(color, ",");
        this.model.clear();
        while (st.hasMoreTokens()) {
            int index;
            String next = st.nextToken();
            String rgb = next;
            if (rgb.endsWith(".rgb") || rgb.endsWith(".txt")) {
                rgb = next.substring(next.lastIndexOf(File.separator) + 1, next.length() - 4);
            }
            if ((index = rgb.lastIndexOf(47)) >= 0 && index < rgb.length() - 1) {
                rgb = rgb.substring(index + 1);
            }
            if ((index = rgb.lastIndexOf(92)) >= 0 && index < rgb.length() - 1) {
                rgb = rgb.substring(index + 1);
            }
            this.hm.put(rgb, next);
            this.hm1.put(next, rgb);
            this.model.addElement(rgb);
        }
        this.setModel(this.model);
        this.setSelectedValue("jpt", true);
    }

    @Override
    public void selectionChanged(JComponent oldPort, JComponent newPort) {
        ColorMapCapable cmc = (ColorMapCapable)this.panelSeek.getCapable("com.ge.med.idc.ColorMapCapable");
        if (cmc == null) {
            return;
        }
        Object name = ((JComponent)((Object)cmc)).getClientProperty("colorMap");
        if (name != null) {
            this.setSelectedValue(this.hm1.get(name), true);
        } else {
            this.clearSelection();
        }
    }

    @Override
    public void setScreen(XPscreen screen) {
        this.screen = screen;
        screen.addPropertyChangeListener(this.viewPortListener);
    }

    @Override
    public void setControlArea(XPcontrolArea ca) {
    }

    private void jbInit() throws Exception {
        this.addListSelectionListener(new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent e2) {
                XPwColorMapList.this.this_valueChanged(e2);
            }
        });
    }

    void this_valueChanged(ListSelectionEvent e2) {
        XPutil.getLogger().log(Level.FINEST, "Start <XPwColorMapList>  " + Tid.newTid());
        ColorMapCapable cmc = (ColorMapCapable)this.panelSeek.getCapable("com.ge.med.idc.ColorMapCapable");
        if (cmc == null) {
            XPutil.getLogger().log(Level.FINEST, "End <XPwColorMapList>");
            Tid.popTID();
            return;
        }
        String cname = (String)this.getSelectedValue();
        cmc.setColorMap(XPutil.getColorTable((String)this.hm.get(cname)));
        if (this.panelSeek.isAll()) {
            JComponent[] ports = this.screen.getAllPorts();
            for (int i2 = 0; i2 < ports.length; ++i2) {
                ports[i2].putClientProperty("colorMap", this.hm.get(cname));
            }
        } else {
            ((JComponent)((Object)cmc)).putClientProperty("colorMap", this.hm.get(cname));
        }
        XPutil.getLogger().log(Level.FINEST, "End <XPwColorMapList>");
        Tid.popTID();
    }

    public int[] getColorMap() {
        ColorMapCapable cmc = (ColorMapCapable)this.panelSeek.getCapable("com.ge.med.idc.ColorMapCapable");
        if (cmc == null) {
            return null;
        }
        return cmc.getColorMap();
    }

    public int[] getColorMap(String colorName) {
        return XPutil.getColorTable(colorName);
    }
}

