/*
 * Decompiled with CFR 0.152.
 */
package com.ge.med.terra.xpv.autoControls;

import com.ge.med.terra.jami.capable.ImageOpCapable;
import com.ge.med.terra.jami.render.XpImageRenderAttributesOwner;
import com.ge.med.terra.xpv.autoControls.AutoControlPanelSeek;
import com.ge.med.terra.xpv.base.CapableListener;
import com.ge.med.terra.xpv.base.XPcontrolArea;
import com.ge.med.terra.xpv.base.XPscreen;
import com.ge.med.terra.xpv.cuiPanels.DisplayColorModelUtils;
import com.ge.med.terra.xpv.cuiPanels.ImageFilter;
import com.ge.med.terra.xpv.cuiPanels.TransactionLogName;
import com.ge.med.terra.xpv.util.XPutil;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Properties;
import java.util.logging.Level;
import javax.swing.InputMap;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.ListCellRenderer;
import javax.swing.UIManager;

public class XPwFilterCombobox
extends JComboBox
implements CapableListener,
ActionListener {
    XPscreen screen = null;
    AutoControlPanelSeek panelSeek = null;
    public static final int ES_FILTER = 0;
    public static final int GS_FILTER = 1;
    private int filterType = 0;

    public XPwFilterCombobox(int type) {
        this.filterType = type;
        this.panelSeek = new AutoControlPanelSeek(this);
        this.addAncestorListener(this.panelSeek);
        this.setInputMap(1, new InputMap());
        this.setRenderer(new ComboBoxRenderer());
        this.addActionListener(this);
    }

    @Override
    public void setProperties(Properties properties) {
    }

    @Override
    public void selectionChanged(JComponent oldPort, JComponent newPort) {
    }

    @Override
    public void setScreen(XPscreen screen) {
        this.screen = screen;
    }

    @Override
    public void setControlArea(XPcontrolArea ca) {
    }

    @Override
    public void actionPerformed(ActionEvent ae2) {
        String selFilter = (String)((JComboBox)ae2.getSource()).getSelectedItem();
        if (selFilter != null) {
            if (selFilter.equals("None")) {
                this.clearESFilter();
            } else if (this.filterType == 0) {
                this.setESFilter(selFilter);
            } else if (this.filterType == 1) {
                this.setGSFilter(selFilter);
            }
        }
    }

    private void clearESFilter() {
        ImageOpCapable imageOp = (ImageOpCapable)this.panelSeek.getCapable("com.ge.med.terra.jami.capable.ImageOpCapable");
        if (imageOp != null) {
            imageOp.clearImageOps();
        }
    }

    private void setESFilter(String filter) {
        TransactionLogName tln = new TransactionLogName("TID=SD_filter_" + filter);
        XPutil.getLogger().log(Level.FINEST, "{0} begin", tln);
        ImageOpCapable imageOp = (ImageOpCapable)this.panelSeek.getCapable("com.ge.med.terra.jami.capable.ImageOpCapable");
        if (imageOp == null) {
            XPutil.getLogger().log(Level.SEVERE, "{0} SEV5 NotImageOpCapable", tln);
            return;
        }
        imageOp.clearImageOps();
        if (filter.equals("E1")) {
            imageOp.addImageOp(ImageFilter.E1());
        } else if (filter.equals("E2")) {
            imageOp.addImageOp(ImageFilter.E2());
        } else if (filter.equals("E21")) {
            imageOp.addImageOp(ImageFilter.E21());
        } else if (filter.equals("E22")) {
            imageOp.addImageOp(ImageFilter.E22());
        } else if (filter.equals("E23")) {
            imageOp.addImageOp(ImageFilter.E23());
        } else if (filter.equals("E3")) {
            imageOp.addImageOp(ImageFilter.E3());
        } else if (filter.equals("S1")) {
            imageOp.addImageOp(ImageFilter.S1());
        } else if (filter.equals("S11")) {
            imageOp.addImageOp(ImageFilter.S11());
        } else if (filter.equals("S2")) {
            imageOp.addImageOp(ImageFilter.S2());
        } else if (filter.equals("S21")) {
            imageOp.addImageOp(ImageFilter.S21());
        } else if (filter.equals("S3")) {
            imageOp.addImageOp(ImageFilter.S3());
        } else if (filter.equals("Lung")) {
            imageOp.addImageOp(ImageFilter.lung());
        }
        XPutil.getLogger().log(Level.FINEST, "{0} end", tln);
    }

    private void setGSFilter(String selFilter) {
        TransactionLogName tln = new TransactionLogName("TID=SD_gse_" + selFilter);
        XPutil.getLogger().log(Level.FINEST, "{0} begin", tln);
        JComponent selectedPort = this.screen.getSelectedPort();
        if (selectedPort instanceof XpImageRenderAttributesOwner) {
            if ("none".equalsIgnoreCase(selFilter)) {
                if (selectedPort.getClientProperty("colorMap") != null) {
                    String cmap = (String)selectedPort.getClientProperty("colorMap");
                    if ("none".equalsIgnoreCase(cmap)) {
                        DisplayColorModelUtils.unapplyGSE((XpImageRenderAttributesOwner)((Object)selectedPort));
                    } else {
                        DisplayColorModelUtils.applyColorMap((XpImageRenderAttributesOwner)((Object)selectedPort), cmap.toLowerCase());
                    }
                } else {
                    DisplayColorModelUtils.unapplyGSE((XpImageRenderAttributesOwner)((Object)selectedPort));
                }
            } else if ("g1".equalsIgnoreCase(selFilter)) {
                DisplayColorModelUtils.applyGSE_G1((XpImageRenderAttributesOwner)((Object)selectedPort));
            } else if ("g2".equalsIgnoreCase(selFilter)) {
                DisplayColorModelUtils.applyGSE_G2((XpImageRenderAttributesOwner)((Object)selectedPort));
            } else if ("g3".equalsIgnoreCase(selFilter)) {
                DisplayColorModelUtils.applyGSE_G3((XpImageRenderAttributesOwner)((Object)selectedPort));
            }
            selectedPort.repaint();
        }
        if (selectedPort instanceof XPscreen) {
            selectedPort = ((XPscreen)selectedPort).getSelectedPort();
        }
        if (selectedPort != null) {
            selectedPort.putClientProperty("gse", selFilter.toLowerCase());
        }
        XPutil.getLogger().log(Level.FINEST, "{0} end", tln);
    }

    class ComboBoxRenderer
    extends JLabel
    implements ListCellRenderer {
        public ComboBoxRenderer() {
            this.setOpaque(true);
            this.setHorizontalAlignment(2);
        }

        public Component getListCellRendererComponent(JList list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
            String label = (String)value;
            if (isSelected) {
                this.setBackground(UIManager.getColor("P8"));
                this.setForeground(list.getSelectionForeground());
            } else {
                this.setBackground(UIManager.getColor("P7"));
                this.setForeground(list.getForeground());
            }
            this.setText(label);
            return this;
        }
    }
}

