/*
 * Decompiled with CFR 0.152.
 */
package com.ge.med.terra.xpv.autoControls;

import com.ge.med.idc.CineCapable;
import com.ge.med.idc.FramePositioningCapable;
import com.ge.med.terra.tap.util.log.Tid;
import com.ge.med.terra.xpv.autoControls.AutoControlPanelSeek;
import com.ge.med.terra.xpv.base.CapableListener;
import com.ge.med.terra.xpv.base.XPcontrolArea;
import com.ge.med.terra.xpv.base.XPscreen;
import com.ge.med.terra.xpv.util.XPutil;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.Properties;
import java.util.logging.Level;
import javax.swing.JComponent;
import javax.swing.JTextField;

public class XPwSliceTextField2
extends JTextField
implements CapableListener {
    XPscreen screen = null;
    AutoControlPanelSeek panelSeek = null;
    private PropertyChangeListener viewPortListener = new PropertyChangeListener(){

        @Override
        public void propertyChange(PropertyChangeEvent evt) {
            FramePositioningCapable fp;
            if (evt.getPropertyName() == "data_changed") {
                FramePositioningCapable fp2 = (FramePositioningCapable)XPwSliceTextField2.this.panelSeek.getCapable("com.ge.med.idc.FramePositioningCapable");
                if (fp2.getFrameIndex() == XPwSliceTextField2.this.getFrameNumber() - 1) {
                    return;
                }
                XPwSliceTextField2.this.updateThis();
            } else if (evt.getPropertyName() == "RowColumnProperty") {
                XPwSliceTextField2.this.updateThis();
            } else if (evt.getPropertyName() == "FrameIndex" && (fp = (FramePositioningCapable)XPwSliceTextField2.this.panelSeek.getCapable("com.ge.med.idc.FramePositioningCapable")) != null) {
                if (fp.getFrameIndex() == XPwSliceTextField2.this.getFrameNumber() - 1) {
                    return;
                }
                XPwSliceTextField2.this.updateThis();
            }
        }
    };
    boolean notFirstTime;

    public XPwSliceTextField2() {
        this.panelSeek = new AutoControlPanelSeek(this);
        this.addAncestorListener(this.panelSeek);
        try {
            this.jbInit();
        }
        catch (Exception e2) {
            e2.printStackTrace();
        }
    }

    @Override
    public void setProperties(Properties properties) {
    }

    @Override
    public void selectionChanged(JComponent oldPort, JComponent newPort) {
        this.updateThis();
    }

    @Override
    public void setScreen(XPscreen screen) {
        this.screen = screen;
        screen.addPropertyChangeListener(this.viewPortListener);
        this.updateThis();
    }

    private void updateThis() {
        FramePositioningCapable fp = (FramePositioningCapable)this.panelSeek.getCapable("com.ge.med.idc.FramePositioningCapable");
        if (fp == null) {
            return;
        }
        this.setText(Integer.toString(fp.getFrameIndex() + 1) + " of " + fp.getNumFrames());
        this.repaint();
    }

    @Override
    public void setControlArea(XPcontrolArea ca) {
    }

    private void jbInit() throws Exception {
        this.setMinimumSize(new Dimension(75, 21));
        this.setPreferredSize(new Dimension(75, 21));
        this.setHorizontalAlignment(0);
        this.setText("1 of 1");
        this.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e2) {
                XPwSliceTextField2.this.this_actionPerformed(e2);
            }
        });
        this.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e2) {
                if (!XPwSliceTextField2.this.notFirstTime) {
                    XPwSliceTextField2.this.selectAll();
                }
                XPwSliceTextField2.this.notFirstTime = true;
            }
        });
    }

    void this_actionPerformed(ActionEvent e2) {
        this.notFirstTime = false;
        XPutil.getLogger().log(Level.FINEST, "Start <XPwSliceTextField> " + Tid.newTid());
        CineCapable cp = (CineCapable)this.panelSeek.getCapable("com.ge.med.idc.CineCapable");
        if (cp != null && cp.getCine()) {
            XPutil.getLogger().log(Level.FINEST, "End <XPwSliceTextField> ");
            Tid.popTID();
            return;
        }
        FramePositioningCapable dp = (FramePositioningCapable)this.panelSeek.getCapable("com.ge.med.idc.FramePositioningCapable");
        if (dp != null) {
            try {
                dp.setFrameIndex(this.getFrameNumber() - 1);
                this.setText("" + this.getFrameNumber() + " of " + dp.getNumFrames());
            }
            catch (NumberFormatException ex) {
                XPutil.getLogger().log(Level.WARNING, "", ex);
            }
        }
        XPutil.getLogger().log(Level.FINEST, "End <XPwSliceTextField> ");
        Tid.popTID();
    }

    private int getFrameNumber() {
        int idx = this.getText().indexOf("of");
        String numText = idx >= 0 ? this.getText().substring(0, idx).trim() : this.getText().trim();
        int num = 0;
        try {
            num = Integer.parseInt(numText);
            FramePositioningCapable dp = (FramePositioningCapable)this.panelSeek.getCapable("com.ge.med.idc.FramePositioningCapable");
            if (num > 0 || num <= dp.getNumFrames()) {
                return num;
            }
            return dp.getFrameIndex() + 1;
        }
        catch (NumberFormatException e2) {
            FramePositioningCapable dp = (FramePositioningCapable)this.panelSeek.getCapable("com.ge.med.idc.FramePositioningCapable");
            if (dp != null) {
                this.setText("" + (dp.getFrameIndex() + 1) + " of " + dp.getNumFrames());
                return dp.getFrameIndex() + 1;
            }
            this.setText("1 of 1");
            return 1;
        }
    }

    public Integer getCurrentFrameNo() {
        FramePositioningCapable dp = (FramePositioningCapable)this.panelSeek.getCapable("com.ge.med.idc.FramePositioningCapable");
        if (dp == null) {
            return null;
        }
        return new Integer(dp.getFrameIndex());
    }

    public Integer getMaxFrameNum() {
        FramePositioningCapable dp = (FramePositioningCapable)this.panelSeek.getCapable("com.ge.med.idc.FramePositioningCapable");
        if (dp == null) {
            return null;
        }
        return new Integer(dp.getNumFrames());
    }
}

