/*
 * Decompiled with CFR 0.152.
 */
package com.ge.med.terra.xpv.autoControls;

import com.ge.med.idc.CineCapable;
import com.ge.med.idc.ColorMapCapable;
import com.ge.med.idc.WindowLevelCapable;
import com.ge.med.terra.tap.dm.DMObject;
import com.ge.med.terra.tap.util.log.Tid;
import com.ge.med.terra.xpv.autoControls.AutoControlPanelSeek;
import com.ge.med.terra.xpv.autoControls.AutoControlResources;
import com.ge.med.terra.xpv.autoControls.Messages;
import com.ge.med.terra.xpv.base.CapableListener;
import com.ge.med.terra.xpv.base.XPcontrolArea;
import com.ge.med.terra.xpv.base.XPscreen;
import com.ge.med.terra.xpv.ui.DualSlider;
import com.ge.med.terra.xpv.util.XPutil;
import java.awt.Dimension;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.Properties;
import java.util.ResourceBundle;
import java.util.logging.Level;
import javax.swing.JComponent;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;

public class XPwWindowLevelControl
extends DualSlider
implements CapableListener {
    static ResourceBundle res = AutoControlResources.STRING_RESOURCES;
    XPscreen screen = null;
    AutoControlPanelSeek panelSeek = null;
    double currentWinMin = 0.0;
    double currentWinMax = 0.0;
    private PropertyChangeListener viewPortListener = new PropertyChangeListener(){

        @Override
        public void propertyChange(PropertyChangeEvent evt) {
            if (evt.getPropertyName() == "COLOR_MAP") {
                ColorMapCapable cmap = (ColorMapCapable)XPwWindowLevelControl.this.panelSeek.getCapable("com.ge.med.idc.ColorMapCapable");
                int[] map = cmap.getColorMap();
                if (map == null) {
                    XPwWindowLevelControl.this.setColorMap(new int[]{0, 0xFFFFFF});
                } else {
                    XPwWindowLevelControl.this.setColorMap(map);
                }
            }
        }
    };
    private PropertyChangeListener wlListen = new PropertyChangeListener(){

        @Override
        public void propertyChange(PropertyChangeEvent evt) {
            WindowLevelCapable wlc = (WindowLevelCapable)XPwWindowLevelControl.this.panelSeek.getCapable("com.ge.med.idc.WindowLevelCapable");
            if (wlc == null) {
                return;
            }
            double min = wlc.getWinMin();
            double max = wlc.getWinMax();
            if (!XPutil.compareCallBack(XPwWindowLevelControl.this.currentWinMin, min) || !XPutil.compareCallBack(XPwWindowLevelControl.this.currentWinMax, max)) {
                return;
            }
            int cmax = XPwWindowLevelControl.this.getWmax();
            int cmin = XPwWindowLevelControl.this.getWmax();
            int crmax = XPwWindowLevelControl.this.getWmaxRange();
            int crmin = XPwWindowLevelControl.this.getWminRange();
            if (min == (double)cmin && max == (double)cmax) {
                return;
            }
            if ((double)crmin > min) {
                XPwWindowLevelControl.this.setWminRange((int)(min - (max - min) / 10.0));
            }
            if ((double)crmax < max) {
                XPwWindowLevelControl.this.setWmaxRange((int)(max + 1.0 + (max - min) / 10.0));
            }
            XPwWindowLevelControl.this.setWmin((int)min);
            XPwWindowLevelControl.this.setWmax((int)max);
            crmax = XPwWindowLevelControl.this.getWmaxRange();
            crmin = XPwWindowLevelControl.this.getWminRange();
            if ((double)crmax > max + 1.0 + (max - min) / 10.0) {
                XPwWindowLevelControl.this.setWmaxRange((int)(max + 1.0 + (max - min) / 10.0));
            }
            if ((double)crmin < min - (max - min) / 10.0) {
                XPwWindowLevelControl.this.setWminRange((int)(min - (max - min) / 10.0));
            }
        }
    };

    public XPwWindowLevelControl() {
        this.panelSeek = new AutoControlPanelSeek(this);
        this.addAncestorListener(this.panelSeek);
        this.setMinMaxAndRange(0, 1200, 0, 1200);
        this.setOpaque(false);
        this.setPreferredSize(new Dimension(40, 100));
        this.setToolTipText(Messages.getString("XPwWindowLevelControl.contrastBrightnessSlider"));
        this.setWminRange(0);
        this.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent e2) {
                XPwWindowLevelControl.this.windowLevelControl_stateChanged(e2);
            }
        });
        try {
            this.jbInit();
        }
        catch (Exception e2) {
            e2.printStackTrace();
        }
    }

    public void setData(DMObject[] objs) {
    }

    private void windowLevelControl_stateChanged(ChangeEvent e2) {
        XPutil.getLogger().log(Level.FINEST, "Start <XPwWindowLevelControl> " + Tid.newTid());
        CineCapable cine = (CineCapable)this.panelSeek.getCapable("com.ge.med.idc.CineCapable");
        if (cine != null && cine.getCine()) {
            XPutil.getLogger().log(Level.FINEST, "End <XPwWindowLevelControl> ");
            Tid.popTID();
            return;
        }
        WindowLevelCapable wlc = (WindowLevelCapable)this.panelSeek.getCapable("com.ge.med.idc.WindowLevelCapable");
        if (wlc != null) {
            wlc.setWinMinMax(this.getWmin(), this.getWmax());
            this.currentWinMax = wlc.getWinMax();
            this.currentWinMin = wlc.getWinMin();
        }
        XPutil.getLogger().log(Level.FINEST, "End <XPwWindowLevelControl> ");
        Tid.popTID();
    }

    @Override
    public void setProperties(Properties properties) {
        super.setProperties(properties);
    }

    @Override
    public void selectionChanged(JComponent oldPort, JComponent newPort) {
        WindowLevelCapable wlc = (WindowLevelCapable)this.panelSeek.getCapable("com.ge.med.idc.WindowLevelCapable");
        if (wlc == null) {
            return;
        }
        this.setMinMax((int)wlc.getWinMin(), (int)wlc.getWinMax());
        this.currentWinMax = wlc.getWinMax();
        this.currentWinMin = wlc.getWinMin();
        this.resetRange();
        this.repaint();
        ColorMapCapable cmap = (ColorMapCapable)this.panelSeek.getCapable("com.ge.med.idc.ColorMapCapable");
        if (cmap == null) {
            return;
        }
        int[] map = cmap.getColorMap();
        if (map == null) {
            this.setColorMap(new int[]{0, 0xFFFFFF});
        } else {
            this.setColorMap(map);
        }
    }

    @Override
    public void setScreen(XPscreen screen) {
        this.screen = screen;
        screen.addPropertyChangeListener("winMax", this.wlListen);
        screen.addPropertyChangeListener("winMin", this.wlListen);
        screen.addPropertyChangeListener("data_changed", this.wlListen);
        screen.addPropertyChangeListener(this.viewPortListener);
    }

    @Override
    public void setControlArea(XPcontrolArea ca) {
    }

    public Double getPortWinMax() {
        WindowLevelCapable wlc = (WindowLevelCapable)this.panelSeek.getCapable("com.ge.med.idc.WindowLevelCapable");
        if (wlc == null) {
            return null;
        }
        return new Double(wlc.getWinMax());
    }

    public Double getPortWinMin() {
        WindowLevelCapable wlc = (WindowLevelCapable)this.panelSeek.getCapable("com.ge.med.idc.WindowLevelCapable");
        if (wlc == null) {
            return null;
        }
        return new Double(wlc.getWinMin());
    }

    private void jbInit() throws Exception {
        this.setToolTipText(res.getString("Windowing_Control_"));
    }
}

