/*
 * Decompiled with CFR 0.152.
 */
package com.ge.med.terra.xpv.base;

import com.ge.med.ptk.PtkBorderFactory;
import com.ge.med.ptk.laf.Utilities;
import com.ge.med.ptk.utilities.VersionStamp;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.Shape;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.JTabbedPane;
import javax.swing.SwingConstants;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.swing.border.Border;
import javax.swing.border.EmptyBorder;
import javax.swing.plaf.ComponentUI;
import javax.swing.plaf.TabbedPaneUI;

public class CuiStackedTabsUI
extends TabbedPaneUI
implements SwingConstants {
    protected static boolean initialized_ = false;
    protected JTabbedPane tabPane_;
    protected Color dummyColor_;
    protected JComponent dummyComponent_ = new JComponent(){

        @Override
        public boolean isOpaque() {
            return true;
        }

        @Override
        public Color getBackground() {
            return CuiStackedTabsUI.this.dummyColor_;
        }
    };
    protected Dimension tabMinimumSize_;
    protected Color selectedBackground_;
    protected Color unselectedBackground_;
    protected Insets tabInsets_;
    protected Border tabBorder_;
    protected Border contentBorder_;
    protected boolean blendBorders_ = true;
    protected int verticalAlignment_;
    protected int horizontalAlignment_;
    protected int verticalTextPosition_;
    protected int horizontalTextPosition_;
    protected int textIconGap_;
    protected MouseListener mouseListener_ = new MouseAdapter(){

        @Override
        public void mouseClicked(MouseEvent e2) {
            JTabbedPane pane = (JTabbedPane)e2.getSource();
            int index = CuiStackedTabsUI.this.tabForCoordinate(pane, e2.getX(), e2.getY());
            int count = pane.getTabCount();
            int selected = pane.getSelectedIndex();
            if (index < 0 || index >= count || index == selected) {
                return;
            }
            pane.setSelectedIndex(index);
            pane.revalidate();
            pane.repaint();
        }
    };
    protected PropertyChangeListener propertyChangeListener_ = new PropertyChangeListener(){

        @Override
        public void propertyChange(PropertyChangeEvent e2) {
            String name = e2.getPropertyName();
            if (!("StackedTabs.tabMinimumSize".equals(name) || "StackedTabs.tabInsets".equals(name) || "StackedTabs.tabBorder".equals(name) || "StackedTabs.contentBorder".equals(name) || "StackedTabs.blendBorders".equals(name) || "StackedTabs.selected".equals(name) || "StackedTabs.unselected".equals(name) || "StackedTabs.verticalAlignment".equals(name) || "StackedTabs.horizontalAlignment".equals(name) || "StackedTabs.verticalTextPosition".equals(name) || "StackedTabs.horizontalTextPosition".equals(name) || "StackedTabs.textIconGap".equals(name))) {
                return;
            }
            JTabbedPane tabPane = (JTabbedPane)e2.getSource();
            CuiStackedTabsUI.this.uninstallUI(tabPane);
            CuiStackedTabsUI.this.installUI(tabPane);
            tabPane.revalidate();
            tabPane.repaint();
        }
    };

    public static void main(String[] argv) {
        VersionStamp.handleVersionQuery(argv, "@(#)@BUILD_INFO@");
    }

    public static ComponentUI createUI(JComponent c2) {
        if (!initialized_) {
            UIManager.getLookAndFeelDefaults().put("StackedTabs.verticalAlignment", new Integer(0));
            UIManager.getLookAndFeelDefaults().put("StackedTabs.horizontalAlignment", new Integer(10));
            UIManager.getLookAndFeelDefaults().put("StackedTabs.verticalTextPosition", new Integer(0));
            UIManager.getLookAndFeelDefaults().put("StackedTabs.horizontalTextPosition", new Integer(11));
            UIManager.getLookAndFeelDefaults().put("StackedTabs.textIconGap", new Integer(4));
            UIManager.getLookAndFeelDefaults().put("StackedTabs.tabInsets", new Insets(1, 4, 0, 0));
            UIManager.getLookAndFeelDefaults().put("StackedTabs.tabBorder", PtkBorderFactory.createRaisedBorder());
            UIManager.getLookAndFeelDefaults().put("StackedTabs.contentBorder", PtkBorderFactory.createRaisedBorder());
            UIManager.getLookAndFeelDefaults().put("StackedTabs.blendBorders", Boolean.TRUE);
            UIManager.getLookAndFeelDefaults().put("StackedTabs.selected", UIManager.getColor("P8"));
            UIManager.getLookAndFeelDefaults().put("StackedTabs.unselected", UIManager.getColor("P9"));
            initialized_ = true;
        }
        return new CuiStackedTabsUI();
    }

    @Override
    public void installUI(JComponent c2) {
        this.tabPane_ = (JTabbedPane)c2;
        this.tabMinimumSize_ = Utilities.getUIPropertyDimension(c2, "StackedTabs.tabMinimumSize");
        if (this.tabMinimumSize_ == null) {
            this.tabMinimumSize_ = new Dimension(0, 0);
        }
        this.tabInsets_ = Utilities.getUIPropertyInsets(c2, "StackedTabs.tabInsets");
        if (this.tabInsets_ == null) {
            this.tabInsets_ = new Insets(0, 0, 0, 0);
        }
        this.tabBorder_ = Utilities.getUIPropertyBorder(c2, "StackedTabs.tabBorder");
        if (this.tabBorder_ == null) {
            this.tabBorder_ = new EmptyBorder(0, 0, 0, 0);
        }
        this.contentBorder_ = Utilities.getUIPropertyBorder(c2, "StackedTabs.contentBorder");
        if (this.contentBorder_ == null) {
            this.contentBorder_ = new EmptyBorder(0, 0, 0, 0);
        }
        this.blendBorders_ = Utilities.getUIPropertyBoolean(c2, "StackedTabs.blendBorders");
        this.selectedBackground_ = Utilities.getUIPropertyColor(c2, "StackedTabs.selected");
        this.unselectedBackground_ = Utilities.getUIPropertyColor(c2, "StackedTabs.unselected");
        this.verticalAlignment_ = Utilities.getUIPropertyInt(c2, "StackedTabs.verticalAlignment");
        this.horizontalAlignment_ = Utilities.getUIPropertyInt(c2, "StackedTabs.horizontalAlignment");
        this.verticalTextPosition_ = Utilities.getUIPropertyInt(c2, "StackedTabs.verticalTextPosition");
        this.horizontalTextPosition_ = Utilities.getUIPropertyInt(c2, "StackedTabs.horizontalTextPosition");
        this.textIconGap_ = Utilities.getUIPropertyInt(c2, "StackedTabs.textIconGap");
        super.installUI(c2);
        c2.setOpaque(true);
        c2.addPropertyChangeListener(this.propertyChangeListener_);
        c2.addMouseListener(this.mouseListener_);
        c2.setLayout(new StackedTabLayout());
    }

    @Override
    public void uninstallUI(JComponent c2) {
        c2.removeMouseListener(this.mouseListener_);
        c2.removePropertyChangeListener(this.propertyChangeListener_);
        c2.setOpaque(false);
        super.uninstallUI(c2);
    }

    protected Rectangle[] calculateBounds(JTabbedPane pane) {
        Insets insets = pane.getInsets();
        int width = pane.getWidth() - (insets.left + insets.right);
        int height = pane.getHeight() - (insets.top + insets.bottom);
        int count = pane.getTabCount();
        int selected = pane.getSelectedIndex();
        int tabHeight = this.calculateTabMinimum((JTabbedPane)pane).height;
        Rectangle[] bounds = new Rectangle[count];
        int totalHeight = 0;
        int i2 = 0;
        while (i2 < count) {
            bounds[i2] = new Rectangle(insets.left, totalHeight + insets.top, width, tabHeight);
            if (this.blendBorders_ && i2 == selected) {
                bounds[i2].height -= this.tabBorder_.getBorderInsets((Component)this.dummyComponent_).bottom;
            }
            totalHeight += bounds[++i2 - 1].height;
        }
        int selectedHeight = height - totalHeight;
        for (int i3 = selected + 1; i3 < count; ++i3) {
            bounds[i3].y += selectedHeight;
        }
        return bounds;
    }

    protected Rectangle calculateContentBounds(JTabbedPane pane) {
        Insets insets = pane.getInsets();
        int width = pane.getWidth() - (insets.left + insets.right);
        int height = pane.getHeight() - (insets.top + insets.bottom);
        int count = pane.getTabCount();
        int selected = pane.getSelectedIndex();
        int tabHeight = this.calculateTabMinimum((JTabbedPane)pane).height;
        int overlap = this.blendBorders_ ? this.tabBorder_.getBorderInsets((Component)this.dummyComponent_).bottom : 0;
        Rectangle bounds = new Rectangle(insets.left, (selected + 1) * tabHeight + insets.top - overlap, width, height - (count * tabHeight - overlap));
        return bounds;
    }

    @Override
    public int tabForCoordinate(JTabbedPane pane, int x2, int y2) {
        Rectangle[] bounds = this.calculateBounds(pane);
        for (int i2 = 0; i2 < bounds.length; ++i2) {
            if (!bounds[i2].contains(x2, y2)) continue;
            return i2;
        }
        return -1;
    }

    @Override
    public Rectangle getTabBounds(JTabbedPane pane, int index) {
        Rectangle[] bounds = this.calculateBounds(pane);
        return bounds[index];
    }

    @Override
    public int getTabRunCount(JTabbedPane pane) {
        return 1;
    }

    protected void paintContentBorder(Graphics g2, int x2, int y2, int w2, int h2) {
        this.contentBorder_.paintBorder(this.tabPane_.getSelectedComponent(), g2, x2, y2, w2, h2);
    }

    protected Color getTabColor(int index, boolean selected) {
        if (selected) {
            Color color;
            Component component = this.tabPane_.getSelectedComponent();
            if (component != null && component.isOpaque() && (color = component.getBackground()) != null) {
                return color;
            }
            color = this.selectedBackground_;
            if (color != null) {
                return color;
            }
            return this.tabPane_.getBackground();
        }
        return this.unselectedBackground_ != null ? this.unselectedBackground_ : this.tabPane_.getBackgroundAt(index);
    }

    @Override
    public void paint(Graphics g2, JComponent c2) {
        int overlap;
        Graphics2D g2d = (Graphics2D)g2;
        JTabbedPane pane = (JTabbedPane)c2;
        Rectangle[] bounds = this.calculateBounds(pane);
        Rectangle content = this.calculateContentBounds(pane);
        int selected = pane.getSelectedIndex();
        Insets tbi = this.tabBorder_.getBorderInsets(this.dummyComponent_);
        Insets ti = new Insets(tbi.top + this.tabInsets_.top, tbi.left + this.tabInsets_.left, tbi.bottom + this.tabInsets_.bottom, tbi.right + this.tabInsets_.right);
        for (int i2 = 0; i2 < bounds.length; ++i2) {
            this.dummyColor_ = this.getTabColor(i2, i2 == selected);
            g2.setColor(this.dummyColor_);
            overlap = i2 == selected && this.blendBorders_ ? tbi.bottom : 0;
            Shape clip = g2.getClip();
            g2.fillRect(bounds[i2].x + tbi.left, bounds[i2].y + tbi.top, bounds[i2].width - (tbi.left + tbi.right), bounds[i2].height - (tbi.top + tbi.bottom) + overlap);
            g2.clipRect(bounds[i2].x, bounds[i2].y, bounds[i2].width, bounds[i2].height);
            this.tabBorder_.paintBorder(this.dummyComponent_, g2, bounds[i2].x, bounds[i2].y, bounds[i2].width, bounds[i2].height + overlap);
            g2.setClip(clip);
            Rectangle viewR = new Rectangle(bounds[i2].x + ti.left, bounds[i2].y + ti.top, bounds[i2].width - (ti.left + ti.right), bounds[i2].height - (ti.top + ti.bottom));
            Rectangle iconR = new Rectangle();
            Rectangle textR = new Rectangle();
            g2.setFont(pane.getFont());
            String title = pane.getTitleAt(i2);
            Icon icon = pane.getIconAt(i2);
            g2d.setRenderingHint(RenderingHints.KEY_TEXT_ANTIALIASING, RenderingHints.VALUE_TEXT_ANTIALIAS_ON);
            g2d.setRenderingHint(RenderingHints.KEY_FRACTIONALMETRICS, RenderingHints.VALUE_FRACTIONALMETRICS_OFF);
            String text = SwingUtilities.layoutCompoundLabel(pane, g2.getFontMetrics(), pane.getTitleAt(i2), pane.getIconAt(i2), this.verticalAlignment_, this.horizontalAlignment_, this.verticalTextPosition_, this.horizontalTextPosition_, viewR, iconR, textR, icon != null && title != null && title.length() > 0 ? this.textIconGap_ : 0);
            this.dummyColor_ = this.getTabColor(i2, i2 == selected);
            g2.setColor(this.dummyColor_);
            if (icon != null) {
                icon.paintIcon(this.dummyComponent_, g2, iconR.x, iconR.y);
            }
            if (i2 == selected) {
                g2.setColor(Color.white);
            } else {
                g2.setColor(pane.getForeground());
            }
            if (title == null || title.length() <= 0) continue;
            g2.drawString(title, textR.x, textR.y + g2.getFontMetrics().getAscent());
        }
        Shape clip = g2.getClip();
        overlap = this.blendBorders_ ? this.contentBorder_.getBorderInsets((Component)this.dummyComponent_).top : 0;
        g2.clipRect(content.x, content.y, content.width, content.height);
        this.paintContentBorder(g2, content.x, content.y - overlap, content.width, content.height + overlap);
        g2.setClip(clip);
    }

    protected Dimension calculateTabMinimum(JTabbedPane pane) {
        FontMetrics metrics = pane.getFontMetrics(pane.getFont());
        Rectangle big = new Rectangle(Short.MAX_VALUE, Short.MAX_VALUE);
        int count = pane.getTabCount();
        int width = 0;
        int height = 0;
        for (int i2 = 0; i2 < count; ++i2) {
            Icon icon;
            Rectangle iconR = new Rectangle();
            Rectangle textR = new Rectangle();
            String title = pane.getTitleAt(i2);
            SwingUtilities.layoutCompoundLabel(pane, metrics, title, icon, this.verticalAlignment_, this.horizontalAlignment_, this.verticalTextPosition_, this.horizontalTextPosition_, big, iconR, textR, (icon = pane.getIconAt(i2)) != null && title != null && title.length() > 0 ? this.textIconGap_ : 0);
            Rectangle bounds = iconR.union(textR);
            width = Math.max(width, bounds.width);
            height = Math.max(height, bounds.height);
        }
        Insets bi = this.tabBorder_.getBorderInsets(this.dummyComponent_);
        height += bi.top + bi.bottom;
        width += bi.left + bi.right;
        return new Dimension(Math.max(width += this.tabInsets_.left + this.tabInsets_.right, this.tabMinimumSize_.width), Math.max(height += this.tabInsets_.top + this.tabInsets_.bottom, this.tabMinimumSize_.height));
    }

    protected class StackedTabLayout
    implements LayoutManager {
        protected StackedTabLayout() {
        }

        @Override
        public Dimension preferredLayoutSize(Container parent) {
            JTabbedPane pane = (JTabbedPane)parent;
            Insets insets = pane.getInsets();
            Insets cbi = CuiStackedTabsUI.this.contentBorder_.getBorderInsets(CuiStackedTabsUI.this.dummyComponent_);
            Component[] children = parent.getComponents();
            int width = 0;
            int height = 0;
            for (int i2 = 0; i2 < children.length; ++i2) {
                Dimension d2 = children[i2].getPreferredSize();
                width = Math.max(width, d2.width + cbi.left + cbi.right);
                height = Math.max(height, d2.height + cbi.top + cbi.bottom);
            }
            Dimension tabMinimum = CuiStackedTabsUI.this.calculateTabMinimum(pane);
            width = Math.max(width, tabMinimum.width);
            height += children.length * tabMinimum.height;
            if (CuiStackedTabsUI.this.blendBorders_) {
                height -= CuiStackedTabsUI.this.tabBorder_.getBorderInsets((Component)CuiStackedTabsUI.this.dummyComponent_).bottom + CuiStackedTabsUI.this.contentBorder_.getBorderInsets((Component)CuiStackedTabsUI.this.dummyComponent_).top;
            }
            return new Dimension(width + (insets.left + insets.right), height + (insets.top + insets.bottom));
        }

        @Override
        public Dimension minimumLayoutSize(Container parent) {
            JTabbedPane pane = (JTabbedPane)parent;
            Insets insets = pane.getInsets();
            Insets cbi = CuiStackedTabsUI.this.contentBorder_.getBorderInsets(CuiStackedTabsUI.this.dummyComponent_);
            Component[] children = parent.getComponents();
            int width = 0;
            int height = 0;
            for (int i2 = 0; i2 < children.length; ++i2) {
                Dimension d2 = children[i2].getMinimumSize();
                width = Math.max(width, d2.width + cbi.left + cbi.right);
                height = Math.max(height, d2.height + cbi.top + cbi.bottom);
            }
            Dimension tabMinimum = CuiStackedTabsUI.this.calculateTabMinimum(pane);
            width = Math.max(width, tabMinimum.width);
            height += children.length * tabMinimum.height;
            if (CuiStackedTabsUI.this.blendBorders_) {
                height -= CuiStackedTabsUI.this.tabBorder_.getBorderInsets((Component)CuiStackedTabsUI.this.dummyComponent_).bottom + CuiStackedTabsUI.this.contentBorder_.getBorderInsets((Component)CuiStackedTabsUI.this.dummyComponent_).top;
            }
            return new Dimension(width + (insets.left + insets.right), height + (insets.top + insets.bottom));
        }

        @Override
        public void addLayoutComponent(String name, Component comp) {
        }

        @Override
        public void removeLayoutComponent(Component comp) {
        }

        @Override
        public void layoutContainer(Container parent) {
            JTabbedPane pane = (JTabbedPane)parent;
            int selected = pane.getSelectedIndex();
            Insets cbi = CuiStackedTabsUI.this.contentBorder_.getBorderInsets(CuiStackedTabsUI.this.dummyComponent_);
            Rectangle contentBounds = CuiStackedTabsUI.this.calculateContentBounds(pane);
            Component[] children = parent.getComponents();
            int overlap = CuiStackedTabsUI.this.blendBorders_ ? cbi.top : 0;
            children[selected].setBounds(contentBounds.x + cbi.left, contentBounds.y + cbi.top - overlap, contentBounds.width - (cbi.left + cbi.right), contentBounds.height - (cbi.top + cbi.bottom) + overlap);
            for (int i2 = 0; i2 < children.length; ++i2) {
                children[i2].setVisible(i2 == selected);
            }
        }
    }
}

