/*
 * Decompiled with CFR 0.152.
 */
package com.ge.med.terra.xpv.base;

import com.ge.med.terra.tap.dm.DMObject;
import com.ge.med.terra.xpv.base.CuiStackedTabsUI;
import com.ge.med.terra.xpv.base.ScreenHeader;
import com.ge.med.terra.xpv.base.ViewportContext;
import com.ge.med.terra.xpv.base.XPcaPanel;
import com.ge.med.terra.xpv.base.XPcomboPanel;
import com.ge.med.terra.xpv.base.XPscreen;
import com.ge.med.terra.xpv.base.XpSelector;
import com.ge.med.terra.xpv.onport.XPopControlFactory;
import com.ge.med.terra.xpv.ui.TitlePanel;
import com.ge.med.terra.xpv.util.XPutil;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Graphics;
import java.awt.event.ContainerEvent;
import java.awt.event.ContainerListener;
import java.beans.Beans;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.Properties;
import java.util.logging.Level;
import javax.swing.Action;
import javax.swing.BorderFactory;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTabbedPane;
import javax.swing.JWindow;
import javax.swing.KeyStroke;
import javax.swing.UIManager;
import javax.swing.border.Border;
import javax.swing.border.SoftBevelBorder;

public class XPcontrolArea
extends JPanel {
    JPanel panelXYZ = new JPanel();
    protected TitlePanel tPanel = new TitlePanel(0);
    JPanel innerPanel = new JPanel();
    JTabbedPane panelSet = null;
    protected XPcaPanel[] ctlPanels = new XPcaPanel[0];
    JPanel tpanelPad = new JPanel();
    protected XPcomboPanel comboPanel = null;
    XPscreen screen_ = null;
    public Color baseColor = null;
    Border softBev = new SoftBevelBorder(0);
    private int tabLimit = 3;
    private int stackLimit = 5;

    public XpSelector getSelector() {
        return this.comboPanel.selector;
    }

    public XPcontrolArea() {
        if (!Beans.isDesignTime()) {
            UIManager.getLookAndFeelDefaults().put("StackedTabsUI", CuiStackedTabsUI.class.getName());
            UIManager.getLookAndFeelDefaults().put("PaletteComboBoxUI", "com.ge.med.terra.xpv.ui.CuiPaletteComboBoxUI");
        }
        try {
            this.jbInit();
        }
        catch (Exception ex) {
            ex.printStackTrace();
            XPutil.getLogger().log(Level.SEVERE, "XPcontrolArea creation failed", ex);
        }
        XPutil.getLogger().log(Level.FINEST, "XPcontrolArea is created", new Exception());
    }

    void jbInit() throws Exception {
        this.panelXYZ.setBorder(BorderFactory.createEmptyBorder(0, 3, 0, 3));
        this.panelXYZ.setOpaque(false);
        this.setLayout(new BorderLayout());
        this.panelXYZ.setLayout(new BorderLayout());
        this.innerPanel.setLayout(new BorderLayout());
        this.tPanel.setTitle("Tools");
        this.tpanelPad.setBorder(BorderFactory.createEmptyBorder(0, 5, 0, 5));
        this.tpanelPad.setLayout(new BorderLayout());
        this.tpanelPad.add((Component)this.tPanel, "Center");
        this.panelXYZ.add((Component)this.tpanelPad, "Center");
        this.tPanel.add((Component)this.innerPanel, "Center");
        this.add((Component)this.panelXYZ, null == System.getProperty("CenterTopPanel") ? "North" : "Center");
        this.setBackground(null);
        this.innerPanel.setBackground(UIManager.getColor("P10"));
        this.panelXYZ.setBackground(null);
        this.tpanelPad.setBackground(null);
    }

    public static void main(String[] args) {
        JWindow w2 = new JWindow();
        XPcontrolArea jw = new XPcontrolArea();
        w2.getContentPane().add(jw);
        w2.setBounds(64, 200, 200, 824);
        w2.setVisible(true);
    }

    public XPscreen getScreen() {
        return this.screen_;
    }

    public void addKeyEventInputActionMap(KeyStroke stroke, Action action) {
        String actionName = (String)action.getValue("Name");
        if (actionName == null) {
            actionName = action.toString();
        }
        this.getInputMap(2).put(stroke, actionName);
        this.getActionMap().put(actionName, action);
    }

    public void setProperties(Properties prop) {
        int i2;
        String stackLimitStr;
        String tabLimitStr = prop.getProperty("ControlArea.TabStyleLimit");
        if (tabLimitStr != null) {
            this.tabLimit = Integer.parseInt(tabLimitStr);
        }
        if ((stackLimitStr = prop.getProperty("ControlArea.StackStyleLimit")) != null) {
            this.stackLimit = Integer.parseInt(stackLimitStr);
        }
        this.stackLimit = Math.max(this.tabLimit, this.stackLimit);
        this.tPanel.setNoTitleBorder(!Boolean.getBoolean(prop.getProperty("ctl.showDecoration", "false")));
        String annotName = prop.getProperty("ControlAreas");
        String[] ca = annotName == null ? new String[]{} : annotName.split("\\s*,\\s*");
        String topCtlAreaName = prop.getProperty("TopControlArea");
        int start = 1;
        if (topCtlAreaName == null) {
            start = 0;
        }
        this.ctlPanels = new XPcaPanel[start + ca.length];
        for (i2 = start; i2 < this.ctlPanels.length; ++i2) {
            String cName = ca[i2 - start];
            try {
                Class<?> c2 = Class.forName(cName);
                Object o2 = c2.newInstance();
                if (!XPcaPanel.class.isInstance(o2)) {
                    XPcaPanel ctrlPanel = new XPcaPanel();
                    ctrlPanel.setLayout(new BorderLayout());
                    String name = c2.getName();
                    if (o2 instanceof Component) {
                        ctrlPanel.add((Component)o2);
                        name = ((Component)o2).getName();
                    }
                    ctrlPanel.setTitle(name);
                    o2 = ctrlPanel;
                }
                this.ctlPanels[i2] = (XPcaPanel)o2;
                this.ctlPanels[i2].setBackground(null);
                this.ctlPanels[i2].setProperties(prop);
                this.ctlPanels[i2].setControlArea(this);
                continue;
            }
            catch (Exception ex) {
                XPutil.getLogger().log(Level.INFO, "XPcontrolArea.setProperties()...class not found " + cName, ex);
                ex.printStackTrace();
            }
        }
        if (ca.length == 1) {
            this.tpanelPad.removeAll();
            this.tpanelPad.add((Component)this.ctlPanels[start], "Center");
            this.tpanelPad.setBackground(null);
        } else if (ca.length <= this.stackLimit) {
            this.panelSet = ca.length > this.tabLimit ? new JTabbedPane(){

                @Override
                public String getUIClassID() {
                    return "StackedTabsUI";
                }
            } : new JTabbedPane();
            int tabPanelCounter = 0;
            for (int i3 = start; i3 < this.ctlPanels.length; ++i3) {
                try {
                    this.addToTab(this.ctlPanels[i3]);
                    this.panelSet.setToolTipTextAt(tabPanelCounter, this.ctlPanels[i3].getPanelDescription());
                }
                catch (Exception ex) {
                    XPutil.getLogger().log(Level.INFO, "fail to load " + ca[i3 - start] + " class", ex);
                }
                ++tabPanelCounter;
            }
            this.panelSet.setTabPlacement(1);
        } else {
            this.comboPanel = new XPcomboPanel(prop, this.ctlPanels);
            this.tPanel.setTitle("");
            for (i2 = start; i2 < this.ctlPanels.length; ++i2) {
                try {
                    Class<?> c3 = Class.forName(ca[i2 - start]);
                    XPcaPanel cp = this.ctlPanels[i2];
                    cp.setProperties(prop);
                    cp.setControlArea(this);
                    this.comboPanel.addPanel(cp.getTitle(), cp, cp.getIcon(), cp.getPanelDescription());
                    continue;
                }
                catch (Exception ex) {
                    System.err.println(ca[i2 - start]);
                    System.err.println(ex);
                    ex.printStackTrace();
                }
            }
        }
        if (this.panelSet != null) {
            this.panelSet.setOpaque(false);
            this.innerPanel.add((Component)this.panelSet, "Center");
            if (this.panelSet.getFont() == null) {
                System.out.println("null");
            }
        }
        if (this.comboPanel != null) {
            this.innerPanel.add((Component)this.comboPanel, "Center");
        }
        this.addTopCtlArea(prop);
    }

    public void addToTab(XPcaPanel p2) {
        Icon icon = p2.getIcon();
        String title = p2.getTitle();
        if (this.panelSet == null) {
            System.out.println("need to create panel");
            this.panelSet = new JTabbedPane();
            this.innerPanel.add((Component)this.panelSet, "Center");
        }
        if (icon == null && title == null) {
            this.panelSet.add(p2);
        } else if (icon == null && title != null) {
            this.panelSet.add((Component)p2, title);
        } else if (icon != null && title == null) {
            this.panelSet.add((Component)p2, icon);
        } else if (icon != null && title != null) {
            this.panelSet.add((Component)p2, new LabelIcon(title, icon));
        }
    }

    public void addTopCtlArea(Properties prop) {
        String topCtlAreaName = prop.getProperty("TopControlArea");
        if (topCtlAreaName != null) {
            try {
                Class<?> c2 = Class.forName(topCtlAreaName);
                this.ctlPanels[0] = (XPcaPanel)c2.newInstance();
                this.panelXYZ.add((Component)this.ctlPanels[0], this.ctlPanels.length > 1 ? "North" : "Center");
                this.ctlPanels[0].setProperties(prop);
                this.ctlPanels[0].setControlArea(this);
            }
            catch (Exception ex) {
                XPutil.getLogger().log(Level.INFO, "fail to load " + topCtlAreaName + " class", ex);
            }
            XPopControlFactory.getFactory().setProperties(prop);
        }
    }

    public void addTopCtlArea(XPcaPanel topPanel) {
        if (this.ctlPanels == null || this.ctlPanels.length == 0) {
            this.ctlPanels = new XPcaPanel[1];
        }
        this.ctlPanels[0] = topPanel;
        this.panelXYZ.add((Component)this.ctlPanels[0], "North");
        this.ctlPanels[0].setProperties(null);
        this.ctlPanels[0].setControlArea(this);
    }

    public void setHeader(ScreenHeader hdr) {
        for (int i2 = 0; i2 < this.ctlPanels.length; ++i2) {
            this.ctlPanels[i2].setHeader(hdr);
        }
    }

    public void setScreen(XPscreen screen) {
        this.screen_ = screen;
        for (int i2 = 0; i2 < this.ctlPanels.length; ++i2) {
            this.ctlPanels[i2].setScreen(screen);
        }
        screen.addPropertyChangeListener(new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent e2) {
                if (e2.getPropertyName().equals("parent_port_changed")) {
                    XPcontrolArea.this.selectionChanged((Integer)e2.getOldValue(), (Integer)e2.getNewValue());
                }
            }
        });
        screen.addPropertyChangeListener("ViewportContext", new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent evt) {
                XPcontrolArea.this.viewportContextChanged((ViewportContext)evt.getNewValue());
            }
        });
        screen.addContainerListener(new ContainerListener(){

            @Override
            public void componentAdded(ContainerEvent e2) {
                for (int i2 = 0; i2 < XPcontrolArea.this.ctlPanels.length; ++i2) {
                    XPcontrolArea.this.ctlPanels[i2].screenComponentAdded((JComponent)e2.getChild());
                }
            }

            @Override
            public void componentRemoved(ContainerEvent e2) {
            }
        });
        if (this.comboPanel != null) {
            this.comboPanel.setScreen(screen);
        }
    }

    public void setToolsPanelTitle(String title) {
        this.tPanel.setTitle(title);
    }

    public String getToolsPanelTitle() {
        return this.tPanel.getTitle();
    }

    public void showPanel(String panelName) {
        if (this.panelSet != null) {
            for (int i2 = 1; i2 < this.ctlPanels.length; ++i2) {
                if (!this.ctlPanels[i2].getTitle().equalsIgnoreCase(panelName)) continue;
                this.panelSet.setSelectedComponent(this.ctlPanels[i2]);
                this.panelSet.repaint();
                break;
            }
        } else {
            this.comboPanel.showPanel(panelName);
        }
    }

    public void selectionChanged(int oldPort, int newPort) {
        for (int i2 = 0; i2 < this.ctlPanels.length; ++i2) {
            this.ctlPanels[i2].selectionChanged(oldPort, newPort);
        }
    }

    public void viewportContextChanged(ViewportContext context) {
        for (int i2 = 0; i2 < this.ctlPanels.length; ++i2) {
            this.ctlPanels[i2].ViewportContextChanged(context);
        }
    }

    public void setData(DMObject[] data) {
        for (int i2 = 0; i2 < this.ctlPanels.length; ++i2) {
            this.ctlPanels[i2].setData(data);
        }
    }

    public XPcaPanel[] getControlPanels() {
        return this.ctlPanels;
    }

    class LabelIcon
    implements Icon {
        JLabel l;
        Icon icon;
        String str;

        public LabelIcon(String text, Icon ico) {
            this.icon = ico;
            this.str = text;
            this.l = new JLabel(text, this.icon, 10);
        }

        @Override
        public void paintIcon(Component c2, Graphics g2, int x2, int y2) {
            this.icon.paintIcon(c2, g2, x2, y2);
            g2.drawString(this.str, x2 + this.icon.getIconWidth() + 4, y2 + this.icon.getIconHeight() - 10);
        }

        @Override
        public int getIconWidth() {
            return this.l.getPreferredSize().width;
        }

        @Override
        public int getIconHeight() {
            return this.l.getPreferredSize().height;
        }
    }
}

