/*
 * Decompiled with CFR 0.152.
 */
package com.ge.med.terra.xpv.base;

import com.ge.med.ptk.PtkBorderFactory;
import com.ge.med.ptk.laf.CuiLookAndFeel;
import com.ge.med.terra.xpv.base.XPcaPanel;
import com.ge.med.terra.xpv.base.XpSelector;
import com.ge.med.terra.xpv.ui.XPui;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.net.URL;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Properties;
import java.util.Vector;
import javax.swing.AbstractButton;
import javax.swing.ButtonGroup;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTabbedPane;
import javax.swing.JToggleButton;
import javax.swing.UIManager;
import javax.swing.UnsupportedLookAndFeelException;
import javax.swing.border.Border;

public class XpPlasmaSelector
extends XpSelector {
    String[] tabNames = null;
    HashMap tabsLookup = null;
    Properties prop;
    Border rect = PtkBorderFactory.createButtonBorder(false, false, false, false);
    JTabbedPane tabs = new JTabbedPane();
    JPanel[] bPanel;
    int count = 0;
    JToggleButton selected;
    ButtonGroup bg = new ButtonGroup();
    ActionListener al = new ActionListener(){

        @Override
        public void actionPerformed(ActionEvent e2) {
            XpPlasmaSelector.this.selected = (JToggleButton)e2.getSource();
            System.out.println(">" + XpPlasmaSelector.this.selected.getName());
            XpPlasmaSelector.this.fireActionListener(e2);
        }
    };
    Vector listeners = new Vector();

    @Override
    public void setProperties(Properties prop) {
        this.prop = prop;
        String s2 = prop.getProperty("plasmaTabs");
        this.tabNames = s2.split("\\,");
        this.tabsLookup = new HashMap();
        for (int i2 = 0; i2 < this.tabNames.length; ++i2) {
            String propname = "tab" + (i2 + 1);
            String tablist = prop.getProperty(propname);
            if (tablist == null) continue;
            String[] tlist = tablist.split("\\,");
            Integer pos = new Integer(i2);
            for (int j2 = 0; j2 < tlist.length; ++j2) {
                String tab = prop.getProperty(tlist[j2]);
                this.tabsLookup.put(tab, pos);
            }
        }
        this.setTabNames(this.tabNames);
    }

    public XpPlasmaSelector() {
        this.tabs.setBackground(XPui.p6());
        this.setLayout(new BorderLayout());
        this.add(this.tabs);
    }

    public void select(String name) {
        name = this.prop.getProperty(name, name);
        int index = (Integer)this.tabsLookup.get(name);
        this.tabs.setSelectedIndex(index);
        Enumeration<AbstractButton> e2 = this.bg.getElements();
        while (e2.hasMoreElements()) {
            JToggleButton b2 = (JToggleButton)e2.nextElement();
            XPcaPanel pan = (XPcaPanel)b2.getClientProperty("panel");
            if (pan == null || !pan.getClass().getName().equals(name)) continue;
            b2.doClick();
        }
    }

    public static void main(String[] args) {
        try {
            UIManager.setLookAndFeel(new CuiLookAndFeel());
        }
        catch (UnsupportedLookAndFeelException e2) {
            e2.printStackTrace();
        }
        JFrame f2 = new JFrame("XpSelector");
        XpPlasmaSelector p2 = new XpPlasmaSelector();
        f2.setContentPane(p2);
        f2.setBounds(100, 100, 255, 200);
        f2.setDefaultCloseOperation(3);
        f2.setVisible(true);
        p2.addFakeIcons(new String[]{"bright.png", "cine.gif", "close.png", "contrast.png", "down.PNG", "expand.gif", "first.png", "flip-rot.gif", "flip-rot.png", "horz-flip.gif", "icoangle_24_1.png", "icoannotation_22_1.png", "icobrightcontrastb1.gif", "icocolorinvert1.gif", "icoGRID_24_1.png", "icoMATellipse_24_1.png", "icoMATrectangle_24_1.png", "icomeasurement_24_1.png", "icomodecursorarrow_24_3.png", "icomodecursorhand_24_1.png", "icomodecursorpaging_24_1.png", "icomodecursorwindowlevels_24_1.png", "icomodecursorzoom_24_1.png", "icopause1.gif", "icoplay1.gificopreferences1_28_1.png", "icoreportcursor_24_1.png", "icoreset1.gif", "icoROIellipse_24_1.png", "icoROIrectangle_24_1.png", "icorooming1.gif", "icorotateleft_24_1.png", "icorotateright_24_1.png", "icoscreencapture_22_1.png", "icoTICK_24_1.png", "icotrace1_31_1.png", "icovecteurs_bgtransp_28_1.png", "icoviewcolor1_26_1.png", "icoviewcolor2_21_1.png", "last.png", "left.png", "link.gif", "loop.png", "maximize.png", "maximize1.PNG", "next.png", "pandown16.png", "pingpong.png", "previous.png", "right.png", "up.png", "vert-flip.gif", "zoompan.png"});
    }

    public void addFakeIcons(String[] ficon) {
        for (int i2 = 0; i2 < this.bPanel.length; ++i2) {
            this.bPanel[i2].setLayout(new GridLayout(2, 5));
        }
        boolean pos = false;
        int max = ficon.length / this.bPanel.length;
        for (int k2 = 0; k2 < this.bPanel.length; ++k2) {
            for (int i3 = 0; i3 < 10; ++i3) {
                this.bPanel[k2].add(new JLabel());
            }
        }
        for (int i4 = 0; i4 < ficon.length; ++i4) {
            URL u2 = this.getClass().getResource("/com/ge/med/terra/xpv/icons/plasma/" + ficon[i4]);
            if (u2 == null) continue;
            ImageIcon ico = new ImageIcon(u2);
            this.addItem(i4 % this.bPanel.length, ficon[i4], ico, u2.toString(), null);
            this.repaint();
        }
    }

    @Override
    public String getSelectedItem() {
        if (this.selected == null) {
            return null;
        }
        return this.selected.getName();
    }

    public void addItem(XPcaPanel pan, String name, Icon icon, String description) {
        if (this.tabsLookup == null) {
            this.addItem(this.count, name, icon, description, pan);
            this.count = (this.count + 1) % this.bPanel.length;
        } else {
            Integer portNo = (Integer)this.tabsLookup.get(pan.getClass().getName());
            if (portNo != null) {
                this.addItem(portNo, name, icon, description, pan);
            } else {
                this.addItem(0, name, icon, description, pan);
            }
        }
    }

    public void addItem(int k2, String name, Icon icon, String description, XPcaPanel pan) {
        JToggleButton jb = new JToggleButton(icon);
        this.bg.add(jb);
        jb.putClientProperty("panel", pan);
        jb.setName(pan.getClass().getName());
        jb.setBorder(this.rect);
        jb.addActionListener(this.al);
        jb.setToolTipText(description);
        Component[] c2 = this.bPanel[k2].getComponents();
        for (int i2 = 0; i2 < c2.length; ++i2) {
            if (!(c2[i2] instanceof JLabel)) continue;
            this.bPanel[k2].remove(c2[i2]);
            break;
        }
        this.bPanel[k2].add(jb);
    }

    public String[] getTabNames() {
        return this.tabNames;
    }

    public void setTabNames(String[] tabNames) {
        this.tabNames = tabNames;
        this.setupTabs();
    }

    protected void setupTabs() {
        this.tabs.removeAll();
        this.bPanel = new JPanel[this.tabNames.length];
        for (int i2 = 0; i2 < this.bPanel.length; ++i2) {
            JPanel p2 = this.bPanel[i2] = new JPanel();
            this.tabs.add((Component)this.bPanel[i2], this.tabNames[i2]);
            p2.setLayout(new GridLayout());
        }
    }

    @Override
    public void addActionListener(ActionListener l2) {
        this.listeners.add(l2);
    }

    public void removeActionListener(ActionListener l2) {
        this.listeners.add(l2);
    }

    protected void fireActionListener(ActionEvent ev) {
        for (ActionListener l2 : this.listeners) {
            l2.actionPerformed(ev);
        }
    }

    @Override
    public void setSelectedItem(String name) {
        this.select(name);
    }

    @Override
    public void addElement(XPcaPanel pan, String name, Icon icon, String desc) {
        this.addItem(pan, name, icon, desc);
    }

    @Override
    public void setSelectedApplication(String appName) {
    }
}

