/*
 * Decompiled with CFR 0.152.
 */
package com.ge.med.terra.xpv.beanbox;

import com.ge.med.terra.xpv.beanbox.BeanWrapper;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Rectangle;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.Transferable;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.beans.Beans;
import java.beans.beancontext.BeanContextChild;
import java.beans.beancontext.BeanContextProxy;
import java.beans.beancontext.BeanContextServicesSupport;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.Iterator;
import java.util.Properties;
import java.util.Vector;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.TransferHandler;
import javax.swing.UIManager;

public class XPBeanBox
extends JPanel
implements BeanContextProxy,
MouseListener,
MouseMotionListener {
    transient BeanContextServicesSupport bcss = new BeanContextServicesSupport();
    public String saveFileName;
    transient Component connectionSource;
    transient int oldX1 = -1;
    transient int oldX2;
    transient int oldY1;
    transient int oldY2;
    public Properties prop;
    public static Cursor nwResizeCursor = Cursor.getPredefinedCursor(6);
    public static Cursor neResizeCursor = Cursor.getPredefinedCursor(7);
    public static Cursor swResizeCursor = Cursor.getPredefinedCursor(4);
    public static Cursor seResizeCursor = Cursor.getPredefinedCursor(5);
    public static Cursor crosshairCursor = Cursor.getPredefinedCursor(1);
    public static Cursor defaultCursor = Cursor.getPredefinedCursor(0);
    public static Cursor moveCursor = Cursor.getPredefinedCursor(13);
    Vector widVector = new Vector();
    public Vector selectedBeans = new Vector();
    int posX = 0;
    int posY = 0;
    transient BeanWrapper moveChild;
    transient int moveStartX;
    transient int moveStartY;
    transient Rectangle oldRubberBox;
    transient BeanWrapper resizeChild;
    transient Cursor resizeCursor;
    transient int resizeStartX;
    transient int resizeStartY;

    public void setDesignTime(boolean status) {
        Beans.setDesignTime(status);
        this.bcss.setDesignTime(status);
        for (BeanWrapper bw : this.widVector) {
            bw.listenForMice(status);
        }
        if (status) {
            this.addMouseListener(this);
            this.addMouseMotionListener(this);
        } else {
            this.removeMouseListener(this);
            this.removeMouseMotionListener(this);
        }
        for (BeanWrapper bw : this.selectedBeans) {
            bw.setBackground(null);
        }
        this.selectedBeans.clear();
    }

    public void removeBeans() {
        for (BeanWrapper bw : this.selectedBeans) {
            this.remove(bw);
            this.bcss.remove(bw);
            this.widVector.remove(bw);
        }
        this.repaint();
    }

    public boolean getDesignTime() {
        return this.bcss.isDesignTime();
    }

    public void saveToFile() {
        if (this.saveFileName == null) {
            return;
        }
        File saveFile = new File(this.saveFileName, "savedBeans");
        if (saveFile.exists()) {
            saveFile.delete();
        }
        Properties prop = new Properties();
        try {
            saveFile.createNewFile();
            prop.setProperty("numBeans", Integer.toString(this.widVector.size()));
            Iterator it = this.widVector.iterator();
            int i2 = 0;
            while (it.hasNext()) {
                BeanWrapper bw = (BeanWrapper)it.next();
                JComponent child = bw.getChild();
                String widgetName = "widget" + i2;
                String widgetX = "widget" + i2 + "x";
                String widgetY = "widget" + i2 + "y";
                String widgetW = "widget" + i2 + "w";
                String widgetH = "widget" + i2 + "h";
                prop.setProperty(widgetName, child.getClass().getName());
                prop.setProperty(widgetX, Integer.toString(bw.getX()));
                prop.setProperty(widgetY, Integer.toString(bw.getY()));
                prop.setProperty(widgetW, Integer.toString(bw.getWidth()));
                prop.setProperty(widgetH, Integer.toString(bw.getHeight()));
                ++i2;
            }
            prop.store(new FileOutputStream(saveFile), "Beans");
        }
        catch (Exception ex) {
            return;
        }
    }

    public void setFileName(String fileName) {
        this.saveFileName = fileName;
    }

    public void restoreBeans() {
        if (this.saveFileName == null) {
            return;
        }
        File saveFile = new File(this.saveFileName, "savedBeans");
        if (!saveFile.exists()) {
            return;
        }
        Properties prop = new Properties();
        try {
            prop.load(new FileInputStream(saveFile));
            int numBeans = Integer.parseInt(prop.getProperty("numBeans"));
            for (int i2 = 0; i2 < numBeans; ++i2) {
                String widgetName = "widget" + i2;
                String widgetX = "widget" + i2 + "x";
                String widgetY = "widget" + i2 + "y";
                String widgetW = "widget" + i2 + "w";
                String widgetH = "widget" + i2 + "h";
                String beanName = prop.getProperty(widgetName);
                int x2 = Integer.parseInt(prop.getProperty(widgetX));
                int y2 = Integer.parseInt(prop.getProperty(widgetY));
                int w2 = Integer.parseInt(prop.getProperty(widgetW));
                int h2 = Integer.parseInt(prop.getProperty(widgetH));
                this.addBean(beanName, x2, y2, w2, h2);
            }
        }
        catch (IOException ex) {
            ex.printStackTrace();
        }
    }

    private void addBean(String beanClassName, int x2, int y2, int w2, int h2) {
        try {
            Class<?> c2 = Class.forName(beanClassName);
            Object obj = Beans.instantiate(c2.getClassLoader(), beanClassName);
            BeanWrapper child = new BeanWrapper(obj);
            this.add(child);
            child.setBounds(x2, y2, w2, h2);
            this.bcss.add(obj);
            this.widVector.add(child);
            child.listenForMice(false);
        }
        catch (Throwable th) {
            th.printStackTrace();
        }
    }

    public XPBeanBox() {
        this.setLayout(null);
        this.setTransferHandler(new BeanBoxTransferHandler());
        this.bcss.setDesignTime(false);
    }

    public void addBean(Object bean) {
        if (!this.bcss.isDesignTime()) {
            return;
        }
        BeanWrapper child = new BeanWrapper(bean);
        this.add(child);
        int childWidth = child.getPreferredSize().width;
        int childHeight = child.getPreferredSize().height;
        child.setBounds(this.posX, this.posY, childWidth, childHeight);
        this.bcss.add(bean);
        this.widVector.add(child);
        this.selectedBeans.clear();
        this.selectedBeans.add(child);
        this.repaint();
    }

    @Override
    public BeanContextChild getBeanContextProxy() {
        return this.bcss;
    }

    Rectangle getMoveBox(int mx, int my) {
        int x2 = this.moveChild.getLocation().x;
        int y2 = this.moveChild.getLocation().y;
        int w2 = this.moveChild.getSize().width;
        int h2 = this.moveChild.getSize().height;
        x2 = x2 + mx - this.moveStartX;
        y2 = y2 + my - this.moveStartY;
        return new Rectangle(x2, y2, w2, h2);
    }

    Rectangle getMoveBoxA(BeanWrapper moveChildA, int mx, int my) {
        int x2 = moveChildA.getLocation().x;
        int y2 = moveChildA.getLocation().y;
        int w2 = moveChildA.getSize().width;
        int h2 = moveChildA.getSize().height;
        x2 = x2 + mx - this.moveStartX;
        y2 = y2 + my - this.moveStartY;
        return new Rectangle(x2, y2, w2, h2);
    }

    private void deleteRubberBox() {
        if (this.oldRubberBox != null) {
            Graphics g2 = this.getGraphics();
            if (g2 == null) {
                return;
            }
            g2.setColor(this.getBackground());
            g2.drawRect(this.oldRubberBox.x, this.oldRubberBox.y, this.oldRubberBox.width, this.oldRubberBox.height);
            this.oldRubberBox = null;
        }
    }

    private void deleteRubberBoxA(BeanWrapper bw) {
        if (bw.rect != null) {
            Graphics g2 = this.getGraphics();
            if (g2 == null) {
                return;
            }
            g2.setColor(this.getBackground());
            g2.drawRect(bw.rect.x, bw.rect.y, bw.rect.width, bw.rect.height);
            bw.rect = null;
        }
    }

    void finishMove(int mx, int my) {
        Rectangle box = this.getMoveBox(mx, my);
        this.moveChild.setBounds(box.x, box.y, box.width, box.height);
        this.deleteRubberBox();
        this.moveChild = null;
    }

    void finishMoveA() {
        if (this.oldRubberBox != null) {
            this.moveChild.setBounds(this.oldRubberBox.x, this.oldRubberBox.y, this.oldRubberBox.width, this.oldRubberBox.height);
            this.deleteRubberBox();
            this.moveChild = null;
        }
    }

    void finishMoveAB() {
        for (BeanWrapper moveChildA : this.selectedBeans) {
            if (moveChildA.rect == null) continue;
            moveChildA.setBounds(moveChildA.rect.x, moveChildA.rect.y, moveChildA.rect.width, moveChildA.rect.height);
            this.deleteRubberBoxA(moveChildA);
            moveChildA.rect = null;
        }
        this.moveChild = null;
    }

    @Override
    public void mouseClicked(MouseEvent evt) {
        this.selectedBeans.clear();
        this.repaint();
    }

    void startResize(BeanWrapper child, int x2, int y2, Cursor cursor) {
        this.resizeStartX = child.getLocation().x + x2;
        this.resizeStartY = child.getLocation().y + y2;
        this.resizeChild = child;
        this.resizeCursor = cursor;
    }

    void startMove(BeanWrapper child, int x2, int y2) {
        this.moveChild = child;
        this.moveStartX = x2;
        this.moveStartY = y2;
    }

    void finishResize(int mx, int my) {
        Rectangle old = this.resizeChild.getBounds();
        Dimension max = this.resizeChild.getMaximumSize();
        Dimension pref = this.resizeChild.getPreferredSize();
        Rectangle box = this.getResizeBox(mx, my);
        this.resizeChild.setBounds(box.x, box.y, box.width, box.height);
        Rectangle newR = this.resizeChild.getBounds();
        this.resizeChild.doLayout();
        this.deleteRubberBox();
        this.resizeChild = null;
    }

    Rectangle getResizeBox(int mx, int my) {
        int x2 = this.resizeChild.getLocation().x;
        int y2 = this.resizeChild.getLocation().y;
        int w2 = this.resizeChild.getSize().width;
        int h2 = this.resizeChild.getSize().height;
        if (this.resizeCursor == nwResizeCursor) {
            w2 -= mx;
            h2 -= my;
            x2 += mx;
            y2 += my;
        } else if (this.resizeCursor == swResizeCursor) {
            w2 -= mx;
            h2 = my;
            x2 += mx;
        } else if (this.resizeCursor == neResizeCursor) {
            w2 = mx;
            h2 -= my;
            y2 += my;
        } else if (this.resizeCursor == seResizeCursor) {
            w2 = mx;
            h2 = my;
        }
        if (w2 < 10) {
            w2 = 10;
        }
        if (h2 < 10) {
            h2 = 10;
        }
        return new Rectangle(x2, y2, w2, h2);
    }

    @Override
    public void mousePressed(MouseEvent evt) {
        if (this.connectionSource != null) {
            this.unpaintConnection();
            this.repaint();
        }
    }

    @Override
    public void mouseEntered(MouseEvent e2) {
    }

    @Override
    public void mouseExited(MouseEvent e2) {
    }

    @Override
    public void mouseReleased(MouseEvent evt) {
        int x2 = evt.getX();
        int y2 = evt.getY();
        if (this.moveChild != null && this.selectedBeans.size() > 0) {
            this.finishMoveAB();
            this.repaint();
            return;
        }
        if (this.resizeChild != null) {
            if (evt.getComponent() == this) {
                x2 -= this.resizeChild.getLocation().x;
                y2 -= this.resizeChild.getLocation().y;
            }
            this.deleteRubberBox();
            this.finishResize(x2, y2);
            return;
        }
    }

    private void drawRubberBox(Rectangle box) {
        Graphics g2 = this.getGraphics();
        if (g2 == null) {
            return;
        }
        if (box.x > 0 && box.y > 0 && box.x < this.getWidth() - box.width && box.y < this.getHeight() - box.height) {
            this.deleteRubberBox();
            g2.setColor(UIManager.getColor("P9"));
            g2.drawRect(box.x, box.y, box.width, box.height);
            this.oldRubberBox = box;
        }
    }

    private void drawRubberBoxA(BeanWrapper bw, Rectangle box) {
        Graphics g2 = this.getGraphics();
        if (g2 == null) {
            return;
        }
        if (box.x > 0 && box.y > 0 && box.x < this.getWidth() - box.width && box.y < this.getHeight() - box.height) {
            this.deleteRubberBoxA(bw);
            g2.setColor(UIManager.getColor("P9"));
            g2.drawRect(box.x, box.y, box.width, box.height);
            this.oldRubberBox = box;
            bw.rect = box;
        }
    }

    @Override
    public void mouseDragged(MouseEvent evt) {
        int x2 = evt.getX();
        int y2 = evt.getY();
        if (this.moveChild != null && this.selectedBeans.size() > 0) {
            for (BeanWrapper moveChildA : this.selectedBeans) {
                if (evt.getComponent() == this) {
                    x2 -= moveChildA.getLocation().x;
                    y2 -= moveChildA.getLocation().y;
                }
                this.drawRubberBoxA(moveChildA, this.getMoveBoxA(moveChildA, x2, y2));
            }
            return;
        }
        if (this.resizeChild != null) {
            if (evt.getComponent() == this) {
                x2 -= this.resizeChild.getLocation().x;
                y2 -= this.resizeChild.getLocation().y;
            }
            this.drawRubberBox(this.getResizeBox(x2, y2));
        }
    }

    @Override
    public void mouseMoved(MouseEvent e2) {
    }

    private void unpaintConnection() {
        Graphics g2 = this.getGraphics();
        if (g2 == null || this.oldX1 < 0) {
            return;
        }
        g2.setColor(this.getBackground());
        g2.drawLine(this.oldX1, this.oldY1, this.oldX2, this.oldY2);
        g2.drawLine(this.oldX1 + 1, this.oldY1 + 1, this.oldX2 + 1, this.oldY2 + 1);
        this.oldX1 = -1;
    }

    class BeanBoxTransferHandler
    extends TransferHandler {
        DataFlavor textFlavor = DataFlavor.stringFlavor;

        @Override
        public boolean canImport(JComponent c2, DataFlavor[] flavors) {
            return true;
        }

        @Override
        protected Transferable createTransferable(JComponent c2) {
            return null;
        }

        @Override
        public boolean importData(JComponent c2, Transferable t2) {
            try {
                String str = (String)t2.getTransferData(DataFlavor.stringFlavor);
                Object obj = this.getInstance(str);
                if (obj != null) {
                    ((XPBeanBox)c2).addBean(obj);
                }
            }
            catch (Exception ex) {
                ex.printStackTrace();
            }
            return true;
        }

        public Object getInstance(String name) {
            try {
                return Beans.instantiate(Class.forName(name).getClassLoader(), name);
            }
            catch (Throwable th) {
                th.printStackTrace();
                return null;
            }
        }

        @Override
        public int getSourceActions(JComponent c2) {
            return 3;
        }

        @Override
        protected void exportDone(JComponent c2, Transferable data, int action) {
        }
    }
}

