/*
 * Decompiled with CFR 0.152.
 */
package com.ge.med.terra.xpv.cuiPanels;

import com.ge.med.terra.jami.XpCompositePort;
import com.ge.med.terra.jami.XpDicomElement;
import com.ge.med.terra.jami.XpFrameVisualizer;
import com.ge.med.terra.jami.XpSingularPort;
import com.ge.med.terra.jami.XpViewport;
import com.ge.med.terra.jami.capable.AnnotCapable;
import com.ge.med.terra.xpv.autoControls.XPcaAutoControlPanel;
import com.ge.med.terra.xpv.base.XPscreen;
import com.ge.med.terra.xpv.cuiPanels.CuiPanelResources;
import com.ge.med.terra.xpv.util.DisplayAnnotPrefUtils;
import com.ge.med.terra.xpv.util.FactoryPreferenceCapble;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.GridLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.ResourceBundle;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;

public class CustomAnnotationPanel
extends XPcaAutoControlPanel
implements ActionListener {
    private JScrollPane scrollPane = new JScrollPane(20, 30);
    private JPanel listPane = new JPanel(new GridLayout(0, 1));
    private JCheckBox[] annotLists;
    JPanel labelPanel = new JPanel();
    JPanel propOptPanel = new JPanel();
    JPanel buttonPanel = new JPanel();
    JLabel title = new JLabel("Custom Annotation: ");
    JPanel contentPanel = new JPanel(new BorderLayout());
    JPanel customPanel = new JPanel();
    JPanel mainPanel = new JPanel(new BorderLayout());
    private JButton ok = new JButton(res.getString("OK_BUTTON"));
    private JButton cancel = new JButton(res.getString("CANCEL_BUTTON"));
    JPanel okPanel = new JPanel();
    JPanel cancelPanel = new JPanel();
    static ResourceBundle res = CuiPanelResources.STRING_RESOURCES;
    XpDicomElement elem = new XpDicomElement(8, 96);
    String modality_ = "mr";
    private PropertyChangeListener vpListener = new PropertyChangeListener(){

        @Override
        public void propertyChange(PropertyChangeEvent evt) {
            if (evt.getPropertyName().equalsIgnoreCase("data_changed")) {
                CustomAnnotationPanel.access$002(CustomAnnotationPanel.this, null);
                CustomAnnotationPanel.this.updateAnnotList();
            } else if (evt.getPropertyName().equalsIgnoreCase("screen_custom_annotation_level")) {
                Object o2 = evt.getNewValue();
                if (o2 != null && o2 instanceof Integer) {
                    int mask = (Integer)o2;
                    for (int i2 = 0; i2 < CustomAnnotationPanel.this.annotLists.length; ++i2) {
                        int gmask = DisplayAnnotPrefUtils.getCustomAnnotationGroupMask(i2);
                        boolean isSelected = (mask & gmask) != 0;
                        CustomAnnotationPanel.this.annotLists[i2].setSelected(isSelected);
                    }
                }
                CustomAnnotationPanel.this.screen_.putClientProperty("screen_custom_annotation_level", null);
            }
        }
    };
    public static final String OK = "ok";
    public static final String CANCEL = "cancel";

    public CustomAnnotationPanel() {
        this.setBackground(null);
        this.setLayout(new BorderLayout());
        this.add((Component)this.mainPanel, "Center");
        this.mainPanel.add((Component)this.labelPanel, "North");
        this.mainPanel.add((Component)this.contentPanel, "Center");
        this.mainPanel.add((Component)this.buttonPanel, "South");
        this.labelPanel.setPreferredSize(new Dimension(100, 20));
        this.labelPanel.setLayout(null);
        this.title.setBounds(3, 0, 200, 20);
        this.labelPanel.add(this.title);
        this.customPanel.setLayout(new GridBagLayout());
        this.scrollPane.getViewport().add(this.listPane);
        this.customPanel.add((Component)this.scrollPane, new GridBagConstraints(0, 0, 1, 1, 1.0, 1.0, 10, 1, new Insets(3, 3, 3, 3), 0, 0));
        this.contentPanel.add((Component)this.customPanel, "Center");
        this.buttonPanel.setLayout(new GridLayout(1, 2));
        this.ok.setPreferredSize(new Dimension(60, 35));
        this.cancel.setPreferredSize(new Dimension(60, 35));
        this.okPanel.setLayout(new FlowLayout(2, 5, 10));
        this.cancelPanel.setLayout(new FlowLayout(0, 5, 10));
        this.okPanel.add(this.ok);
        this.cancelPanel.add(this.cancel);
        this.buttonPanel.add(this.okPanel);
        this.buttonPanel.add(this.cancelPanel);
        this.ok.addActionListener(this);
        this.cancel.addActionListener(this);
        this.ok.setActionCommand(OK);
        this.cancel.setActionCommand(CANCEL);
    }

    @Override
    public void setScreen(XPscreen screen) {
        this.screen_ = screen;
        this.updateAnnotList();
        this.screen_.removePropertyChangeListener(this.vpListener);
        this.screen_.addPropertyChangeListener(this.vpListener);
    }

    private void updateAnnotList() {
        XpViewport disp;
        if (this.annotLists != null) {
            return;
        }
        AnnotCapable annotPort = (AnnotCapable)this.getCapable("com.ge.med.terra.jami.capable.AnnotCapable");
        if (annotPort == null) {
            return;
        }
        if (this.screen_.getSelectedPort() instanceof XpCompositePort) {
            disp = (XpCompositePort)this.screen_.getSelectedPort();
            XpFrameVisualizer vis = ((XpCompositePort)disp).getPort(0);
            vis.getImages()[0].getValue(this.elem);
            this.modality_ = this.elem.getStringValue();
        } else if (this.screen_.getSelectedPort() instanceof XpSingularPort) {
            disp = (XpSingularPort)this.screen_.getSelectedPort();
            disp.getImages()[0].getValue(this.elem);
            this.modality_ = this.elem.getStringValue();
        }
        String[] groups = DisplayAnnotPrefUtils.getCustomAnnotationGroups(this.modality_);
        if (groups != null) {
            String annotation = " ";
            this.annotLists = new JCheckBox[groups.length];
            for (int i2 = 0; i2 < groups.length; ++i2) {
                annotation = i2 + 1 + ":  " + groups[i2];
                if (groups[i2].trim().equalsIgnoreCase("windowing")) {
                    annotation = "W:  " + groups[i2];
                }
                if (groups[i2].trim().equalsIgnoreCase("Graphic Annotation") || groups[i2].trim().equalsIgnoreCase("Graphic_Results")) {
                    annotation = "G:  " + groups[i2];
                }
                boolean isSelected = DisplayAnnotPrefUtils.queryScreenCustomAnnotationGroup(i2);
                this.annotLists[i2] = new JCheckBox(annotation);
                this.annotLists[i2].setSelected(isSelected);
                this.annotLists[i2].setFocusable(false);
                this.listPane.add(this.annotLists[i2]);
            }
        }
    }

    @Override
    public void actionPerformed(ActionEvent e2) {
        String cmd = e2.getActionCommand();
        if (cmd.equalsIgnoreCase(OK)) {
            this.updateChange();
            this.firePropertyChange(OK, false, true);
        } else if (cmd.equalsIgnoreCase(CANCEL)) {
            this.vetoChange();
            this.firePropertyChange(CANCEL, false, true);
        }
    }

    private void updateChange() {
        AnnotCapable annotPort = (AnnotCapable)this.getCapable("com.ge.med.terra.jami.capable.AnnotCapable");
        if (annotPort == null || this.annotLists == null) {
            return;
        }
        int customMask = 0;
        for (int i2 = 0; i2 < this.annotLists.length; ++i2) {
            if (!this.annotLists[i2].isSelected()) continue;
            int mask = DisplayAnnotPrefUtils.getCustomAnnotationGroupMask(i2);
            customMask |= mask;
        }
        FactoryPreferenceCapble.getInstance().updateScreenCustomAnnotationLevel(customMask);
    }

    private void vetoChange() {
        AnnotCapable annotPort = (AnnotCapable)this.getCapable("com.ge.med.terra.jami.capable.AnnotCapable");
        if (annotPort == null || this.annotLists == null) {
            return;
        }
        for (int i2 = 0; i2 < this.annotLists.length; ++i2) {
            boolean isSelected = DisplayAnnotPrefUtils.queryScreenCustomAnnotationGroup(i2);
            this.annotLists[i2].setSelected(isSelected);
        }
    }

    static /* synthetic */ JCheckBox[] access$002(CustomAnnotationPanel x0, JCheckBox[] x1) {
        x0.annotLists = x1;
        return x1;
    }
}

