/*
 * Decompiled with CFR 0.152.
 */
package com.ge.med.terra.xpv.formatter;

import com.ge.med.terra.tap.dm.DMTag;
import com.ge.med.terra.xpv.formatter.GetValue;
import java.awt.image.BufferedImage;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class FormatUtils {
    private static final String IP_ADDRESS_RE = "^(25[0-5]|2[0-4]\\d|[0-1]?\\d?\\d)(\\.(25[0-5]|2[0-4]\\d|[0-1]?\\d?\\d)){3}$";

    public static int getValue(Object vector, int index) {
        if (vector instanceof Integer[]) {
            Integer[] shorts = (Integer[])vector;
            return shorts[index];
        }
        if (vector instanceof short[]) {
            short[] shorts = (short[])vector;
            return shorts[index];
        }
        if (vector instanceof Short) {
            return ((Short)vector).intValue();
        }
        if (vector instanceof Integer) {
            return (Integer)vector;
        }
        if (vector instanceof int[]) {
            int[] shorts = (int[])vector;
            return shorts[index];
        }
        if (vector instanceof Short[]) {
            Short[] shorts = (Short[])vector;
            return shorts[index].intValue();
        }
        if (vector instanceof String) {
            return Integer.parseInt((String)vector);
        }
        return -1;
    }

    public static int getFrameIndex(GetValue im) {
        return (Integer)im.getValue(0, 1) - 1;
    }

    public static int getFrameIndex(BufferedImage im) {
        return (Integer)im.getProperty("0,1") - 1;
    }

    public static Object objectFromImage(BufferedImage rstr, DMTag tag2) {
        return FormatUtils.objectFromImage(rstr, tag2.getGroup(), tag2.getElement());
    }

    public static Object objectFromImage(BufferedImage rstr, int group, int element) {
        StringBuffer utilBuffer = new StringBuffer();
        utilBuffer.append(group);
        utilBuffer.append(',');
        utilBuffer.append(element);
        return rstr.getProperty(utilBuffer.toString());
    }

    public static boolean validIP(String ipAddress) {
        Matcher ipMatcher = Pattern.compile(IP_ADDRESS_RE).matcher(ipAddress);
        return ipMatcher.matches();
    }

    public static boolean validPortNumber(String portNumber) {
        char[] source = portNumber.toCharArray();
        for (int i2 = 0; i2 < source.length; ++i2) {
            if (Character.isDigit(source[i2])) continue;
            return false;
        }
        return true;
    }

    public static boolean validHostname(String ipAddress) {
        int lastDotLoc = -1;
        char[] source = ipAddress.toCharArray();
        if (source.length > 63) {
            return false;
        }
        for (int i2 = 0; i2 < source.length; ++i2) {
            if ((Character.isDigit(source[i2]) || Character.isLetter(source[i2]) || source[i2] == '.' || source[i2] == '-') && source[i2] != '$' && source[i2] != '_') {
                if (lastDotLoc > 0 && (source[i2] == '.' || source[i2] == '-') && lastDotLoc == i2 - 1) {
                    return false;
                }
                if (source[i2] != '.') continue;
                lastDotLoc = i2;
                continue;
            }
            return false;
        }
        return true;
    }
}

