/*
 * Decompiled with CFR 0.152.
 */
package com.ge.med.terra.xpv.mouseController;

import com.ge.med.idc.CineCapable;
import com.ge.med.idc.FramePositioningCapable;
import com.ge.med.terra.jami.XpMouseController;
import com.ge.med.terra.jami.j3d.SelectMouseController;
import com.ge.med.terra.xpv.cuiPanels.CuiPanelUtils;
import com.ge.med.terra.xpv.mouseController.CustomCursor;
import com.ge.med.terra.xpv.mouseController.PagingMouseController;
import com.ge.med.terra.xpv.mouseController.PanMouseController;
import com.ge.med.terra.xpv.mouseController.RightMenuMouseController;
import com.ge.med.terra.xpv.mouseController.WLMouseController;
import com.ge.med.terra.xpv.mouseController.ZoomMouseController;
import java.awt.Cursor;
import java.awt.event.MouseEvent;
import java.awt.event.MouseWheelEvent;
import java.awt.event.MouseWheelListener;
import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import javax.swing.JComponent;

public class Default2DViewerMouseController
implements XpMouseController,
MouseWheelListener {
    protected Map controllerMap_ = new HashMap();
    protected Map propertyMap_ = new HashMap();
    private JComponent target_;
    private Map controllerReverseMap_ = new HashMap();
    private XpMouseController activeController_;
    private FramePositioningCapable vp = null;
    private Cursor oldCursor_;
    public static final String CURSOR_PROPERTY = "Cursor";
    public static final String ICON_PROPERTY = "Icon";
    public static final String NAME_PROPERTY = "Name";
    public static final String SHORT_DESCRIPTION_PROPERTY = "ShortDescription";
    public static final Map SELECT_PROPERTIES = new HashMap();
    public static final Map PAGING_PROPERTIES = new HashMap();
    public static final Map ZOOM_PROPERTIES = new HashMap();
    public static final Map PAN_PROPERTIES = new HashMap();
    public static final Map WL_PROPERTIES = new HashMap();
    public static final int NumberOfControllers = 5;
    public static final int SELECT_INDEX = 0;
    public static final int PAGING_INDEX = 1;
    public static final int PAN_INDEX = 2;
    public static final int ZOOM_INDEX = 3;
    public static final int WL_INDEX = 4;
    public static final String LEFT_MOUSE_BINDING_PROPERTY = "leftMouse";
    protected PropertyChangeSupport pcs_ = new PropertyChangeSupport(this);
    private XpMouseController[] mouseControllers_ = new XpMouseController[5];
    private int index_ = 0;
    long wheelPrevTime_ = 0L;
    static final int WHEEL_SENSITIVITY = 500;
    static final int FAST_WHEEL_SCROLL_AMOUNT = 3;

    public void addPropertyChangeListener(PropertyChangeListener l2) {
        this.pcs_.addPropertyChangeListener(l2);
    }

    public void addPropertyChangeListener(String prop, PropertyChangeListener l2) {
        this.pcs_.addPropertyChangeListener(prop, l2);
    }

    public void removePropertyChangeListener(PropertyChangeListener l2) {
        this.pcs_.removePropertyChangeListener(l2);
    }

    public void removePropertyChangeListener(String prop, PropertyChangeListener l2) {
        this.pcs_.removePropertyChangeListener(prop, l2);
    }

    public XpMouseController getMouseController(int binding) {
        return (XpMouseController)this.controllerMap_.get(new Integer(binding));
    }

    public Properties getMouseControllerProperties(int binding) {
        return (Properties)this.propertyMap_.get(this.getMouseController(binding));
    }

    public void addMouseController(XpMouseController controller, int binding, Map properties) {
        this.controllerMap_.put(new Integer(binding), controller);
        this.controllerReverseMap_.put(controller, new Integer(binding));
        if (properties != null) {
            this.propertyMap_.put(controller, new HashMap(properties));
        }
        if (this.target_ != null) {
            controller.setTarget(this.target_);
        }
    }

    public void removeMouseController(XpMouseController controller) {
        if (controller == null) {
            return;
        }
        Object o2 = this.controllerReverseMap_.get(controller);
        this.controllerReverseMap_.remove(controller);
        this.propertyMap_.remove(controller);
        if (o2 != null) {
            this.controllerMap_.remove(o2);
        }
    }

    public Default2DViewerMouseController() {
        this.mouseControllers_[0] = new SelectMouseController();
        this.mouseControllers_[1] = new PagingMouseController();
        this.mouseControllers_[2] = new PanMouseController();
        this.mouseControllers_[3] = new ZoomMouseController();
        this.mouseControllers_[4] = new WLMouseController();
        this.addMouseController(this.mouseControllers_[2], 1088, PAN_PROPERTIES);
        this.addMouseController(this.mouseControllers_[4], 2048, WL_PROPERTIES);
        this.addMouseController(this.mouseControllers_[3], 1152, ZOOM_PROPERTIES);
        this.addMouseController(new RightMenuMouseController(this, new Map[]{SELECT_PROPERTIES, PAGING_PROPERTIES, PAN_PROPERTIES, ZOOM_PROPERTIES, WL_PROPERTIES}), 4096, null);
    }

    @Override
    public void setTarget(JComponent jc) {
        this.target_ = jc;
        for (XpMouseController controller : this.controllerMap_.values()) {
            controller.setTarget(jc);
        }
        JComponent comp = this.target_;
        while (!(comp instanceof FramePositioningCapable)) {
            comp = (JComponent)comp.getParent();
        }
        this.vp = (FramePositioningCapable)((Object)comp);
    }

    public void setLeftMouseBinding(int newIndex) {
        if (newIndex != this.index_) {
            int oldIndex = this.index_;
            this.index_ = newIndex;
            switch (this.index_) {
                case 0: {
                    this.addMouseController(this.mouseControllers_[0], 1024, SELECT_PROPERTIES);
                    break;
                }
                case 1: {
                    this.addMouseController(this.mouseControllers_[1], 1024, PAGING_PROPERTIES);
                    break;
                }
                case 3: {
                    this.addMouseController(this.mouseControllers_[3], 1024, ZOOM_PROPERTIES);
                    break;
                }
                case 2: {
                    this.addMouseController(this.mouseControllers_[2], 1024, PAN_PROPERTIES);
                    break;
                }
                case 4: {
                    this.addMouseController(this.mouseControllers_[4], 1024, WL_PROPERTIES);
                }
            }
            this.pcs_.firePropertyChange(LEFT_MOUSE_BINDING_PROPERTY, oldIndex, this.index_);
        }
    }

    @Override
    public void mouseClicked(MouseEvent e2) {
        if (this.activeController_ == null) {
            return;
        }
        this.activeController_.mouseClicked(e2);
    }

    @Override
    public void mousePressed(MouseEvent e2) {
        Cursor cursor;
        this.activeController_ = (XpMouseController)this.controllerMap_.get(new Integer(e2.getModifiersEx()));
        if (this.activeController_ == null) {
            System.err.println("mouse controller not found!");
            return;
        }
        Map prop = (Map)this.propertyMap_.get(this.activeController_);
        if (prop != null && (cursor = (Cursor)prop.get(CURSOR_PROPERTY)) != null) {
            this.oldCursor_ = e2.getComponent().getCursor();
            e2.getComponent().setCursor(cursor);
        }
        this.activeController_.mousePressed(e2);
    }

    @Override
    public void mouseReleased(MouseEvent e2) {
        if (this.activeController_ == null) {
            return;
        }
        this.activeController_.mouseReleased(e2);
        if (this.oldCursor_ != null) {
            e2.getComponent().setCursor(this.oldCursor_);
            this.oldCursor_ = null;
        }
    }

    @Override
    public void mouseDragged(MouseEvent e2) {
        if (this.activeController_ != null) {
            this.activeController_.mouseDragged(e2);
        }
    }

    @Override
    public void mouseEntered(MouseEvent e2) {
    }

    @Override
    public void mouseExited(MouseEvent e2) {
    }

    @Override
    public void mouseMoved(MouseEvent e2) {
    }

    @Override
    public void mouseWheelMoved(MouseWheelEvent e2) {
        if (e2.getScrollType() == 0) {
            int sign = e2.getWheelRotation() > 0 ? 1 : -1;
            long t2 = System.currentTimeMillis();
            int dz = t2 - this.wheelPrevTime_ > 500L ? 1 * sign : 3;
            this.page(dz);
            this.wheelPrevTime_ = t2;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void page(int unit) {
        if (this.vp == null) {
            return;
        }
        if (((CineCapable)((Object)this.vp)).getCine()) {
            return;
        }
        Default2DViewerMouseController default2DViewerMouseController = this;
        synchronized (default2DViewerMouseController) {
            int size = this.vp.getNumFrames();
            if (unit < 0) {
                this.vp.setFrameIndex((this.vp.getFrameIndex() + unit + size) % size);
            } else {
                this.vp.setFrameIndex((this.vp.getFrameIndex() + unit) % size);
            }
        }
    }

    static {
        SELECT_PROPERTIES.put(CURSOR_PROPERTY, Cursor.getDefaultCursor());
        SELECT_PROPERTIES.put(ICON_PROPERTY, CuiPanelUtils.getIcon("CURSOR_ARROW_ICO"));
        SELECT_PROPERTIES.put(NAME_PROPERTY, "Select");
        SELECT_PROPERTIES.put(SHORT_DESCRIPTION_PROPERTY, "Select Object");
        PAGING_PROPERTIES.put(CURSOR_PROPERTY, CustomCursor.PAGE_CURSOR);
        PAGING_PROPERTIES.put(ICON_PROPERTY, CuiPanelUtils.getIcon("CURSOR_PAGING_ICO"));
        PAGING_PROPERTIES.put(NAME_PROPERTY, "Page");
        PAGING_PROPERTIES.put(SHORT_DESCRIPTION_PROPERTY, "Cine Paging");
        ZOOM_PROPERTIES.put(CURSOR_PROPERTY, CustomCursor.ZOOM_CURSOR);
        ZOOM_PROPERTIES.put(ICON_PROPERTY, CuiPanelUtils.getIcon("CURSOR_ZOOM_ICO"));
        ZOOM_PROPERTIES.put(NAME_PROPERTY, "Zoom");
        ZOOM_PROPERTIES.put(SHORT_DESCRIPTION_PROPERTY, "Zoom In/Out");
        PAN_PROPERTIES.put(CURSOR_PROPERTY, CustomCursor.PAN_CURSOR);
        PAN_PROPERTIES.put(ICON_PROPERTY, CuiPanelUtils.getIcon("CURSOR_HAND_ICO"));
        PAN_PROPERTIES.put(NAME_PROPERTY, "Pan/Roam");
        PAN_PROPERTIES.put(SHORT_DESCRIPTION_PROPERTY, "Move Image");
        WL_PROPERTIES.put(CURSOR_PROPERTY, CustomCursor.WL_CURSOR);
        WL_PROPERTIES.put(ICON_PROPERTY, CuiPanelUtils.getIcon("CURSOR_WINDOW_ICO"));
        WL_PROPERTIES.put(NAME_PROPERTY, "Window/Level");
        WL_PROPERTIES.put(SHORT_DESCRIPTION_PROPERTY, "WindowLevel");
    }
}

