/*
 * Decompiled with CFR 0.152.
 */
package com.ge.med.terra.xpv.mouseController;

import com.ge.med.idc.T3DCapable;
import com.ge.med.terra.jami.XpMouseController;
import java.awt.event.MouseEvent;
import java.awt.event.MouseWheelEvent;
import java.awt.event.MouseWheelListener;
import javax.swing.JComponent;
import javax.swing.event.MouseInputAdapter;

public class T3DZoomMouseController
extends MouseInputAdapter
implements XpMouseController,
MouseWheelListener {
    private T3DCapable t3d_;
    private int prevY_;
    long wheelPrevTime_ = 0L;
    static final int WHEEL_SENSITIVITY = 500;
    static final int FAST_WHEEL_SCROLL_AMOUNT = 3;

    @Override
    public void mouseDragged(MouseEvent e2) {
        if (this.t3d_ == null) {
            return;
        }
        int y2 = e2.getY();
        double h2 = this.t3d_.getViewHeight();
        this.t3d_.setViewHeight(h2 *= 1.0 - (double)(this.prevY_ - y2) / (double)e2.getComponent().getHeight());
        this.prevY_ = y2;
        this.t3d_.repaint();
    }

    @Override
    public void mouseReleased(MouseEvent e2) {
    }

    @Override
    public void mousePressed(MouseEvent e2) {
        this.prevY_ = e2.getY();
    }

    @Override
    public void setTarget(JComponent jc) {
        if (jc instanceof T3DCapable) {
            this.t3d_ = (T3DCapable)((Object)jc);
        }
    }

    @Override
    public void mouseWheelMoved(MouseWheelEvent e2) {
        if (e2.getScrollType() == 0) {
            int sign = e2.getWheelRotation() > 0 ? 1 : -1;
            long t2 = System.currentTimeMillis();
            int dz = t2 - this.wheelPrevTime_ > 500L ? 1 : 3;
            dz *= sign;
            this.wheelPrevTime_ = t2;
        }
    }
}

