/*
 * Decompiled with CFR 0.152.
 */
package com.ge.med.terra.xpv.onport;

import com.ge.med.idc.Capable;
import com.ge.med.idc.ColorMapCapable;
import com.ge.med.idc.WindowLevelCapable;
import com.ge.med.terra.xpv.onport.XPopPanel;
import com.ge.med.terra.xpv.ui.WindowLevelControl;
import com.ge.med.terra.xpv.util.XPutil;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Insets;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import javax.swing.JComponent;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;

public class XPopWindowLevel
extends XPopPanel {
    public WindowLevelCapable port;
    WindowLevelControl windowLevelControl = new WindowLevelControl();
    private PropertyChangeListener viewPortListener = new PropertyChangeListener(){

        @Override
        public void propertyChange(PropertyChangeEvent evt) {
            if (evt.getPropertyName() == "COLOR_MAP") {
                int[] cMap = ((ColorMapCapable)((Object)XPopWindowLevel.this.port)).getColorMap();
                if (cMap != null) {
                    XPopWindowLevel.this.windowLevelControl.setColorMap(cMap);
                } else {
                    XPopWindowLevel.this.windowLevelControl.setColorMap(new int[]{0, 0xFFFFFF});
                }
            } else if (evt.getPropertyName() == "winMax") {
                XPopWindowLevel.this.windowLevelControl.setWindowMax(XPopWindowLevel.this.port.getWinMax());
            } else if (evt.getPropertyName() == "winMin") {
                XPopWindowLevel.this.windowLevelControl.setWindowMin(XPopWindowLevel.this.port.getWinMin());
            }
        }
    };

    public XPopWindowLevel() {
        try {
            this.jbInit();
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    private void jbInit() throws Exception {
        this.setLayout(new BorderLayout());
        this.setPreferredSize(new Dimension(40, 300));
        this.setMinimumSize(new Dimension(20, 150));
        this.windowLevelControl.setOpaque(false);
        this.windowLevelControl.setRequestFocusEnabled(false);
        this.windowLevelControl.setWindowMax(200.0);
        this.windowLevelControl.setWindowMin(0.0);
        this.windowLevelControl.setOrientation(1);
        this.windowLevelControl.setPaintLabels(false);
        this.windowLevelControl.setPaintTicks(false);
        this.windowLevelControl.setRangeMin(0.0);
        this.windowLevelControl.setRangeMax(1000.0);
        this.windowLevelControl.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent e2) {
                XPopWindowLevel.this.windowLevelControl_stateChanged(e2);
            }
        });
        this.setOpaque(false);
        this.add((Component)this.windowLevelControl, "Center");
    }

    @Override
    public Insets getInsets() {
        return new Insets(2, 2, 2, 2);
    }

    @Override
    public void setCapable(Capable capable) {
        if (capable instanceof WindowLevelCapable) {
            int[] cMap;
            this.port = (WindowLevelCapable)capable;
            this.windowLevelControl.setWindowMax(this.port.getWinMax());
            this.windowLevelControl.setWindowMin(this.port.getWinMin());
            if (this.port instanceof ColorMapCapable && (cMap = ((ColorMapCapable)((Object)this.port)).getColorMap()) != null) {
                this.windowLevelControl.setColorMap(cMap);
            }
            this.port.addPropertyChangeListener(this.viewPortListener);
        }
    }

    @Override
    public boolean isSupported(Capable capable) {
        return capable instanceof WindowLevelCapable;
    }

    void windowLevelControl_stateChanged(ChangeEvent e2) {
        if (!(this.port instanceof WindowLevelCapable)) {
            return;
        }
        if (((WindowLevelControl)e2.getSource()).getX() == 0) {
            this.level = 0;
            return;
        }
        this.fire();
        this.updateWL(this.port);
    }

    void updateWL(Object target) {
        if (!(this.port instanceof WindowLevelCapable)) {
            return;
        }
        WindowLevelCapable wlc = this.port;
        wlc.setWinMinMax(this.windowLevelControl.getWindowMin(), this.windowLevelControl.getWindowMax());
    }

    public void setWinLevel() {
        if (!(this.port instanceof WindowLevelCapable)) {
            return;
        }
        WindowLevelCapable wlc = this.port;
        this.windowLevelControl.setWindowMax(wlc.getWinMax());
        this.windowLevelControl.setWindowMin(wlc.getWinMin());
        if (!(this.port instanceof ColorMapCapable)) {
            return;
        }
        ColorMapCapable cmc = (ColorMapCapable)((Object)this.port);
        Object name = ((JComponent)((Object)cmc)).getClientProperty("colorMap");
        int[] colorTable = null;
        if (name == null || (colorTable = XPutil.getColorTable((String)name)) == null) {
            colorTable = new int[]{0, 0xFFFFFF};
        }
        this.windowLevelControl.setColorMap(colorTable);
    }
}

