/*
 * Decompiled with CFR 0.152.
 */
package com.ge.med.terra.xpv.print;

import com.ge.med.idc.FramePositioningCapable;
import com.ge.med.terra.xpv.print.PrintableXPVPort;
import java.awt.print.PageFormat;
import java.awt.print.Pageable;
import java.awt.print.Printable;
import javax.swing.JComponent;

public class PageableXPVPort
implements Pageable {
    JComponent port = null;
    int numOfPages = 1;

    public PageableXPVPort(JComponent port) {
        this.port = port;
        if (port instanceof FramePositioningCapable) {
            this.numOfPages = ((FramePositioningCapable)((Object)port)).getNumFrames();
        }
    }

    @Override
    public int getNumberOfPages() {
        return this.numOfPages;
    }

    @Override
    public PageFormat getPageFormat(int pageIndex) throws IndexOutOfBoundsException {
        if (pageIndex < this.numOfPages) {
            return new PageFormat();
        }
        throw new IndexOutOfBoundsException();
    }

    @Override
    public Printable getPrintable(int pageIndex) throws IndexOutOfBoundsException {
        if (pageIndex == 0) {
            return new PrintableXPVPort(this.port);
        }
        if (pageIndex < this.numOfPages) {
            if (this.port instanceof FramePositioningCapable) {
                ((FramePositioningCapable)((Object)this.port)).setFrameIndex(pageIndex);
            }
            return new PrintableXPVPort(this.port);
        }
        throw new IndexOutOfBoundsException();
    }
}

