/*
 * Decompiled with CFR 0.152.
 */
package com.ge.med.terra.xpv.template;

import com.ge.med.terra.jami.XpMedicalImage;
import com.ge.med.terra.jami.XpMultiImageViewport;
import com.ge.med.terra.jami.annotation.XpApdAnnotationGenerator;
import com.ge.med.terra.jami.platform.dm.XpMedicalDmImage;
import com.ge.med.terra.tap.dm.DMImage;
import com.ge.med.terra.tap.dm.DMObject;
import com.ge.med.terra.tap.dm.DMTag;
import com.ge.med.terra.xpv.base.XPscreen;
import com.ge.med.terra.xpv.template.BasicTemplate;
import java.awt.Component;
import java.awt.RenderingHints;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Properties;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTree;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.TreePath;

public class DebugTemplateUI
extends JDialog {
    private JPanel jPanel1 = new JPanel();
    private JButton load = new JButton();
    private JScrollPane jScrollPane1 = new JScrollPane();
    private JTree jTree1 = new JTree();
    private JButton clear = new JButton();
    private JButton done = new JButton();
    DefaultMutableTreeNode root = new DefaultMutableTreeNode();
    DefaultTreeModel tm = new DefaultTreeModel(this.root);
    String[] list = new String[]{"patient", "study", "series", "image"};
    Properties prop;
    XPscreen screen_;

    public void setConfigProp(Properties prop) {
        this.prop = prop;
    }

    public DebugTemplateUI() {
        try {
            this.jbInit();
        }
        catch (Exception e2) {
            e2.printStackTrace();
        }
        this.setBounds(0, 100, 256, 300);
        this.setModal(true);
    }

    private void jbInit() throws Exception {
        this.load.setText("Load");
        this.load.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e2) {
                DebugTemplateUI.this.load_actionPerformed(e2);
            }
        });
        this.clear.setText("Clear");
        this.clear.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e2) {
                DebugTemplateUI.this.clear_actionPerformed(e2);
            }
        });
        this.done.setText("Done");
        this.done.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e2) {
                DebugTemplateUI.this.done_actionPerformed(e2);
            }
        });
        this.jTree1.setModel(this.tm);
        this.jTree1.setRootVisible(false);
        this.getContentPane().add((Component)this.jPanel1, "South");
        this.jPanel1.add((Component)this.load, null);
        this.jPanel1.add((Component)this.clear, null);
        this.jPanel1.add((Component)this.done, null);
        this.getContentPane().add((Component)this.jScrollPane1, "Center");
        this.jScrollPane1.getViewport().add((Component)this.jTree1, null);
    }

    private void adddata(DefaultMutableTreeNode node, DMObject dmo, int n2) {
        DMObject[] c2 = dmo.getRelated(this.list[n2]);
        for (int i2 = 0; i2 < c2.length; ++i2) {
            DefaultMutableTreeNode mtn = new DefaultMutableTreeNode(new DMWrap(c2[i2], n2));
            node.add(mtn);
            if (n2 >= 2) continue;
            this.adddata(mtn, c2[0], n2 + 1);
        }
    }

    public void load(DMObject[] pat) {
        this.root.removeAllChildren();
        this.tm.nodeStructureChanged(this.root);
        this.root = new DefaultMutableTreeNode();
        for (int i2 = 0; i2 < pat.length; ++i2) {
            System.out.flush();
            this.adddata(this.root, pat[i2], 1);
        }
        try {
            Thread.sleep(1000L);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
        this.tm.setRoot(this.root);
        this.tm.nodeStructureChanged(this.root);
        this.jTree1.expandPath(new TreePath(this.jTree1.getModel().getRoot()));
    }

    private DMObject[] getSelected() {
        TreePath[] tp = this.jTree1.getSelectionPaths();
        DMObject[] selObj = new DMObject[tp == null ? 0 : tp.length];
        int k2 = 0;
        for (int i2 = 0; i2 < (tp == null ? 0 : tp.length); ++i2) {
            DefaultMutableTreeNode m2;
            if (tp == null || (m2 = (DefaultMutableTreeNode)tp[i2].getLastPathComponent()) == null) continue;
            selObj[k2++] = ((DMWrap)m2.getUserObject()).dmo;
        }
        if (k2 != selObj.length) {
            DMObject[] tmp = new DMObject[k2];
            System.arraycopy(selObj, 0, tmp, 0, k2);
            return tmp;
        }
        return selObj;
    }

    void load_actionPerformed(ActionEvent e2) {
        DMObject[] selected = this.getSelected();
        if (selected.length <= 0) {
            return;
        }
        DMTag[] tagList = BasicTemplate.getNeededTags();
        this.setDataOnPort(selected, tagList);
        this.jTree1.clearSelection();
    }

    public void setScreen(XPscreen scr) {
        this.screen_ = scr;
    }

    private void setDataOnPort(DMObject[] dmo, DMTag[] tagList) {
        int portNo = this.screen_.getSelectedPortNumber();
        DMImage[][] imgs = new DMImage[dmo.length][];
        int imageCount = 0;
        for (int i2 = 0; i2 < dmo.length; ++i2) {
            imgs[i2] = dmo[i2].getImages(tagList);
            imageCount += imgs[i2].length;
        }
        DMImage[] img = new DMImage[imageCount];
        int ic = 0;
        for (int i3 = 0; i3 < dmo.length; ++i3) {
            System.arraycopy(imgs[i3], 0, img, ic, imgs[i3].length);
            ic = 0;
        }
        XpMultiImageViewport port = new XpMultiImageViewport();
        XpMedicalImage[] mi = new XpMedicalImage[img.length];
        port.setPrimaryBorder(null);
        for (int ii = 0; ii < img.length; ++ii) {
            XpMedicalDmImage dmi = new XpMedicalDmImage(img[ii]);
            mi[ii] = dmi;
        }
        this.screen_.addPort(port, portNo);
        port.setImages(mi);
        port.setAnnotationGenerator(XpApdAnnotationGenerator.class, this.prop);
        port.setCineQuality(RenderingHints.VALUE_INTERPOLATION_BILINEAR);
        port.setRowCol(imageCount > 1 ? 2 : 1, imageCount > 2 ? 2 : 1);
    }

    void clear_actionPerformed(ActionEvent e2) {
    }

    void done_actionPerformed(ActionEvent e2) {
        this.setVisible(false);
    }

    class DMWrap {
        DMObject dmo;
        int n;

        public DMWrap(DMObject o2, int n2) {
            this.dmo = o2;
            this.n = n2;
        }

        public String toString() {
            if (this.dmo == null) {
                return "...";
            }
            if (this.n == 0) {
                return "p:" + this.dmo.getValue(16, 16).toString();
            }
            if (this.n == 1) {
                return "ex:" + this.dmo.getValue(16, 16).toString();
            }
            if (this.n == 2) {
                return "se:" + this.dmo.getValue(16, 16).toString();
            }
            if (this.n == 3) {
                return "im:" + this.dmo.getValue(16, 16).toString();
            }
            return "4+" + this.dmo.getValue(16, 16).toString();
        }
    }
}

