/*
 * Decompiled with CFR 0.152.
 */
package com.ge.med.terra.xpv.ui;

import com.ge.med.ptk.border.CuiButtonBorder;
import com.ge.med.ptk.laf.CuiLookAndFeel;
import java.awt.BorderLayout;
import java.awt.CardLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Arrays;
import java.util.Iterator;
import java.util.Vector;
import javax.swing.AbstractButton;
import javax.swing.ComboBoxEditor;
import javax.swing.ComboBoxModel;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.ListCellRenderer;
import javax.swing.UIManager;
import javax.swing.border.EmptyBorder;

public class ComboButton
extends JComboBox {
    protected ButtonPanelCBE cards_;
    protected boolean defensive_;
    protected ListCellRenderer defaultRenderer_;

    @Override
    public boolean isEditable() {
        return true;
    }

    @Override
    public final ComboBoxEditor getEditor() {
        return this.cards_ == null ? (this.cards_ = new ButtonPanelCBE()) : this.cards_;
    }

    public boolean isExpertMode() {
        return !this.defensive_;
    }

    public void setExpertMode(boolean e2) {
        this.defensive_ = !e2;
    }

    protected void expertOnly() {
        if (!this.isExpertMode()) {
            throw new UnsupportedOperationException();
        }
    }

    @Override
    public final void setEditor(ComboBoxEditor e2) {
        throw new UnsupportedOperationException();
    }

    @Override
    public final void setEditable(boolean e2) {
        throw new UnsupportedOperationException();
    }

    public final void setModel(ComboBoxModel m2) {
        this.expertOnly();
        super.setModel(m2);
    }

    public final void setRenderer(ListCellRenderer r2) {
        this.expertOnly();
        super.setRenderer(r2);
    }

    public ComboButton() {
        this(new Vector());
    }

    public ComboButton(Object[] buttons) {
        this((Vector)new Vector<Object>(Arrays.asList(buttons)));
    }

    public ComboButton(Vector buttons) {
        super(new ComboButtonCBM(buttons));
        for (int i2 = 0; i2 < this.getModel().getSize(); ++i2) {
            this.addButton(ComboButton.button(this.getModel().getElementAt(i2)));
        }
        this.defaultRenderer_ = this.getRenderer();
        this.setRenderer(new ListCellRenderer(){

            public Component getListCellRendererComponent(JList list, Object value, int index, boolean selected, boolean focus) {
                Component c2 = ComboButton.this.defaultRenderer_.getListCellRendererComponent(list, value, index, selected, focus);
                if (!(value instanceof AbstractButton) || !(c2 instanceof JLabel)) {
                    return c2;
                }
                JLabel label = (JLabel)c2;
                AbstractButton button = (AbstractButton)value;
                Insets inL = label.getInsets();
                Insets inB = button.getInsets();
                label.setPreferredSize(new Dimension(button.getPreferredSize().width - (inB.left + inB.right) + (inL.left + inL.right), label.getPreferredSize().height));
                label.setText(button.getText());
                label.setIcon(selected ? button.getPressedIcon() : button.getIcon());
                label.setEnabled(button.isEnabled());
                if (label.getIcon() != null) {
                    label.setHorizontalAlignment(button.getHorizontalAlignment());
                    label.setVerticalAlignment(button.getVerticalAlignment());
                    label.setHorizontalTextPosition(button.getHorizontalTextPosition());
                    label.setVerticalTextPosition(button.getVerticalTextPosition());
                }
                return label;
            }
        });
        this.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e2) {
                if (!(ComboButton.this.getSelectedItem() instanceof AbstractButton)) {
                    return;
                }
                ((CardLayout)ComboButton.this.cards_.getLayout()).show(ComboButton.this.cards_, "" + ComboButton.this.getSelectedItem().hashCode());
            }
        });
        this.defensive_ = true;
    }

    public void addItem(Object button) {
        super.addItem(this.addButton(ComboButton.button(button)));
    }

    public void insertItemAt(Object button, int index) {
        super.insertItemAt(this.addButton(ComboButton.button(button)), index);
    }

    protected AbstractButton addButton(AbstractButton button) {
        ((JPanel)((Object)this.getEditor())).add((Component)button, "" + button.hashCode());
        button.setContentAreaFilled(true);
        button.setBorderPainted(true);
        if ("CUI".equals(UIManager.getLookAndFeel().getName())) {
            button.setBorder(new CuiButtonBorder(CuiLookAndFeel.getInteriorEdge(), CuiLookAndFeel.getExteriorEdge(), new double[]{CuiLookAndFeel.getCornerRadius(), 0.0, 0.0, 0.0}, true, true, true, false));
        } else {
            button.setBorder(UIManager.getBorder("Button.border"));
        }
        return button;
    }

    protected static AbstractButton button(Object b2) {
        if (!(b2 instanceof AbstractButton)) {
            throw new IllegalArgumentException("AbstractButton only.");
        }
        return (AbstractButton)b2;
    }

    protected static Vector buttons(Vector v2) {
        Iterator i2 = v2.iterator();
        while (i2.hasNext()) {
            ComboButton.button(i2.next());
        }
        return v2;
    }

    public static void main(String[] argv) {
        try {
            UIManager.setLookAndFeel(System.getProperty("laf", "com.ge.med.ptk.laf.CuiLookAndFeel"));
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        JFrame frame = new JFrame();
        frame.setDefaultCloseOperation(3);
        frame.getContentPane().setLayout(new BorderLayout());
        JPanel top = new JPanel(new FlowLayout());
        top.setBorder(new EmptyBorder(10, 10, 10, 10));
        top.add(new ComboButton(new AbstractButton[]{new JButton("One"), new JButton("Two"), new JButton("Three"), new JButton("Four"), new JButton("Five"), new JButton("Six"), new JButton("Seven"), new JButton("Eight")}));
        frame.getContentPane().add(top);
        frame.pack();
        frame.setVisible(true);
    }

    protected static class ButtonPanelCBE
    extends JPanel
    implements ComboBoxEditor {
        public ButtonPanelCBE() {
            super(new CardLayout());
        }

        @Override
        public Component getEditorComponent() {
            return this;
        }

        @Override
        public Object getItem() {
            return null;
        }

        @Override
        public void setItem(Object o2) {
        }

        @Override
        public void selectAll() {
        }

        @Override
        public void addActionListener(ActionListener l2) {
        }

        @Override
        public void removeActionListener(ActionListener l2) {
        }
    }

    protected static class ComboButtonCBM
    extends DefaultComboBoxModel {
        protected Object dummy_;

        protected Object getDummy() {
            return this.dummy_ == null ? (this.dummy_ = new JButton(" ")) : this.dummy_;
        }

        public ComboButtonCBM(Vector items) {
            super(ComboButton.buttons(items));
        }

        public ComboButtonCBM(Object[] items) {
            super(ComboButton.buttons(new Vector<Object>(Arrays.asList(items))));
        }

        @Override
        public int getSize() {
            return Math.max(1, super.getSize());
        }

        @Override
        public Object getSelectedItem() {
            Object o2 = super.getSelectedItem();
            return o2 != null ? o2 : this.getDummy();
        }

        @Override
        public Object getElementAt(int i2) {
            Object o2 = super.getElementAt(i2);
            return o2 != null || i2 > 0 ? o2 : this.getDummy();
        }

        @Override
        public void addElement(Object o2) {
            super.addElement(ComboButton.button(o2));
            if (this.getSize() == 1) {
                this.setSelectedItem(o2);
            }
        }

        @Override
        public void insertElementAt(Object o2, int i2) {
            super.insertElementAt(ComboButton.button(o2), i2);
            if (this.getSize() == 1) {
                this.setSelectedItem(o2);
            }
        }
    }
}

