/*
 * Decompiled with CFR 0.152.
 */
package com.ge.med.terra.xpv.ui;

import com.ge.med.terra.xpv.base.XPscreen;
import com.ge.med.terra.xpv.base.XPscreenLayout;
import com.ge.med.terra.xpv.util.DTPicture;
import com.ge.med.terra.xpv.util.PortTransferable;
import com.ge.med.terra.xpv.util.SerializablePort;
import java.awt.Color;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Insets;
import java.awt.datatransfer.Clipboard;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.Transferable;
import java.awt.dnd.DragSource;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ContainerEvent;
import java.awt.event.ContainerListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.Timer;
import javax.swing.TransferHandler;
import javax.swing.border.Border;

public class DragDropScreenPanel
extends JPanel {
    JComponent[] pport = new JComponent[0];
    private int selectedPortNumber = 0;
    ImageTransferHandler handler = new ImageTransferHandler();
    int clickedPortNo = -1;
    XPscreen screenToControl = null;
    private ContainerListener containerListener = new ContainerListener(){

        @Override
        public void componentAdded(ContainerEvent e2) {
            for (int i2 = 0; i2 < DragDropScreenPanel.this.pport.length; ++i2) {
                ((DTPicture)DragDropScreenPanel.this.pport[i2]).setComponent(DragDropScreenPanel.this.screenToControl.getPort(i2));
                if (DragDropScreenPanel.this.screenToControl.getPort(i2) instanceof XPscreen.EmptyPort) {
                    ((DTPicture)DragDropScreenPanel.this.pport[i2]).setEmpty(true);
                    DragDropScreenPanel.this.pport[i2].repaint();
                    continue;
                }
                ((DTPicture)DragDropScreenPanel.this.pport[i2]).setEmpty(false);
                DragDropScreenPanel.this.pport[i2].repaint();
            }
        }

        @Override
        public void componentRemoved(ContainerEvent e2) {
            for (int i2 = 0; i2 < DragDropScreenPanel.this.pport.length; ++i2) {
                ((DTPicture)DragDropScreenPanel.this.pport[i2]).setComponent(DragDropScreenPanel.this.screenToControl.getPort(i2));
                if (DragDropScreenPanel.this.screenToControl.getPort(i2) instanceof XPscreen.EmptyPort) {
                    ((DTPicture)DragDropScreenPanel.this.pport[i2]).setEmpty(true);
                    continue;
                }
                ((DTPicture)DragDropScreenPanel.this.pport[i2]).setEmpty(false);
                DragDropScreenPanel.this.pport[i2].repaint();
            }
        }
    };
    private PropertyChangeListener viewPortListener = new PropertyChangeListener(){

        @Override
        public void propertyChange(PropertyChangeEvent evt) {
            for (int i2 = 0; i2 < DragDropScreenPanel.this.pport.length; ++i2) {
                ((DTPicture)DragDropScreenPanel.this.pport[i2]).setComponent(DragDropScreenPanel.this.screenToControl.getPort(i2));
                if (DragDropScreenPanel.this.screenToControl.getPort(i2) instanceof XPscreen.EmptyPort) {
                    ((DTPicture)DragDropScreenPanel.this.pport[i2]).setEmpty(true);
                    continue;
                }
                ((DTPicture)DragDropScreenPanel.this.pport[i2]).setEmpty(false);
            }
        }
    };

    public DragDropScreenPanel() {
        try {
            this.jbInit();
        }
        catch (Exception e2) {
            e2.printStackTrace();
        }
    }

    private void jbInit() throws Exception {
        this.setBackground(Color.black);
        this.setOpaque(false);
        this.setPreferredSize(new Dimension(150, 150));
        this.setSelectedPortNumber(0);
    }

    public int getSelectedPortNumber() {
        return this.selectedPortNumber;
    }

    public JComponent getPort(int n2) {
        if (n2 < 0 || n2 >= this.pport.length) {
            return null;
        }
        return this.pport[n2];
    }

    public JComponent getSelectedPort() {
        if (this.selectedPortNumber < 0 || this.selectedPortNumber >= this.pport.length) {
            return null;
        }
        return this.pport[this.selectedPortNumber];
    }

    public void setLayout(XPscreenLayout layout) {
        int i2;
        if (this.screenToControl == null) {
            return;
        }
        int len = this.screenToControl.getNumPorts();
        if (len > this.pport.length) {
            JComponent[] tmp = new JComponent[len];
            System.arraycopy(this.pport, 0, tmp, 0, this.pport.length);
            for (int i3 = this.pport.length; i3 < len; ++i3) {
                DTPicture pic = new DTPicture();
                if (this.screenToControl != null && this.screenToControl.getPort(i3) != null && this.screenToControl.getPort(i3) instanceof XPscreen.EmptyPort) {
                    pic.setEmpty(true);
                    pic.setComponent(this.screenToControl.getPort(i3));
                }
                pic.setTransferHandler(this.handler);
                pic.setPortNo(i3);
                this.addPort(pic, i3);
            }
        }
        super.setLayout(layout);
        if (this.getSelectedPortNumber() >= layout.getNoOfPorts()) {
            this.setSelectedPortNumber(0);
        }
        for (i2 = 0; i2 < len; ++i2) {
            this.pport[i2].setVisible(true);
        }
        if (this.screenToControl != null) {
            for (i2 = 0; i2 < this.pport.length; ++i2) {
                ((DTPicture)this.pport[i2]).setComponent(this.screenToControl.getPort(i2));
            }
        }
    }

    public void setSelectedPortNumber(int selectedPort) {
        int oldSelectedPortNumber = this.selectedPortNumber;
        this.selectedPortNumber = selectedPort;
        this.repaint();
    }

    public JComponent getClickedPort() {
        if (this.clickedPortNo >= 0) {
            return this.pport[this.clickedPortNo];
        }
        return null;
    }

    public void addPort(JComponent comp, int index) {
        if (this.pport.length <= index) {
            JComponent[] port = new JComponent[index + 1];
            System.arraycopy(this.pport, 0, port, 0, this.pport.length);
            for (int i2 = this.pport.length; i2 <= index; ++i2) {
                port[i2] = new XPscreen.EmptyPort();
                this.add(port[i2]);
            }
            this.pport = port;
        }
        this.pport[index].setVisible(false);
        this.remove(this.pport[index]);
        this.pport[index] = comp;
        this.add((Component)comp, index);
        comp.setVisible(true);
        comp.setBorder(new Border(){

            @Override
            public Insets getBorderInsets(Component c2) {
                return new Insets(2, 2, 2, 2);
            }

            @Override
            public boolean isBorderOpaque() {
                return true;
            }

            @Override
            public void paintBorder(Component c2, Graphics g2, int x2, int y2, int w2, int h2) {
                Graphics2D g2d = (Graphics2D)g2;
                g2.setColor(Color.lightGray);
                g2.drawRect(x2 + 0, y2 + 0, (int)((double)c2.getWidth() / g2d.getTransform().getScaleX() - 1.0), (int)((double)c2.getHeight() / g2d.getTransform().getScaleY() - 1.0));
            }
        });
    }

    public JComponent[] getPorts() {
        return this.pport;
    }

    public void switchPort(int num1, int num2) {
        JComponent sPort;
        JComponent fPort = this.getPort(num1);
        this.pport[num1] = sPort = this.getPort(num2);
        this.pport[num2] = fPort;
        this.removeAll();
        for (int i2 = 0; i2 < this.pport.length; ++i2) {
            this.add((Component)this.pport[i2], i2);
        }
        this.revalidate();
        this.screenToControl.switchPort(num1, num2);
    }

    public void setScreenToControl(XPscreen scr) {
        this.screenToControl = scr;
        this.screenToControl.addPropertyChangeListener(this.viewPortListener);
        this.screenToControl.addContainerListener(this.containerListener);
    }

    public int getNumPortShown() {
        return ((XPscreenLayout)this.screenToControl.getLayout()).getNoOfPorts();
    }

    public int getNumPort() {
        return this.pport.length;
    }

    public class ImageTransferHandler
    extends TransferHandler {
        DataFlavor pictureFlavor = PortTransferable.PortFlavor;
        DTPicture sourcePic;
        DTPicture destPic;
        boolean copied = false;
        Timer tm;

        @Override
        public boolean canImport(JComponent c2, DataFlavor[] flavors) {
            for (int i2 = 0; i2 < flavors.length; ++i2) {
                if (!this.pictureFlavor.equals(flavors[i2])) continue;
                return true;
            }
            return false;
        }

        @Override
        public boolean importData(JComponent c2, Transferable t2) {
            if (this.tm != null) {
                this.copied = false;
                DragDropScreenPanel.this.setCursor(Cursor.getPredefinedCursor(0));
                this.tm.stop();
                this.tm = null;
            }
            if (t2.isDataFlavorSupported(this.pictureFlavor)) {
                this.destPic = (DTPicture)c2;
                try {
                    SerializablePort port = (SerializablePort)t2.getTransferData(this.pictureFlavor);
                    this.sourcePic = (DTPicture)DragDropScreenPanel.this.getPort(port.getPort().getPortNo());
                }
                catch (Exception ex) {
                    ex.printStackTrace();
                }
                if (this.sourcePic == this.destPic) {
                    return true;
                }
                if (this.sourcePic != null && this.destPic != null) {
                    DragDropScreenPanel.this.switchPort(this.sourcePic.getPortNo(), this.destPic.getPortNo());
                    int sourceNo = this.sourcePic.getPortNo();
                    this.sourcePic.setPortNo(this.destPic.getPortNo());
                    this.destPic.setPortNo(sourceNo);
                    DragDropScreenPanel.this.revalidate();
                }
                return true;
            }
            return false;
        }

        @Override
        protected Transferable createTransferable(JComponent c2) {
            this.sourcePic = (DTPicture)c2;
            return new PortTransferable(this.sourcePic);
        }

        @Override
        public int getSourceActions(JComponent c2) {
            return 3;
        }

        @Override
        protected void exportDone(JComponent c2, Transferable data, int action) {
            this.sourcePic = null;
            this.destPic = null;
            DragDropScreenPanel.this.revalidate();
        }

        @Override
        public void exportToClipboard(JComponent comp, Clipboard clip, int action) {
            if (!this.copied) {
                int clipboardAction;
                boolean exportSuccess = false;
                Transferable t2 = null;
                if (this.tm != null) {
                    this.tm.stop();
                    this.tm = null;
                }
                if ((clipboardAction = this.getSourceActions(comp) & action) != 0 && (t2 = this.createTransferable(comp)) != null) {
                    clip.setContents(t2, null);
                    exportSuccess = true;
                }
                DragDropScreenPanel.this.setCursor(DragSource.DefaultMoveDrop);
                this.sourcePic = (DTPicture)comp;
                this.copied = true;
                this.tm = new Timer(5000, new ActionListener(){

                    @Override
                    public void actionPerformed(ActionEvent e2) {
                        ImageTransferHandler.this.copied = false;
                        DragDropScreenPanel.this.setCursor(Cursor.getPredefinedCursor(0));
                        ImageTransferHandler.this.tm = null;
                    }
                });
                this.tm.start();
            } else {
                DragDropScreenPanel.this.setCursor(Cursor.getPredefinedCursor(0));
                this.importData(comp, clip.getContents(null));
                this.sourcePic = null;
                this.destPic = null;
                this.copied = false;
            }
        }
    }
}

