/*
 * Decompiled with CFR 0.152.
 */
package com.ge.med.terra.xpv.ui;

import com.ge.med.ptk.laf.CuiLookAndFeel;
import com.ge.med.ptk.laf.CuiSliderUI;
import java.awt.Dimension;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.image.BufferedImage;
import javax.swing.BoundedRangeModel;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JSlider;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.swing.UnsupportedLookAndFeelException;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;

public class NumberedThumbSlider
extends JSlider {
    BufferedImage im;

    public NumberedThumbSlider() {
        this.myinit();
    }

    private void myinit() {
        this.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent e2) {
                NumberedThumbSlider.this.repaint();
            }
        });
    }

    public NumberedThumbSlider(BoundedRangeModel brm) {
        super(brm);
        this.myinit();
    }

    public NumberedThumbSlider(int orientation, int min, int max, int value) {
        super(orientation, min, max, value);
        this.myinit();
    }

    public NumberedThumbSlider(int min, int max, int value) {
        super(min, max, value);
        this.myinit();
    }

    public NumberedThumbSlider(int min, int max) {
        super(min, max);
        this.myinit();
    }

    public NumberedThumbSlider(int orientation) {
        super(orientation);
        this.myinit();
    }

    @Override
    public void updateUI() {
        this.setUI(new NumberedThumbSliderUI());
        this.updateLabelUIs();
    }

    public Rectangle getThumbRect() {
        return ((NumberedThumbSliderUI)this.getUI()).getThumbRect();
    }

    @Override
    public void paint(Graphics g2) {
        int w2 = this.getWidth();
        int h2 = this.getHeight();
        if (this.im == null || this.im.getWidth() != w2 || this.im.getHeight() != h2) {
            this.im = new BufferedImage(w2, h2, 2);
        }
        Graphics2D g22 = this.im.createGraphics();
        super.paint(g22);
        Rectangle rect = this.getThumbRect();
        g22.setRenderingHint(RenderingHints.KEY_TEXT_ANTIALIASING, RenderingHints.VALUE_TEXT_ANTIALIAS_ON);
        FontMetrics fm = g22.getFontMetrics();
        String valString = "" + this.getValue();
        int sw = fm.stringWidth(valString);
        if (this.orientation == 0) {
            g22.drawString(valString, rect.x + (rect.width - sw >> 1) + 1, rect.y);
        } else {
            g22.drawString(valString, rect.x + rect.width + 1, rect.y + rect.height - 1 - (rect.height - fm.getHeight() >> 1));
        }
        g22.dispose();
        g2.drawImage(this.im, 0, 0, null);
    }

    @Override
    public Dimension getPreferredSize() {
        Dimension dim = super.getPreferredSize();
        JLabel l2 = new JLabel("" + this.getValue());
        dim.height += l2.getPreferredSize().height + 5;
        dim.width += l2.getPreferredSize().width + 5;
        return dim;
    }

    public Dimension getMininumSize() {
        return this.getPreferredSize();
    }

    public static void main(String[] args) {
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                try {
                    UIManager.setLookAndFeel(new CuiLookAndFeel());
                }
                catch (UnsupportedLookAndFeelException e2) {
                    e2.printStackTrace();
                }
                JFrame f2 = new JFrame();
                f2.setContentPane(new NumberedThumbSlider(0));
                f2.pack();
                f2.setDefaultCloseOperation(3);
                f2.setVisible(true);
            }
        });
    }

    class NumberedThumbSliderUI
    extends CuiSliderUI {
        NumberedThumbSliderUI() {
        }

        public Rectangle getThumbRect() {
            return this.thumbRect;
        }
    }
}

