/*
 * Decompiled with CFR 0.152.
 */
package com.ge.med.terra.xpv.ui;

import com.ge.med.ptk.laf.CuiComboBoxUI;
import com.ge.med.ptk.laf.CuiLookAndFeel;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Insets;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionAdapter;
import java.awt.event.MouseMotionListener;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import javax.swing.ComboBoxModel;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JFrame;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.ListCellRenderer;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.swing.border.EmptyBorder;
import javax.swing.event.ListDataEvent;
import javax.swing.event.ListDataListener;
import javax.swing.plaf.ComponentUI;
import javax.swing.plaf.ListUI;
import javax.swing.plaf.basic.BasicComboBoxRenderer;
import javax.swing.plaf.basic.ComboPopup;

public class RowColumnCombo
extends JComboBox {
    public Dimension getValue() {
        return ((RowColumnComboBoxModel)this.getModel()).getSelected();
    }

    public void setValue(Dimension value) {
        ((RowColumnComboBoxModel)this.getModel()).setSelected(value);
    }

    public RowColumnCombo(Dimension dimension) {
        super(new RowColumnComboBoxModel(dimension));
    }

    public RowColumnCombo() {
        this(new Dimension(1, 1));
        Object obj = this.getClientProperty("ComboBox.button");
        if (obj instanceof JButton) {
            ((JButton)obj).setFocusable(false);
        }
    }

    @Override
    public String getUIClassID() {
        return "RowColumnComboUI";
    }

    public static void main(String[] argv) {
        try {
            UIManager.setLookAndFeel(new CuiLookAndFeel());
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        EmptyBorder border = new EmptyBorder(8, 8, 8, 8);
        Dimension size = new Dimension(120, 36);
        JFrame f2 = new JFrame("outside edge only");
        f2.setDefaultCloseOperation(3);
        JPanel p2 = new JPanel(new BorderLayout());
        p2.setBorder(border);
        RowColumnCombo c2 = new RowColumnCombo();
        c2.setPreferredSize(size);
        c2.setEditable(false);
        p2.add(c2);
        f2.setContentPane(p2);
        f2.pack();
        f2.setVisible(true);
        c2.setFocusable(false);
    }

    static {
        UIManager.put("RowColumnComboUI", RowColumnComboUI.class.getName());
        UIManager.put("RowColumnComboListUI", RowColumnComboListUI.class.getName());
    }

    public static class RowColumnComboUI
    extends CuiComboBoxUI {
        public static ComponentUI createUI(JComponent c2) {
            return new RowColumnComboUI();
        }

        @Override
        protected ListCellRenderer createRenderer() {
            return new BasicComboBoxRenderer.UIResource(){

                @Override
                public Component getListCellRendererComponent(JList list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
                    super.getListCellRendererComponent((JList<?>)list, value, index, index >= 0 && isSelected, cellHasFocus);
                    this.setOpaque(index >= 0);
                    this.setEnabled(RowColumnComboUI.this.comboBox.isEnabled());
                    this.setHorizontalAlignment(0);
                    this.setBorder(new EmptyBorder(0, index >= 0 ? 2 : 0, 0, index >= 0 ? 2 : 0));
                    if (value instanceof Dimension) {
                        this.setText("" + ((Dimension)value).width + " x " + ((Dimension)value).height);
                    }
                    return this;
                }
            };
        }

        @Override
        protected ComboPopup createPopup() {
            return new CuiComboBoxUI.CuiComboPopup(this.comboBox){

                @Override
                protected MouseListener createMouseListener() {
                    return new MouseAdapter(){

                        @Override
                        public void mousePressed(MouseEvent e2) {
                            if (!SwingUtilities.isLeftMouseButton(e2) || !comboBox.isEnabled()) {
                                return;
                            }
                            if (comboBox.isEditable()) {
                                Component comp = comboBox.getEditor().getEditorComponent();
                                if (!(comp instanceof JComponent) || ((JComponent)comp).isRequestFocusEnabled()) {
                                    comp.requestFocus();
                                }
                            } else if (comboBox.isRequestFocusEnabled()) {
                                comboBox.requestFocus();
                            }
                            this.togglePopup();
                        }

                        @Override
                        public void mouseReleased(MouseEvent e2) {
                            Component source = (Component)e2.getSource();
                            Dimension size = source.getSize();
                            Rectangle bounds = new Rectangle(0, 0, size.width - 1, size.height - 1);
                            if (!bounds.contains(e2.getPoint())) {
                                MouseEvent newEvent = this.convertMouseEvent(e2);
                                Point location = newEvent.getPoint();
                                Rectangle r2 = new Rectangle();
                                list.computeVisibleRect(r2);
                                if (r2.contains(location)) {
                                    comboBox.setSelectedIndex(list.getSelectedIndex());
                                }
                                comboBox.setPopupVisible(false);
                            }
                            hasEntered = false;
                            this.stopAutoScrolling();
                        }
                    };
                }

                @Override
                protected MouseMotionListener createMouseMotionListener() {
                    return new MouseMotionAdapter(){

                        @Override
                        public void mouseDragged(MouseEvent e2) {
                            if (!this.isVisible()) {
                                return;
                            }
                            MouseEvent newEvent = this.convertMouseEvent(e2);
                            Rectangle r2 = new Rectangle();
                            list.computeVisibleRect(r2);
                            if (newEvent.getPoint().y >= r2.y && newEvent.getPoint().y <= r2.y + r2.height - 1) {
                                Point location;
                                hasEntered = true;
                                if (isAutoScrolling) {
                                    this.stopAutoScrolling();
                                }
                                if (r2.contains(location = newEvent.getPoint())) {
                                    this.updateListBoxSelectionForEvent(newEvent, false);
                                }
                            } else if (hasEntered) {
                                int directionToScroll;
                                int n2 = directionToScroll = newEvent.getPoint().y < r2.y ? 0 : 1;
                                if (isAutoScrolling && scrollDirection != directionToScroll) {
                                    this.stopAutoScrolling();
                                    this.startAutoScrolling(directionToScroll);
                                } else if (!isAutoScrolling) {
                                    this.startAutoScrolling(directionToScroll);
                                }
                            } else if (e2.getPoint().y < 0) {
                                hasEntered = true;
                                this.startAutoScrolling(0);
                            }
                        }
                    };
                }

                @Override
                protected void startAutoScrolling(int i2) {
                }

                protected JList createList() {
                    return new JList(this.comboBox.getModel()){

                        @Override
                        public String getUIClassID() {
                            return "RowColumnComboListUI";
                        }

                        @Override
                        public void setSelectedIndex(int index) {
                            RowColumnComboBoxModel model = (RowColumnComboBoxModel)this.getModel();
                            Dimension shown = model.getDimension();
                            Dimension actual = (Dimension)model.getElementAt(index);
                            shown = new Dimension(Math.min(8, Math.max(3, actual.width + 1)), Math.min(8, Math.max(3, actual.height + 1)));
                            model.setDimension(shown);
                            index = (actual.height - 1) * shown.width + actual.width - 1;
                            super.setSelectedIndex(index);
                            this.repaint();
                        }
                    };
                }

                @Override
                protected JScrollPane createScroller() {
                    return new JScrollPane(this.list, 21, 31){};
                }
            };
        }
    }

    public static class RowColumnComboListUI
    extends ListUI {
        public static ComponentUI createUI(JComponent c2) {
            return new RowColumnComboListUI();
        }

        @Override
        public Dimension getPreferredSize(JComponent c2) {
            return new Dimension(40, 40);
        }

        public Rectangle getCellBounds(JList list, int index1, int index2) {
            RowColumnComboBoxModel model = (RowColumnComboBoxModel)list.getModel();
            Dimension shown = model.getDimension();
            Dimension s2 = list.getSize();
            Insets i2 = list.getInsets();
            double[] cellSize = new double[]{(double)(s2.width - (i2.left + i2.right)) / (double)shown.width, (double)(s2.height - (i2.top + i2.bottom)) / (double)shown.height};
            int index = Math.max(index1, index2);
            int r2 = index / shown.width;
            int c2 = index % shown.width;
            return new Rectangle((int)Math.round((double)c2 * cellSize[0]), (int)Math.round((double)r2 * cellSize[1]), (int)Math.round((double)(c2 + 1) * cellSize[0]), (int)Math.round((double)(r2 + 1) * cellSize[1]));
        }

        public Point indexToLocation(JList list, int index) {
            return this.getCellBounds(list, index, index).getLocation();
        }

        public int locationToIndex(JList list, Point location) {
            RowColumnComboBoxModel model = (RowColumnComboBoxModel)list.getModel();
            Dimension shown = model.getDimension();
            Dimension s2 = list.getSize();
            Insets i2 = list.getInsets();
            double[] cellSize = new double[]{(double)(s2.width - (i2.left + i2.right)) / (double)shown.width, (double)(s2.height - (i2.top + i2.bottom)) / (double)shown.height};
            int c2 = (int)Math.floor((double)(location.x - i2.left) / cellSize[0]);
            int r2 = (int)Math.floor((double)(location.y - i2.top) / cellSize[1]);
            return r2 * shown.width + c2;
        }

        @Override
        public void paint(Graphics g2, JComponent component) {
            JList list = (JList)component;
            RowColumnComboBoxModel model = (RowColumnComboBoxModel)list.getModel();
            Dimension shown = model.getDimension();
            Dimension actual = (Dimension)list.getSelectedValue();
            Dimension s2 = list.getSize();
            Insets i2 = list.getInsets();
            double[] cellSize = new double[]{(double)(s2.width - (i2.left + i2.right)) / (double)shown.width, (double)(s2.height - (i2.top + i2.bottom)) / (double)shown.height};
            for (int r2 = 0; r2 < shown.height; ++r2) {
                for (int c2 = 0; c2 < shown.width; ++c2) {
                    g2.setColor(UIManager.getColor(r2 < actual.height && c2 < actual.width ? "P9" : "P5"));
                    g2.fillRect((int)Math.round((double)c2 * cellSize[0]), (int)Math.round((double)r2 * cellSize[1]), (int)Math.round((double)(c2 + 1) * cellSize[0]), (int)Math.round((double)(r2 + 1) * cellSize[1]));
                    g2.setColor(Color.white);
                    g2.drawRect((int)Math.round((double)c2 * cellSize[0]), (int)Math.round((double)r2 * cellSize[1]), (int)Math.round((double)(c2 + 1) * cellSize[0]), (int)Math.round((double)(r2 + 1) * cellSize[1]));
                }
            }
        }
    }

    public static class RowColumnComboBoxModel
    implements ComboBoxModel {
        protected Dimension selected_ = new Dimension(1, 1);
        protected Dimension dimension_ = new Dimension(2, 2);
        protected List listeners_ = new ArrayList();

        public RowColumnComboBoxModel(Dimension dimension) {
            this.selected_ = new Dimension(dimension.width, dimension.height);
            this.dimension_ = new Dimension(dimension.width + 1, dimension.height + 1);
        }

        public RowColumnComboBoxModel() {
            this(new Dimension(1, 1));
        }

        public Dimension getSelected() {
            return this.selected_;
        }

        public void setSelected(Dimension selected) {
            this.selected_ = new Dimension(selected.width, selected.height);
            if (this.selected_.width > this.dimension_.width || this.selected_.height > this.dimension_.height) {
                this.dimension_ = new Dimension(Math.max(this.selected_.width, this.dimension_.width), Math.max(this.selected_.height, this.dimension_.height));
            }
            this.fireListDataChanged();
        }

        public Dimension getDimension() {
            return this.dimension_;
        }

        public void setDimension(Dimension dimension) {
            this.dimension_ = new Dimension(dimension.width, dimension.height);
            if (this.selected_.width > this.dimension_.width || this.selected_.height > this.dimension_.height) {
                this.selected_ = new Dimension(Math.min(this.selected_.width, this.dimension_.width), Math.min(this.selected_.height, this.dimension_.height));
            }
            this.fireListDataChanged();
        }

        @Override
        public Object getSelectedItem() {
            return this.selected_;
        }

        @Override
        public void setSelectedItem(Object anItem) {
            if (anItem instanceof Dimension) {
                this.setSelected((Dimension)anItem);
            }
        }

        @Override
        public int getSize() {
            return this.dimension_.width * this.dimension_.height;
        }

        @Override
        public Object getElementAt(int index) {
            return new Dimension(index % this.dimension_.width + 1, index / this.dimension_.width + 1);
        }

        @Override
        public void addListDataListener(ListDataListener l2) {
            this.listeners_.add(l2);
        }

        @Override
        public void removeListDataListener(ListDataListener l2) {
            this.listeners_.remove(l2);
        }

        protected void fireListDataChanged() {
            ListDataEvent event = new ListDataEvent(this, 0, 0, this.getSize() - 1);
            Iterator i2 = this.listeners_.iterator();
            while (i2.hasNext()) {
                ((ListDataListener)i2.next()).contentsChanged(event);
            }
        }
    }
}

