/*
 * Decompiled with CFR 0.152.
 */
package com.ge.med.terra.xpv.ui;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;

public class WindowLevelModel {
    protected double windowMin;
    protected double windowMax;
    protected double rangeMin;
    protected double rangeMax;
    protected List listeners_ = new ArrayList();

    public WindowLevelModel(double wMin, double wMax, double rMin, double rMax) {
        this.windowMax = wMax;
        this.windowMin = wMin;
        this.rangeMax = rMax;
        this.rangeMin = rMin;
    }

    public WindowLevelModel() {
        this(0.0, 0.0, 100.0, 100.0);
    }

    public double getWindowMin() {
        return this.windowMin;
    }

    public void setWindowMin(double wMin) {
        this.set(wMin, Math.max(wMin, this.windowMax), Math.min(wMin, this.rangeMin), Math.max(wMin, this.rangeMax));
    }

    public double getWindowMax() {
        return this.windowMax;
    }

    public void setWindowMax(double wMax) {
        this.set(Math.min(wMax, this.windowMin), wMax, Math.min(wMax, this.rangeMin), Math.max(wMax, this.rangeMax));
    }

    public double getRangeMin() {
        return this.rangeMin;
    }

    public void setRangeMin(double rMin) {
        this.set(Math.max(this.windowMin, rMin), Math.max(rMin, this.windowMax), rMin, Math.max(rMin, this.rangeMax));
    }

    public double getRangeMax() {
        return this.rangeMax;
    }

    public void setRangeMax(double rMax) {
        this.set(Math.min(rMax, this.rangeMin), Math.min(rMax, this.windowMax), Math.min(rMax, this.rangeMin), rMax);
    }

    protected void set(double wMin, double wMax, double rMin, double rMax) {
        double getWindowMin = this.getWindowMin();
        double getWindowMax = this.getWindowMax();
        double getRangeMin = this.getRangeMin();
        double getRangeMax = this.getRangeMax();
        this.windowMin = wMin;
        this.windowMax = wMax;
        this.rangeMin = rMin;
        this.rangeMax = rMax;
        if (getWindowMin != this.getWindowMin() || getWindowMax != this.getWindowMax() || getRangeMin != this.getRangeMin() || getRangeMax != this.getRangeMax()) {
            this.fireStateChanged();
        }
    }

    public void addChangeListener(ChangeListener l2) {
        this.listeners_.add(l2);
    }

    public void removeChangeListener(ChangeListener l2) {
        this.listeners_.remove(l2);
    }

    protected void fireStateChanged() {
        ChangeEvent event = new ChangeEvent(this);
        Iterator i2 = this.listeners_.iterator();
        while (i2.hasNext()) {
            ((ChangeListener)i2.next()).stateChanged(event);
        }
    }
}

