/*
 * Decompiled with CFR 0.152.
 */
package com.ge.med.terra.xpv.util;

import com.ge.med.terra.jami.capable.AnnotCapable;
import com.ge.med.terra.xpv.util.FactoryPreferenceCapble;

public class DisplayAnnotPrefUtils {
    private static final String[] mr_groups = new String[]{"Hospital_Name", "Patient_Name", "Patient_Id", "ESI_Information", "Scan_Time", "Scan_Parameters", "Thick_Space", "Top_Marker", "Bottom_Marker", "Left_Marker", "Right_Marker", "System_Name", "Scan_Date", "Scan_bottom", "geometry", "Date_Of_Birth", "Accession_Number", "Windowing", "Graphic_Results"};
    private static final String[] ct_groups = new String[]{"Hospital_Name", "Patient_Name", "Patient_Id", "ESI_Information", "Scan_Time", "Scan_Parameters", "View_Parameters", "Top_Marker", "Bottom_Marker", "Left_Marker", "Right_Marker", "System_Name", "Scan_Date", "Display_Parameters", "Filter", "Date_Of_Birth", "Accession_Number", "Windowing", "Graphic Annotation"};

    public static int getCustomAnnotationGroupMask(int group) {
        return 1 << group;
    }

    public static String[] getCustomAnnotationGroups(String modality) {
        if (modality == null) {
            return null;
        }
        if (modality.trim().equalsIgnoreCase("mr")) {
            return mr_groups;
        }
        if (modality.trim().equalsIgnoreCase("ct")) {
            return ct_groups;
        }
        return null;
    }

    public static boolean queryScreenCustomAnnotationGroup(int group) {
        int customMask;
        int groupMask = DisplayAnnotPrefUtils.getCustomAnnotationGroupMask(group);
        return (groupMask & (customMask = FactoryPreferenceCapble.getInstance().getScreenCustomAnnotationLevel())) != 0;
    }

    public static boolean queryFilmCustomAnnotationGroup(int group) {
        int customMask;
        int groupMask = DisplayAnnotPrefUtils.getCustomAnnotationGroupMask(group);
        return (groupMask & (customMask = FactoryPreferenceCapble.getInstance().getFilmCustomAnnotationLevel())) != 0;
    }

    public static void setAnnotLevel(AnnotCapable port, String level) {
        if (!level.equals("custom")) {
            String[] items = port.getAnnotationItems();
            if (items != null && items.length != 0) {
                port.setAnnotationItems(items, false);
            }
            items = null;
            items = port.getAnnotationItems(level);
            if (items != null && items.length != 0) {
                port.setAnnotationItems(items, true);
            }
        }
    }

    public static void setCustomAnnotItems(AnnotCapable port, String[] groups) {
        String[] items = port.getAnnotationItems();
        if (items != null && items.length != 0) {
            port.setAnnotationItems(items, false);
        }
        if (groups != null) {
            for (int i2 = 0; i2 < groups.length; ++i2) {
                port.setAnnotationItems(new String[]{groups[i2]}, true);
            }
        }
    }

    public static void setCustomAnnotItems(AnnotCapable port, String modality, int mask) {
        String[] items = port.getAnnotationItems();
        if (items != null && items.length != 0) {
            port.setAnnotationItems(items, false);
        }
        if ((items = DisplayAnnotPrefUtils.getCustomAnnotationGroups(modality)) != null) {
            for (int i2 = 0; i2 < items.length; ++i2) {
                int groupMask = DisplayAnnotPrefUtils.getCustomAnnotationGroupMask(i2);
                boolean selected = (groupMask & mask) != 0;
                port.setAnnotationItems(new String[]{items[i2]}, selected);
            }
        }
    }
}

