/*
 * Decompiled with CFR 0.152.
 */
package com.ge.med.terra.xpv.util;

import com.ge.med.terra.tap.dm.DMElement;
import com.ge.med.terra.tap.dm.DMObject;
import com.ge.med.terra.tap.dm.DMSession;
import com.ge.med.terra.tap.dm.DMTag;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.text.DecimalFormat;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Arrays;
import java.util.Comparator;
import java.util.HashMap;
import java.util.StringTokenizer;

public class MRDicomInfo {
    private HashMap valueMap;
    private DMObject dmo;
    private String ieLevel;
    private static DMTag[] headerTags = new DMTag[]{new DMTag(8, 8), new DMTag(8, 22), new DMTag(8, 34), new DMTag(8, 35), new DMTag(8, 51), new DMTag(8, 65), new DMTag(8, 80), new DMTag(8, 112), new DMTag(8, 144), new DMTag(8, 4144), new DMTag(8, 4158), new DMTag(8, 4192), new DMTag(8, 4208), new DMTag(8, 4240), new DMTag(9, 16), new DMTag(9, 4100), new DMTag(9, 4122), new DMTag(16, 16), new DMTag(16, 32), new DMTag(16, 48), new DMTag(16, 64), new DMTag(16, 4144), new DMTag(16, 4161), new DMTag(16, 8624), new DMTag(24, 16), new DMTag(24, 32), new DMTag(24, 33), new DMTag(24, 34), new DMTag(24, 80), new DMTag(24, 128), new DMTag(24, 129), new DMTag(24, 130), new DMTag(24, 132), new DMTag(24, 133), new DMTag(24, 135), new DMTag(24, 136), new DMTag(24, 148), new DMTag(24, 4128), new DMTag(24, 4160), new DMTag(24, 4192), new DMTag(24, 4194), new DMTag(24, 4352), new DMTag(24, 4688), new DMTag(24, 4880), new DMTag(24, 4884), new DMTag(24, 20736), new DMTag(25, 16), new DMTag(25, 25), new DMTag(25, 4119), new DMTag(25, 4120), new DMTag(25, 4121), new DMTag(25, 4122), new DMTag(25, 4123), new DMTag(25, 4126), new DMTag(25, 4234), new DMTag(25, 4235), new DMTag(25, 4239), new DMTag(25, 4260), new DMTag(25, 4288), new DMTag(25, 4302), new DMTag(25, 4313), new DMTag(25, 4345), new DMTag(32, 16), new DMTag(32, 17), new DMTag(32, 19), new DMTag(32, 50), new DMTag(32, 55), new DMTag(32, 4160), new DMTag(32, 4161), new DMTag(33, 16), new DMTag(33, 4184), new DMTag(33, 4189), new DMTag(39, 16), new DMTag(39, 4146), new DMTag(39, 4147), new DMTag(39, 4149), new DMTag(39, 4150), new DMTag(39, 4160), new DMTag(39, 4192), new DMTag(39, 4193), new DMTag(39, 4194), new DMTag(40, 16), new DMTag(40, 17), new DMTag(40, 48), new DMTag(67, 16), new DMTag(67, 4097), new DMTag(67, 4148), new DMTag(67, 4153), new DMTag(67, 4207), new DMTag(67, 4223)};
    protected Comparator comp = new Comparator(){

        public int compare(Object o1, Object o2) {
            return this.compare((DMObject)o1, (DMObject)o2);
        }

        public int compare(DMObject n1, DMObject n2) {
            System.err.println("in compare...n1.type==" + n1.getType());
            if (n1.getType().compareToIgnoreCase("image") == 0 && n2.getType().compareToIgnoreCase("image") == 0) {
                System.err.println("in image compare");
                String imNo1 = (String)n1.getValue(new DMTag(32, 19));
                String imNo2 = (String)n2.getValue(new DMTag(32, 19));
                if (imNo1 != null && imNo2 != null) {
                    int im2;
                    int im1 = Integer.parseInt(imNo1);
                    if (im1 > (im2 = Integer.parseInt(imNo2))) {
                        return 1;
                    }
                    if (im1 < im2) {
                        return -1;
                    }
                    return 0;
                }
                return 0;
            }
            if (n1.getType().compareToIgnoreCase("series") == 0 && n2.getType().compareToIgnoreCase("series") == 0) {
                String seNo1 = (String)n1.getValue(new DMTag(32, 17));
                String seNo2 = (String)n2.getValue(new DMTag(32, 17));
                if (seNo1 != null && seNo2 != null) {
                    int im2;
                    int im1 = Integer.parseInt(seNo1);
                    if (im1 > (im2 = Integer.parseInt(seNo2))) {
                        return 1;
                    }
                    if (im1 < im2) {
                        return -1;
                    }
                    return 0;
                }
                return 0;
            }
            return 0;
        }
    };

    public MRDicomInfo() {
    }

    public MRDicomInfo(DMObject dmo, String level) {
        this.dmo = dmo;
        this.ieLevel = level;
        this.loadHeaderValues();
    }

    public void setDMObject(DMObject dmo, String level) {
        this.dmo = dmo;
        this.ieLevel = level;
        this.loadHeaderValues();
    }

    public HashMap getDicomInfo() {
        return this.valueMap;
    }

    private void loadHeaderValues() {
        this.valueMap = new HashMap();
        DMObject[] series = this.dmo.getRelated(this.ieLevel);
        if (series.length == 0) {
            return;
        }
        DMObject thisSeries = series[0];
        DMElement[] elements = new DMElement[headerTags.length];
        for (int i2 = 0; i2 < elements.length; ++i2) {
            elements[i2] = new DMElement(headerTags[i2].getGroup(), headerTags[i2].getElement());
        }
        thisSeries.getValues(elements);
        this.valueMap.put(new String("var_contrastAgent"), this.getStringValue(new DMTag(24, 16)));
        this.valueMap.put(new String("var_hist"), this.getStringValue(new DMTag(16, 8624)));
        this.valueMap.put(new String("var_exDesc"), this.getStringValue(new DMTag(8, 4144)));
        this.valueMap.put(new String("var_opName"), this.getStringValue(new DMTag(8, 4208)));
        this.valueMap.put(new String("var_diagradName"), this.getStringValue(new DMTag(8, 4208)));
        this.valueMap.put(new String("var_refphyName"), this.getStringValue(new DMTag(8, 144)));
        this.valueMap.put(new String("var_exNo"), this.getStringValue(new DMTag(32, 16)));
        this.valueMap.put(new String("varAccessionNumber"), this.getStringValue(new DMTag(8, 80)));
        this.valueMap.put(new String("var_AShortPatName"), this.var_AShortPatName());
        this.valueMap.put(new String("var_AShortPatID"), this.var_AShortPatID());
        this.valueMap.put(new String("var_BaseSystemName"), this.var_BaseSystemName());
        this.valueMap.put(new String("var_AAge"), this.var_AAge());
        this.valueMap.put(new String("var_ASex"), this.getStringValue(new DMTag(16, 64)));
        this.valueMap.put(new String("var_weight"), this.var_weight());
        this.valueMap.put(new String("varN_anref"), this.getStringValue(new DMTag(32, 4160)));
        this.valueMap.put(new String("var_PatPosition"), this.var_PatPosition());
        this.valueMap.put(new String("var_PatEntry"), this.var_PatEntry());
        this.valueMap.put(new String("varN_TablePosition"), this.varN_TablePosition());
        this.valueMap.put(new String("var_seNo"), this.getStringValue(new DMTag(32, 17)));
        this.valueMap.put(new String("var_PSD"), MRDicomInfo.var_PSD(this.dmo));
        this.valueMap.put(new String("var_seDesc"), this.getStringValue(new DMTag(8, 4158)));
        this.valueMap.put(new String("var_seType"), MRDicomInfo.var_seType(this.dmo));
        this.valueMap.put(new String("var_cname"), this.getStringValue(new DMTag(24, 4688)));
        this.valueMap.put(new String("var_scanRange"), MRDicomInfo.var_scanRange(this.dmo));
        this.valueMap.put(new String("var_tuning"), this.var_tuning());
        this.valueMap.put(new String("var_prescan"), this.var_prescan());
        this.valueMap.put(new String("var_BESTScanDateTime"), this.var_BESTScanDateTime());
    }

    private String var_BESTScanDateTime() {
        String acq_date = (String)this.dmo.getValue(new DMTag(8, 34));
        if (acq_date != null && !acq_date.equals("")) {
            acq_date.trim();
            SimpleDateFormat df = new SimpleDateFormat("MMM dd yy");
            try {
                return df.format(df.parse(acq_date));
            }
            catch (ParseException ex) {
                return new String("");
            }
        }
        return new String("");
    }

    private String loc() {
        String loc = (String)this.dmo.getValue(new DMTag(16, 4161));
        if (loc != null) {
            DecimalFormat df = new DecimalFormat("#");
            float locF = Float.parseFloat(loc);
            return df.format(Math.abs(locF));
        }
        return new String("");
    }

    private String loc_ras() {
        int value;
        String GEMS_obplane;
        String OLD_loc_ras = (String)this.dmo.getValue(new DMTag(39, 4160));
        String GEMS_OLD_loc_ras = null;
        if (MRDicomInfo.GEM_sig27(this.dmo) && OLD_loc_ras != null) {
            GEMS_OLD_loc_ras = OLD_loc_ras;
        }
        if ((GEMS_obplane = MRDicomInfo.GEMS_obplane(this.dmo)) != null && ((value = Integer.parseInt(GEMS_obplane)) & 2) != 0) {
            String ULHC = (String)this.dmo.getValue(new DMTag(32, 50));
            StringTokenizer st = new StringTokenizer(ULHC, "\\");
            float tlhc_R = Float.parseFloat(st.nextToken());
            float tlhc_A = Float.parseFloat(st.nextToken());
            float tlhc_S = Float.parseFloat(st.nextToken());
        }
        return new String("S");
    }

    private String ASeSpecAcq() {
        String iopt1;
        if (!MRDicomInfo.combImage(this.dmo) && MRDicomInfo.mfgByGE(this.dmo) && (iopt1 = this.iopt1()) != null) {
            return iopt1.substring(1);
        }
        return null;
    }

    private String AScanOption() {
        String scanOption = (String)this.dmo.getValue(new DMTag(24, 34));
        if (!MRDicomInfo.combImage(this.dmo) && scanOption != null && !MRDicomInfo.mfgByGE(this.dmo)) {
            return scanOption;
        }
        return new String("");
    }

    private String iopt1() {
        StringTokenizer st;
        String iopt1 = "";
        String scanOption = (String)this.dmo.getValue(new DMTag(24, 34));
        if (scanOption == null) {
            return iopt1;
        }
        String firstScanOption = "";
        Number iopt = (Number)this.dmo.getValue(new DMTag(39, 4147));
        int GEMS_iopt = 0;
        if (iopt != null && MRDicomInfo.GEM_sig27(this.dmo)) {
            GEMS_iopt = iopt.intValue();
        }
        if (scanOption != null && (st = new StringTokenizer(scanOption, "\\")).hasMoreTokens()) {
            firstScanOption = st.nextToken();
        }
        if (firstScanOption.indexOf("CG") >= 0 || scanOption.indexOf("\\CG") >= 0) {
            iopt1 = "/EG";
        }
        if (iopt != null && (GEMS_iopt & 2) != 0) {
            iopt1 = iopt1 + "/RESP";
        }
        if (firstScanOption.indexOf("RG") >= 0 || scanOption.indexOf("\\RG") >= 0) {
            iopt1 = iopt1 + "/RC";
        }
        if (firstScanOption.indexOf("FC") >= 0 || scanOption.indexOf("\\FC") >= 0) {
            iopt1 = iopt1 + "/FC";
        }
        if (scanOption.indexOf("FC_FREQ_AX_GEMS") >= 0) {
            iopt1 = iopt1 + "f";
        }
        if (scanOption.indexOf("FC_SLICE_AX_GEMS") >= 0) {
            iopt1 = iopt1 + "s";
        }
        if (scanOption.indexOf("CL_GEMS") >= 0) {
            iopt1 = iopt1 + "/CL";
        }
        if (scanOption.indexOf("MART_GEMS") >= 0) {
            iopt1 = iopt1 + "/MART";
        }
        if (scanOption.indexOf("VGR_GEMS") >= 0) {
            iopt1 = iopt1 + "/VGR";
        }
        if (scanOption.indexOf("SAT_GEMS") >= 0) {
            Integer opt2;
            iopt1 = iopt1 + "/";
            Float user24 = (Float)this.dmo.getValue(new DMTag(25, 4313));
            float GEMS_user24 = 0.0f;
            if (user24 != null && MRDicomInfo.GEM_sig19(this.dmo)) {
                GEMS_user24 = user24.floatValue();
            }
            Number diff_air = (Number)this.dmo.getValue(new DMTag(33, 4184));
            Number GEMS_diff_air = null;
            if (MRDicomInfo.GEM_sig21(this.dmo) && diff_air != null) {
                GEMS_diff_air = diff_air;
            }
            float flt_concatSat = GEMS_user24;
            if (user24 != null && flt_concatSat != 0.0f && GEMS_diff_air != null && GEMS_diff_air.intValue() != 16 && GEMS_diff_air.intValue() != 32) {
                iopt1 = iopt1 + "c";
            }
            iopt1 = iopt1 + "St";
            Number satbits = (Number)this.dmo.getValue(new DMTag(25, 4288));
            Number GEMS_satbits = null;
            if (MRDicomInfo.GEM_sig19(this.dmo) && satbits != null) {
                GEMS_satbits = satbits;
            }
            if (GEMS_satbits != null && GEMS_satbits.intValue() > 0) {
                iopt1 = iopt1 + ":";
                if ((GEMS_satbits.intValue() & 1) != 0) {
                    iopt1 = iopt1 + "S";
                }
                if ((GEMS_satbits.intValue() & 0x40) != 0) {
                    iopt1 = iopt1 + "s";
                }
                if ((GEMS_satbits.intValue() & 2) != 0) {
                    iopt1 = iopt1 + "I";
                }
                if ((GEMS_satbits.intValue() & 0x80) != 0) {
                    iopt1 = iopt1 + "i";
                }
                if ((GEMS_satbits.intValue() & 4) != 0) {
                    iopt1 = iopt1 + "R";
                }
                if ((GEMS_satbits.intValue() & 0x100) != 0) {
                    iopt1 = iopt1 + "r";
                }
                if ((GEMS_satbits.intValue() & 8) != 0) {
                    iopt1 = iopt1 + "L";
                }
                if ((GEMS_satbits.intValue() & 0x200) != 0) {
                    iopt1 = iopt1 + "l";
                }
                if ((GEMS_satbits.intValue() & 0x10) != 0) {
                    iopt1 = iopt1 + "A";
                }
                if ((GEMS_satbits.intValue() & 0x400) != 0) {
                    iopt1 = iopt1 + "a";
                }
                if ((GEMS_satbits.intValue() & 0x20) != 0) {
                    iopt1 = iopt1 + "P";
                }
                if ((GEMS_satbits.intValue() & 0x800) != 0) {
                    iopt1 = iopt1 + "p";
                }
            }
            Number supp_tech = (Number)this.dmo.getValue(new DMTag(25, 4260));
            Number GEMS_supp_tech = null;
            if (MRDicomInfo.GEM_sig19(this.dmo) && supp_tech != null) {
                GEMS_supp_tech = supp_tech;
            }
            if (scanOption.indexOf("FS") >= 0) {
                if (GEMS_supp_tech != null) {
                    if (GEMS_supp_tech.intValue() == 1) {
                        iopt1 = iopt1 + "F";
                    }
                    if (GEMS_supp_tech.intValue() == 5) {
                        iopt1 = iopt1 + "Fcl";
                    }
                    if (GEMS_supp_tech.intValue() == 9) {
                        iopt1 = iopt1 + "Fsp";
                    }
                }
            } else if (GEMS_supp_tech != null && GEMS_supp_tech.intValue() == 2) {
                iopt1 = iopt1 + "W";
            }
            if (scanOption.indexOf("PPG") >= 0) {
                iopt1 = iopt1 + "/PG";
            }
            if (scanOption.indexOf("NPW") >= 0) {
                iopt1 = iopt1 + "/NP";
            }
            if (scanOption.indexOf("NF_GEMS") >= 0) {
                iopt1 = iopt1 + "/NF";
            }
            if (scanOption.indexOf("RT_GEMS") >= 0) {
                iopt1 = iopt1 + "/RT";
            }
            if (scanOption.indexOf("VB_GEMS") >= 0) {
                iopt1 = iopt1 + "/VB";
            }
            if (scanOption.indexOf("EDR_GEMS") >= 0) {
                iopt1 = iopt1 + "/ED";
            }
            if (scanOption.indexOf("PROM_GEMS") >= 0) {
                iopt1 = iopt1 + "/PM";
            }
            if (scanOption.indexOf("SEQ_GEMS") >= 0) {
                iopt1 = iopt1 + "/SQ";
            }
            if (scanOption.indexOf("CS_GEMS") >= 0) {
                iopt1 = iopt1 + "/cs";
            }
            if (scanOption.indexOf("MP_GEMS") >= 0) {
                iopt1 = iopt1 + "/MP";
            }
            if (scanOption.indexOf("SQPIX") >= 0) {
                iopt1 = iopt1 + "/SqP";
            }
            if (scanOption.indexOf("MT_GEMS") >= 0) {
                iopt1 = iopt1 + "/MT";
            }
            if (scanOption.indexOf("TRF_GEMS") >= 0) {
                iopt1 = iopt1 + "/TRF";
            }
            if (scanOption.indexOf("RTR_GEMS") >= 0) {
                iopt1 = iopt1 + "/RTr";
            }
            if (scanOption.indexOf("FT iopt1") >= 0) {
                iopt1 = iopt1 + "/FT";
            }
            if ((opt2 = this.opt2()) != null) {
                if ((opt2 & 2) != 0) {
                    iopt1 = iopt1 + "/BC";
                }
                if ((opt2 & 0x400000) != 0) {
                    iopt1 = iopt1 + "/NAV";
                }
                if ((opt2 & 4) != 0) {
                    iopt1 = iopt1 + "/Z1024";
                }
                if ((opt2 & 0x10) != 0) {
                    iopt1 = iopt1 + "/CC";
                }
                if ((opt2 & 0x20) != 0) {
                    iopt1 = iopt1 + "/Z512";
                }
                if ((opt2 & 0x40) != 0) {
                    iopt1 = iopt1 + "/Z2";
                }
                if ((opt2 & 0x7C) != 0) {
                    iopt1 = iopt1 + "/Z4";
                }
                if ((opt2 & 0x2000) != 0) {
                    iopt1 = iopt1 + "/FWf";
                }
                if ((opt2 & 0x4000) != 0) {
                    iopt1 = iopt1 + "/FWw";
                }
                if ((opt2 & 0x80000) != 0) {
                    iopt1 = iopt1 + "/rtBC";
                }
                if ((opt2 & 0x100000) != 0) {
                    iopt1 = iopt1 + "/AN";
                }
                if ((opt2 & 0x8000) != 0) {
                    iopt1 = iopt1 + "/T2P";
                }
                if ((opt2 & 0x10000) != 0) {
                    iopt1 = iopt1 + "/SSRF";
                }
                if ((opt2 & 0x200) != 0 && MRDicomInfo.int_magStrength_Gauss(this.dmo) > 8000 || (opt2 & 0x1000) != 0) {
                    iopt1 = iopt1 + "/BSP";
                }
                if ((opt2 & 0x400) != 0) {
                    iopt1 = iopt1 + "/RTI";
                }
                if ((opt2 & 0x1000000) != 0) {
                    iopt1 = iopt1 + "/PS";
                }
                if ((opt2 & (int)Math.exp(23.0)) != 0) {
                    iopt1 = iopt1 + "FTr";
                }
                if ((opt2 & (int)Math.exp(25.0)) != 0) {
                    iopt1 = iopt1 + "/CAL";
                }
                if ((opt2 & (int)Math.exp(26.0)) != 0) {
                    iopt1 = iopt1 + "/AST";
                }
            }
            Number swappf = (Number)this.dmo.getValue(new DMTag(25, 4239));
            Number GEMS_swappf = null;
            if (MRDicomInfo.GEM_sig19(this.dmo) && swappf != null) {
                GEMS_swappf = swappf;
            }
            if (GEMS_swappf != null && GEMS_swappf.intValue() == 1) {
                iopt1 = iopt1 + "/SPF";
            }
        }
        return iopt1;
    }

    private String var_prescan() {
        String prescan = "";
        Number pscopts = (Number)this.dmo.getValue(new DMTag(67, 4097));
        if (MRDicomInfo.GEM_sig43(this.dmo) && pscopts != null) {
            int int_pscopts = pscopts.intValue();
            if (int_pscopts > 0) {
                if ((int_pscopts & 1) != 0) {
                    prescan = "AS";
                }
                if ((int_pscopts & 2) != 0) {
                    prescan = "PC";
                }
            }
        } else {
            prescan = "none";
        }
        return prescan;
    }

    private String var_tuning() {
        String tunning = "";
        String xmtfreq = (String)this.dmo.getValue(new DMTag(24, 132));
        String AManufacturer = this.getStringValue(new DMTag(8, 112));
        boolean notMfgByGE = false;
        if (AManufacturer.equals("") || AManufacturer.indexOf("GE") < 0) {
            notMfgByGE = true;
        }
        String int_xmtfreq_Hz = "";
        if (xmtfreq != null && !xmtfreq.equals("")) {
            String sw_version = (String)this.dmo.getValue(new DMTag(24, 4128));
            String ex_verscre = "0";
            if (sw_version != null) {
                StringTokenizer st = new StringTokenizer(sw_version, "\\");
                if (st.hasMoreTokens()) {
                    ex_verscre = st.nextToken();
                }
                int_xmtfreq_Hz = !notMfgByGE && Integer.parseInt(ex_verscre) < 11 ? Double.toString((Float.parseFloat(xmtfreq) + 5.0f) / 10.0f) : Double.toString((double)Float.parseFloat(xmtfreq) * 1000000.0 + 0.5);
            }
        }
        tunning = int_xmtfreq_Hz;
        boolean GEM_sig19 = MRDicomInfo.GEM_sig19(this.dmo);
        String smtgain = (String)this.dmo.getValue(new DMTag(25, 4345));
        String GEMS_xmtgain = "";
        if (GEM_sig19 && smtgain != null) {
            GEMS_xmtgain = smtgain;
            DecimalFormat df = new DecimalFormat("#");
            GEMS_xmtgain = df.format(Math.abs(Float.parseFloat(GEMS_xmtgain)));
        }
        if (!GEMS_xmtgain.equals("")) {
            tunning = tunning + " TG: " + GEMS_xmtgain;
        }
        Number rcvgain1 = (Number)this.dmo.getValue(new DMTag(25, 4234));
        String GEMS_rcvgain1 = "";
        if (GEM_sig19 && rcvgain1 != null) {
            GEMS_rcvgain1 = rcvgain1.toString();
        }
        if (!GEMS_rcvgain1.equals("")) {
            tunning = tunning + " R1: " + GEMS_rcvgain1;
        }
        Number rcvgain2 = (Number)this.dmo.getValue(new DMTag(25, 4235));
        String GEMS_rcvgain2 = "";
        if (GEM_sig19 && rcvgain2 != null) {
            GEMS_rcvgain2 = rcvgain2.toString();
        }
        if (!GEMS_rcvgain2.equals("")) {
            tunning = tunning + " R2: " + GEMS_rcvgain2;
        }
        Number ps_flag = (Number)this.dmo.getValue(new DMTag(25, 4302));
        String GEMS_ps_flag = "";
        if (GEM_sig19 && ps_flag != null) {
            int int_ps_flag = ps_flag.intValue();
            if (int_ps_flag == 1) {
                GEMS_ps_flag = "a";
            }
            if (int_ps_flag == 2) {
                GEMS_ps_flag = "A";
            }
            if (int_ps_flag == 3) {
                GEMS_ps_flag = "M";
            }
            if (int_ps_flag == 4) {
                GEMS_ps_flag = "aM";
            }
            if (int_ps_flag == 5) {
                GEMS_ps_flag = "AM";
            }
        }
        if (!GEMS_ps_flag.equals("")) {
            tunning = tunning + GEMS_ps_flag;
        }
        return tunning;
    }

    private Integer opt2() {
        String mr_slops = (String)this.dmo.getValue(67, 4153);
        String GEMS_mr_slops = null;
        if (MRDicomInfo.GEM_sig43(this.dmo) && mr_slops != null) {
            GEMS_mr_slops = mr_slops;
        }
        if (GEMS_mr_slops != null && MRDicomInfo.ex_verscre(this.dmo) >= 8) {
            StringTokenizer st = new StringTokenizer(GEMS_mr_slops, "\\");
            String secondSlop = null;
            if (st.countTokens() >= 2) {
                st.nextToken();
                secondSlop = st.nextToken();
            }
            if (secondSlop != null) {
                return new Integer(Integer.parseInt(secondSlop));
            }
        }
        return null;
    }

    private String varN_TablePosition() {
        String sig43 = this.getStringValue(new DMTag(67, 16));
        boolean GEM_sig43 = false;
        if (sig43.indexOf("GEMS_PARM_01") >= 0) {
            GEM_sig43 = true;
        }
        String tabPos_gradCoil = this.getStringValue(new DMTag(67, 4207));
        String GEM_tabPos_gradCoil = "";
        if (GEM_sig43 && !tabPos_gradCoil.equals("")) {
            GEM_tabPos_gradCoil = tabPos_gradCoil;
        }
        int table_entry = 0;
        if (!GEM_tabPos_gradCoil.equals("")) {
            System.err.println("GEM_tabPos_gradCoil==" + GEM_tabPos_gradCoil);
            StringTokenizer st = new StringTokenizer(GEM_tabPos_gradCoil, "\\");
            table_entry = Integer.parseInt(st.nextToken());
        }
        if (table_entry == 1) {
            return new String("left");
        }
        if (table_entry == 2) {
            return new String("center");
        }
        if (table_entry == 3) {
            return new String("right");
        }
        if (table_entry == 4) {
            return new String("front");
        }
        if (table_entry == 5) {
            return new String("side");
        }
        if (table_entry == 6) {
            return new String("vertical");
        }
        return new String("");
    }

    private String var_PatEntry() {
        String Pat_position = this.getStringValue(new DMTag(24, 20736));
        boolean pat_entry = false;
        if (Pat_position.indexOf("HFS") >= 0 || Pat_position.indexOf("HFP") >= 0 || Pat_position.indexOf("HFDL") >= 0 || Pat_position.indexOf("HFDR") >= 0) {
            return new String("Head First");
        }
        if (Pat_position.indexOf("FFS") >= 0 || Pat_position.indexOf("FFP") >= 0 || Pat_position.indexOf("FFDL") >= 0 || Pat_position.indexOf("FFDR") >= 0) {
            return new String("Feet First");
        }
        return new String("");
    }

    private String var_PatPosition() {
        String Pat_position = this.getStringValue(new DMTag(24, 20736));
        boolean pat_position = false;
        if (Pat_position.indexOf("HFS") >= 0 || Pat_position.indexOf("FFS") >= 0) {
            return new String("Supine");
        }
        if (Pat_position.indexOf("HFP") >= 0 || Pat_position.indexOf("FFP") >= 0) {
            return new String("Prone");
        }
        if (Pat_position.indexOf("HFDL") >= 0 || Pat_position.indexOf("FFDL") >= 0) {
            return new String("Decubitus Left");
        }
        if (Pat_position.indexOf("HFDR") >= 0 || Pat_position.indexOf("FFDR") >= 0) {
            return new String("Decubitus Right");
        }
        return new String("");
    }

    private String var_AAge() {
        return "";
    }

    private String var_weight() {
        String weight = this.getStringValue(new DMTag(16, 4144));
        if (!weight.equals("")) {
            float fw = Float.parseFloat(weight) + 0.5f;
            int iw = (int)fw;
            return Integer.toString(iw) + " kg";
        }
        return new String("");
    }

    private String var_AShortPatName() {
        String pName = this.getStringValue(new DMTag(16, 16));
        if (pName.equals("")) {
            String ex_no = this.getStringValue(new DMTag(32, 16));
            pName = "no_name_" + ex_no;
        }
        if (pName.length() > 24) {
            pName = pName.substring(0, 24) + "*";
        }
        return pName;
    }

    private String var_BaseSystemName() {
        String AManufacturer = this.getStringValue(new DMTag(8, 112));
        String baseSystemName = "";
        String cl_ModelName = this.getStringValue(new DMTag(8, 4240));
        String AModelName = "";
        AModelName = cl_ModelName.indexOf("GENESIS_FOREIGN") >= 0 ? "GENESIS" : (cl_ModelName.indexOf("GENESIS_SIGNA") >= 0 ? "Signa" : cl_ModelName);
        boolean notMfgByGE = false;
        if (AManufacturer.equals("") || AManufacturer.indexOf("GE") < 0) {
            notMfgByGE = true;
        }
        if (notMfgByGE) {
            if (!AManufacturer.equals("")) {
                baseSystemName = baseSystemName + AManufacturer + " ";
            }
            baseSystemName = baseSystemName + AModelName;
        } else {
            baseSystemName = baseSystemName + AModelName + " ";
            if (this.getStringValue(new DMTag(8, 4240)).indexOf("1.2.840.10008.5.1.4.1.1.7") < 0) {
                String magStrength = this.getStringValue(new DMTag(24, 135));
                float mgS = Float.parseFloat(magStrength);
                float flt_magStrength_Tesla = !notMfgByGE && 175.0f < mgS ? mgS / 10000.0f : mgS;
                baseSystemName = baseSystemName + Float.toString(flt_magStrength_Tesla);
            }
        }
        return baseSystemName;
    }

    private String var_AShortPatID() {
        String dob;
        String patID = this.getStringValue(new DMTag(16, 32));
        if (patID.length() > 12) {
            patID = patID.substring(0, 12);
        }
        if (!(dob = this.getStringValue(new DMTag(16, 48))).equals("")) {
            patID = patID + "DOB: ";
            SimpleDateFormat df = new SimpleDateFormat("MMM dd yy");
            try {
                patID = patID + df.format(df.parse(dob));
            }
            catch (ParseException ex) {
                // empty catch block
            }
        }
        return patID;
    }

    public String generateHTMLTextPage() {
        if (this.valueMap.size() == 0) {
            return null;
        }
        String str = "";
        String stt = "resources/MRStudy.htm";
        if (this.ieLevel.equalsIgnoreCase("study")) {
            stt = "resources/MRStudy.htm";
        } else if (this.ieLevel.equalsIgnoreCase("series")) {
            stt = "resources/MRSeries.htm";
        }
        BufferedReader br = new BufferedReader(new InputStreamReader(this.getClass().getResourceAsStream(stt)));
        try {
            String line;
            while (br.ready() && (line = br.readLine()) != null) {
                if (line.indexOf("hr") >= 0) {
                    str = str + line;
                    str = str + this.processRepeats(br);
                    continue;
                }
                int index = line.indexOf("var");
                if (index >= 0) {
                    int endIndex = line.indexOf(60, index);
                    String var = line.substring(index, endIndex);
                    String value = (String)this.valueMap.get(var);
                    if (var.startsWith("varN") && value.equals("")) continue;
                    str = str + line.substring(0, index - 1) + "  " + value + line.subSequence(endIndex, line.length()) + "\n";
                    continue;
                }
                str = str + line;
            }
        }
        catch (IOException ex) {
            // empty catch block
        }
        return str;
    }

    private String processRepeats(BufferedReader br) {
        Object info;
        int i2;
        String str = "";
        String str1 = "";
        boolean started = false;
        try {
            String line;
            while (br.ready() && (line = br.readLine()) != null) {
                if (line.indexOf("<TR") >= 0) {
                    started = true;
                }
                if (started) {
                    str1 = str1 + line;
                }
                if (!started || line.indexOf("</TR") < 0) continue;
                break;
            }
        }
        catch (IOException ex) {
            // empty catch block
        }
        if (this.ieLevel.equalsIgnoreCase("series")) {
            DMObject[] images = this.dmo.getRelated("image");
            Arrays.sort(images, this.comp);
            for (i2 = 0; i2 < images.length; ++i2) {
                info = new MRImageInfo(images[i2], str1);
                str = str + ((MRImageInfo)info).getHTMLStream();
            }
        }
        if (this.ieLevel.equalsIgnoreCase("study")) {
            DMObject[] series = this.dmo.getRelated("series");
            Arrays.sort(series, this.comp);
            for (i2 = 0; i2 < series.length; ++i2) {
                info = new MRSeriesInfo(series[i2], str1);
                str = str + ((MRSeriesInfo)info).getHTMLStream();
            }
        }
        return str;
    }

    private String getStringValue(DMTag tag2) {
        String value = (String)this.dmo.getValue(tag2);
        if (value != null) {
            return value;
        }
        return new String("");
    }

    public static void main(String[] args) {
        DMSession sess = new DMSession(new String[]{"file", "c:\\images\\test"});
        MRDicomInfo MRDicomInfo1 = new MRDicomInfo();
        MRDicomInfo1.setDMObject(sess.getChildren()[0], "Study");
        String str = MRDicomInfo1.generateHTMLTextPage();
        System.err.println("str==" + str);
    }

    public static boolean GEM_sig43(DMObject dmoo) {
        String manuf1 = (String)dmoo.getValue(new DMTag(67, 16));
        return manuf1 != null && manuf1.indexOf("GEMS_PARM_01") >= 0;
    }

    public static boolean GEM_sig27(DMObject dmoo) {
        String manuf1 = (String)dmoo.getValue(new DMTag(39, 16));
        return manuf1 != null && manuf1.indexOf("GEMS_IMAG_01") >= 0;
    }

    public static boolean GEM_sig9(DMObject dmoo) {
        String manuf1 = (String)dmoo.getValue(new DMTag(9, 16));
        return manuf1 != null && manuf1.indexOf("GEMS_PETD_01") >= 0;
    }

    public static boolean GEM_sig21(DMObject dmoo) {
        String manuf1 = (String)dmoo.getValue(new DMTag(33, 16));
        return manuf1 != null && manuf1.indexOf("GEMS_RELA_01") >= 0;
    }

    public static boolean GEM_sig19(DMObject dmoo) {
        String manuf1 = (String)dmoo.getValue(new DMTag(25, 16));
        return manuf1 != null && manuf1.equals("GEMS_ACQU_01");
    }

    public static String GEMS_obplane(DMObject dmoo) {
        String OLD_obplane = (String)dmoo.getValue(new DMTag(39, 4150));
        String GEMS_OLD_obplane = null;
        if (MRDicomInfo.GEM_sig27(dmoo) && OLD_obplane != null) {
            GEMS_OLD_obplane = OLD_obplane;
        }
        if (GEMS_OLD_obplane != null) {
            return GEMS_OLD_obplane;
        }
        Number plane = (Number)dmoo.getValue(new DMTag(39, 4149));
        Number GEMS_plane = null;
        if (MRDicomInfo.GEM_sig27(dmoo) && plane != null) {
            GEMS_plane = plane;
        }
        String GEMS_obplane = null;
        if (GEMS_plane != null) {
            String URBRHC = (String)dmoo.getValue(new DMTag(32, 55));
            StringTokenizer st = new StringTokenizer(URBRHC, "\\");
            float dir_cos_row_L = Float.parseFloat(st.nextToken());
            float dir_cos_row_P = Float.parseFloat(st.nextToken());
            float dir_cos_row_S = Float.parseFloat(st.nextToken());
            float dir_cos_col_L = Float.parseFloat(st.nextToken());
            float dir_cos_col_P = Float.parseFloat(st.nextToken());
            float dir_cos_col_S = Float.parseFloat(st.nextToken());
            float norm_R = -1.0f * dir_cos_row_P * dir_cos_col_S + dir_cos_row_S * dir_cos_col_P;
            float norm_S = dir_cos_row_L * dir_cos_col_P - dir_cos_row_P * dir_cos_col_L;
            float fns = Math.abs(norm_S);
            float norm_A = dir_cos_row_S * -1.0f * dir_cos_col_L + dir_cos_row_L * dir_cos_col_S;
            float fna = Math.abs(norm_A);
            float tmp_fnr = 0.0f;
            float fnr = Math.abs(norm_R);
            tmp_fnr = (double)Math.abs(fnr - fna) < 1.0E-5 ? fna : fnr;
            float new_fnr = 0.0f;
            new_fnr = (double)Math.abs(tmp_fnr - fns) < 1.0E-5 ? fns : tmp_fnr;
            float new_fna = 0.0f;
            new_fna = (double)Math.abs(fna - fns) < 1.0E-5 ? fns : fna;
            GEMS_obplane = (GEMS_plane.intValue() & 0x10) != 0 ? (new_fnr < new_fna ? (new_fna > fns ? Integer.toString(GEMS_plane.intValue() & 7) : Integer.toString(GEMS_plane.intValue() & 2)) : (new_fnr > fns ? Integer.toString(GEMS_plane.intValue() & 4) : Integer.toString(GEMS_plane.intValue() & 2))) : Integer.toString(GEMS_plane.intValue());
        }
        return GEMS_obplane;
    }

    public static boolean mfgByGE(DMObject dmoo) {
        String Manufacturer = (String)dmoo.getValue(new DMTag(8, 112));
        return Manufacturer != null && Manufacturer.equals("GE MEDICAL SYSTEMS");
    }

    public static boolean combImage(DMObject dmoo) {
        String se_type = (String)dmoo.getValue(new DMTag(8, 65));
        boolean combImage = false;
        if (se_type != null) {
            if (se_type.indexOf("COMBINED") >= 0 || se_type.indexOf("PROCESSED") >= 0) {
                combImage = true;
            }
        } else {
            String seType = MRDicomInfo.var_seType(dmoo);
            if (seType.equals("COMB") || seType.equals("PROC")) {
                combImage = true;
            }
        }
        return combImage;
    }

    public static String var_seType(DMObject dmoo) {
        String seType = "";
        String se_type = (String)dmoo.getValue(new DMTag(8, 65));
        String sig9 = (String)dmoo.getValue(new DMTag(9, 16));
        String se_typ = (String)dmoo.getValue(new DMTag(9, 4122));
        boolean GEM_sig9 = false;
        if (sig9 != null && !sig9.equals("") && sig9.indexOf("GEMS_PETD_01") >= 0) {
            GEM_sig9 = true;
        }
        String GEM_se_typ = "";
        if (GEM_sig9) {
            GEM_se_typ = se_typ;
        }
        if (se_type != null && !se_type.equals("")) {
            seType = se_type;
        } else if (!GEM_se_typ.equals("")) {
            seType = GEM_se_typ;
        } else {
            String dicomImageType = (String)dmoo.getValue(new DMTag(8, 8));
            String suid = (String)dmoo.getValue(new DMTag(8, 22));
            String PimageType0 = "";
            String PimageType1 = "";
            String PimageType2 = "";
            String PimageType3 = "";
            if (!dicomImageType.equals("")) {
                StringTokenizer st = new StringTokenizer(dicomImageType, "\\");
                int startIndex = 0;
                while (st.hasMoreTokens()) {
                    if (startIndex == 0) {
                        PimageType0 = st.nextToken();
                    }
                    if (startIndex == 1) {
                        PimageType1 = st.nextToken();
                    }
                    if (startIndex == 2) {
                        PimageType2 = st.nextToken();
                    }
                    if (startIndex == 3) {
                        PimageType3 = st.nextToken();
                    }
                    ++startIndex;
                }
            }
            if (PimageType0.equals("") && PimageType1.equals("") && PimageType2.equals("")) {
                if (suid.equals("1.2.840.10008.5.1.4.1.1.11.1")) {
                    seType = "GSPS";
                } else if (suid.equals("1.2.840.10008.5.1.4.1.1.88.11")) {
                    seType = "SR";
                } else if (suid.equals("1.2.840.10008.5.1.4.1.1.88.22")) {
                    seType = "SR";
                } else if (suid.equals("1.2.840.10008.5.1.4.1.1.88.33")) {
                    seType = "SR";
                }
            } else if (PimageType0.equals("ORIGINAL")) {
                if (PimageType1.equals("PRIMARY")) {
                    seType = PimageType2.equals("OTHER") ? "PROSP" : (suid.equals("1.2.840.10008.5.1.4.1.1.7") ? "SSAVE" : (PimageType2.length() > 9 ? PimageType2.substring(0, 8) : PimageType2));
                }
            } else if (PimageType0.equals("DERIVED")) {
                if (PimageType1.equals("PRIMARY")) {
                    seType = PimageType2.equals("PROJECTION IMAGE") || PimageType2.equals("PJIN") ? (PimageType3.equals("COLLAPSE") || PimageType3.equals("VASCULAR") ? "PROSP" : (PimageType3.equals("IVI") ? "PJN" : "SSAVE")) : (suid.equals("1.2.840.10008.5.1.4.1.1.7") ? "SSAVE" : (PimageType2.length() > 9 ? PimageType2.substring(0, 8) : PimageType2));
                } else if (PimageType1.equals("SECONDARY")) {
                    if (PimageType2.equals("REFORMATTED") || PimageType2.equals("MPR")) {
                        seType = "REFMT";
                    } else if (PimageType2.equals("PROCESSED") || PimageType2.equals("PROC")) {
                        seType = "PROC";
                    } else if (PimageType2.equals("PROJECTION IMAGE") || PimageType2.equals("PJN")) {
                        seType = "PJN";
                    } else if (PimageType2.equals("COMB") || PimageType2.equals("COMBINED")) {
                        seType = "COMB";
                    } else if (suid.equals("1.2.840.10008.5.1.4.1.1.7")) {
                        seType = PimageType2.equals("3D") ? "3D" : "SSAVE";
                    }
                }
            }
        }
        return seType;
    }

    public static String APsdAnnot(DMObject dmoo) {
        StringTokenizer st;
        String APsAnnot = "";
        boolean combImage = MRDicomInfo.combImage(dmoo);
        boolean isFullGEMS = MRDicomInfo.mfgByGE(dmoo);
        String mr_slops = (String)dmoo.getValue(67, 4153);
        String GEMS_mr_slops = "";
        if (MRDicomInfo.GEM_sig43(dmoo) && mr_slops != null) {
            GEMS_mr_slops = mr_slops;
        }
        int ex_verscre = MRDicomInfo.ex_verscre(dmoo);
        String secondValue = "";
        if (!GEMS_mr_slops.equals("") && (st = new StringTokenizer(GEMS_mr_slops, "\\")).countTokens() > 2) {
            st.nextToken();
            secondValue = st.nextToken();
        }
        int iopt2 = 0;
        if (!GEMS_mr_slops.equals("") && ex_verscre >= 8 && !secondValue.equals("")) {
            iopt2 = Integer.parseInt(secondValue);
        }
        String tmp_psd_annot = MRDicomInfo.tmp_psd_annot(dmoo, iopt2);
        if (!combImage && MRDicomInfo.mfgByGE(dmoo)) {
            if ((iopt2 & 1) != 0) {
                APsAnnot = "SS";
            }
            APsAnnot = APsAnnot + tmp_psd_annot;
        }
        return APsAnnot;
    }

    public static String var_PSD(DMObject dmoo) {
        String APsAnnot = MRDicomInfo.APsdAnnot(dmoo);
        String ASequenceName = "";
        String ASequenceVariant = "";
        String Manufacturer = (String)dmoo.getValue(new DMTag(8, 112));
        String sequenceName = (String)dmoo.getValue(new DMTag(24, 36));
        if (Manufacturer != null && Manufacturer.indexOf("Elscint") >= 0 && sequenceName != null) {
            ASequenceName = sequenceName;
        }
        String scanVariant = (String)dmoo.getValue(new DMTag(24, 33));
        if (!MRDicomInfo.combImage(dmoo) && !MRDicomInfo.mfgByGE(dmoo) && ASequenceName.equals("") && scanVariant != null) {
            ASequenceVariant = scanVariant;
        }
        String scanOptions = (String)dmoo.getValue(new DMTag(24, 34));
        String ARampedDirection = "";
        String ramped_direction = "";
        if (scanOptions != null && scanOptions.indexOf("RAMP_SI") >= 0) {
            ramped_direction = "S->I";
        }
        if (scanOptions != null && scanOptions.indexOf("RAMP_IS") >= 0) {
            ramped_direction = ramped_direction + "I->S";
        }
        if (scanOptions != null && scanOptions.indexOf("RAMP_AP") >= 0) {
            ramped_direction = ramped_direction + "A->P";
        }
        if (scanOptions != null && scanOptions.indexOf("RAMP_PA") >= 0) {
            ramped_direction = ramped_direction + "P->A";
        }
        if (scanOptions != null && scanOptions.indexOf("RAMP_RL") >= 0) {
            ramped_direction = ramped_direction + "R->L";
        }
        if (scanOptions != null && scanOptions.indexOf("RAMP_LR") >= 0) {
            ramped_direction = ramped_direction + "L->R";
        }
        if (!MRDicomInfo.combImage(dmoo) && scanOptions != null && !ramped_direction.equals("")) {
            ARampedDirection = " " + ramped_direction;
        }
        return new String(APsAnnot + " " + ASequenceName + " " + ASequenceVariant + " " + ARampedDirection);
    }

    public static String tmp_psd_annot(DMObject dmoo, int iopt2) {
        String GEMS_psdname;
        String temp_psd_annot = "";
        String imaged_nucleus = (String)dmoo.getValue(new DMTag(24, 133));
        Number pseq = (Number)dmoo.getValue(new DMTag(39, 4146));
        int GEMS_pseq = 0;
        if (MRDicomInfo.GEM_sig27(dmoo) && pseq.equals("")) {
            GEMS_pseq = pseq.intValue();
        }
        String psdname = (String)dmoo.getValue(new DMTag(25, 4252));
        String tmp_psdname = GEMS_psdname = "";
        String flipAngle = (String)dmoo.getValue(new DMTag(24, 4884));
        double mr_flip = 0.0;
        String scanOptions = (String)dmoo.getValue(new DMTag(24, 34));
        if (flipAngle != null) {
            mr_flip = Double.parseDouble(flipAngle);
        }
        double temp_flip_int = 0.0;
        if (flipAngle != null && mr_flip > 0.0 && pseq != null && GEMS_pseq != 1 && GEMS_pseq != 6 && GEMS_pseq != 7 && GEMS_pseq != 19 && GEMS_pseq != 26 && GEMS_pseq != 0 && GEMS_pseq != 48 && GEMS_pseq != 49 && GEMS_pseq != 58 && GEMS_pseq != 59 && imaged_nucleus != null && imaged_nucleus.indexOf("SPECT") < 0) {
            temp_flip_int = mr_flip;
        }
        String temp_flip = "";
        if (temp_flip_int > 0.0) {
            temp_flip = "/" + new Double(temp_flip_int).toString();
        }
        Number imode = (Number)dmoo.getValue(new DMTag(39, 4145));
        String tmp_imode = "";
        if (pseq != null && imode != null) {
            if (GEMS_pseq != 8 && GEMS_pseq != 9) {
                int int_imode = imode.intValue();
                if (int_imode == 2) {
                    tmp_imode = "3D/";
                }
                if (int_imode == 4) {
                    tmp_imode = "Cine/";
                }
                if (int_imode == 6) {
                    tmp_imode = "MRS/";
                }
                if (int_imode == 9) {
                    tmp_imode = "M3D/";
                }
            }
        } else {
            String acqType = (String)dmoo.getValue(new DMTag(24, 35));
            if (acqType != null && acqType.indexOf("3D") >= 0) {
                tmp_imode = "3D/";
            } else if (imaged_nucleus != null && imaged_nucleus.indexOf("SPECT") >= 0) {
                tmp_imode = "MRS/";
            } else if (scanOptions != null && scanOptions.indexOf("CINE") >= 0) {
                tmp_imode = "Cine/";
            }
        }
        String tmp_vmode = "";
        if (scanOptions != null && (!MRDicomInfo.mfgByGE(dmoo) || pseq != null && GEMS_pseq != 12 && GEMS_pseq != 13 && GEMS_pseq != 15 && GEMS_pseq != 16 && GEMS_pseq != 17 && GEMS_pseq != 19)) {
            if (scanOptions.indexOf("VASCTOF") >= 0) {
                tmp_vmode = "TOF/";
            } else if (scanOptions.indexOf("VASCPC") >= 0) {
                tmp_vmode = "TOF/";
            } else if (scanOptions.indexOf("VASCPC") >= 0) {
                tmp_vmode = "PC/";
            } else if (scanOptions.indexOf("VASCANGIO") >= 0) {
                tmp_vmode = "ANGIO/";
            }
        }
        String ModelName = (String)dmoo.getValue(new DMTag(8, 4240));
        String prodid = (String)dmoo.getValue(new DMTag(9, 4100));
        String GEMS_prodid = "";
        if (MRDicomInfo.GEM_sig9(dmoo) && prodid != null) {
            GEMS_prodid = prodid;
        }
        String scanVariant = (String)dmoo.getValue(new DMTag(24, 33));
        Number var_echo = (Number)dmoo.getValue(new DMTag(25, 4312));
        int GEMS_var_echo = 0;
        if (var_echo != null) {
            GEMS_var_echo = var_echo.intValue();
        }
        Number se_pseq = (Number)dmoo.getValue(new DMTag(25, 4114));
        String scanSeq = (String)dmoo.getValue(new DMTag(24, 32));
        int GEMS_se_pseq = 0;
        if (MRDicomInfo.GEM_sig19(dmoo) && se_pseq != null) {
            GEMS_se_pseq = se_pseq.intValue();
        }
        if (imaged_nucleus != null && imaged_nucleus.indexOf("SPECT") >= 0 || pseq != null && (GEMS_pseq != 2 || GEMS_pseq != 3 || GEMS_pseq != 24)) {
            if (pseq != null && GEMS_pseq == 2) {
                temp_psd_annot = "RM";
            }
            temp_psd_annot = temp_psd_annot + tmp_psdname + temp_flip;
        } else {
            temp_psd_annot = tmp_imode + tmp_vmode;
            if (pseq != null && GEMS_pseq == 19 && (iopt2 & 0x200) != 0 && MRDicomInfo.int_magStrength_Gauss(dmoo) < 8000 || se_pseq != null && (iopt2 & 0x200000) != 0 && GEMS_se_pseq != 55) {
                temp_psd_annot = temp_psd_annot + "FR";
            }
            if (scanSeq != null) {
                temp_psd_annot = tmp_psdname;
            } else if (pseq != null) {
                if (ModelName != null && (ModelName.indexOf("VECTRA") >= 0 || ModelName.indexOf("MRVECTRA") >= 0) || prodid != null && prodid.indexOf("VECTRA") >= 0 || prodid.indexOf("MRVECTRA") >= 0) {
                    temp_psd_annot = temp_psd_annot + tmp_psdname;
                    if (scanVariant != null) {
                        temp_psd_annot = temp_psd_annot + "/" + scanVariant;
                    }
                } else {
                    temp_psd_annot = temp_psd_annot + MRDicomInfo.PSeq(GEMS_pseq);
                }
            }
            if ((iopt2 & 0x8000000) != 0) {
                temp_psd_annot = temp_psd_annot + "/Prop";
            }
            if ((iopt2 & 0x20000) != 0) {
                temp_psd_annot = temp_psd_annot + "/SPIRAL";
            }
            if (scanOptions != null && scanOptions.indexOf("EPI") >= 0) {
                temp_psd_annot = temp_psd_annot + "/EPI";
            }
            if (var_echo != null && GEMS_var_echo == 1) {
                temp_psd_annot = temp_psd_annot + "/V";
            }
            if (scanOptions != null && scanOptions.indexOf("\\CS") >= 0) {
                temp_psd_annot = temp_psd_annot + "/cs";
            }
            if ((iopt2 & 0x40000) != 0) {
                temp_psd_annot = temp_psd_annot + "/ET";
            }
            temp_psd_annot = temp_psd_annot + temp_flip;
        }
        return temp_psd_annot;
    }

    public static int int_magStrength_Gauss(DMObject dmoo) {
        String magStrength = (String)dmoo.getValue(new DMTag(24, 135));
        if (magStrength == null) {
            return 0;
        }
        float ft = Float.parseFloat(magStrength);
        if (MRDicomInfo.mfgByGE(dmoo) && 175.0f < ft) {
            Float ft1 = new Float(ft);
            return ft1.intValue();
        }
        Float ft1 = new Float(ft * 10000.0f);
        return ft1.intValue();
    }

    public static String var_scanRange(DMObject dmoo) {
        int se_plane;
        Object obj;
        String range = "";
        if (MRDicomInfo.GEM_sig19(dmoo) && (obj = dmoo.getValue(new DMTag(25, 4119))) != null && ((se_plane = ((Integer)obj).intValue()) & 0x100) == 0) {
            String startScanRange = "";
            String GEMS_start_loc = (String)dmoo.getValue(new DMTag(25, 4121));
            DecimalFormat df = new DecimalFormat("#.#");
            GEMS_start_loc = df.format(Math.abs(Float.parseFloat(GEMS_start_loc)));
            float fstartLoc = Float.parseFloat(GEMS_start_loc);
            String start_ras = (String)dmoo.getValue(new DMTag(25, 4120));
            if (start_ras != null) {
                startScanRange = startScanRange + start_ras + Float.toString(fstartLoc);
            }
            range = range + startScanRange;
            String endScanRange = "";
            String GEMS_end_loc = (String)dmoo.getValue(new DMTag(25, 4123));
            GEMS_end_loc = df.format(Math.abs(Float.parseFloat(GEMS_end_loc)));
            float fendLoc = Float.parseFloat(GEMS_end_loc);
            String end_ras = (String)dmoo.getValue(new DMTag(25, 4122));
            if (start_ras != null) {
                endScanRange = endScanRange + end_ras + Float.toString(fendLoc);
            }
            if (!startScanRange.equals("") && !endScanRange.equals("")) {
                range = range + "  to  ";
            }
            range = range + endScanRange;
        }
        return range;
    }

    public static int ex_verscre(DMObject dmoo) {
        StringTokenizer st;
        String sw_version = (String)dmoo.getValue(new DMTag(24, 4128));
        String ex_verscre = "0";
        if (MRDicomInfo.mfgByGE(dmoo) && sw_version != null && sw_version != null && (st = new StringTokenizer(sw_version, "\\")).hasMoreTokens()) {
            ex_verscre = st.nextToken();
        }
        return Integer.parseInt(ex_verscre);
    }

    static String PSeq(int index) {
        switch (index) {
            case 0: {
                return new String("SE");
            }
            case 1: {
                return new String("IR");
            }
            case 2: {
                return new String("RM");
            }
            case 3: {
                return new String("");
            }
            case 4: {
                return new String("GR");
            }
            case 5: {
                return new String("MPGR");
            }
            case 6: {
                return new String("IR/s");
            }
            case 7: {
                return new String("IR");
            }
            case 8: {
                return new String("3D/GR");
            }
            case 9: {
                return new String("Cine/GR");
            }
            case 10: {
                return new String("SPGR");
            }
            case 11: {
                return new String("SSFP");
            }
            case 12: {
                return new String("TOF");
            }
            case 13: {
                return new String("PC");
            }
            case 14: {
                return new String("SPGR");
            }
            case 15: {
                return new String("TOF/GR");
            }
            case 16: {
                return new String("TOF/SPGR");
            }
            case 17: {
                return new String("PC/GR");
            }
            case 18: {
                return new String("PC/SPGR");
            }
            case 19: {
                return new String("FSE");
            }
            case 20: {
                return new String("FGR");
            }
            case 21: {
                return new String("FMPGR");
            }
            case 22: {
                return new String("FSPGR");
            }
            case 23: {
                return new String("FMSPGR");
            }
            case 25: {
                return new String("MIXED");
            }
            case 26: {
                return new String("FSEIR");
            }
            case 27: {
                return new String("STEAM");
            }
            case 28: {
                return new String("PRESS");
            }
            case 29: {
                return new String("PROBE-P");
            }
            case 30: {
                return new String("PROBE-S");
            }
            case 31: 
            case 32: {
                return new String("PRESS_CSI");
            }
            case 33: {
                return new String("FID_CSI");
            }
            case 34: {
                return new String("ECHO_CSI");
            }
            case 35: {
                return new String("SPINECHO_CSI");
            }
            case 45: {
                return new String("LOC");
            }
            case 48: {
                return new String("LOC-FSE");
            }
            case 49: {
                return new String("LSDI");
            }
            case 55: {
                return new String("FRFSE-XL");
            }
            case 56: {
                return new String("FSE-XL");
            }
            case 57: {
                return new String("FIESTA");
            }
            case 58: {
                return new String("T1flair");
            }
            case 59: {
                return new String("T2flair");
            }
            case 60: {
                return new String("FSEIR-XL");
            }
            case 64: {
                return new String("FIESTA-C");
            }
            case 65: {
                return new String("TRICKS");
            }
            case 66: {
                return new String("VIBRANT");
            }
            case 67: {
                return new String("LAVA");
            }
        }
        return new String("");
    }

    private class MRImageInfo {
        DMObject image;
        String html;
        HashMap valueMap = new HashMap();

        public MRImageInfo(DMObject image, String html) {
            this.image = image;
            this.html = html;
            this.queryValues();
        }

        private void queryValues() {
            this.valueMap.put(new String("var_imNo"), this.getImNo());
            this.valueMap.put(new String("var_flStr"), this.var_flStr());
            this.valueMap.put(new String("var_teStr"), this.var_teStr());
            this.valueMap.put(new String("var_tiStr"), this.var_tiStr());
            this.valueMap.put(new String("var_trStr"), this.var_trStr());
            this.valueMap.put(new String("var_tdel"), this.var_tdel());
            this.valueMap.put(new String("var_thick"), this.var_thick());
            this.valueMap.put(new String("var_fxfy"), this.var_fxfy());
            this.valueMap.put(new String("var_nex"), this.var_nex());
            this.valueMap.put(new String("var_fovStr"), this.var_fovStr());
            this.valueMap.put(new String("var_loc"), this.var_loc());
        }

        public String getHTMLStream() {
            int startIndex = 0;
            String result = "";
            int oldStartIndex = 0;
            while ((startIndex = this.html.indexOf("<td", startIndex)) >= 0) {
                result = result + this.html.substring(oldStartIndex, startIndex);
                int varIndex = this.html.indexOf("var", startIndex);
                if (varIndex >= 0) {
                    result = result + this.html.substring(startIndex, varIndex);
                    int varIndex1 = this.html.indexOf("<", varIndex);
                    String variable = this.html.substring(varIndex, varIndex1);
                    String value = (String)this.valueMap.get(variable);
                    result = result + value;
                    startIndex = oldStartIndex = varIndex1;
                    continue;
                }
                varIndex = this.html.indexOf("</td", startIndex);
                oldStartIndex = startIndex;
                startIndex = varIndex;
            }
            result = result + this.html.substring(oldStartIndex, this.html.length());
            return result;
        }

        private String var_loc() {
            String var_locRas = this.var_locRas();
            DecimalFormat df = new DecimalFormat("#.#");
            String loc = (String)this.image.getValue(new DMTag(32, 4161));
            if (loc != null) {
                float ft = Float.parseFloat(loc);
                float aft = Math.abs(ft);
                return var_locRas + df.format(aft);
            }
            return null;
        }

        private String var_locRas() {
            String var_locRas = "";
            String OLD_loc_ras = (String)this.image.getValue(new DMTag(39, 4160));
            String GEMS_OLD_loc_ras = null;
            if (MRDicomInfo.GEM_sig27(this.image) && OLD_loc_ras != null) {
                GEMS_OLD_loc_ras = OLD_loc_ras;
            }
            if (GEMS_OLD_loc_ras != null) {
                return GEMS_OLD_loc_ras;
            }
            return null;
        }

        private String var_nex() {
            Float nex = (Float)this.image.getValue(new DMTag(39, 4194));
            if (nex != null) {
                return nex.toString();
            }
            return new String(" ");
        }

        private String var_fxfy() {
            return this.freqX() + " X " + this.freqY();
        }

        private String freqX() {
            Number[] acqMatrix = (Number[])this.image.getValue(new DMTag(24, 4880));
            Number acqMatrix_1 = null;
            Number acqMatrix_0 = null;
            if (acqMatrix != null) {
                acqMatrix_1 = acqMatrix[1];
                acqMatrix_0 = acqMatrix[0];
            }
            Float OLD_dim_X = (Float)this.image.getValue(new DMTag(39, 4192));
            Float GEMS_OLD_dim_X = null;
            if (MRDicomInfo.GEM_sig27(this.image) && OLD_dim_X != null) {
                GEMS_OLD_dim_X = OLD_dim_X;
            }
            Number imageWidth = (Number)this.image.getValue(new DMTag(40, 17));
            Integer BEST_dim_X = null;
            BEST_dim_X = GEMS_OLD_dim_X != null ? new Integer(GEMS_OLD_dim_X.intValue()) : new Integer(imageWidth.intValue());
            if (acqMatrix_1 != null && acqMatrix_1.intValue() > 0) {
                return acqMatrix_1.toString();
            }
            if (acqMatrix_0 != null && acqMatrix_0.intValue() > 0) {
                return acqMatrix_0.toString();
            }
            if (BEST_dim_X != null) {
                return ((Object)BEST_dim_X).toString();
            }
            return new String("");
        }

        private String freqY() {
            Number[] acqMatrix = (Number[])this.image.getValue(new DMTag(24, 4880));
            Number acqMatrix_2 = null;
            Number acqMatrix_3 = null;
            if (acqMatrix != null) {
                acqMatrix_2 = acqMatrix[2];
                acqMatrix_3 = acqMatrix[3];
            }
            Float OLD_dim_Y = (Float)this.image.getValue(new DMTag(39, 4193));
            Float GEMS_OLD_dim_Y = null;
            if (MRDicomInfo.GEM_sig27(this.image) && OLD_dim_Y != null) {
                GEMS_OLD_dim_Y = OLD_dim_Y;
            }
            Number imageHeight = (Number)this.image.getValue(new DMTag(40, 16));
            Integer BEST_dim_Y = null;
            BEST_dim_Y = GEMS_OLD_dim_Y != null ? new Integer(GEMS_OLD_dim_Y.intValue()) : new Integer(imageHeight.intValue());
            if (acqMatrix_2 != null && acqMatrix_2.intValue() > 0) {
                return acqMatrix_2.toString();
            }
            if (acqMatrix_3 != null && acqMatrix_3.intValue() > 0) {
                return acqMatrix_3.toString();
            }
            if (BEST_dim_Y != null) {
                return ((Object)BEST_dim_Y).toString();
            }
            return new String("");
        }

        private String var_fovStr() {
            String fovStr = "";
            String dfov = (String)this.image.getValue(new DMTag(24, 4352));
            String pixelSpacing = (String)this.image.getValue(new DMTag(40, 48));
            String imageWidth = (String)this.image.getValue(new DMTag(40, 1));
            String pixelS1 = "";
            Float dfovFlt = null;
            if (pixelSpacing != null) {
                StringTokenizer st = new StringTokenizer(pixelSpacing, "\\");
                if (st.countTokens() > 1) {
                    st.nextToken();
                    pixelS1 = st.nextToken();
                }
                float f_pixelS1 = Float.parseFloat(pixelS1);
                if (imageWidth != null && !imageWidth.equals("")) {
                    float f_imageWidth = Float.parseFloat(imageWidth);
                    dfovFlt = new Float(f_pixelS1 * f_imageWidth);
                }
            }
            String dfov_str = "";
            if (dfov != null && !dfov.equals("")) {
                float float_dfov = Float.parseFloat(dfov);
                if (float_dfov > 0.0f) {
                    float f1 = float_dfov / 10.0f;
                    dfov_str = dfov_str + new Float(f1).toString();
                }
            } else if (dfovFlt != null && dfovFlt.floatValue() > 0.0f) {
                double db = Math.floor((double)dfovFlt.floatValue() + 0.5) / 10.0;
                dfov_str = dfov_str + new Double(db).toString();
            }
            System.err.println("%%%%%%%%%%%%%%%dfov_str====" + dfov_str);
            String dfov_rect = (String)this.image.getValue(new DMTag(25, 4126));
            Float GEMS_dfov_rect = null;
            if (dfov_rect != null && MRDicomInfo.GEM_sig19(this.image)) {
                GEMS_dfov_rect = new Float(dfov_rect);
            }
            Object obj = this.image.getValue(new DMTag(39, 4147));
            Number iopt = (Number)this.image.getValue(new DMTag(39, 4147));
            Integer GEMS_iopt = null;
            if (MRDicomInfo.GEM_sig27(this.image) && iopt != null) {
                GEMS_iopt = new Integer(iopt.intValue());
            }
            String percentPhasefov = (String)this.image.getValue(new DMTag(24, 148));
            Float F_dfov_rect = null;
            if (GEMS_iopt != null && (GEMS_iopt & 0x10000) == 1) {
                System.err.println("in heere");
                if (dfovFlt != null && Float.parseFloat(this.freqX()) > 0.0f && Float.parseFloat(this.freqY()) > 0.0f) {
                    F_dfov_rect = new Float(Float.parseFloat(this.freqX()) * Float.parseFloat(this.freqY()) * dfovFlt.floatValue());
                }
            } else {
                System.err.println("in here1");
                if (dfovFlt != null && percentPhasefov != null && (double)Float.parseFloat(percentPhasefov) > 0.0) {
                    F_dfov_rect = new Float(dfovFlt.floatValue() * Float.parseFloat(percentPhasefov) / 100.0f);
                }
            }
            if (dfov_str != null) {
                fovStr = fovStr + dfov_str + " X ";
            }
            fovStr = F_dfov_rect != null && F_dfov_rect.floatValue() > 5.0f ? fovStr + new Double(Math.floor(F_dfov_rect.floatValue() / 10.0f + 0.5f)).toString() : fovStr + dfov_str;
            return fovStr;
        }

        private String var_thick() {
            String slthick = (String)this.image.getValue(new DMTag(24, 80));
            String scanspacing = (String)this.image.getValue(new DMTag(24, 136));
            float thkFloat = 0.0f;
            String returnString = "";
            DecimalFormat df = new DecimalFormat("#.#");
            if (slthick != null && !slthick.equals("")) {
                thkFloat = Float.parseFloat(slthick);
                returnString = returnString + df.format(new Float(thkFloat));
            }
            float spacingFloat = 0.0f;
            if (scanspacing != null && !scanspacing.equals("")) {
                spacingFloat = Float.parseFloat(scanspacing);
                returnString = returnString + "/" + df.format(new Float(spacingFloat - thkFloat));
            }
            return returnString;
        }

        private String var_tdel() {
            float flt_triggerTime;
            String triggerTime = (String)this.image.getValue(new DMTag(24, 4192));
            if (triggerTime != null && !triggerTime.equals("") && (flt_triggerTime = Float.parseFloat(triggerTime)) > 0.0f && triggerTime.length() > 9) {
                return triggerTime.substring(0, 8);
            }
            return new String("");
        }

        private String getImNo() {
            String imNo = (String)this.image.getValue(new DMTag(32, 19));
            if (imNo != null) {
                return imNo;
            }
            return new String(" ");
        }

        private Double mr_flip() {
            String flipAngle = (String)this.image.getValue(new DMTag(24, 4884));
            if (flipAngle == null) {
                return null;
            }
            return new Double(flipAngle);
        }

        private String var_flStr() {
            Double mr_flip = this.mr_flip();
            if (mr_flip == null) {
                return new String(" ");
            }
            return mr_flip.toString();
        }

        private String var_teStr() {
            String nominal_inteval = (String)this.image.getValue(new DMTag(24, 4194));
            String echoTime = (String)this.image.getValue(new DMTag(24, 129));
            float flt_te = 0.0f;
            if (echoTime != null) {
                flt_te = Float.parseFloat(echoTime);
            }
            int int_te = (int)Math.floor(flt_te + 0.5f);
            if (nominal_inteval != null || flt_te < 100.0f) {
                int val = (int)Math.floor((flt_te * 10.0f + 0.5f) / 10.0f);
                return new Integer(val).toString();
            }
            return new Integer(int_te).toString();
        }

        private String var_tiStr() {
            String invTime = (String)this.image.getValue(new DMTag(24, 130));
            DecimalFormat df = new DecimalFormat("#");
            if (invTime != null) {
                float flt = Float.parseFloat(invTime);
                double flt_floor = Math.floor(flt + 0.5f);
                return df.format(new Double(flt_floor).intValue());
            }
            double flt_floor = Math.floor(0.5);
            return df.format(new Double(flt_floor).intValue());
        }

        private String var_trStr() {
            String repetitionTime = (String)this.image.getValue(new DMTag(24, 128));
            float flt_tr = 0.0f;
            if (repetitionTime != null) {
                flt_tr = Float.parseFloat(repetitionTime);
            }
            DecimalFormat df = new DecimalFormat("#.#");
            if (flt_tr < 100.0f) {
                double val = Math.floor((double)(flt_tr * 10.0f) + 0.5) / 10.0;
                return df.format(val);
            }
            double val = Math.floor(flt_tr + 0.5f);
            return df.format(val);
        }
    }

    private class MRSeriesInfo {
        DMObject series;
        String html;
        HashMap valueMap = new HashMap();

        public MRSeriesInfo(DMObject series, String html) {
            this.series = series;
            this.html = html;
            this.queryValues();
        }

        public String getHTMLStream() {
            int startIndex = 0;
            String result = "";
            int oldStartIndex = 0;
            while ((startIndex = this.html.indexOf("<td", startIndex)) >= 0) {
                result = result + this.html.substring(oldStartIndex, startIndex);
                int varIndex = this.html.indexOf("var", startIndex);
                if (varIndex >= 0) {
                    result = result + this.html.substring(startIndex, varIndex);
                    int varIndex1 = this.html.indexOf("<", varIndex);
                    String variable = this.html.substring(varIndex, varIndex1);
                    String value = (String)this.valueMap.get(variable);
                    result = result + value;
                    startIndex = oldStartIndex = varIndex1;
                    continue;
                }
                varIndex = this.html.indexOf("</td", startIndex);
                oldStartIndex = startIndex;
                startIndex = varIndex;
            }
            result = result + this.html.substring(oldStartIndex, this.html.length());
            return result;
        }

        private void queryValues() {
            this.valueMap.put(new String("var_seNo"), this.getSeNo());
            this.valueMap.put(new String("var_numImags"), this.var_numImags());
            this.valueMap.put(new String("var_Plane"), this.var_Plane());
            this.valueMap.put(new String("var_seType"), MRDicomInfo.var_seType(this.series));
            this.valueMap.put(new String("var_seDesc"), this.var_seDesc());
            this.valueMap.put(new String("var_PSD"), MRDicomInfo.var_PSD(this.series));
            this.valueMap.put(new String("var_scanRange"), this.var_scanRange());
        }

        private String var_seDesc() {
            String se_desc = (String)this.series.getValue(new DMTag(8, 4158));
            if (se_desc != null) {
                return se_desc;
            }
            return new String(" ");
        }

        private boolean GEM_sig19() {
            String manuf1 = (String)this.series.getValue(new DMTag(25, 16));
            return manuf1.equals("GEMS_ACQU_01");
        }

        private String var_Plane() {
            String tmp_plane = "";
            Number se_plane = (Number)this.series.getValue(new DMTag(25, 4119));
            Number GEMS_se_plane = null;
            if (se_plane != null && this.GEM_sig19()) {
                GEMS_se_plane = se_plane;
            }
            if (GEMS_se_plane != null) {
                int int_se_plane = GEMS_se_plane.intValue();
                if ((GEMS_se_plane.intValue() & 0x100) == 1) {
                    tmp_plane = tmp_plane + "MIX ";
                }
            } else {
                int int_GEMS_plane;
                Integer plane = (Integer)this.series.getValue(new DMTag(39, 4149));
                Integer GEMS_plane = null;
                if (plane != null) {
                    GEMS_plane = plane;
                }
                if (GEMS_plane != null && (int_GEMS_plane = ((Number)GEMS_plane).intValue()) > 0 && int_GEMS_plane <= 1024) {
                    if ((int_GEMS_plane & 0x40) == 1) {
                        tmp_plane = tmp_plane + "RFMT";
                    }
                    if ((int_GEMS_plane & 0x20) == 1) {
                        tmp_plane = tmp_plane + "PAX";
                    }
                    if ((int_GEMS_plane & 0x10) == 1) {
                        tmp_plane = tmp_plane + "O" + this.tmp_plane2();
                    } else if ((int_GEMS_plane & 8) == 1) {
                        tmp_plane = tmp_plane + "Cor";
                    } else if ((int_GEMS_plane & 4) == 1) {
                        tmp_plane = tmp_plane + "Sag";
                    } else if ((int_GEMS_plane & 2) == 1) {
                        tmp_plane = tmp_plane + "Ax";
                    }
                    if ((int_GEMS_plane & 1) == 1) {
                        tmp_plane = tmp_plane + "SCT";
                    }
                }
            }
            return tmp_plane;
        }

        private String var_scanRange() {
            String start = this.startScanRange();
            String end = this.endScanRange();
            String startEnd = "";
            if (!start.equals("") || !end.equals("")) {
                startEnd = startEnd + " - ";
            }
            return start + startEnd + end;
        }

        private String startScanRange() {
            String startScanRange = "";
            String GEMS_start_loc = (String)this.series.getValue(new DMTag(25, 4121));
            if (GEMS_start_loc == null) {
                return new String("");
            }
            DecimalFormat df = new DecimalFormat("#.#");
            GEMS_start_loc = df.format(Math.abs(Float.parseFloat(GEMS_start_loc)));
            float fstartLoc = Float.parseFloat(GEMS_start_loc);
            String start_ras = (String)this.series.getValue(new DMTag(25, 4120));
            if (start_ras != null) {
                startScanRange = startScanRange + start_ras + Float.toString(fstartLoc);
            }
            return startScanRange;
        }

        private String endScanRange() {
            String endScanRange = "";
            String GEMS_end_loc = (String)this.series.getValue(new DMTag(25, 4123));
            if (GEMS_end_loc == null) {
                return new String("");
            }
            DecimalFormat df = new DecimalFormat("#.#");
            GEMS_end_loc = df.format(Math.abs(Float.parseFloat(GEMS_end_loc)));
            float fendLoc = Float.parseFloat(GEMS_end_loc);
            String end_ras = (String)this.series.getValue(new DMTag(25, 4122));
            endScanRange = endScanRange + end_ras + Float.toString(fendLoc);
            return endScanRange;
        }

        private String GEMS_plane() {
            String plane = (String)this.series.getValue(new DMTag(39, 4149));
            if (plane != null) {
                return plane;
            }
            return null;
        }

        private String GEMS_OLD_obplane() {
            String OLD_obplane = (String)this.series.getValue(new DMTag(39, 4150));
            if (this.GEM_sig27() && OLD_obplane != null) {
                return OLD_obplane;
            }
            return null;
        }

        private boolean GEM_sig27() {
            String manuf1 = (String)this.series.getValue(new DMTag(39, 16));
            return manuf1.equals("GEMS_IMAG_01");
        }

        private String tmp_plane2() {
            String GEMS_plane = this.GEMS_plane();
            String tmp_plane2 = "";
            if (GEMS_plane != null) {
                int int_GEMS_plane = Integer.parseInt(GEMS_plane);
                if ((int_GEMS_plane & 8) == 1) {
                    tmp_plane2 = "Cor ";
                } else if ((int_GEMS_plane & 4) == 1) {
                    tmp_plane2 = "Sag ";
                } else if ((int_GEMS_plane & 2) == 1) {
                    tmp_plane2 = "Ax ";
                } else if ((int_GEMS_plane & 0x40) == 1) {
                    tmp_plane2 = " ";
                } else {
                    String GEMS_obplane = MRDicomInfo.GEMS_obplane(this.series);
                    if (GEMS_obplane != null) {
                        int int_GEMS_obplane = Integer.parseInt(GEMS_obplane);
                        if ((int_GEMS_obplane & 8) == 1) {
                            tmp_plane2 = "Cor ";
                        } else if ((int_GEMS_obplane & 4) == 1) {
                            tmp_plane2 = "Sag ";
                        } else if ((int_GEMS_obplane & 2) == 1) {
                            tmp_plane2 = "Ax ";
                        }
                    }
                }
            }
            return tmp_plane2;
        }

        private String var_numImags() {
            return new Integer(this.series.getRelated("image").length).toString() + this.AContrast();
        }

        private String AContrast() {
            String contrast_agent;
            String contrast_route;
            String Manufacturer = (String)this.series.getValue(new DMTag(8, 112));
            if (Manufacturer != null && Manufacturer.indexOf("GE MEDICAL SYSTEMS") >= 0 ? (contrast_route = (String)this.series.getValue(new DMTag(24, 4160))) != null && contrast_route.indexOf("IV") >= 0 : (contrast_agent = (String)this.series.getValue(new DMTag(24, 16))) != null && contrast_agent.indexOf("NONE") < 0) {
                return new String("+C");
            }
            return new String("");
        }

        private String getSeNo() {
            String seNo = (String)this.series.getValue(new DMTag(32, 17));
            if (seNo != null) {
                return seNo;
            }
            return new String(" ");
        }
    }
}

