/*
 * Decompiled with CFR 0.152.
 */
package com.ge.med.terra.xpv.util;

import java.lang.ref.Reference;
import java.lang.ref.WeakReference;
import java.util.Vector;

public class WeakSingletonTaskManager {
    private static Reference ref = new WeakReference<Object>(null);

    public static void submit(Task task) {
        WorkerThread thread = (WorkerThread)ref.get();
        if (thread == null || !thread.isAlive()) {
            System.err.println("@@@@@@@@@@@@@@@@@@@@@@@@@WeakSingletonTaskManager.submit(): worker thread not found or dead!!!");
            WorkerThread t2 = new WorkerThread(task);
            ref = new WeakReference<WorkerThread>(t2);
        } else {
            System.err.println("@@@@@@@@@@@@@@@@@@@@@@@@@WeakSingletonTaskManager.submit(): add task to existing worker thread!!!");
            thread.add(task);
        }
    }

    public static void cancel(Task task) {
        WorkerThread t2 = (WorkerThread)ref.get();
        if (t2 != null && t2.isAlive()) {
            t2.cancel(task);
        }
    }

    public static boolean raisePriority(Task task, int ind, int len) {
        WorkerThread t2 = (WorkerThread)ref.get();
        if (t2 == null || !t2.isAlive()) {
            return false;
        }
        t2.raisePriority(task, ind, len);
        return true;
    }

    public static boolean waitForDone(Task task, int ind, int len) {
        WeakSingletonTaskManager.raisePriority(task, ind, len);
        WorkerThread t2 = (WorkerThread)ref.get();
        if (t2 == null || !t2.isAlive()) {
            return false;
        }
        for (int i2 = 0; i2 < len; ++i2) {
            try {
                task.doStep(ind + i2);
                continue;
            }
            catch (InterruptedException e2) {
                e2.printStackTrace();
                return false;
            }
        }
        return true;
    }

    private static class WorkerThread
    extends Thread {
        Vector taskV = new Vector();
        Vector highPriorityTaskSteps = new Vector();
        Vector normalPriorityTaskSteps = new Vector();

        public WorkerThread(Task task) {
            super("WeakSingletonTaskManager");
            this.taskV.add(task);
            this.start();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void cancel(Task task) {
            Task pp;
            int i2;
            Vector vector = this.highPriorityTaskSteps;
            synchronized (vector) {
                i2 = 0;
                while (i2 < this.highPriorityTaskSteps.size()) {
                    pp = ((TaskStep)this.highPriorityTaskSteps.get((int)i2)).task_;
                    if (pp == task) {
                        this.highPriorityTaskSteps.remove(i2);
                        continue;
                    }
                    ++i2;
                }
            }
            vector = this.normalPriorityTaskSteps;
            synchronized (vector) {
                i2 = 0;
                while (i2 < this.normalPriorityTaskSteps.size()) {
                    pp = ((TaskStep)this.normalPriorityTaskSteps.get((int)i2)).task_;
                    if (pp == task) {
                        this.normalPriorityTaskSteps.remove(i2);
                        continue;
                    }
                    ++i2;
                }
            }
            if (this.highPriorityTaskSteps.isEmpty() && this.normalPriorityTaskSteps.isEmpty()) {
                this.interrupt();
            }
        }

        public void add(Task task) {
            this.taskV.add(task);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            while (true) {
                Task task = null;
                Vector vector = this.taskV;
                synchronized (vector) {
                    if (this.taskV.size() > 0) {
                        task = (Task)this.taskV.remove(0);
                    }
                }
                if (task != null) {
                    task.init();
                    vector = this.normalPriorityTaskSteps;
                    synchronized (vector) {
                        int len = task.getTotalSteps();
                        for (int i2 = 0; i2 < len; ++i2) {
                            this.normalPriorityTaskSteps.add(new TaskStep(task, i2));
                        }
                    }
                }
                TaskStep taskStep = null;
                Vector i2 = this.highPriorityTaskSteps;
                synchronized (i2) {
                    if (this.highPriorityTaskSteps.size() > 0) {
                        taskStep = (TaskStep)this.highPriorityTaskSteps.remove(0);
                    }
                }
                if (taskStep != null) {
                    try {
                        taskStep.task_.doStep(taskStep.step_);
                    }
                    catch (InterruptedException e2) {
                        this.cancel(taskStep.task_);
                        e2.printStackTrace();
                    }
                    continue;
                }
                Vector e2 = this.normalPriorityTaskSteps;
                synchronized (e2) {
                    if (this.normalPriorityTaskSteps.size() > 0) {
                        taskStep = (TaskStep)this.normalPriorityTaskSteps.remove(0);
                    }
                }
                if (taskStep == null) break;
                try {
                    taskStep.task_.doStep(taskStep.step_);
                }
                catch (InterruptedException e22) {
                    this.cancel(taskStep.task_);
                    e22.printStackTrace();
                }
            }
            System.out.println("WeakSingleton thread to die");
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void raisePriority(Task task, int ind, int len) {
            Vector vector = this.highPriorityTaskSteps;
            synchronized (vector) {
                int i2 = 0;
                while (i2 < this.highPriorityTaskSteps.size()) {
                    Task t2 = ((TaskStep)this.highPriorityTaskSteps.get((int)i2)).task_;
                    if (t2 == task) {
                        this.highPriorityTaskSteps.remove(i2);
                        continue;
                    }
                    ++i2;
                }
                if (Boolean.getBoolean("WeakSingleton.normalOrder")) {
                    for (i2 = 0; i2 < len; ++i2) {
                        this.highPriorityTaskSteps.add(new TaskStep(task, ind + i2));
                    }
                } else {
                    for (i2 = len - 1; i2 >= 0; --i2) {
                        this.highPriorityTaskSteps.add(new TaskStep(task, ind + i2));
                    }
                }
            }
        }
    }

    static class TaskStep {
        Task task_;
        int step_;

        public TaskStep(Task t2, int s2) {
            this.task_ = t2;
            this.step_ = s2;
        }
    }

    public static interface Task {
        public static final String TASK_STEP_DONE_PROPERTY = "taskStepDone";

        public void init();

        public void doStep(int var1) throws InterruptedException;

        public int getTotalSteps();
    }
}

