/*
 * Decompiled with CFR 0.152.
 */
package com.ge.med.terra.xpv.util;

import com.ge.med.terra.xpv.util.PrefernceCapble;
import com.ge.med.terra.xpv.util.Prefs;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.List;
import javax.swing.event.ChangeListener;

public class XpDisplayPrefernce
implements PrefernceCapble {
    private static String bakupFile = "com/ge/med/terra/xpv/util/prefs.properties";
    private static Prefs prefs = null;
    private static String fileName = null;
    public static final String UPDATE_PREFS = "update_prefs";

    @Override
    public void addChangeListener(ChangeListener listener) {
    }

    @Override
    public void removeChangeListener(ChangeListener listener) {
    }

    @Override
    public void refreshContents() {
        try {
            prefs.refreshContents();
        }
        catch (FileNotFoundException e2) {
            e2.printStackTrace();
        }
        catch (IOException e3) {
            e3.printStackTrace();
        }
    }

    @Override
    public int getNumPresets(String modality) {
        if (modality == null) {
            return 0;
        }
        return prefs.getInteger(modality.toLowerCase() + "_num_presets", 0);
    }

    @Override
    public String[] getPresetLabels(String modality) {
        if (modality == null) {
            return null;
        }
        int num = this.getNumPresets(modality);
        if (num == 0) {
            return null;
        }
        String[] strArray = new String[num];
        String prefix = modality.toLowerCase() + "_preset_label";
        for (int i2 = 0; i2 < strArray.length; ++i2) {
            strArray[i2] = prefs.getString(prefix + (i2 + 1));
        }
        return strArray;
    }

    @Override
    public double[][] getWLPresets(String modality) {
        if (modality == null) {
            return null;
        }
        int n2 = this.getNumPresets(modality);
        if (n2 == 0) {
            return null;
        }
        double[][] wlPresets = new double[n2][2];
        for (int i2 = 0; i2 < n2; ++i2) {
            wlPresets[i2][0] = prefs.getFloat(modality.toLowerCase() + "_presets_ww" + i2);
            wlPresets[i2][1] = prefs.getFloat(modality.toLowerCase() + "_presets_wl" + i2);
        }
        return wlPresets;
    }

    @Override
    public double[] getWLPreset(String modality, String label) {
        if (modality == null) {
            return null;
        }
        List list = prefs.getKeys(modality.toLowerCase() + "_preset_label");
        if (list == null || list.size() == 0) {
            return null;
        }
        char index = '\u0000';
        for (int i2 = 0; i2 < list.size(); ++i2) {
            String s2 = (String)list.get(i2);
            if (!prefs.getString(s2).equalsIgnoreCase(label)) continue;
            index = s2.charAt(s2.length() - 1);
            break;
        }
        double[] wl = new double[]{prefs.getFloat(modality.toLowerCase() + "_preset_ww" + index), prefs.getFloat(modality.toLowerCase() + "_preset_wl" + index)};
        return wl;
    }

    @Override
    public double[] getWLPreset(String modality, int index) {
        if (modality == null) {
            return null;
        }
        double[] wl = new double[]{prefs.getFloat(modality.toLowerCase() + "_preset_ww" + index), prefs.getFloat(modality.toLowerCase() + "_preset_wl" + index)};
        return wl;
    }

    @Override
    public String getScreenAnnotationLevel() {
        return prefs.getString("screen_annotation_level");
    }

    @Override
    public int getScreenCustomAnnotationLevel() {
        return prefs.getInteger("screen_custom_annotation_level");
    }

    @Override
    public String getFilmAnnotationLevel() {
        return prefs.getString("film_annotation_level");
    }

    @Override
    public int getFilmCustomAnnotationLevel() {
        return prefs.getInteger("film_custom_annotation_level");
    }

    public static synchronized void updateWLPreset(String modality, String label, double ww, double wl) {
        if (modality == null) {
            return;
        }
        List list = prefs.getKeys(modality.toLowerCase() + "_preset_label");
        if (list == null || list.size() == 0) {
            return;
        }
        char index = '\u0000';
        for (int i2 = 0; i2 < list.size(); ++i2) {
            String s2 = (String)list.get(i2);
            if (!prefs.getString(s2).equalsIgnoreCase(label)) continue;
            index = s2.charAt(s2.length() - 1);
            break;
        }
        prefs.getRepository().put(modality.toLowerCase() + "_preset_ww" + index, Double.toString(ww));
        prefs.getRepository().put(modality.toLowerCase() + "_preset_wl" + index, Double.toString(wl));
    }

    @Override
    public synchronized void updateWLPreset(String modality, int index, String label, double ww, double wl) {
        if (modality == null) {
            return;
        }
        String key = modality.toLowerCase() + "_preset_label" + index;
        prefs.getRepository().put(key, label);
        key = modality.toLowerCase() + "_preset_ww" + index;
        prefs.getRepository().put(key, Double.toString(ww));
        key = modality.toLowerCase() + "_preset_wl" + index;
        prefs.getRepository().put(key, Double.toString(wl));
    }

    @Override
    public synchronized void updateWLPreset(String modality, int index, double ww, double wl) {
        if (modality == null) {
            return;
        }
        String key = modality.toLowerCase() + "_preset_ww" + index;
        prefs.getRepository().put(key, Double.toString(ww));
        key = modality.toLowerCase() + "_preset_wl" + index;
        prefs.getRepository().put(key, Double.toString(wl));
    }

    @Override
    public synchronized void updateWLPresets(String modality, double[][] wl) {
        if (modality == null) {
            return;
        }
        String key = null;
        int i2 = 0;
        while (i2 < wl.length / 2) {
            key = modality.toLowerCase() + "_preset_ww" + ++i2;
            prefs.getRepository().put(key, Double.toString(wl[i2][0]));
            key = modality.toLowerCase() + "_preset_wl" + i2;
            prefs.getRepository().put(key, Double.toString(wl[i2][1]));
        }
    }

    @Override
    public synchronized void updateScreenAnnotationLevel(String val) {
        if (val == null) {
            return;
        }
        if (val.equalsIgnoreCase("all")) {
            prefs.getRepository().put("screen_annotation_level", "all");
        } else if (val.equalsIgnoreCase("partial")) {
            prefs.getRepository().put("screen_annotation_level", "partial");
        } else if (val.equalsIgnoreCase("none")) {
            prefs.getRepository().put("screen_annotation_level", "none");
        } else if (val.equalsIgnoreCase("custom")) {
            prefs.getRepository().put("screen_annotation_level", "custom");
        }
    }

    @Override
    public synchronized void updateScreenCustomAnnotationLevel(int mask) {
        prefs.getRepository().put("screen_custom_annotation_level", Integer.toString(mask));
    }

    @Override
    public synchronized void updateFilmAnnotationLevel(String val) {
        if (val == null) {
            return;
        }
        if (val.equalsIgnoreCase("all")) {
            prefs.getRepository().put("film_annotation_level", "all");
        } else if (val.equalsIgnoreCase("partial")) {
            prefs.getRepository().put("film_annotation_level", "partial");
        } else if (val.equalsIgnoreCase("none")) {
            prefs.getRepository().put("film_annotation_level", "none");
        } else if (val.equalsIgnoreCase("custom")) {
            prefs.getRepository().put("film_annotation_level", "custom");
        }
    }

    @Override
    public synchronized void updateFilmCustomAnnotationLevel(int mask) {
        prefs.getRepository().put("film_custom_annotation_level", Integer.toString(mask));
    }

    @Override
    public synchronized void setReportCursor(boolean isOn) {
        prefs.getRepository().put("Report_Cursor", Boolean.toString(isOn));
    }

    @Override
    public boolean isReportCursorOn() {
        return prefs.getBoolean("Report_Cursor");
    }

    @Override
    public String getImageStatePropagationMode() {
        return prefs.getString("image_state_propagation");
    }

    @Override
    public synchronized void setImageStatePropagationModeNone() {
        prefs.getRepository().put("image_state_propagation", "none");
    }

    @Override
    public synchronized void setImageStatePropagationModeForward() {
        prefs.getRepository().put("image_state_propagation", "forward");
    }

    @Override
    public synchronized void setImageStatePropagationModeAll() {
        prefs.getRepository().put("image_state_propagation", "all");
    }

    @Override
    public String getGraphicPropagationMode() {
        return prefs.getString("graphic_propagation");
    }

    @Override
    public synchronized void setGraphicPropagationModeNone() {
        prefs.getRepository().put("graphic_propagation", "none");
    }

    @Override
    public synchronized void setGraphicPropagationModeAll() {
        prefs.getRepository().put("graphic_propagation", "all");
    }

    @Override
    public boolean isverticalTickOn() {
        return prefs.getBoolean("vertical_ticks");
    }

    @Override
    public synchronized void setVerticalTicks(boolean on) {
        prefs.getRepository().put("vertical_ticks", Boolean.toString(on));
    }

    @Override
    public boolean ishorizontalTickOn() {
        return prefs.getBoolean("horizontal_ticks");
    }

    @Override
    public synchronized void setHorizontalTicks(boolean on) {
        prefs.getRepository().put("horizontal_ticks", Boolean.toString(on));
    }

    @Override
    public boolean isgridOn() {
        return prefs.getBoolean("grid");
    }

    @Override
    public synchronized void setGrid(boolean on) {
        prefs.getRepository().put("grid", Boolean.toString(on));
    }

    @Override
    public boolean isSeriesBindingOn() {
        return prefs.getBoolean("series_binding");
    }

    @Override
    public synchronized void setSeriesBinding(boolean on) {
        prefs.getRepository().put("series_binding", Boolean.toString(on));
    }

    @Override
    public void updatePrefs() {
        try {
            prefs.savePrefs(fileName);
        }
        catch (FileNotFoundException e2) {
            e2.printStackTrace();
        }
        catch (IOException e3) {
            e3.printStackTrace();
        }
    }

    @Override
    public void updateWLPreset() {
    }

    static {
        fileName = System.getProperty("DISPLAY_PREFS", bakupFile);
        try {
            prefs = new Prefs(fileName);
        }
        catch (FileNotFoundException e2) {
            e2.printStackTrace();
        }
        catch (IOException e3) {
            e3.printStackTrace();
        }
    }
}

