/*
 * Decompiled with CFR 0.152.
 */
package srjdom;

import com.archimed.dicom.DDict;
import org.w3c.dom.Attr;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import srjdom.SRCommon;
import srjdom.SRDOMDoc;

public class SRNode {
    Element xmlTag;
    Attr idAttr;
    Attr vrAttr;
    private int tagID;

    public SRNode(int gr, int el) {
        this(DDict.lookupDDict(gr, el));
    }

    public SRNode(int id) {
        this(DDict.getDescription(id), id);
    }

    SRNode(String tag2, int id) {
        this.tagID = id;
        this.xmlTag = SRDOMDoc.srDOM.createElement(tag2);
        this.addAttr(this.tagID);
        this.xmlTag.setUserData("srnode", this, null);
    }

    public SRNode getNextSibling() {
        SRNode nextSibling = null;
        if (this.xmlTag != null) {
            Node node = this.xmlTag.getNextSibling();
        }
        return nextSibling;
    }

    public String toString() {
        return DDict.getDescription(this.tagID);
    }

    public String dump() {
        return this.xmlTag.toString();
    }

    public String toXMLString() {
        String xmlStr = SRCommon.toXMLString(this.xmlTag);
        return xmlStr.substring(0, xmlStr.length() - 1);
    }

    public void writeXML(boolean omitXMLDeclaration) {
        SRCommon.writeXML(this.xmlTag, omitXMLDeclaration);
    }

    private String padTagValue(String tag2) {
        StringBuffer sb = new StringBuffer(tag2);
        int i2 = 0;
        while (sb.length() < 4) {
            sb.insert(0, "0");
            ++i2;
        }
        return sb.toString();
    }

    private void addAttr(int id) {
        this.idAttr = SRDOMDoc.srDOM.createAttribute("tag");
        this.idAttr.setValue(this.padTagValue(Integer.toHexString(DDict.getGroup(id)).toUpperCase()) + "," + this.padTagValue(Integer.toHexString(DDict.getElement(id)).toUpperCase()));
        this.vrAttr = SRDOMDoc.srDOM.createAttribute("vr");
        this.vrAttr.setValue(DDict.getTypeCodeName(id));
        if (!this.xmlTag.getNodeName().equalsIgnoreCase("ITEM")) {
            this.xmlTag.setAttributeNode(this.idAttr);
            this.xmlTag.setAttributeNode(this.vrAttr);
        }
    }
}

