<?xml version="1.0" encoding="UTF-8"?>
<xsl:stylesheet version="1.0" xmlns:xsl="http://www.w3.org/1999/XSL/Transform"
                              xmlns:util="com.ge.med.cse.cvf.sr.SRUtils">

	<xsl:output method="xml" indent="yes" version="1.0" encoding="UTF-8"/>

	<!-- Global variables -->
	<xsl:variable name="DICOM" select="/DICOM" />
	<xsl:variable name="ImageDir" select="$DICOM/@SRImage" />

	<!-- Notification of empty content content items with 1C values. -->
	<xsl:variable name="NO_CONTENT">
		-
	</xsl:variable>

	<xsl:variable name="LF">
		<xsl:value-of select="'&#x0A;'" />
	</xsl:variable>
	<xsl:variable name="NewLineSeparator">
		\n
	</xsl:variable>
<xsl:template match="/">
  <html>
  <meta content="text/html; charset=UTF-8" http-equiv="Content-Type" />
  <body>
  <h1><xsl:value-of select="$DICOM/ConceptNameCodeSequence/Item/CodeMeaning"></xsl:value-of></h1>
   	<table width="100%" border="0">
		<tr>
			<td align="left">
				<table border="0" width="30%"
					style="font-family: Arial; font-size: 10pt">
					<tr>
						<td style="width: 60%; vertical-align: top;">
							<b>Completion Flag: </b>
						</td>
						<td style="vertical-align: top;">
							<xsl:value-of select="$DICOM/CompletionFlag"/>
						</td>
					</tr>
					<tr>
						<td style="width: 30%; vertical-align: top;">
							<b>Verification Flag: </b>
						</td>
						<td style="vertical-align: top;">
							<xsl:value-of select="$DICOM/VerificationFlag"/>
						</td>
					</tr>
					<tr>
						<td style="width: 30%; vertical-align: top;">
							<b>Verifying Observers: </b>
						</td>
						<td style="vertical-align: top;">
							<xsl:value-of select="$DICOM/VerifyingObserverSequence/Item/VerifyingObserverName"/>
						</td>
					</tr>
					<tr>
						<td style="width: 30%; vertical-align: top;">
							<b>Content Date/Time: </b>
						</td>
						<td style="vertical-align: top;">
							<xsl:value-of select="$DICOM/VerifyingObserverSequence/Item/VerificationDateTime"/>
						</td>
					</tr>
				</table>
			</td>
		</tr>
	</table>
	
  <h2>Patient Information</h2>
 
 	<table width="100%" border="0">
		<tr>
			<td align="left">
				<table border="0" width="30%"
					style="font-family: Arial; font-size: 10pt">
					<tr>
						<td style="width: 60%; vertical-align: top;">
							<b>Patient Name:</b>
						</td>
						<td style="vertical-align: top;">
							<xsl:value-of select="$DICOM/PatientName"/>
						</td>
					</tr>
					<tr>
						<td style="width: 30%; vertical-align: top;">
							<b>Patient Id:</b>
						</td>
						<td style="vertical-align: top;">
							<xsl:value-of select="$DICOM/PatientID"/>
						</td>
					</tr>
					<tr>
						<td style="width: 30%; vertical-align: top;">
							<b>Patient Birthday: </b>
						</td>
						<td style="vertical-align: top;">
							<xsl:value-of select="$DICOM/PatientBirthDate"/>
						</td>
					</tr>
					<tr>
						<td style="width: 30%; vertical-align: top;">
							<b>Patient Sex:  </b>
						</td>
						<td style="vertical-align: top;">
							<xsl:value-of select="$DICOM/PatientSex"/>
						</td>
					</tr>
					<tr>
						<td style="width: 30%; vertical-align: top;">
							<b>Referring Physician: </b>
						</td>
						<td style="vertical-align: top;">
							<xsl:value-of select="DICOM/ReferringPhysiciansName"/>
						</td>
					</tr>
					<tr>
						<td style="width: 30%; vertical-align: top;">
							<b>Accession No:  </b>
						</td>
						<td style="vertical-align: top;">
							<xsl:value-of select="DICOM/AccessionNumber"/>
						</td>
					</tr>
					<tr>
						<td style="width: 30%; vertical-align: top;">
							<b>Study Description:  </b>
						</td>
						<td style="vertical-align: top;">
							<xsl:value-of select="$DICOM/StudyDescription"/>
						</td>
					</tr>
					<tr>
						<td style="width: 30%; vertical-align: top;">
							<b>Modality: </b>
						</td>
						<td style="vertical-align: top;">
							<xsl:value-of select="DICOM/Modality"/>
						</td>
					</tr>
				</table>
			</td>
		</tr>
	</table>
 
  <h2>Equipment Information</h2>
  
  <table width="100%" border="0">
		<tr>
			<td align="left">
				<table border="0" width="30%"
					style="font-family: Arial; font-size: 10pt">
					<tr>
						<td style="width: 60%; vertical-align: top;">
							<b>Organization:  </b>
						</td>
						<td style="vertical-align: top;">
							<xsl:value-of select="$DICOM/VerifyingObserverSequence/Item/VerifyingOrganization"/>
						</td>
					</tr>
					<tr>
						<td style="width: 30%; vertical-align: top;">
							<b>Manufacturer:  </b>
						</td>
						<td style="vertical-align: top;">
							<xsl:value-of select="$DICOM/Manufacturer"/>
						</td>
					</tr>
					<tr>
						<td style="width: 30%; vertical-align: top;">
							<b>Model:  </b>
						</td>
						<td style="vertical-align: top;">
							<xsl:value-of select="$DICOM/ManufacturerModelName"/>
						</td>
					</tr>
					<tr>
						<td style="width: 30%; vertical-align: top;">
							<b>Serial No:  </b>
						</td>
						<td style="vertical-align: top;">
							<xsl:value-of select="$DICOM/DeviceSerialNumber"/>
						</td>
					</tr>
					<tr>
						<td style="width: 30%; vertical-align: top;">
							<b>Software Version:  </b>
						</td>
						<td style="vertical-align: top;">
							<xsl:value-of select="$DICOM/SoftwareVersion"/>
						</td>
					</tr>
				</table>
			</td>
		</tr>
	</table>
	
  <xsl:call-template name="processReportSections">
	 <xsl:with-param name="pCurSectionPos" select="current()" />
  </xsl:call-template>
  </body>
  </html>
  <xsl:value-of select="util:clearItemLists()"/>
</xsl:template>
	<!-- #################################################################################################### 
		Template: processReportSections Description: Process report sections. Parameters: 
		pCurSectionPos : -->

	<xsl:template name="processReportSections">
		<xsl:param name="pCurSectionPos" />
		<h1 style="text-align: left; font-weight: bold; color: #FF0000;">Images are not clinically applicable !</h1>
		<xsl:for-each
			select="$DICOM/ContentSequence/Item[RelationshipType = 'CONTAINS']">
			<xsl:call-template name="addContentItem">
				<xsl:with-param name="pItem" select="current()" />
				<xsl:with-param name="pPosition"
					select="concat($pCurSectionPos, position())" />
			</xsl:call-template>
		</xsl:for-each>
	</xsl:template>
	
	<xsl:template name="addContentItem">
		<xsl:param name="pItem" />
		<xsl:param name="pPosition" />
		<a name="{concat(translate($pItem/ConceptNameCodeSequence/Item/CodeMeaning, ' ', ''), $pPosition)}" />
		<xsl:if test="($pItem/ConceptNameCodeSequence/Item/CodeMeaning) and not (util:isItemAlreadyAdded($pItem/ConceptNameCodeSequence/Item/CodeMeaning))">
			<h2>
				<xsl:value-of select="$pItem/ConceptNameCodeSequence/Item/CodeMeaning" />
				<xsl:value-of select="util:addItem($pItem/ConceptNameCodeSequence/Item/CodeMeaning)" />
			</h2>
		</xsl:if>
		<xsl:call-template name="addItemWithGeneric">
			<xsl:with-param name="pItem" select="$pItem" />
			<xsl:with-param name="itemVal" select="$pItem/ConceptNameCodeSequence/Item/CodeMeaning" />
		</xsl:call-template>
	</xsl:template>
	
	<xsl:template name="addItemWithGeneric">
		<xsl:param name="pItem" />
		<xsl:param name="itemVal" />

		<!-- Add value of different Value Types except CONTAINER. -->
		<xsl:if test="not($pItem/ValueType_CONTAINER)">
			<xsl:call-template name="addValue">
				<xsl:with-param name="pCurrent" select="$pItem" />
			</xsl:call-template>
		</xsl:if>
		<!-- Process nested ContentSequences. -->
		<xsl:if test="$pItem/ContentSequence">
			<xsl:call-template name="addRecursiveContent">
				<xsl:with-param name="itemVal" select="$itemVal" />
				<xsl:with-param name="pCurrent" select="$pItem" />
			</xsl:call-template>
		</xsl:if>
	</xsl:template>
	
	<xsl:template name="addValue">
		<xsl:param name="pCurrent" />
		<xsl:param name="pUnit" select="'cv'" />
		<xsl:choose>
			<xsl:when test="$pCurrent/ValueType_TEXT or $pCurrent/ValueType = 'TEXT'">
				<xsl:choose>
					<xsl:when test="contains($pCurrent/TextValue, $LF)">
						<xsl:call-template name="break2NewLine">
							<xsl:with-param name="pText" select="$pCurrent/TextValue" />
							<xsl:with-param name="pNewLineSeparator" select="$LF" />
						</xsl:call-template>
					</xsl:when>
					<xsl:otherwise>
						<xsl:value-of select="$pCurrent/TextValue" />
					</xsl:otherwise>
				</xsl:choose>
			</xsl:when>
			<xsl:when test="$pCurrent/ValueType_CODE or $pCurrent/ValueType = 'CODE'">
				<xsl:call-template name="addCODEValue">
					<xsl:with-param name="pCurrent" select="$pCurrent" />
				</xsl:call-template>
			</xsl:when>
			<xsl:when test="$pCurrent/ValueType_NUM or $pCurrent/ValueType = 'NUM'">
				<xsl:value-of select="$pCurrent/MeasuredValueSequence/Item/NumericValue" />
				<xsl:choose>
					<xsl:when test="$pUnit = 'cv'">
						<xsl:if
							test="$pCurrent/MeasuredValueSequence/Item/MeasurementUnitsCodeSequence/Item/CodeValue != '1'">
							<xsl:value-of
								select="concat(' ', $pCurrent/MeasuredValueSequence/Item/MeasurementUnitsCodeSequence/Item/CodeValue)" />
						</xsl:if>
					</xsl:when>
					<xsl:when test="$pUnit = 'cm'">
						<xsl:value-of
							select="concat(' ', $pCurrent/MeasuredValueSequence/Item/MeasurementUnitsCodeSequence/Item/CodeMeaning)" />
					</xsl:when>
				</xsl:choose>
			</xsl:when>
			<xsl:when
				test="$pCurrent/ValueType_PNAME or $pCurrent/ValueType = 'PNAME'">
				<xsl:value-of select="$pCurrent/PersonName" />
			</xsl:when>
			<xsl:when test="$pCurrent/ValueType_DATE or $pCurrent/ValueType = 'DATE'">
				<xsl:value-of select="$pCurrent/Date" />
			</xsl:when>
			<xsl:when test="$pCurrent/ValueType_TIME or $pCurrent/ValueType = 'TIME'">
				<xsl:if test="$DICOM/@international_date_time = 'true'">
					<xsl:attribute name="title">HH:MM:SS</xsl:attribute>
				</xsl:if>
				<xsl:value-of select="$pCurrent/Time" />
			</xsl:when>
			<xsl:when
				test="$pCurrent/ValueType_DATETIME or $pCurrent/ValueType = 'DATETIME'">
				<xsl:if test="$DICOM/@international_date_time = 'true'">
					<xsl:attribute name="title">YYYY-MM-DD, HH:MM:SS</xsl:attribute>
				</xsl:if>
				<xsl:value-of select="$pCurrent/DateTime" />
			</xsl:when>
			<xsl:when
				test="$pCurrent/ValueType_UIDREF or $pCurrent/ValueType = 'UIDREF'">
				<xsl:value-of select="$pCurrent/UID" />
			</xsl:when>
			<xsl:when
				test="$pCurrent/ValueType_COMPOSITE or $pCurrent/ValueType = 'COMPOSITE'">
				<a href="{$pCurrent/ReferencedSOPSequence/Item/ReferencedSOPInstanceUID}">
					<xsl:value-of
						select="$pCurrent/ReferencedSOPSequence/Item/ReferencedSOPInstanceUID" />
				</a>
			</xsl:when>
			
			<xsl:when
				test="$pCurrent/ValueType_IMAGE or $pCurrent/ValueType = 'IMAGE'">
				<xsl:if test="util:hasImgeOrWaveForm()">
					<xsl:call-template name="addImage">
						<xsl:with-param name="pSOPClassUID"
							select="$pCurrent/ReferencedSOPSequence/Item/ReferencedSOPClassUID" />
						<xsl:with-param name="pSOPInstUID"
							select="$pCurrent/ReferencedSOPSequence/Item/ReferencedSOPInstanceUID" />
						<xsl:with-param name="pIconImageSeq"
							select="$pCurrent/ReferencedSOPSequence/Item/IconImageSequence" />
					</xsl:call-template>
				</xsl:if>
			</xsl:when>
			<xsl:when
				test="$pCurrent/ValueType_WAVEFORM or $pCurrent/ValueType = 'WAVEFORM'">
				<xsl:if test="util:hasImgeOrWaveForm()">
					<xsl:message>
						<xsl:value-of select="$pCurrent/ValueType_WAVEFORM" />
					</xsl:message>
					<a href="{$pCurrent/ReferencedSOPSequence/Item/ReferencedSOPInstanceUID}">
						<xsl:value-of
							select="$pCurrent/ReferencedSOPSequence/Item/ReferencedSOPInstanceUID" />
					</a>
				</xsl:if>
			</xsl:when>
		</xsl:choose>
	</xsl:template>
	
	<xsl:template name="addRecursiveContent">
		<xsl:param name="itemVal" />
		<xsl:param name="pCurrent" />

		<table border="1" >
         <tr bgcolor="#6D7B8D">
           <xsl:if test="not (util:isColumnsAddedForItem($itemVal))">
			 <xsl:for-each select="$pCurrent/ContentSequence/Item">
				<th width="6%"><font SIZE="2"><xsl:value-of select="ConceptNameCodeSequence/Item/CodeMeaning" /></font></th>
			</xsl:for-each>
			<xsl:value-of select="util:addedColumnsForItem($itemVal)" />
		  </xsl:if>
		 </tr>
		 <tr>
			<xsl:for-each select="$pCurrent/ContentSequence/Item">
        	    <td style="width: 6%">
        	       <xsl:call-template name="addValue">
					   <xsl:with-param name="pCurrent" select="current()" />
			       </xsl:call-template>
		       </td>
            </xsl:for-each>
          </tr>
		</table>
	</xsl:template>
	
	<xsl:template name="break2NewLine">
		<xsl:param name="pText" />
		<xsl:param name="pNewLineSeparator" select="$NewLineSeparator" />

		<xsl:choose>
			<xsl:when test="contains($pText, $pNewLineSeparator)">
				<xsl:value-of select="substring-before($pText, $pNewLineSeparator)" />
				<br />
				<xsl:call-template name="break2NewLine">
					<xsl:with-param name="pText"
						select="substring-after($pText, $pNewLineSeparator)" />
					<xsl:with-param name="pNewLineSeparator" select="$pNewLineSeparator" />
				</xsl:call-template>
			</xsl:when>
			<xsl:otherwise>
				<xsl:value-of select="$pText" />
				<br />
			</xsl:otherwise>
		</xsl:choose>
	</xsl:template>
	
	<xsl:template name="addImage">
		<xsl:param name="pSOPClassUID" />
		<xsl:param name="pSOPInstUID" />
		<xsl:param name="pIconImageSeq" />
		<a>
		<img width="256" height="256" name="temp"
				onclick="this.height=512;this.width=512" ondblclick="this.height=256;this.width=256">
		<xsl:attribute name="alt">
        
        </xsl:attribute>
				<xsl:attribute name="src">
           <xsl:value-of select="util:getURI(concat($ImageDir, $pSOPInstUID, '.jpg'))" />
    </xsl:attribute>
			</img>
		</a>
	</xsl:template>
	
	<xsl:template name="addCODEValue">
		<xsl:param name="pCurrent" />
		<xsl:value-of select="$pCurrent/ConceptCodeSequence/Item/CodeMeaning" />
	</xsl:template>
</xsl:stylesheet>