/*
 * Decompiled with CFR 0.152.
 */
package com.archimed.codec.jpeg;

import com.archimed.codec.jpeg.DecompressInfo;
import com.archimed.codec.jpeg.FComponent;
import com.archimed.codec.jpeg.HuffmanTable;
import com.archimed.codec.jpeg.HuffmanTableReader;
import com.archimed.codec.jpeg.SComponent;
import com.archimed.dicom.Jdt;
import com.archimed.dicom.data.BitTools;
import com.archimed.log.JdtLogger;
import java.io.IOException;

public class Jpeg14Decoder {
    private static JdtLogger log = Jdt.getJdtLoggerFactory().getJdtLogger(Jpeg14Decoder.class);
    private static final int ZERO = 0;
    private static final int ONE = 1;
    private static final int FIVE_SEVEN = 57;
    private static final int OXFF = 255;
    private static final byte OXFF2Byte = -1;
    private static final int OXFFFF = 65535;
    private static final int RST0 = 208;
    private static final int SOF3 = 195;
    private static final int SOI = 216;
    private static final int SOS = 218;
    private static final int COM = 254;
    private static final int APP0 = 224;
    private long bitbuffer;
    private int bitsleft = 0;
    private int bytecounter = 0;
    private byte c;
    private byte c2;
    int code;
    private DecompressInfo dcmprI = new DecompressInfo();
    private byte[] inbuffer;
    int j;
    private int nf;
    private int ns;
    private byte[] outbuffer;
    private int[] componentOffsetLookup = new int[255];
    private int sampleBytes;
    int temp;
    int value;
    private int width;
    private int height;
    private int precision;
    private static final int[] bmask = new int[]{0, 1, 3, 7, 15, 31, 63, 127, 255, 511, 1023, 2047, 4095, 8191, 16383, Short.MAX_VALUE, 65535};
    private static final int DHT = 196;
    private static final int DRI = 221;
    private static final int EIGHT = 8;
    private static final int EOI = 217;
    private static final String ERROR_MESSAGE_BAD_HUFFMAN_CODE = "bad Huffman code";
    private static final int[] extendOffset = new int[]{0, -1, -3, -7, -15, -31, -63, -127, -255, -511, -1023, -2047, -4095, -8191, -16383, -32767};
    private static final int[] extendTest = new int[]{0, 1, 2, 4, 8, 16, 32, 64, 128, 256, 512, 1024, 2048, 4096, 8192, 16384};

    public byte[] decode(byte[] inbuffer) throws IOException {
        this.bitsleft = 0;
        this.bitbuffer = 0L;
        this.bytecounter = 0;
        this.inbuffer = inbuffer;
        this.process();
        return this.outbuffer;
    }

    private void applyPointTransform(int componentIndex) {
        int nofpixels = this.width * this.height;
        int idx = componentIndex;
        if (this.precision > 8) {
            for (int i = 0; i < nofpixels; ++i) {
                int t = this.get2Bytes(this.outbuffer, idx) << this.dcmprI.al;
                this.outbuffer[idx] = (byte)t;
                this.outbuffer[idx + 1] = (byte)(t >> 8);
                idx += 2 * this.nf;
            }
        } else {
            for (int i = 0; i < nofpixels; ++i) {
                int t = BitTools.unsignToInt((byte)this.outbuffer[i]);
                this.outbuffer[idx] = (byte)(t << this.dcmprI.al);
                idx += this.nf;
            }
        }
    }

    private void decodeAsFirstRow(int row) throws IOException {
        int sampleValue;
        int diff;
        int value;
        int destination;
        int componentIndex;
        for (int comp = 0; comp < this.ns; ++comp) {
            componentIndex = this.componentOffsetLookup[this.dcmprI.scomps[comp].cs];
            destination = this.dcmprI.scomps[comp].td;
            value = this.huffDecode(destination);
            if (value == 16) {
                diff = 32768;
            } else if (value != 0) {
                diff = this.get_bits(value);
                diff = this.extend(diff, value);
            } else {
                diff = 0;
            }
            if (this.precision > 8) {
                sampleValue = this.decodeFirstPixelFirstRow(diff, this.dcmprI.al);
                this.outbuffer[row * this.width * 2 * this.nf + 2 * componentIndex] = (byte)sampleValue;
                this.outbuffer[row * this.width * 2 * this.nf + 2 * componentIndex + 1] = (byte)(sampleValue >> 8);
                continue;
            }
            this.outbuffer[row * this.width * this.nf + componentIndex] = (byte)this.decodeFirstPixelFirstRow(diff, this.dcmprI.al);
        }
        for (int col = 1; col < this.width; ++col) {
            for (int comp = 0; comp < this.ns; ++comp) {
                componentIndex = this.componentOffsetLookup[this.dcmprI.scomps[comp].cs];
                destination = this.dcmprI.scomps[comp].td;
                value = this.huffDecode(destination);
                if (value == 16) {
                    diff = 32768;
                } else if (value != 0) {
                    diff = this.get_bits(value);
                    diff = this.extend(diff, value);
                } else {
                    diff = 0;
                }
                if (this.precision > 8) {
                    sampleValue = this.decodeOtherPixelsFirstRow16bits(row, col, componentIndex, diff);
                    this.outbuffer[(row * this.width + col) * 2 * this.nf + 2 * componentIndex] = (byte)sampleValue;
                    this.outbuffer[(row * this.width + col) * 2 * this.nf + 2 * componentIndex + 1] = (byte)(sampleValue >> 8);
                    continue;
                }
                this.outbuffer[(row * this.width + col) * this.nf + componentIndex] = (byte)this.decodeOtherPixelsFirstRow8bits(row, col, componentIndex, diff);
            }
        }
        if (this.dcmprI.restartInRows != 0) {
            --this.dcmprI.restartRowsToGo;
        }
    }

    private int extend(int v, int t) {
        if (v < extendTest[t]) {
            return v + extendOffset[t];
        }
        return v;
    }

    private void fillBitBuffer(int nbits) {
        while (this.bitsleft < 57) {
            if (this.bytecounter == this.inbuffer.length) {
                this.c = 0;
                break;
            }
            this.c = this.inbuffer[this.bytecounter++];
            if (this.c == -1) {
                this.c2 = this.inbuffer[this.bytecounter++];
                if (this.c2 != 0) {
                    this.bytecounter -= 2;
                    if (this.bitsleft >= nbits) break;
                    this.c = 0;
                }
            }
            this.bitbuffer = this.bitbuffer << 8 | (long)(this.c & 0xFF);
            this.bitsleft += 8;
        }
    }

    private int get_bit() {
        if (this.bitsleft == 0) {
            this.fillBitBuffer(1);
        }
        return (int)(this.bitbuffer >> --this.bitsleft) & 1;
    }

    private int get_bits(int nbits) {
        if (this.bitsleft < nbits) {
            this.fillBitBuffer(nbits);
        }
        return (int)(this.bitbuffer >> (this.bitsleft -= nbits) & (long)bmask[nbits]);
    }

    private int get2Bytes(byte[] buffer, int position) {
        return (buffer[position] & 0xFF) + 256 * (buffer[position + 1] & 0xFF);
    }

    private int getMarker() {
        while (this.inbuffer[this.bytecounter] != -1) {
            ++this.bytecounter;
        }
        while (this.inbuffer[this.bytecounter] == -1) {
            ++this.bytecounter;
        }
        return this.inbuffer[this.bytecounter++] & 0xFF;
    }

    private int getLength() {
        return this.getUnsignedWord();
    }

    private int getUnsignedWord() {
        int i = (this.inbuffer[this.bytecounter++] & 0xFF) << 8;
        return i += this.inbuffer[this.bytecounter++] & 0xFF;
    }

    private void findFirstMarker() {
        while (this.inbuffer[this.bytecounter] != -1) {
            ++this.bytecounter;
        }
    }

    private int huffDecode(int destination) throws IOException {
        this.code = this.show_bits8();
        if (this.dcmprI.hts[destination].numbits[this.code] != 0) {
            this.bitsleft -= this.dcmprI.hts[destination].numbits[this.code];
            this.value = this.dcmprI.hts[destination].value[this.code];
        } else {
            this.bitsleft -= 8;
            int i = 8;
            while (this.code > this.dcmprI.hts[destination].maxcode[i]) {
                this.temp = this.get_bit();
                this.code = this.code << 1 | this.temp;
                ++i;
                if (this.code == 65535) break;
                if (i != this.dcmprI.hts[destination].maxcode.length) continue;
                System.out.println("big problem");
            }
            if (i > 16) {
                throw new IOException(ERROR_MESSAGE_BAD_HUFFMAN_CODE);
            }
            this.j = this.dcmprI.hts[destination].valptr[i];
            this.j += this.code - this.dcmprI.hts[destination].mincode[i];
            this.value = this.dcmprI.hts[destination].huffval[this.j];
        }
        return this.value;
    }

    private int decodeFirstPixelOtherRows(int row, int componentIndex, int comp) throws IOException {
        int destination = this.dcmprI.scomps[comp].td;
        int value = this.huffDecode(destination);
        int diff = 0;
        if (value == 16) {
            diff = 32768;
        } else if (value != 0) {
            diff = this.get_bits(value);
            diff = this.extend(diff, value);
        }
        int pixvalue = this.precision > 8 ? this.get2Bytes(this.outbuffer, (row - 1) * 2 * this.nf * this.width + 2 * componentIndex) + diff : (this.outbuffer[(row - 1) * this.nf * this.width + componentIndex] & 0xFF) + diff;
        return pixvalue;
    }

    private int decodeFirstPixelFirstRow(int diff, int pointTransform) {
        return (1 << this.precision - pointTransform - 1) + diff;
    }

    private int decodeOtherPixelsFirstRow8bits(int row, int col, int componentIndex, int diff) {
        return (this.outbuffer[(row * this.width + col - 1) * this.nf + componentIndex] & 0xFF) + diff;
    }

    private int decodeOtherPixelsFirstRow16bits(int row, int col, int componentIndex, int diff) {
        return this.get2Bytes(this.outbuffer, (row * this.width + col - 1) * 2 * this.nf + 2 * componentIndex) + diff;
    }

    private int decodeOtherPixelsOtherRows(int row, int col, int componentIndex, int comp) throws IOException {
        int value = this.huffDecode(this.dcmprI.scomps[comp].td);
        int diff = 0;
        if (value == 16) {
            diff = 32768;
        } else if (value != 0) {
            diff = this.get_bits(value);
            diff = this.extend(diff, value);
        }
        if (this.precision > 8) {
            return this.decodeOtherPixelsOtherRows16bit(row, col, componentIndex, diff);
        }
        return this.decodeOtherPixelsOtherRows8bit(row, col, componentIndex, diff);
    }

    private int decodeOtherPixelsOtherRows16bit(int row, int col, int componentIndex, int diff) {
        int pixvalue = this.predict(this.get2Bytes(this.outbuffer, (row * this.width + col - 1) * 2 * this.nf + 2 * componentIndex), this.get2Bytes(this.outbuffer, ((row - 1) * this.width + col) * 2 * this.nf + 2 * componentIndex), this.get2Bytes(this.outbuffer, ((row - 1) * this.width + col - 1) * this.nf + 2 * componentIndex)) + diff;
        return pixvalue;
    }

    private int decodeOtherPixelsOtherRows8bit(int row, int col, int componentIndex, int diff) {
        return this.predict(this.outbuffer[(row * this.width + col - 1) * this.nf + componentIndex] & 0xFF, this.outbuffer[((row - 1) * this.width + col) * this.nf + componentIndex] & 0xFF, this.outbuffer[((row - 1) * this.width + col - 1) * this.nf + componentIndex] & 0xFF) + diff;
    }

    private int predict(int a, int b, int c) {
        switch (this.dcmprI.predictor) {
            case 0: {
                break;
            }
            case 1: {
                return a;
            }
            case 2: {
                return b;
            }
            case 3: {
                return c;
            }
            case 4: {
                return a + b - c;
            }
            case 5: {
                return a + (b - c >> 1);
            }
            case 6: {
                return b + (a - c >> 1);
            }
            case 7: {
                return a + b >> 1;
            }
        }
        return 0;
    }

    private void processScan() throws IOException {
        int componentIndex;
        this.bitsleft = 0;
        this.bitbuffer = 0L;
        this.dcmprI.restartRowsToGo = this.dcmprI.restartInRows = this.dcmprI.restartInterval / this.width;
        this.dcmprI.nextRestartNum = 0;
        this.decodeAsFirstRow(0);
        for (int row = 1; row < this.height; ++row) {
            int pixel;
            if (this.dcmprI.restartInRows != 0) {
                if (this.dcmprI.restartRowsToGo == 0) {
                    this.processRestart();
                    this.decodeAsFirstRow(row);
                    continue;
                }
                --this.dcmprI.restartRowsToGo;
            }
            for (int comp = 0; comp < this.ns; ++comp) {
                componentIndex = this.componentOffsetLookup[this.dcmprI.scomps[comp].cs];
                pixel = this.decodeFirstPixelOtherRows(row, componentIndex, comp);
                if (this.precision > 8) {
                    this.outbuffer[2 * this.width * row * this.nf + 2 * componentIndex] = (byte)pixel;
                    this.outbuffer[2 * this.width * row * this.nf + 2 * componentIndex + 1] = (byte)(pixel >> 8);
                    continue;
                }
                this.outbuffer[this.width * row * this.nf + componentIndex] = (byte)pixel;
            }
            for (int col = 1; col < this.width; ++col) {
                for (int comp = 0; comp < this.ns; ++comp) {
                    componentIndex = this.componentOffsetLookup[this.dcmprI.scomps[comp].cs];
                    pixel = this.decodeOtherPixelsOtherRows(row, col, componentIndex, comp);
                    if (this.precision > 8) {
                        this.outbuffer[2 * this.nf * (this.width * row + col) + 2 * componentIndex] = (byte)pixel;
                        this.outbuffer[2 * this.nf * (this.width * row + col) + 2 * componentIndex + 1] = (byte)(pixel >> 8);
                        continue;
                    }
                    this.outbuffer[this.nf * (this.width * row + col) + componentIndex] = (byte)pixel;
                }
            }
        }
        if (this.dcmprI.al > 0) {
            for (int comp = 0; comp < this.ns; ++comp) {
                componentIndex = this.componentOffsetLookup[this.dcmprI.scomps[comp].cs];
                this.applyPointTransform(componentIndex);
            }
        }
    }

    private void process() throws IOException {
        int marker = this.getMarker();
        if (marker != 216) {
            throw new IOException("Not a valid lossless JPEG file");
        }
        block8: do {
            marker = this.getMarker();
            switch (marker) {
                case 196: {
                    HuffmanTableReader htr = new HuffmanTableReader();
                    this.bytecounter = htr.read(this.inbuffer, this.bytecounter);
                    HuffmanTable[] tables = htr.getTables();
                    for (int ii = 0; ii < tables.length; ++ii) {
                        this.dcmprI.hts[tables[ii].destination] = tables[ii];
                    }
                    continue block8;
                }
                case 195: {
                    byte t;
                    int i;
                    int len = this.getLength();
                    this.precision = this.inbuffer[this.bytecounter++];
                    this.sampleBytes = this.precision <= 8 ? 1 : 2;
                    this.height = this.getUnsignedWord();
                    this.width = this.getUnsignedWord();
                    this.nf = this.inbuffer[this.bytecounter++];
                    this.dcmprI.fcomps = new FComponent[this.nf];
                    for (i = 0; i < this.nf; ++i) {
                        this.dcmprI.fcomps[i] = new FComponent();
                        this.dcmprI.fcomps[i].c = this.inbuffer[this.bytecounter++];
                        t = this.inbuffer[this.bytecounter++];
                        this.dcmprI.fcomps[i].h = (t & 0xF0) >> 4;
                        this.dcmprI.fcomps[i].v = t & 0xF;
                        this.dcmprI.fcomps[i].tq = this.inbuffer[this.bytecounter++];
                        this.componentOffsetLookup[this.dcmprI.fcomps[i].c] = i;
                    }
                    this.outbuffer = new byte[this.width * this.height * this.nf * this.sampleBytes];
                    break;
                }
                case 218: {
                    byte t;
                    int i;
                    int len = this.getLength();
                    this.ns = this.inbuffer[this.bytecounter++];
                    this.dcmprI.scomps = new SComponent[this.ns];
                    for (i = 0; i < this.ns; ++i) {
                        this.dcmprI.scomps[i] = new SComponent();
                        this.dcmprI.scomps[i].cs = this.inbuffer[this.bytecounter++];
                        t = this.inbuffer[this.bytecounter++];
                        this.dcmprI.scomps[i].td = (t & 0xF0) >> 4;
                        this.dcmprI.scomps[i].ta = t & 0xF;
                    }
                    this.dcmprI.predictor = this.inbuffer[this.bytecounter++];
                    this.dcmprI.se = this.inbuffer[this.bytecounter++];
                    t = this.inbuffer[this.bytecounter++];
                    this.dcmprI.ah = (t & 0xF0) >> 4;
                    this.dcmprI.al = t & 0xF;
                    this.createBackupHuffmanTables();
                    this.processScan();
                    break;
                }
                case 221: {
                    int len = this.getLength();
                    this.dcmprI.restartInterval = this.getUnsignedWord();
                    break;
                }
                case 254: {
                    int len = this.getLength();
                    this.bytecounter += len - 2;
                    break;
                }
                case 217: {
                    return;
                }
                default: {
                    log.debug("Received unknown marker " + Integer.toHexString(marker) + ", trying to jump over");
                    int len = this.getLength();
                    this.bytecounter += len - 2;
                }
            }
        } while (marker != 217);
    }

    private void createBackupHuffmanTables() {
        int i;
        HuffmanTable backupHuffmanTable = null;
        for (i = 0; i < this.dcmprI.hts.length; ++i) {
            if (this.dcmprI.hts[i] == null) continue;
            backupHuffmanTable = this.dcmprI.hts[i];
            break;
        }
        for (i = 0; i < this.dcmprI.hts.length; ++i) {
            if (this.dcmprI.hts[i] != null) continue;
            this.dcmprI.hts[i] = backupHuffmanTable;
        }
    }

    private void processRestart() throws IOException {
        int c;
        this.bitsleft = 0;
        while (true) {
            if ((c = this.inbuffer[this.bytecounter++] & 0xFF) != 255) {
                continue;
            }
            while ((c = this.inbuffer[this.bytecounter++] & 0xFF) == 255) {
            }
            if (c != 0) break;
        }
        if (c != 208 + this.dcmprI.nextRestartNum) {
            throw new IOException("messed up restart markers");
        }
        this.dcmprI.restartRowsToGo = this.dcmprI.restartInRows;
        this.dcmprI.nextRestartNum = this.dcmprI.nextRestartNum + 1 & 7;
    }

    private int show_bits8() {
        if (this.bitsleft < 8) {
            this.fillBitBuffer(8);
        }
        return (int)(this.bitbuffer >> this.bitsleft - 8 & 0xFFL);
    }
}

