/*
 * Decompiled with CFR 0.152.
 */
package com.archimed.codec.jpeg;

import java.io.IOException;
import java.io.InputStream;

public class JpegSegmentReader {
    private InputStream in;
    private boolean inECS = false;
    private long left;

    public JpegSegmentReader(InputStream in) {
        this.in = in;
    }

    public boolean findMarker(int marker, long length) throws IOException {
        this.left = length;
        if (!this.inECS) {
            int nextMarker;
            do {
                if ((nextMarker = this.findNextMarker()) != -1) continue;
                return false;
            } while (nextMarker != marker);
            return true;
        }
        return false;
    }

    private int findNextMarker() throws IOException {
        int b = -1;
        while (this.left > 0L && (b = this.in.read()) == 255) {
            --this.left;
        }
        return this.left > 0L ? b : -1;
    }

    private int readLength() throws IOException {
        int i = this.in.read() << 8;
        return i += this.in.read();
    }
}

