/*
 * Decompiled with CFR 0.152.
 */
package com.archimed.codec.jpeg;

import java.io.IOException;
import java.io.InputStream;

public class JpegUtil {
    private static final byte FF = -1;

    public static boolean hasEOIMarker(byte[] fragment) {
        int idx;
        int len = fragment.length;
        if (len < 2) {
            return false;
        }
        if (len == 2) {
            return fragment[0] == -1 && fragment[1] == -39;
        }
        if (fragment[len - 2] == -1 && fragment[len - 1] == -39 || fragment[len - 3] == -1 && fragment[len - 2] == -39 && (fragment[len - 1] == 0 || fragment[len - 1] == 32)) {
            return true;
        }
        for (idx = fragment.length - 1; fragment[idx] == -1 && idx > 0; --idx) {
        }
        return idx > 0 && fragment[idx] == -39 && fragment[--idx] == -1;
    }

    public static boolean startWithSOI(InputStream in, long length, int marker) throws IOException {
        if (length < 2L) {
            throw new IllegalArgumentException("length to search for SOI must be >= 2");
        }
        long c = 0L;
        int b = in.read();
        ++c;
        if (b == -1) {
            throw new IOException("EOF reached while reading input stream");
        }
        if (b != 255) {
            return false;
        }
        while ((b = in.read()) == 255 && c < length) {
            ++c;
        }
        if (b == -1) {
            throw new IOException("EOF reached while reading input stream");
        }
        return b == marker;
    }
}

